/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleJsCheckDTO;
import com.geoway.adf.dms.config.filemodel.CustomNameRuler;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.util.ArchivePackagePath;
import com.geoway.adf.dms.config.filemodel.util.DepressHelper;
import com.geoway.adf.dms.config.filemodel.util.FileHelper;
import com.geoway.adf.gis.fs.IFileset;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Predicate;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ArchiveEnvironment.class);
    private DataPackage dataPackage;
    private String guidDirectory;

    public ArchiveEnvironment(DataPackage dataPackage) {
        this.dataPackage = dataPackage;
        this.guidDirectory = UUID.randomUUID().toString().replace("-", "");
    }

    public String getGuidDirectory() {
        return this.guidDirectory;
    }

    public List<IFileset> deCompressChildArchivePag(IFileset fileName, DataCompactPackage compactPag) {
        ArrayList<IFileset> unCompressDirs = new ArrayList<IFileset>();
        IFileset unZipPath = fileName.getParentFile();
        String virtualFolderPath = ArchiveEnvironment.getVirtualFolderPath(unZipPath.getFileStorage().combinePaths(unZipPath.getFullPath(), new String[]{ArchivePackagePath.getFileNameWithoutExtension(fileName, compactPag.getPackageType(), false)}), compactPag.getPackageType());
        IFileset virtualFolder = unZipPath.getFileStorage().getFile(virtualFolderPath);
        if (virtualFolder != null && unZipPath.getFileStorage().fileExist(virtualFolder.getFullPath())) {
            unCompressDirs.add(virtualFolder);
            return unCompressDirs;
        }
        this.decompressFilesByCompactType(fileName, compactPag, unZipPath);
        String originalDir = Paths.get(unZipPath.getFullPath(), ArchivePackagePath.getFileNameWithoutExtension(fileName, compactPag.getPackageType(), false)).toString();
        unCompressDirs.add(unZipPath.getFileStorage().getFile(this.renameDir(originalDir, compactPag.getPackageType())));
        return unCompressDirs;
    }

    public List<IFileset> compressCompactPackageInFolder(IFileset scanPath, IFileset initScanPath, DataCompactPackage item, boolean isNeedDeCompressChild) {
        ArrayList<IFileset> deCompressPaths = new ArrayList<IFileset>();
        List<Object> allCompactPackages = new ArrayList();
        if (this.dataPackage.getDataCompactPackageFiles().size() > 0 || !this.dataPackage.isUncompress()) {
            allCompactPackages = this.dataPackage.getDataCompactPackageFiles();
        } else {
            Predicate<IFileset> fileFilter = pathname -> {
                boolean needCompress = ArchiveEnvironment.needCompress(item, pathname, scanPath);
                return needCompress && pathname.getName().toLowerCase(Locale.ROOT).endsWith(item.getPackageType().toLowerCase(Locale.ROOT));
            };
            allCompactPackages = FileHelper.searchFileData(scanPath, fileFilter, false);
        }
        for (IFileset iFileset : allCompactPackages) {
            deCompressPaths.addAll(this.unCompressTopCompressPag(iFileset, item, initScanPath, isNeedDeCompressChild));
        }
        return deCompressPaths;
    }

    public List<IFileset> compressCompactPackageInFolder(IFileset scanPath, IFileset initScanPath, DataCompactPackage item, IFileset[] compactPackages, boolean isNeedDeCompressChild) {
        ArrayList<IFileset> deCompressPaths = new ArrayList<IFileset>();
        for (IFileset compactPackageFile : compactPackages) {
            deCompressPaths.addAll(this.unCompressTopCompressPag(compactPackageFile, item, initScanPath, isNeedDeCompressChild));
        }
        return deCompressPaths;
    }

    public List<IFileset> unCompressTopCompressPag(IFileset archivePath, DataCompactPackage compactPackage, IFileset scanFolder, boolean isNeedDeCompressChild) {
        ArrayList<IFileset> unCompressPaths = new ArrayList<IFileset>();
        IFileset compactVirtualFolder = ArchivePackagePath.getUnCompressFolder(archivePath, scanFolder, compactPackage.getPackageType(), this.dataPackage, true);
        IFileset compactVirtualFile = ArchivePackagePath.getVirtualPackagePath(archivePath, scanFolder, this.dataPackage, compactPackage);
        boolean hasFile = false;
        List list = compactVirtualFile.listFiles();
        if (list != null && list.size() > 0) {
            hasFile = true;
        }
        if (compactVirtualFile.getFileStorage().fileExist(compactVirtualFile.getFullPath().replace("\\", "/")) && hasFile) {
            unCompressPaths.add(compactVirtualFile);
            return unCompressPaths;
        }
        this.decompressFilesByCompactType(archivePath, compactPackage, compactVirtualFolder);
        String originalDir = Paths.get(compactVirtualFolder.getFullPath(), ArchivePackagePath.getFileNameWithoutExtension(archivePath, compactPackage.getPackageType(), false)).toString();
        IFileset unCompressPath = compactVirtualFile.getFileStorage().getFile(this.renameDir(originalDir, compactPackage.getPackageType()));
        if (unCompressPath == null) {
            unCompressPaths.add(archivePath);
            return unCompressPaths;
        }
        unCompressPaths.add(unCompressPath);
        if (!isNeedDeCompressChild) {
            return unCompressPaths;
        }
        ArrayList<DataCompactPackage> childCompressPackages = new ArrayList<DataCompactPackage>();
        ArchiveEnvironment.getAllChildArchive(compactPackage, childCompressPackages);
        ArrayList childCompressPackagePaths = new ArrayList();
        childCompressPackages.forEach(item -> this.unCompressAllArchive(scanFolder, compactVirtualFolder, (DataCompactPackage)item, childCompressPackagePaths, false));
        return unCompressPaths;
    }

    public IFileset getCompactPagRealPath(DataCompactPackage dataCompactPackage, IFileset virtualPath, IFileset scanPath) {
        return ArchivePackagePath.translateRealPackagePath(this.dataPackage, scanPath, virtualPath);
    }

    public void dispose() {
        String dirName = Paths.get(ArchivePackagePath.getVirtualFolder(this.dataPackage), new String[0]).toString();
        File dir = new File(dirName);
        if (dir.exists()) {
            FileUtil.deleteDir((String)dir.getParentFile().getAbsolutePath());
        }
    }

    public void dispose(IFileset realPath, IFileset scanPath, DataCompactPackage dataCompactPackage) {
        String targetDir = ArchivePackagePath.getVirtualPackagePathStr(realPath, scanPath, this.dataPackage, dataCompactPackage);
        File dir = new File(targetDir);
        if (dir.exists()) {
            FileUtil.deleteDir((String)targetDir);
        }
    }

    private void decompressFilesByCompactType(IFileset archivePath, DataCompactPackage compactPackage, IFileset compactVirtualFolder) {
        List<String> childrenExtensions = this.getChildrenObjectExtension(compactPackage);
        this.decompressionFiles(archivePath, compactVirtualFolder, compactPackage.getPackageType(), childrenExtensions);
    }

    private String renameDir(String originalDir, String packageType) {
        String destDir = ArchiveEnvironment.getVirtualFolderPath(originalDir, packageType);
        try {
            File oDir;
            File dDir = new File(destDir);
            if (dDir.exists()) {
                FileUtil.deleteDir((String)destDir);
            }
            if (!(oDir = new File(originalDir)).exists()) {
                return destDir.replace("\\", "/");
            }
            FileUtil.copy((String)originalDir, (String)destDir);
            FileUtil.deleteDir((String)originalDir);
            return destDir.replace("\\", "/");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return destDir.replace("\\", "/");
        }
    }

    private void decompressionFiles(IFileset archivePath, IFileset destFolder, String packageType, List<String> childrenObjectExtension) {
        if (!this.dataPackage.isUncompress()) {
            return;
        }
        if (childrenObjectExtension.contains(".*")) {
            DepressHelper.extract(archivePath, destFolder, packageType, "");
        } else {
            DepressHelper.extract(archivePath, destFolder, packageType, String.join((CharSequence)" ", childrenObjectExtension));
        }
    }

    private List<String> getChildrenObjectExtension(DataCompactPackage dataObject) {
        List<DatumModelDataObject> childrenObjects = dataObject.getChildren();
        HashSet childrenExtensions = new HashSet();
        childrenObjects.forEach(childObject -> {
            if (childObject instanceof DataFile) {
                childrenExtensions.addAll(((DataFile)childObject).getFileExtensionCollection());
            } else if (childObject instanceof DataCompactPackage) {
                childrenExtensions.add(((DataCompactPackage)childObject).getPackageType());
            } else if (childObject instanceof DataFolder) {
                childrenExtensions.add(".*");
            }
        });
        return new ArrayList<String>(childrenExtensions);
    }

    private static String getVirtualFolderPath(String originalDir, String packageType) {
        return originalDir + ArchivePackagePath.getExtension(packageType);
    }

    private void unCompressAllArchive(IFileset archivePath, IFileset dirInfo, DataCompactPackage dataCompact, List<IFileset> unCompressDirs, boolean isPackageCurrent) {
        String packageType = dataCompact.getPackageType();
        List<Object> tarFiles = new ArrayList();
        if (this.dataPackage.getDataCompactPackageFiles().size() > 0 || !this.dataPackage.isUncompress()) {
            tarFiles = this.dataPackage.getDataCompactPackageFiles();
        } else {
            Predicate<IFileset> searchPattern = pathname -> {
                boolean needCompress = ArchiveEnvironment.needCompress(dataCompact, pathname, dirInfo);
                return needCompress && pathname.getName().endsWith(packageType);
            };
            tarFiles = FileHelper.searchFileData(dirInfo, searchPattern, false);
        }
        unCompressDirs = new ArrayList<IFileset>();
        for (IFileset iFileset : tarFiles) {
            IFileset unZipDir = null;
            if (!isPackageCurrent) {
                unZipDir = iFileset.getParentFile();
            }
            if (unZipDir == null) continue;
            if (!iFileset.getFileStorage().fileExist(unZipDir.getFullPath())) {
                iFileset.getFileStorage().createDirectory(unZipDir.getParentFile().getFullPath(), unZipDir.getName());
            }
            if (this.dataPackage.isUncompress()) {
                boolean bl = DepressHelper.extract(iFileset, unZipDir, packageType, "");
            }
            String originalDir = Paths.get(unZipDir.getFullPath(), ArchivePackagePath.getFileNameWithoutExtension(iFileset, packageType, false)).toString();
            unCompressDirs.add(unZipDir.getFileStorage().getFile(this.renameDir(originalDir, packageType)));
        }
    }

    private static void getAllChildArchive(DatumModelDataObject parentPackage, List<DataCompactPackage> childDataCompactPackage) {
        for (int i = 0; i < parentPackage.getChildren().size(); ++i) {
            DatumModelDataObject childObject = parentPackage.getChildren().get(i);
            if (childObject instanceof DataCompactPackage) {
                childDataCompactPackage.add((DataCompactPackage)childObject);
            }
            if (!(childObject instanceof DataFolder)) continue;
            ArchiveEnvironment.getAllChildArchive(childObject, childDataCompactPackage);
        }
    }

    public static boolean needCompress(DataCompactPackage dataCompact, IFileset fileName, IFileset packageDir) {
        boolean canAdd = false;
        String realName = FileHelper.getNameWithoutExt(fileName, dataCompact.getPackageType());
        String name = realName.toUpperCase(Locale.ROOT);
        String custom = "";
        switch (dataCompact.getFolderNameRulerType()) {
            case FixedName: {
                custom = ArchiveEnvironment.getCustomNameByNameRule(dataCompact.getCustomNameRuler());
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                canAdd = name.compareTo(custom) == 0;
                break;
            }
            case ContainsCustom: {
                custom = ArchiveEnvironment.getCustomNameByNameRule(dataCompact.getCustomNameRuler());
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                canAdd = name.contains(custom);
                break;
            }
            case CustomScript: {
                if (dataCompact.getCustomNameRuler().getCustomString().contains("MainDataFileName")) {
                    return true;
                }
                try {
                    NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                    checkDTO.setJsContent(dataCompact.getCustomNameRuler().getCustomString());
                    checkDTO.setCurrentFileName(realName);
                    checkDTO.setDataFolder(packageDir.getFullPath());
                    String checkResult = ArchiveEnvironment.checkNameRuleJs(checkDTO);
                    canAdd = Boolean.parseBoolean(checkResult);
                }
                catch (Exception e) {
                    log.error(realName + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                    canAdd = false;
                }
                break;
            }
            default: {
                canAdd = true;
            }
        }
        return canAdd;
    }

    private static String checkNameRuleJs(NameRuleJsCheckDTO checkDTO) {
        try {
            String js;
            Object result;
            if (StringUtil.isEmptyOrWhiteSpace((String)checkDTO.getJsContent())) {
                return "";
            }
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("js");
            Bindings bindings = engine.createBindings();
            String param = "";
            if (checkDTO.getJsContent().contains("CurrentFileName")) {
                param = "CurrentFileName,";
                bindings.put("CurrentFileName", (Object)checkDTO.getCurrentFileName());
            }
            if (checkDTO.getJsContent().contains("MainDataFileName")) {
                param = param + "MainDataFileName,";
                bindings.put("MainDataFileName", (Object)checkDTO.getMainDataFileName());
            }
            if (checkDTO.getJsContent().contains("DataFolder")) {
                param = param + "DataFolder,";
                bindings.put("DataFolder", (Object)checkDTO.getDataFolder());
            }
            if (param.length() > 0) {
                param = param.substring(0, param.length() - 1);
            }
            return (result = engine.eval(js = String.format("function GetFileName(%s){%s} GetFileName(%s);", param, checkDTO.getJsContent(), param), bindings)) == null ? null : result.toString();
        }
        catch (Exception e) {
            log.error("js\u811a\u672c\u9519\u8bef\uff1a", (Throwable)e);
            throw new RuntimeException("js\u811a\u672c\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    private static String getCustomNameByNameRule(CustomNameRuler ruler) {
        if (ruler == null) {
            return null;
        }
        switch (ruler.getType()) {
            case String: {
                return ruler.getCustomString();
            }
        }
        return "";
    }
}

