/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleJsCheckDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.CustomNameRuler;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.ScanErrorMessage;
import com.geoway.adf.dms.config.filemodel.ScanInstanceParam;
import com.geoway.adf.dms.config.filemodel.ScanModelParam;
import com.geoway.adf.dms.config.filemodel.constant.CatalogFileTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFileNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFolderNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.util.ArchivePackagePath;
import com.geoway.adf.dms.config.filemodel.util.FileHelper;
import com.geoway.adf.dms.config.filemodel.util.FileStorageCache;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.fs.IFileset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInstanceUtil {
    private static final Logger log = LoggerFactory.getLogger(DataInstanceUtil.class);

    private static boolean parentHasZipPackage(DataPackage dataPackage, DatumModelDataObject dataObject, IFileset folder, RefObject<List<IFileset>> zipPaths, RefObject<DataCompactPackage> topParentCompactPackage) {
        DatumModelDataObject parentObject = dataObject;
        DataCompactPackage dataCompactPackage = null;
        LinkedList<DataCompactPackage> allDataCompactPackage = new LinkedList<DataCompactPackage>();
        boolean isSuccess = false;
        if (parentObject instanceof DataCompactPackage) {
            dataCompactPackage = (DataCompactPackage)parentObject;
            allDataCompactPackage.add(0, dataCompactPackage);
            isSuccess = true;
        }
        while ((parentObject = parentObject.getParentObject()) != null) {
            if (!(parentObject instanceof DataCompactPackage)) continue;
            dataCompactPackage = (DataCompactPackage)parentObject;
            allDataCompactPackage.add(0, dataCompactPackage);
            isSuccess = true;
        }
        if (isSuccess) {
            zipPaths.set(dataPackage.getArchiveEnvironment().compressCompactPackageInFolder(folder, folder, (DataCompactPackage)allDataCompactPackage.get(0), true));
        }
        topParentCompactPackage.set((Object)dataCompactPackage);
        return isSuccess;
    }

    private static boolean scanMainCompactParentHasZipPackage(ScanModelParam modelParam, DataPackage dataPackage, DatumModelDataObject dataObject, IFileset folder, RefObject<List<IFileset>> zipPaths, RefObject<DataCompactPackage> topParentCompactPackage) {
        DatumModelDataObject parentObject = dataObject;
        DataCompactPackage dataCompactPackage = null;
        LinkedList<DataCompactPackage> allDataCompactPackage = new LinkedList<DataCompactPackage>();
        boolean isSuccess = false;
        if (parentObject instanceof DataCompactPackage) {
            dataCompactPackage = (DataCompactPackage)parentObject;
            allDataCompactPackage.add(0, dataCompactPackage);
            isSuccess = true;
        }
        while ((parentObject = parentObject.getParentObject()) != null) {
            if (!(parentObject instanceof DataCompactPackage)) continue;
            dataCompactPackage = (DataCompactPackage)parentObject;
            allDataCompactPackage.add(0, dataCompactPackage);
            isSuccess = true;
        }
        if (isSuccess) {
            IFileset[] resCompact = DataInstanceUtil.getFileInfoByExtensionCollection(folder, modelParam.getKeyCompactPackage(), modelParam);
            zipPaths.set(dataPackage.getArchiveEnvironment().compressCompactPackageInFolder(folder, folder, (DataCompactPackage)allDataCompactPackage.get(0), resCompact, true));
        }
        topParentCompactPackage.set((Object)dataCompactPackage);
        return isSuccess;
    }

    public static IFileset[] scanMainDataFiles(ScanModelParam modelParam, IFileset folder) {
        RefObject unZipPaths = new RefObject();
        RefObject parentDataCompactPackage = new RefObject();
        boolean isInCompressPackage = DataInstanceUtil.parentHasZipPackage(modelParam.getModel(), modelParam.getKeyFile(), folder, (RefObject<List<IFileset>>)unZipPaths, (RefObject<DataCompactPackage>)parentDataCompactPackage);
        DataFile dataFile = modelParam.getKeyFile();
        if (isInCompressPackage) {
            ArrayList<IFileset> fileInfos = new ArrayList<IFileset>();
            for (IFileset unZipPath : (List)unZipPaths.get()) {
                IFileset[] array = DataInstanceUtil.getFileInfoByExtensionCollection(unZipPath, dataFile, modelParam);
                fileInfos.addAll(Arrays.asList(array));
            }
            IFileset[] fileNameArray = new IFileset[fileInfos.size()];
            fileInfos.toArray(fileNameArray);
            return fileNameArray;
        }
        return DataInstanceUtil.getFileInfoByExtensionCollection(folder, dataFile, modelParam);
    }

    public static IFileset[] scanMainCompactPackage(ScanModelParam modelParam, IFileset folder) {
        RefObject unZipPaths = new RefObject();
        RefObject parentDataCompactPackage = new RefObject();
        boolean isSuccess = DataInstanceUtil.scanMainCompactParentHasZipPackage(modelParam, modelParam.getModel(), modelParam.getKeyCompactPackage(), folder, (RefObject<List<IFileset>>)unZipPaths, (RefObject<DataCompactPackage>)parentDataCompactPackage);
        DataCompactPackage compactPackage = modelParam.getKeyCompactPackage();
        if (isSuccess) {
            ArrayList<IFileset> fileInfos = new ArrayList<IFileset>();
            for (IFileset unZipPath : (List)unZipPaths.get()) {
                fileInfos.add(modelParam.getModel().getArchiveEnvironment().getCompactPagRealPath(compactPackage, unZipPath, folder));
            }
            IFileset[] folderNameArray = new IFileset[fileInfos.size()];
            fileInfos.toArray(folderNameArray);
            return folderNameArray;
        }
        return DataInstanceUtil.getFileInfoByExtensionCollection(folder, compactPackage, modelParam);
    }

    public static IFileset[] scanMainDataPackages(ScanModelParam modelParam, IFileset folder) {
        return new IFileset[0];
    }

    public static IFileset[] scanMainDataFolders(ScanModelParam modelParam, IFileset folder) {
        RefObject unZipPaths = new RefObject();
        RefObject parentDataCompactPackage = new RefObject();
        boolean isSuccess = DataInstanceUtil.parentHasZipPackage(modelParam.getModel(), modelParam.getKeyFolder(), folder, (RefObject<List<IFileset>>)unZipPaths, (RefObject<DataCompactPackage>)parentDataCompactPackage);
        if (isSuccess) {
            ArrayList<IFileset> dirInfos = new ArrayList<IFileset>();
            for (IFileset unZipPath : (List)unZipPaths.get()) {
                IFileset[] array = DataInstanceUtil.findDirectory(modelParam, unZipPath);
                dirInfos.addAll(Arrays.asList(array));
            }
            IFileset[] folderNameArray = new IFileset[dirInfos.size()];
            dirInfos.toArray(folderNameArray);
            return folderNameArray;
        }
        return DataInstanceUtil.findDirectory(modelParam, folder);
    }

    public static IFileset getPackageDir(IFileset path, Boolean isFilePath, ScanModelParam modelParam) {
        String[] folders = null;
        int i = 0;
        if (isFilePath.booleanValue()) {
            String parentPath = path.getParentFile().getFullPath();
            parentPath = parentPath.replace("\\", "/");
            folders = parentPath.split("/");
            i = folders.length;
        } else {
            String filePath = path.getFullPath().replace("\\", "/");
            folders = filePath.split("/");
            i = folders.length - 1;
        }
        if ((i -= modelParam.getKeyObj().getDepth().intValue()) > 0) {
            String str = "";
            for (int j = 0; j <= i; ++j) {
                str = str + folders[j] + '/';
            }
            if (!str.startsWith(path.getFileStorage().getStorageUrl())) {
                str = str.replace("/", "\\");
            }
            return FileStorageCache.getFile(path.getFileStorage(), str);
        }
        return null;
    }

    public static boolean constructCatalogDataByMainFile(ScanModelParam modelParam, ScanInstanceParam insParam, DmFileData catalogData) {
        if (catalogData == null) {
            catalogData = new DmFileData();
        }
        catalogData.setDatatype(modelParam.getModel().getName());
        catalogData.setRealPkgName(insParam.getFolderName());
        catalogData.setMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setSrcMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setContainsRootFolder(modelParam.getModel().getRelated2RealFolder() != false ? 1L : 0L);
        ArrayList<FileDataUnit> files = new ArrayList<FileDataUnit>();
        RefObject size = new RefObject();
        size.set((Object)0L);
        FileDataUnit keyFile = new FileDataUnit();
        keyFile.setCatalogFileType(CatalogFileTypeEnum.SingleFile);
        if (modelParam.getKeyObj().getProperties() != null && modelParam.getKeyObj().getProperties().size() > 0) {
            ArrayList<String> tempProperties = new ArrayList<String>();
            tempProperties.addAll(modelParam.getKeyObj().getProperties());
            keyFile.setProperties(tempProperties);
        }
        keyFile.setFileLocation(insParam.getKeyPath().getFullPath());
        keyFile.setFileSourceLocation(insParam.getKeyPath().getFullPath());
        keyFile.setDataAmount(DataInstanceUtil.getFileAmount(insParam.getKeyPath()));
        keyFile.setPackagePath(modelParam.getKeyObj().getPathWithoutModelName());
        keyFile.setMainFile(true);
        files.add(keyFile);
        size.set((Object)((Long)size.get() + keyFile.getDataAmount()));
        boolean flag = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, modelParam.getModel(), insParam.getPacPath(), files, (RefObject<Long>)size);
        catalogData.setDataAmount((Long)size.get());
        if (catalogData.getFiles() == null) {
            catalogData.setFiles(new ArrayList<FileDataUnit>());
        }
        if (flag || modelParam.getNeedScanInvalid().booleanValue()) {
            catalogData.addTempCatalogDataFile(files);
        }
        catalogData.setDataName(DataInstanceUtil.getDataName(modelParam.getModel(), modelParam.getModel(), insParam, catalogData));
        return flag;
    }

    public static boolean constructCatalogDataByMainFolder(ScanModelParam modelParam, ScanInstanceParam insParam, DmFileData catalogData) {
        if (catalogData == null) {
            catalogData = new DmFileData();
        }
        catalogData.setDatatype(modelParam.getModel().getName());
        catalogData.setRealPkgName(insParam.getFolderName());
        catalogData.setMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setSrcMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setContainsRootFolder(modelParam.getModel().getRelated2RealFolder() != false ? 1L : 0L);
        ArrayList<FileDataUnit> files = new ArrayList<FileDataUnit>();
        RefObject size = new RefObject();
        size.set((Object)0L);
        String dataKeyName = "";
        boolean flg = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, modelParam.getModel(), insParam.getPacPath(), files, (RefObject<Long>)size);
        if (catalogData.getFiles() == null) {
            catalogData.setFiles(new ArrayList<FileDataUnit>());
        }
        if (flg || modelParam.getNeedScanInvalid().booleanValue()) {
            catalogData.setDataAmount((Long)size.get());
            catalogData.addTempCatalogDataFile(files);
        }
        catalogData.setDataName(DataInstanceUtil.getDataName(modelParam.getModel(), modelParam.getModel(), insParam, catalogData));
        return flg;
    }

    public static boolean constructCatalogDataByMainCompactPackage(ScanModelParam modelParam, ScanInstanceParam insParam, DmFileData catalogData) {
        if (catalogData == null) {
            catalogData = new DmFileData();
        }
        catalogData.setDatatype(modelParam.getModel().getName());
        catalogData.setRealPkgName(insParam.getFolderName());
        catalogData.setMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setSrcMainPath(DataInstanceUtil.getRealPath(modelParam.getModel(), null, insParam.getPacPath(), insParam.getScanFolderName()).getFullPath());
        catalogData.setContainsRootFolder(modelParam.getModel().getRelated2RealFolder() != false ? 1L : 0L);
        ArrayList<FileDataUnit> files = new ArrayList<FileDataUnit>();
        RefObject size = new RefObject();
        size.set((Object)0L);
        String dataKeyName = "";
        boolean flg = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, modelParam.getModel(), insParam.getPacPath(), files, (RefObject<Long>)size);
        if (catalogData.getFiles() == null) {
            catalogData.setFiles(new ArrayList<FileDataUnit>());
        }
        if (flg || modelParam.getNeedScanInvalid().booleanValue()) {
            catalogData.setDataAmount((Long)size.get());
            catalogData.addTempCatalogDataFile(files);
        }
        catalogData.setDataName(DataInstanceUtil.getDataName(modelParam.getModel(), modelParam.getModel(), insParam, catalogData));
        return flg;
    }

    public static boolean canAdd(DataFile dataFile, IFileset fileName, String packageDir, String dataKeyName) {
        boolean canAdd = false;
        String realName = FileHelper.getNameWithoutExt(fileName, "");
        String name = realName.toUpperCase(Locale.ROOT);
        String custom = "";
        switch (dataFile.getFileNameRuler()) {
            case SameWithMainFile: {
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                canAdd = name.compareTo(dataKeyName.toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case ContainsMainFile: {
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                canAdd = name.contains(dataKeyName.toUpperCase(Locale.ROOT));
                break;
            }
            case PrefixMainFile: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                canAdd = name.compareTo((custom + dataKeyName).toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case SuffixMainFile: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                canAdd = name.compareTo((dataKeyName + custom).toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case SameWithCustom: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                canAdd = name.compareTo(custom) == 0;
                break;
            }
            case ContainsCustom: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                if (!StringUtil.isEmpty((String)custom)) {
                    custom = custom.toUpperCase(Locale.ROOT);
                }
                canAdd = name.contains(custom);
                break;
            }
            case CustomScript: {
                try {
                    NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                    checkDTO.setJsContent(dataFile.getCustomNameRuler().getCustomString());
                    checkDTO.setCurrentFileName(realName);
                    checkDTO.setMainDataFileName(dataKeyName);
                    checkDTO.setDataFolder(packageDir);
                    String checkResult = DataInstanceUtil.checkNameRuleJs(checkDTO);
                    canAdd = Boolean.parseBoolean(checkResult);
                }
                catch (Exception e) {
                    log.error(realName + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                    canAdd = false;
                }
                break;
            }
            default: {
                canAdd = true;
            }
        }
        return canAdd;
    }

    public static String checkNameRuleJs(NameRuleJsCheckDTO checkDTO) {
        try {
            String js;
            Object result;
            if (StringUtil.isEmptyOrWhiteSpace((String)checkDTO.getJsContent())) {
                return "";
            }
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("js");
            Bindings bindings = engine.createBindings();
            String param = "";
            if (checkDTO.getJsContent().contains("CurrentFileName")) {
                param = "CurrentFileName,";
                bindings.put("CurrentFileName", (Object)checkDTO.getCurrentFileName());
            }
            if (checkDTO.getJsContent().contains("MainDataFileName")) {
                param = param + "MainDataFileName,";
                bindings.put("MainDataFileName", (Object)checkDTO.getMainDataFileName());
            }
            if (checkDTO.getJsContent().contains("DataFolder")) {
                param = param + "DataFolder,";
                bindings.put("DataFolder", (Object)checkDTO.getDataFolder());
            }
            if (param.length() > 0) {
                param = param.substring(0, param.length() - 1);
            }
            return (result = engine.eval(js = String.format("function GetFileName(%s){%s} GetFileName(%s);", param, checkDTO.getJsContent(), param), bindings)) == null ? null : result.toString();
        }
        catch (Exception e) {
            log.error("js\u811a\u672c\u9519\u8bef\uff1a", (Throwable)e);
            throw new RuntimeException("js\u811a\u672c\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public static boolean checkFolder(DataFolder dataFolder, String folderName, String packageDir, String dataKeyName) {
        boolean valid = false;
        String name = folderName.toUpperCase(Locale.ROOT);
        String custom = "";
        String mainDataName = "";
        switch (dataFolder.getFolderNameRulerType()) {
            case SameWithMainFile: {
                String string = mainDataName = StringUtil.isEmpty((String)dataKeyName) ? "" : dataKeyName;
                if (StringUtil.isEmpty((String)mainDataName)) break;
                valid = name.compareTo(mainDataName.toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case ContainsMainFile: {
                String string = mainDataName = StringUtil.isEmpty((String)dataKeyName) ? "" : dataKeyName;
                if (StringUtil.isEmpty((String)mainDataName)) break;
                valid = name.contains(mainDataName.toUpperCase(Locale.ROOT));
                break;
            }
            case PrefixMainFile: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFolder.getCustomNameRuler(), packageDir, dataKeyName);
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                valid = name.compareTo((custom.toUpperCase(Locale.ROOT) + dataKeyName).toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case SuffixMainFile: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFolder.getCustomNameRuler(), packageDir, dataKeyName);
                if (StringUtil.isEmpty((String)dataKeyName)) break;
                valid = name.compareTo((dataKeyName + custom.toUpperCase(Locale.ROOT)).toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case FixedName: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFolder.getCustomNameRuler(), packageDir, dataKeyName);
                valid = name.compareTo(custom.toUpperCase(Locale.ROOT)) == 0;
                break;
            }
            case ContainsCustom: {
                custom = DataInstanceUtil.getCustomNameByNameRule(dataFolder.getCustomNameRuler(), packageDir, dataKeyName);
                valid = name.contains(custom.toUpperCase(Locale.ROOT));
                break;
            }
            case CustomScript: {
                try {
                    NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                    checkDTO.setJsContent(dataFolder.getCustomNameRuler().getCustomString());
                    checkDTO.setCurrentFileName(folderName);
                    checkDTO.setMainDataFileName(dataKeyName);
                    checkDTO.setDataFolder(packageDir);
                    String checkResult = DataInstanceUtil.checkNameRuleJs(checkDTO);
                    valid = Boolean.parseBoolean(checkResult);
                }
                catch (Exception e) {
                    log.error(name + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                    valid = false;
                }
                break;
            }
            default: {
                valid = true;
            }
        }
        return valid;
    }

    public static String getDataName(DataPackage basePackage, DataPackage realPackage, ScanInstanceParam insParam, DmFileData catalogData) {
        switch (basePackage.getDataNameRuler()) {
            case MainDataFile: {
                return insParam.getKeyName();
            }
            case DataPackageFolder: {
                return (realPackage.getParentObject() == null ? "" : "_") + insParam.getFolderName();
            }
            case DataPackageAndMainDataFile: {
                return (realPackage.getParentObject() == null ? "" : "_") + insParam.getFolderName() + "_" + insParam.getKeyName();
            }
        }
        return insParam.getKeyName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean scanDataFilesByDataKey(ScanModelParam modelParam, ScanInstanceParam insParam, DatumModelDataObject curDataObj, IFileset curFile, List<FileDataUnit> fileList, RefObject<Long> totalSize) {
        ScanErrorMessage errorMessage;
        if (curFile == null) {
            return false;
        }
        boolean success = true;
        boolean folderValid = false;
        boolean flg = true;
        String packageName = curFile.getName();
        List<DatumModelDataObject> dataObjects = curDataObj.getChildren();
        ArrayList<DataFile> otherFiles = new ArrayList<DataFile>();
        DataFolder otherFolder = null;
        for (DatumModelDataObject dataObject : dataObjects) {
            Object dataCompactPackage;
            if (dataObject instanceof DataFile) {
                DataFile dataFile = (DataFile)dataObject;
                if (!dataFile.getIsDataKey().booleanValue()) {
                    if (dataFile.getFileExtension().compareTo(".*") == 0) {
                        if (dataFile.getFileNameRuler() == DataFileNameRulerEnum.None) {
                            otherFiles.add(dataFile);
                            continue;
                        }
                        otherFiles.add(0, dataFile);
                        continue;
                    }
                    if (DataInstanceUtil.scanFiles(packageName, insParam.getKeyName(), totalSize, curFile, dataFile, fileList) != 0 || !modelParam.getEnableNecessary().booleanValue() || !dataFile.getNecessary().booleanValue()) continue;
                    ScanErrorMessage errorMessage2 = new ScanErrorMessage();
                    errorMessage2.setScanPath(curFile.getFullPath());
                    errorMessage2.setDataObj(dataFile);
                    errorMessage2.setErrorInfo("\u672a\u626b\u63cf\u5fc5\u5907\u6587\u4ef6\uff01");
                    insParam.appendScanErrorInfo(errorMessage2);
                    if (modelParam.getNeedScanInvalid() == false) return false;
                    success = false;
                    continue;
                }
                if (dataObjects.size() != 1 || insParam.getKeyPath().getFullPath().startsWith(curFile.getFullPath())) continue;
                success = false;
                continue;
            }
            if (dataObject instanceof DataFolder) {
                List<IFileset> list;
                IFileset relPath;
                Object errorMessage3;
                IFileset realPath = FileStorageCache.getFile(curFile.getFileStorage(), curFile.getFullPath());
                boolean isDeCompressInTopPath = false;
                dataCompactPackage = null;
                if (dataObject instanceof DataCompactPackage) {
                    dataCompactPackage = (DataCompactPackage)dataObject;
                    if (!ArchivePackagePath.isContainVirtualPackagePath(realPath.getFullPath())) {
                        DataPackage dataPackage = modelParam.getModel();
                        modelParam.getModel().getArchiveEnvironment().compressCompactPackageInFolder(realPath, insParam.getScanFolderName(), (DataCompactPackage)dataObject, false);
                        realPath = ArchivePackagePath.getUnCompressFolder(realPath, insParam.getScanFolderName(), ((DataCompactPackage)dataObject).getPackageType(), modelParam.getModel(), false);
                        isDeCompressInTopPath = true;
                    }
                }
                DataFolder dataFolder = (DataFolder)dataObject;
                List<Object> directoryList = new ArrayList();
                if (dataObject instanceof DataCompactPackage && !isDeCompressInTopPath) {
                    DataInstanceUtil.unCompressCurrentPackage(modelParam.getModel(), (DataCompactPackage)dataObject, realPath, insParam);
                }
                if (dataFolder.getIsDataKey().booleanValue()) {
                    Predicate<IFileset> filter = dataObject instanceof DataCompactPackage ? pathname -> FileUtil.getFileName((String)pathname.getName()).equals(insParam.getKeyName() + ArchivePackagePath.getExtension(((DataCompactPackage)dataObject).getPackageType())) : pathname -> FileUtil.getFileName((String)pathname.getName()).equals(insParam.getKeyName());
                    directoryList = FileHelper.getWholeDirectories(realPath, filter, true);
                } else {
                    directoryList = FileHelper.getWholeDirectories(realPath, null, true);
                }
                folderValid = true;
                boolean singleFolderScanRlt = false;
                boolean allFolderFolderFalse = true;
                IFileset dataFolderPath = null;
                boolean resultIsEmpty = false;
                if (directoryList.size() == 0) {
                    errorMessage3 = new ScanErrorMessage();
                    ((ScanErrorMessage)errorMessage3).setScanPath(curFile.getFullPath());
                    ((ScanErrorMessage)errorMessage3).setDataObj(dataFolder);
                    ((ScanErrorMessage)errorMessage3).setErrorInfo("\u626b\u63cf\u6587\u4ef6\u5939\u4e3a\u7a7a\uff01");
                    insParam.appendScanErrorInfo((ScanErrorMessage)errorMessage3);
                    resultIsEmpty = true;
                    flg = false;
                } else {
                    for (IFileset iFileset : directoryList) {
                        IFileset checkName;
                        IFileset iFileset2 = checkName = dataObject instanceof DataCompactPackage ? modelParam.getModel().getArchiveEnvironment().getCompactPagRealPath((DataCompactPackage)dataObject, iFileset, insParam.getScanFolderName()) : iFileset;
                        if (DataInstanceUtil.checkFolder(dataFolder, checkName.getName(), packageName, insParam.getKeyName())) {
                            singleFolderScanRlt = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, dataFolder, iFileset, fileList, totalSize);
                            if (singleFolderScanRlt) {
                                dataFolderPath = FileStorageCache.getFile(iFileset.getFileStorage(), iFileset.getFullPath());
                                allFolderFolderFalse = false;
                            }
                        } else {
                            singleFolderScanRlt = true;
                        }
                        flg = flg && singleFolderScanRlt;
                    }
                    if (allFolderFolderFalse) {
                        flg = false;
                        resultIsEmpty = true;
                    }
                    if (!allFolderFolderFalse) {
                        flg = true;
                    }
                }
                if (!flg) {
                    errorMessage3 = new ScanErrorMessage();
                    ((ScanErrorMessage)errorMessage3).setScanPath(curFile.getFullPath());
                    ((ScanErrorMessage)errorMessage3).setDataObj(dataFolder);
                    ((ScanErrorMessage)errorMessage3).setErrorInfo("\u6240\u6709\u67e5\u8be2\u6587\u4ef6\u5939\u5747\u4e0d\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\uff01");
                    insParam.appendScanErrorInfo((ScanErrorMessage)errorMessage3);
                    folderValid = false;
                }
                if (!folderValid) {
                    if (dataFolder.getNecessary().booleanValue()) {
                        errorMessage3 = new ScanErrorMessage();
                        ((ScanErrorMessage)errorMessage3).setScanPath(curFile.getFullPath());
                        ((ScanErrorMessage)errorMessage3).setDataObj(dataFolder);
                        ((ScanErrorMessage)errorMessage3).setErrorInfo("\u672a\u627e\u5230\u5fc5\u5907\u6587\u4ef6\u5939\uff01");
                        insParam.appendScanErrorInfo((ScanErrorMessage)errorMessage3);
                        if (modelParam.getNeedScanInvalid() == false) return false;
                        success = false;
                    } else if (resultIsEmpty) {
                        success = !DataInstanceUtil.hasNecessaryChild(dataFolder);
                        boolean bl = success = success && dataFolder.getCanBeEmpty() != false;
                    }
                }
                if (!(dataFolder.getNecessary().booleanValue() || dataFolder.getCanBeEmpty().booleanValue() || resultIsEmpty || (relPath = DataInstanceUtil.getRealPath(modelParam.getModel(), (DataCompactPackage)dataCompactPackage, dataFolderPath, insParam.getScanFolderName())) == null || relPath.getFullPath().length() <= 0 || (list = FileHelper.searchFileData(relPath, null, false)) != null && list.size() != 0)) {
                    success = false;
                }
                if (!flg || dataFolderPath == null) continue;
                FileDataUnit fileDataUnit = new FileDataUnit();
                fileDataUnit.setCatalogFileType(dataFolder.getContainsSubFoldersAndFiles() != false ? CatalogFileTypeEnum.FolderWithChildren : CatalogFileTypeEnum.SingleFolder);
                if (dataFolder instanceof DataCompactPackage) {
                    fileDataUnit.setCatalogFileType(CatalogFileTypeEnum.SingleFile);
                    fileDataUnit.setDataAmount(DataInstanceUtil.getFileAmount(DataInstanceUtil.getRealPath(modelParam.getModel(), (DataCompactPackage)dataCompactPackage, dataFolderPath, insParam.getScanFolderName())));
                    totalSize.set((Object)((Long)totalSize.get() + fileDataUnit.getDataAmount()));
                    fileDataUnit.setFileLocation(DataInstanceUtil.getRealPath(modelParam.getModel(), (DataCompactPackage)dataCompactPackage, dataFolderPath, insParam.getScanFolderName()).getFullPath());
                    fileDataUnit.setFileSourceLocation(DataInstanceUtil.getRealPath(modelParam.getModel(), (DataCompactPackage)dataCompactPackage, dataFolderPath, insParam.getScanFolderName()).getFullPath());
                } else {
                    fileDataUnit.setDataAmount(DataInstanceUtil.getFileAmount(dataFolderPath));
                    fileDataUnit.setFileLocation(dataFolderPath.getFullPath());
                    fileDataUnit.setFileSourceLocation(dataFolderPath.getFullPath());
                }
                fileDataUnit.setMainFile(dataFolder.getIsDataKey());
                fileDataUnit.setPackagePath(dataFolder.getPathWithoutModelName());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(dataFolder.getProperties());
                fileDataUnit.setProperties(arrayList);
                fileList.add(fileDataUnit);
                continue;
            }
            if (!(dataObject instanceof DataPackage)) continue;
            DataPackage dataPackage = (DataPackage)dataObject;
            List<IFileset> directoryList = FileHelper.getWholeDirectories(curFile, null, true);
            dataCompactPackage = directoryList.iterator();
            while (dataCompactPackage.hasNext()) {
                IFileset di = (IFileset)dataCompactPackage.next();
                flg = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, dataPackage, di, fileList, totalSize);
            }
        }
        if (otherFiles.size() > 0) {
            for (DataFile otherFile : otherFiles) {
                if (DataInstanceUtil.scanFiles(packageName, insParam.getKeyName(), totalSize, curFile, otherFile, fileList) != 0 || !modelParam.getNeedScanInvalid().booleanValue() || !otherFile.getNecessary().booleanValue()) continue;
                errorMessage = new ScanErrorMessage();
                errorMessage.setScanPath(curFile.getFullPath());
                errorMessage.setDataObj(otherFile);
                errorMessage.setErrorInfo("\u672a\u627e\u5230\u5fc5\u5907\u5176\u4ed6\u6587\u4ef6\uff01");
                insParam.appendScanErrorInfo(errorMessage);
                if (modelParam.getNeedScanInvalid() == false) return false;
                success = false;
            }
        }
        if (otherFolder != null) {
            String dataFolderPath = "";
            if (otherFolder.getContainsSubFoldersAndFiles().booleanValue()) {
                ScanErrorMessage errorMessage4;
                ArrayList<FileDataUnit> existFiles = new ArrayList<FileDataUnit>(fileList);
                if (otherFolder.getCanBeEmpty().booleanValue()) {
                    List<IFileset> directorys = FileHelper.getWholeDirectories(curFile, null, true);
                    for (IFileset di : directorys) {
                        if (DataInstanceUtil.hasFiles(di).booleanValue()) continue;
                        FileDataUnit fileDataUnit = new FileDataUnit();
                        fileDataUnit.setCatalogFileType(otherFolder.getContainsSubFoldersAndFiles() != false ? CatalogFileTypeEnum.FolderWithChildren : CatalogFileTypeEnum.SingleFolder);
                        fileDataUnit.setFileLocation(di.getFullPath());
                        fileDataUnit.setFileSourceLocation(di.getFullPath());
                        fileDataUnit.setMainFile(false);
                        fileDataUnit.setPackagePath(otherFolder.getPathWithoutModelName());
                        ArrayList<String> properties = new ArrayList<String>();
                        properties.addAll(otherFolder.getProperties());
                        fileDataUnit.setProperties(properties);
                        fileList.add(fileDataUnit);
                    }
                }
                List<IFileset> subAnyDirs = FileHelper.getWholeDirectories(curFile, null, true);
                int subFilesCount = fileList.size();
                if (subAnyDirs.size() > 0) {
                    for (IFileset di : subAnyDirs) {
                        if (DataInstanceUtil.containsDir(di, existFiles)) continue;
                        DataInstanceUtil.getAllSubFiles(di, fileList, otherFolder.getPathWithoutModelName());
                    }
                    if (otherFolder.getNecessary().booleanValue()) {
                        errorMessage4 = new ScanErrorMessage();
                        errorMessage4.setScanPath(curFile.getFullPath());
                        errorMessage4.setDataObj(otherFolder);
                        errorMessage4.setErrorInfo("\u672a\u627e\u5230\u5fc5\u5907\u6587\u4ef6\u5939\uff01");
                        insParam.appendScanErrorInfo(errorMessage4);
                        if (modelParam.getNeedScanInvalid() == false) return false;
                        return false;
                    }
                    if (!success) return false;
                    if (otherFolder.getCanBeEmpty() == false) return false;
                    boolean bl = true;
                    success = bl;
                } else {
                    if (otherFolder.getNecessary().booleanValue()) {
                        errorMessage4 = new ScanErrorMessage();
                        errorMessage4.setScanPath(curFile.getFullPath());
                        errorMessage4.setDataObj(otherFolder);
                        errorMessage4.setErrorInfo("\u672a\u627e\u5230\u5fc5\u5907\u6587\u4ef6\u5939\uff01");
                        insParam.appendScanErrorInfo(errorMessage4);
                        if (modelParam.getNeedScanInvalid() == false) return false;
                        return false;
                    }
                    if (!success) return false;
                    if (otherFolder.getCanBeEmpty() == false) return false;
                    boolean bl = true;
                    success = bl;
                }
            } else {
                List<IFileset> directoryList = FileHelper.getWholeDirectories(curFile, null, true);
                if (directoryList.size() > 0 && !(flg = DataInstanceUtil.scanDataFilesByDataKey(modelParam, insParam, otherFolder, directoryList.get(0), fileList, totalSize))) {
                    success = false;
                    if (!modelParam.getNeedScanInvalid().booleanValue()) {
                        errorMessage = new ScanErrorMessage();
                        errorMessage.setScanPath(curFile.getFullPath());
                        errorMessage.setDataObj(otherFolder);
                        errorMessage.setErrorInfo("\u672a\u627e\u5230\u5176\u4ed6\u6587\u4ef6\u5939\uff01");
                        insParam.appendScanErrorInfo(errorMessage);
                        return false;
                    }
                }
            }
            if (!success) return success;
            FileDataUnit fileDataUnit = new FileDataUnit();
            fileDataUnit.setCatalogFileType(otherFolder.getContainsSubFoldersAndFiles() != false ? CatalogFileTypeEnum.FolderWithChildren : CatalogFileTypeEnum.SingleFolder);
            fileDataUnit.setFileLocation(dataFolderPath);
            fileDataUnit.setFileSourceLocation(dataFolderPath);
            fileDataUnit.setMainFile(false);
            fileDataUnit.setPackagePath(otherFolder.getPathWithoutModelName());
            ArrayList<String> properties = new ArrayList<String>();
            properties.addAll(otherFolder.getProperties());
            fileDataUnit.setProperties(properties);
            fileList.add(fileDataUnit);
            return success;
        } else {
            if (curDataObj.getClass() != DataFolder.class) return success;
            if (((DataFolder)curDataObj).getContainsSubFoldersAndFiles() == false) return success;
        }
        return success;
    }

    private static void unCompressCurrentPackage(DataPackage dataPackage, DataCompactPackage dataCompactPackage, IFileset realPath, ScanInstanceParam insParam) {
        if (dataCompactPackage == null) {
            return;
        }
        List compressFiles = FileStorageCache.listFiles(realPath);
        if (compressFiles == null) {
            return;
        }
        compressFiles = ListUtil.findAll(compressFiles, pathname -> pathname.getName().toLowerCase(Locale.ROOT).endsWith(dataCompactPackage.getPackageType().toLowerCase(Locale.ROOT)));
        for (IFileset compressFile : compressFiles) {
            IFileset virtualPackage = ArchivePackagePath.getVirtualPackagePath(compressFile, insParam.getScanFolderName(), dataPackage, dataCompactPackage);
            if (virtualPackage != null) continue;
            dataPackage.getArchiveEnvironment().deCompressChildArchivePag(compressFile, dataCompactPackage);
        }
    }

    private static Long getAllSubFiles(IFileset dir, List<FileDataUnit> taskFileList, String xPath) {
        Long totalSize = 0L;
        FileDataUnit taskFile = null;
        List<IFileset> files = FileHelper.searchFileData(dir, null, false);
        for (IFileset item : files) {
            taskFile = new FileDataUnit();
            taskFile.setCatalogFileType(CatalogFileTypeEnum.SingleFile);
            taskFile.setFileLocation(item.getFullPath());
            taskFile.setFileSourceLocation(item.getFullPath());
            taskFile.setMainFile(true);
            taskFile.setDataAmount(DataInstanceUtil.getFileAmount(item));
            taskFile.setPackagePath(xPath);
            taskFileList.add(taskFile);
            totalSize = totalSize + taskFile.getDataAmount();
        }
        return totalSize;
    }

    private static boolean hasNecessaryChild(DatumModelDataObject dataFolder) {
        boolean hasNecessaryChild = false;
        if (dataFolder.getChildren() != null && dataFolder.getChildren().size() > 0) {
            for (DatumModelDataObject child : dataFolder.getChildren()) {
                if (child.getNecessary().booleanValue()) {
                    return true;
                }
                hasNecessaryChild = DataInstanceUtil.hasNecessaryChild(child);
            }
        }
        return hasNecessaryChild;
    }

    private static int scanFiles(String packageDir, String dataKeyName, RefObject<Long> totalSize, IFileset de, DataFile dataFile, List<FileDataUnit> fileList) {
        int count = 0;
        FileDataUnit taskFile = null;
        RefObject fileName = new RefObject(null);
        StringBuilder fileNameBuilder = new StringBuilder();
        if (DataInstanceUtil.getFileAccurateName(dataFile, packageDir, dataKeyName, de, fileNameBuilder)) {
            String filePath = de.getFileStorage().combinePaths(de.getFullPath(), new String[]{fileNameBuilder.toString()});
            fileName.set((Object)FileStorageCache.getFile(de.getFileStorage(), filePath));
            if (fileName.get() != null && DataInstanceUtil.isFileExist((RefObject<IFileset>)fileName).booleanValue() && !DataInstanceUtil.containFileName((IFileset)fileName.get(), fileList)) {
                taskFile = new FileDataUnit();
                taskFile.setCatalogFileType(CatalogFileTypeEnum.SingleFile);
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(dataFile.getProperties());
                taskFile.setProperties(properties);
                taskFile.setFileLocation(((IFileset)fileName.get()).getFullPath());
                taskFile.setFileSourceLocation(((IFileset)fileName.get()).getFullPath());
                taskFile.setDataAmount(DataInstanceUtil.getFileAmount((IFileset)fileName.get()));
                taskFile.setPackagePath(dataFile.getPathWithoutModelName());
                fileList.add(taskFile);
                totalSize.set((Object)((Long)totalSize.get() + taskFile.getDataAmount()));
                count = 1;
            }
        } else {
            ArrayList<FileDataUnit> existFiles = new ArrayList<FileDataUnit>(fileList);
            List<Object> files = new ArrayList();
            try {
                files = DataInstanceUtil.getFilesByExtensions(dataFile.getFileExtensionCollection(), de);
            }
            catch (Exception ex) {
                log.error("\u6587\u4ef6\u540e\u7f00\u5904\u7406\u5f02\u5e38", (Throwable)ex);
            }
            for (IFileset iFileset : files) {
                boolean canAdd;
                if (DataInstanceUtil.containFileName(iFileset, existFiles) || dataFile.getFileExtension().compareTo(".*") != 0 && !DataInstanceUtil.isEffectiveExtension(dataFile, FileUtil.getExtension((String)iFileset.getName())) || !(canAdd = DataInstanceUtil.canAdd(dataFile, iFileset, packageDir, dataKeyName))) continue;
                ++count;
                taskFile = new FileDataUnit();
                taskFile.setCatalogFileType(CatalogFileTypeEnum.SingleFile);
                ArrayList<String> properties = new ArrayList<String>();
                properties.addAll(dataFile.getProperties());
                taskFile.setProperties(properties);
                taskFile.setFileLocation(iFileset.getFullPath());
                taskFile.setFileSourceLocation(iFileset.getFullPath());
                taskFile.setDataAmount(DataInstanceUtil.getFileAmount(iFileset));
                taskFile.setPackagePath(dataFile.getPathWithoutModelName());
                fileList.add(taskFile);
                totalSize.set((Object)((Long)totalSize.get() + taskFile.getDataAmount()));
            }
        }
        return count;
    }

    private static IFileset getRealPath(DataPackage dataPackage, DataCompactPackage dataCompactPackage, IFileset dataFolderPath, IFileset scanFolder) {
        return dataPackage.getArchiveEnvironment().getCompactPagRealPath(dataCompactPackage, dataFolderPath, scanFolder);
    }

    private static List<IFileset> getFilesByExtensions(List<String> extensions, IFileset dir) {
        List<IFileset> allFiles = FileHelper.searchFileData(dir, null, true);
        if (extensions.contains(".*")) {
            return allFiles;
        }
        ArrayList<IFileset> files = new ArrayList<IFileset>();
        for (String ext : extensions) {
            files.addAll(allFiles.stream().filter(f -> f.getFullPath().toUpperCase(Locale.ROOT).endsWith(ext.toUpperCase(Locale.ROOT))).collect(Collectors.toList()));
        }
        return files;
    }

    private static boolean isEffectiveExtension(DataFile dataFile, String extension) {
        List<String> extensionCollection = dataFile.getFileExtensionCollection();
        List upperExtensionCol = extensionCollection.stream().map(f -> f.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        return upperExtensionCol.contains(extension.toUpperCase(Locale.ROOT));
    }

    private static boolean containFileName(IFileset fileName, List<FileDataUnit> existFiles) {
        if (existFiles == null || existFiles.size() == 0) {
            return false;
        }
        return existFiles.stream().filter(f -> f.getFileLocation().toUpperCase(Locale.ROOT).equals(fileName.getFullPath().toUpperCase(Locale.ROOT))).count() > 0L;
    }

    public static boolean containsDir(IFileset dir, List<FileDataUnit> fileList) {
        if (fileList == null) {
            return false;
        }
        for (FileDataUnit file : fileList) {
            if (!file.getFileLocation().contains(dir.getFullPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean getFileAccurateName(DataFile dataFile, String packageDir, String dataKeyName, IFileset dirName, StringBuilder fileName) {
        if (dataFile.getFileExtension().equals(".*")) {
            return false;
        }
        boolean flg = true;
        fileName.delete(0, fileName.length());
        switch (dataFile.getFileNameRuler()) {
            case SameWithMainFile: {
                fileName.append(DataInstanceUtil.selectFileExtension(dirName, dataKeyName, dataFile.getFileExtensionCollection()));
                break;
            }
            case PrefixMainFile: {
                String custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                fileName.append(DataInstanceUtil.selectFileExtension(dirName, custom + dataKeyName, dataFile.getFileExtensionCollection()));
                break;
            }
            case SuffixMainFile: {
                String custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                fileName.append(DataInstanceUtil.selectFileExtension(dirName, dataKeyName + custom, dataFile.getFileExtensionCollection()));
                break;
            }
            case SameWithCustom: {
                String custom = DataInstanceUtil.getCustomNameByNameRule(dataFile.getCustomNameRuler(), packageDir, dataKeyName);
                fileName.append(DataInstanceUtil.selectFileExtension(dirName, custom, dataFile.getFileExtensionCollection()));
                break;
            }
            default: {
                flg = false;
            }
        }
        return flg;
    }

    private static String selectFileExtension(IFileset dirName, String fileName, List<String> extensions) {
        for (String ext : extensions) {
            String fullFileName = fileName + ext;
            RefObject fullName = new RefObject();
            String fullPath = dirName.getFileStorage().combinePaths(dirName.getFullPath(), new String[]{fullFileName});
            fullName.set((Object)FileStorageCache.getFile(dirName.getFileStorage(), fullPath));
            if (fullName.get() == null || !DataInstanceUtil.isFileExist((RefObject<IFileset>)fullName).booleanValue()) continue;
            return fullFileName;
        }
        return "";
    }

    private static String getCustomNameByNameRule(CustomNameRuler ruler, String packageDir, String mainFileName) {
        if (ruler == null) {
            return null;
        }
        switch (ruler.getType()) {
            case String: {
                return ruler.getCustomString();
            }
        }
        return "";
    }

    private static IFileset[] getFileInfoByExtensionCollection(IFileset dirInfo, final DataFile dataFile, ScanModelParam modelParam) {
        Predicate<IFileset> searchPattern = null;
        ArrayList<IFileset> mainFiles = new ArrayList<IFileset>();
        List<String> fileExtensionCollection = dataFile.getFileExtensionCollection();
        DataFileNameRulerEnum fileNameRuler = dataFile.getFileNameRuler();
        block5: for (final String extension : fileExtensionCollection) {
            switch (fileNameRuler) {
                case SameWithCustom: {
                    searchPattern = new Predicate<IFileset>(){

                        @Override
                        public boolean test(IFileset pathname) {
                            return FileHelper.getNameWithoutExt(pathname, extension).equals(dataFile.getCustomNameRuler().getCustomString());
                        }
                    };
                    mainFiles.addAll(DataInstanceUtil.getFileInfos(searchPattern, extension, dirInfo));
                    continue block5;
                }
                case ContainsCustom: {
                    searchPattern = new Predicate<IFileset>(){

                        @Override
                        public boolean test(IFileset pathname) {
                            return pathname.getName().contains(dataFile.getCustomNameRuler().getCustomString());
                        }
                    };
                    mainFiles.addAll(DataInstanceUtil.getFileInfos(searchPattern, extension, dirInfo));
                    continue block5;
                }
                case CustomScript: {
                    searchPattern = new Predicate<IFileset>(){

                        @Override
                        public boolean test(IFileset pathname) {
                            boolean isAdd = false;
                            try {
                                NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                                checkDTO.setJsContent(dataFile.getCustomNameRuler().getCustomString());
                                checkDTO.setCurrentFileName(pathname.getName());
                                checkDTO.setMainDataFileName(pathname.getName());
                                checkDTO.setDataFolder(pathname.getParentFile() == null ? "" : pathname.getParentFile().getName());
                                String checkResult = DataInstanceUtil.checkNameRuleJs(checkDTO);
                                isAdd = Boolean.parseBoolean(checkResult);
                            }
                            catch (Exception e) {
                                log.error(pathname.getName() + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                                isAdd = false;
                            }
                            return isAdd;
                        }
                    };
                    mainFiles.addAll(DataInstanceUtil.getFileInfos(searchPattern, extension, dirInfo));
                    continue block5;
                }
            }
            mainFiles.addAll(DataInstanceUtil.getFileInfos(null, extension, dirInfo));
        }
        IFileset[] mainFilesArray = new IFileset[mainFiles.size()];
        mainFiles.toArray(mainFilesArray);
        return mainFilesArray;
    }

    public static IFileset[] getFileInfoByExtensionCollection(IFileset dirInfo, DataCompactPackage compactPackage, ScanModelParam modelParam) {
        Predicate<IFileset> searchPattern = null;
        ArrayList<IFileset> mainFiles = new ArrayList<IFileset>();
        String extension = compactPackage.getPackageType();
        switch (compactPackage.getFolderNameRulerType()) {
            case FixedName: {
                IFileset mainFile = FileStorageCache.getFile(dirInfo.getFileStorage(), String.format("%s/%s", dirInfo.getFullPath(), compactPackage.getName() + compactPackage.getPackageType()));
                mainFiles.add(mainFile);
                break;
            }
            case ContainsCustom: {
                searchPattern = pathname -> pathname.getName().contains(compactPackage.getCustomNameRuler().getCustomString());
                mainFiles.addAll(DataInstanceUtil.getFileInfos(searchPattern, extension, dirInfo));
                break;
            }
            case CustomScript: {
                searchPattern = pathname -> {
                    boolean isAdd = false;
                    try {
                        NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                        checkDTO.setJsContent(compactPackage.getCustomNameRuler().getCustomString());
                        checkDTO.setCurrentFileName(pathname.getName());
                        checkDTO.setMainDataFileName(pathname.getName());
                        checkDTO.setDataFolder(pathname.getParentFile() == null ? "" : pathname.getParentFile().getName());
                        String checkResult = DataInstanceUtil.checkNameRuleJs(checkDTO);
                        isAdd = Boolean.parseBoolean(checkResult);
                    }
                    catch (Exception e) {
                        log.error(pathname.getName() + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                        isAdd = false;
                    }
                    return isAdd;
                };
                mainFiles.addAll(DataInstanceUtil.getFileInfos(searchPattern, extension, dirInfo));
                break;
            }
            default: {
                mainFiles.addAll(DataInstanceUtil.getFileInfos(null, extension, dirInfo));
            }
        }
        IFileset[] mainFilesArray = new IFileset[mainFiles.size()];
        mainFiles.toArray(mainFilesArray);
        return mainFilesArray;
    }

    private static IFileset[] findDirectory(ScanModelParam modelParam, IFileset folder) {
        Predicate<IFileset> searchPattern = null;
        ArrayList<IFileset> folderNames = new ArrayList<IFileset>();
        final DataFolder keyFolder = modelParam.getKeyFolder();
        log.debug("\u5f00\u59cb\u626b\u63cf\u6587\u4ef6\u5939findDirectory\uff1a" + (folder == null ? "" : folder.getFullPath()));
        DataFolderNameRulerEnum dataFolderNameRuler = keyFolder.getFolderNameRulerType();
        switch (dataFolderNameRuler) {
            case FixedName: {
                searchPattern = new Predicate<IFileset>(){

                    @Override
                    public boolean test(IFileset pathname) {
                        return FileHelper.getNameWithoutExt(pathname, "").equals(keyFolder.getCustomNameRuler().getCustomString());
                    }
                };
                break;
            }
            case ContainsCustom: {
                searchPattern = new Predicate<IFileset>(){

                    @Override
                    public boolean test(IFileset pathname) {
                        return pathname.getName().contains(keyFolder.getCustomNameRuler().getCustomString());
                    }
                };
                break;
            }
            case CustomScript: {
                searchPattern = new Predicate<IFileset>(){

                    @Override
                    public boolean test(IFileset pathname) {
                        boolean isAdd = false;
                        try {
                            NameRuleJsCheckDTO checkDTO = new NameRuleJsCheckDTO();
                            checkDTO.setJsContent(keyFolder.getCustomNameRuler().getCustomString());
                            checkDTO.setCurrentFileName(pathname.getName());
                            checkDTO.setMainDataFileName(pathname.getName());
                            checkDTO.setDataFolder(pathname.getParentFile() == null ? "" : pathname.getParentFile().getName());
                            String checkResult = DataInstanceUtil.checkNameRuleJs(checkDTO);
                            isAdd = Boolean.parseBoolean(checkResult);
                        }
                        catch (Exception e) {
                            log.error(pathname.getName() + "\u9a8c\u8bc1\u811a\u672c\u5931\u8d25\uff01");
                            isAdd = false;
                        }
                        return isAdd;
                    }
                };
                break;
            }
        }
        if (folder != null && (searchPattern == null || searchPattern.test(folder))) {
            folderNames.add(folder);
        }
        folderNames.addAll(DataInstanceUtil.findKeyFolder(folder, searchPattern));
        IFileset[] folderNameArray = new IFileset[folderNames.size()];
        folderNames.toArray(folderNameArray);
        return folderNameArray;
    }

    private static List<IFileset> getFileInfos(Predicate<IFileset> searchPattern, String extension, IFileset dirInfo) {
        if (".*".equals(extension)) {
            return FileHelper.searchFileData(dirInfo, searchPattern, false);
        }
        List<IFileset> allFiles = FileHelper.searchFileData(dirInfo, searchPattern, false);
        return allFiles.stream().filter(f -> f.getFullPath().toUpperCase(Locale.ROOT).endsWith(extension.toUpperCase(Locale.ROOT))).collect(Collectors.toList());
    }

    private static List<IFileset> findKeyFolder(IFileset dirFileset, Predicate<IFileset> pattern) {
        ArrayList<IFileset> dirInfos = new ArrayList<IFileset>();
        try {
            if (dirFileset == null) {
                log.error("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff01");
                return dirInfos;
            }
            List<IFileset> subFiles = FileStorageCache.listFiles(dirFileset);
            if (subFiles == null) {
                return dirInfos;
            }
            for (IFileset file : subFiles) {
                if (!pattern.test(file) || !file.getIsDirectory()) continue;
                dirInfos.add(file);
            }
            for (IFileset item : subFiles) {
                if (!item.getIsDirectory() || dirInfos.contains(item)) continue;
                dirInfos.addAll(DataInstanceUtil.findKeyFolder(item, pattern));
            }
            return dirInfos;
        }
        catch (Exception ex) {
            log.error((dirFileset == null ? "null" : dirFileset.getFullPath()) + " \u6587\u4ef6\u5939\u904d\u5386\u5f02\u5e38", (Throwable)ex);
            return dirInfos;
        }
    }

    private static Boolean hasFiles(IFileset dirPath) {
        List<IFileset> subFiles = FileStorageCache.listFiles(dirPath);
        return subFiles != null && subFiles.size() > 0;
    }

    private static Long getFileAmount(IFileset fileName) {
        if (fileName.getFullPath().replace("\\", "/").startsWith(UploadPathConfig.getUploadPath().toString().replace("\\", "/"))) {
            return 0L;
        }
        return fileName.getSize();
    }

    private static Boolean isFileExist(RefObject<IFileset> path) {
        List<String> extensionCol;
        String extension = "";
        int index = ((IFileset)path.get()).getFullPath().lastIndexOf(".");
        if (!((IFileset)path.get()).getIsDirectory() && index >= 0) {
            extension = ((IFileset)path.get()).getFullPath().substring(index);
        }
        if ((extensionCol = DataInstanceUtil.getStringIgnoreCase(extension)).size() > 0) {
            for (String s : extensionCol) {
                String realPath = ((IFileset)path.get()).getFullPath().substring(0, index) + s;
                IFileset file = FileStorageCache.getFile(((IFileset)path.get()).getFileStorage(), realPath);
                if (file == null) continue;
                path.set((Object)file);
                return true;
            }
        } else {
            return path.get() != null && !((IFileset)path.get()).getIsDirectory();
        }
        return false;
    }

    public static List<String> getStringIgnoreCase(String fileExtension) {
        ArrayList<String> extensionCol = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)fileExtension)) {
            String[] extensionCollection;
            for (String ext : extensionCollection = fileExtension.split(";")) {
                int i;
                char[] array = ext.toLowerCase(Locale.ROOT).toCharArray();
                int n = 1;
                int num = 0;
                boolean[] flags = new boolean[array.length];
                for (i = 0; i < array.length; ++i) {
                    if (Character.isLetter(array[i])) {
                        flags[i] = true;
                        n *= 2;
                        ++num;
                        continue;
                    }
                    flags[i] = false;
                }
                for (i = 0; i < n; ++i) {
                    String temp = Integer.toBinaryString(i);
                    StringBuilder stringBuffer = new StringBuilder();
                    for (int j = 0; j < num - temp.length(); ++j) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(temp);
                    char[] tempArray = stringBuffer.toString().toCharArray();
                    int k = 0;
                    StringBuilder item = new StringBuilder();
                    for (int j = 0; j < flags.length; ++j) {
                        char value = array[j];
                        if (flags[j]) {
                            if ('0' == tempArray[k]) {
                                item.append(Character.toLowerCase(value));
                            } else {
                                item.append(Character.toUpperCase(value));
                            }
                            ++k;
                            continue;
                        }
                        item.append(value);
                    }
                    extensionCol.add(item.toString());
                }
            }
        }
        return extensionCol;
    }
}

