/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmBaseMapDao;
import com.geoway.adf.dms.config.dto.basemap.BaseMapDTO;
import com.geoway.adf.dms.config.dto.basemap.BaseMapGroupDTO;
import com.geoway.adf.dms.config.dto.basemap.BaseMapItemTypeEnum;
import com.geoway.adf.dms.config.dto.basemap.BaseMapServiceDTO;
import com.geoway.adf.dms.config.entity.CmBaseMap;
import com.geoway.adf.dms.config.service.CmBaseMapService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

@Service
public class CmBaseMapServiceImpl
implements CmBaseMapService {
    private static final Logger log = LoggerFactory.getLogger(CmBaseMapServiceImpl.class);
    @Resource
    private CmBaseMapDao cmBaseMapDao;

    @Override
    public List<BaseMapDTO> list(String types) {
        List<CmBaseMap> allBaseMap;
        List<Integer> typeList = new ArrayList<Integer>();
        boolean removeEmptyGroup = false;
        if (StringUtil.isNotEmpty((String)types)) {
            typeList = StringUtil.split((String)types, (String)",", Integer::parseInt);
            for (Integer type : typeList) {
                BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(type);
                switch (typeEnum) {
                    case WMTS: 
                    case MapServer: 
                    case XYZ: 
                    case VectorTileData: 
                    case VectorTileService: 
                    case Annotation3: 
                    case BaiduMapService: 
                    case TerrainIME: 
                    case TerrainArcGIS: 
                    case TerrainCesium: {
                        removeEmptyGroup = true;
                        break;
                    }
                }
            }
        }
        this.completeTypes(typeList);
        if (typeList.size() == 0) {
            typeList.addAll(ListUtil.convertAll((Object[])BaseMapItemTypeEnum.values(), BaseMapItemTypeEnum::getValue));
        }
        if ((allBaseMap = this.cmBaseMapDao.selectByTypes(typeList)).size() > 0 && allBaseMap.get(0).getOrder() == null) {
            this.resetAllServiceOrder();
            allBaseMap = this.cmBaseMapDao.selectByTypes(typeList);
        }
        List allDto = ListUtil.convertAll(allBaseMap, this::convertToDto);
        allDto = this.groupBaseMapDto(allDto);
        if (removeEmptyGroup) {
            allDto = ListUtil.findAll(allDto, f -> f instanceof BaseMapGroupDTO && ((BaseMapGroupDTO)f).getServices() != null && ((BaseMapGroupDTO)f).getServices().size() > 0);
        }
        return allDto;
    }

    @Override
    public BaseMapDTO getDetail(String id) {
        CmBaseMap baseMap = this.cmBaseMapDao.selectByPrimaryKey(id);
        Assert.notNull((Object)baseMap, (String)"\u5e95\u56fe\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
        BaseMapDTO dto = this.convertToDto(baseMap);
        Assert.notNull((Object)dto, (String)"\u5e95\u56fe\u914d\u7f6e\u4e0d\u5b58\u5728\uff01");
        return dto;
    }

    @Override
    public String getBaseMapExtentJson() {
        List<CmBaseMap> extentList = this.cmBaseMapDao.selectByNameType("\u5e95\u56fe\u8303\u56f4", -90);
        String extentJson = "";
        extentJson = extentList == null || extentList.size() == 0 ? "" : extentList.get(0).getExtension();
        if (StringUtil.isEmptyOrWhiteSpace((String)extentJson)) {
            return null;
        }
        return extentJson;
    }

    @Override
    public void updateBaseMapExtentJson(String extentJson) {
        CmBaseMap extent = new CmBaseMap();
        extent.setName("\u5e95\u56fe\u8303\u56f4");
        extent.setType(-90);
        extent.setExtension(extentJson);
        List<CmBaseMap> extentList = this.cmBaseMapDao.selectByNameType("\u5e95\u56fe\u8303\u56f4", -90);
        if (extentList == null || extentList.size() == 0) {
            extent.setId(IdUtil.getSnowflakeNextIdStr());
            this.cmBaseMapDao.insert(extent);
        } else {
            extent.setId(extentList.get(0).getId());
            this.cmBaseMapDao.updateByPrimaryKey(extent);
        }
    }

    @Override
    public String addBaseMapGroup(BaseMapDTO groupDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)groupDTO.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\uff01");
        }
        List<CmBaseMap> sameList = this.cmBaseMapDao.selectByNameType(groupDTO.getName(), groupDTO.getType());
        Assert.isTrue((sameList.size() == 0 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u5df2\u5b58\u5728\uff01");
        CmBaseMap baseMap = new CmBaseMap();
        baseMap.setId(IdUtil.getSnowflakeNextIdStr());
        baseMap.setName(groupDTO.getName());
        baseMap.setGroupId("-1");
        baseMap.setIsDefault(ConstantsValue.FALSE_VALUE);
        baseMap.setType(groupDTO.getType());
        BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(groupDTO.getType());
        if (typeEnum != BaseMapItemTypeEnum.GroupMapCustom && typeEnum != BaseMapItemTypeEnum.GroupTerrain && typeEnum != BaseMapItemTypeEnum.GroupVector && typeEnum != BaseMapItemTypeEnum.GroupRaster && typeEnum != BaseMapItemTypeEnum.GroupShaded) {
            throw new RuntimeException("\u5206\u7ec4\u7c7b\u578b\u6709\u8bef\uff01");
        }
        Integer order = this.cmBaseMapDao.queryMaxOrder(baseMap.getGroupId());
        if (order == null) {
            order = 0;
        }
        baseMap.setOrder(order + 1);
        this.cmBaseMapDao.insert(baseMap);
        return baseMap.getId();
    }

    @Override
    public void updateBaseMapGroup(BaseMapDTO groupDTO) {
        CmBaseMap baseMap = this.cmBaseMapDao.selectByPrimaryKey(groupDTO.getId());
        Assert.notNull((Object)baseMap, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
        if (groupDTO.getName() != null && !baseMap.getName().equals(groupDTO.getName())) {
            List<CmBaseMap> sameList = this.cmBaseMapDao.selectByNameType(groupDTO.getName(), baseMap.getType());
            Assert.isTrue((sameList.size() == 0 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u5df2\u5b58\u5728\uff01");
            baseMap.setName(groupDTO.getName());
        }
        if (groupDTO.getType() != null) {
            BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(groupDTO.getType());
            if (typeEnum != BaseMapItemTypeEnum.GroupMapCustom && typeEnum != BaseMapItemTypeEnum.GroupTerrain && typeEnum != BaseMapItemTypeEnum.GroupVector && typeEnum != BaseMapItemTypeEnum.GroupRaster && typeEnum != BaseMapItemTypeEnum.GroupShaded) {
                throw new RuntimeException("\u5206\u7ec4\u7c7b\u578b\u6709\u8bef\uff01");
            }
            baseMap.setType(groupDTO.getType());
        }
        this.cmBaseMapDao.updateByPrimaryKey(baseMap);
    }

    @Override
    public String addBaseMapService(BaseMapServiceDTO serviceDTO) {
        Integer order;
        if (StringUtil.isEmptyOrWhiteSpace((String)serviceDTO.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\uff01");
        }
        BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(serviceDTO.getType());
        if (typeEnum == null || typeEnum == BaseMapItemTypeEnum.GroupMap || typeEnum == BaseMapItemTypeEnum.GroupTerrain || typeEnum == BaseMapItemTypeEnum.GroupMapCustom || typeEnum == BaseMapItemTypeEnum.GroupVector || typeEnum == BaseMapItemTypeEnum.GroupRaster || typeEnum == BaseMapItemTypeEnum.GroupShaded) {
            throw new RuntimeException("\u5e95\u56fe\u670d\u52a1\u7c7b\u578b\u6709\u8bef\uff01");
        }
        if (StringUtil.isNotEmpty((String)serviceDTO.getGroupId())) {
            CmBaseMap group = this.cmBaseMapDao.selectByPrimaryKey(serviceDTO.getGroupId());
            Assert.notNull((Object)group, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
        } else if (typeEnum == BaseMapItemTypeEnum.TerrainIME || typeEnum == BaseMapItemTypeEnum.TerrainArcGIS || typeEnum == BaseMapItemTypeEnum.TerrainCesium) {
            List<CmBaseMap> groups = this.cmBaseMapDao.selectDefaultGroup(BaseMapItemTypeEnum.GroupTerrain.getValue());
            if (groups == null || groups.size() == 0) {
                throw new RuntimeException("\u65e0\u9ed8\u8ba4\u5730\u5f62\u5206\u7ec4");
            }
            serviceDTO.setGroupId(groups.get(0).getId());
        }
        List<CmBaseMap> sameList = this.cmBaseMapDao.selectByNameTypeGroup(serviceDTO.getName(), serviceDTO.getType(), serviceDTO.getGroupId());
        Assert.isTrue((sameList.size() == 0 ? 1 : 0) != 0, (String)"\u5e95\u56fe\u670d\u52a1\u5df2\u5b58\u5728\uff01");
        CmBaseMap baseMap = new CmBaseMap();
        baseMap.setId(IdUtil.getSnowflakeNextIdStr());
        baseMap.setName(serviceDTO.getName());
        baseMap.setType(serviceDTO.getType());
        baseMap.setServiceUrl(serviceDTO.getServiceUrl());
        baseMap.setEnable(serviceDTO.getEnable() == null || serviceDTO.getEnable() == false ? ConstantsValue.FALSE_VALUE : ConstantsValue.TRUE_VALUE);
        baseMap.setMinLevel(serviceDTO.getMinLevel());
        baseMap.setMaxLevel(serviceDTO.getMaxLevel());
        baseMap.setVisible2d(serviceDTO.getVisible2d() == null || serviceDTO.getVisible2d() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        baseMap.setVisible3d(serviceDTO.getVisible3d() == null || serviceDTO.getVisible3d() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        baseMap.setNote(serviceDTO.getNote() == null || serviceDTO.getNote() == false ? ConstantsValue.FALSE_VALUE : ConstantsValue.TRUE_VALUE);
        baseMap.setGroupId(serviceDTO.getGroupId());
        baseMap.setSubdomain(serviceDTO.getSubdomain());
        baseMap.setServiceVague(serviceDTO.getServiceVague() == null || serviceDTO.getServiceVague() == false ? ConstantsValue.FALSE_VALUE : ConstantsValue.TRUE_VALUE);
        baseMap.setOpenAvoidance(serviceDTO.getOpenAvoidance() == null || serviceDTO.getOpenAvoidance() == false ? ConstantsValue.FALSE_VALUE : ConstantsValue.TRUE_VALUE);
        baseMap.setAnnotationPixelRange(serviceDTO.getAnnotationPixelRange());
        baseMap.setExtension(serviceDTO.getExtension());
        if (typeEnum == BaseMapItemTypeEnum.TerrainIME || typeEnum == BaseMapItemTypeEnum.TerrainArcGIS || typeEnum == BaseMapItemTypeEnum.TerrainCesium) {
            baseMap.setVisible3d(ConstantsValue.TRUE_VALUE);
            baseMap.setVisible2d(ConstantsValue.FALSE_VALUE);
            baseMap.setNote(ConstantsValue.FALSE_VALUE);
        }
        if (typeEnum == BaseMapItemTypeEnum.Annotation3) {
            baseMap.setVisible3d(ConstantsValue.TRUE_VALUE);
            baseMap.setVisible2d(ConstantsValue.FALSE_VALUE);
            baseMap.setNote(ConstantsValue.TRUE_VALUE);
        }
        if ((order = this.cmBaseMapDao.queryMaxOrder(baseMap.getGroupId())) == null) {
            order = 0;
        }
        baseMap.setOrder(order + 1);
        this.cmBaseMapDao.insert(baseMap);
        return baseMap.getId();
    }

    @Override
    public void updateBaseMapService(BaseMapServiceDTO serviceDTO) {
        CmBaseMap baseMap = this.cmBaseMapDao.selectByPrimaryKey(serviceDTO.getId());
        Assert.notNull((Object)baseMap, (String)"\u5e95\u56fe\u670d\u52a1\u4e0d\u5b58\u5728\uff01");
        BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(serviceDTO.getType());
        if (typeEnum == null) {
            typeEnum = BaseMapItemTypeEnum.getByValue(baseMap.getType());
        }
        if (typeEnum == null || typeEnum == BaseMapItemTypeEnum.GroupMap || typeEnum == BaseMapItemTypeEnum.GroupTerrain) {
            throw new RuntimeException("\u5e95\u56fe\u670d\u52a1\u7c7b\u578b\u6709\u8bef\uff01");
        }
        if (serviceDTO.getName() != null && !baseMap.getName().equals(serviceDTO.getName())) {
            List<CmBaseMap> sameList = this.cmBaseMapDao.selectByNameTypeGroup(serviceDTO.getName(), typeEnum.getValue(), serviceDTO.getGroupId());
            Assert.isTrue((sameList.size() == 0 ? 1 : 0) != 0, (String)"\u5e95\u56fe\u670d\u52a1\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            baseMap.setName(serviceDTO.getName());
        }
        baseMap.setType(typeEnum.getValue());
        if (serviceDTO.getServiceUrl() != null) {
            baseMap.setServiceUrl(serviceDTO.getServiceUrl());
        }
        if (serviceDTO.getEnable() != null) {
            baseMap.setEnable(serviceDTO.getEnable() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getMinLevel() != null) {
            baseMap.setMinLevel(serviceDTO.getMinLevel());
        }
        if (serviceDTO.getMaxLevel() != null) {
            baseMap.setMaxLevel(serviceDTO.getMaxLevel());
        }
        if (serviceDTO.getVisible2d() != null) {
            baseMap.setVisible2d(serviceDTO.getVisible2d() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getVisible3d() != null) {
            baseMap.setVisible3d(serviceDTO.getVisible3d() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getNote() != null) {
            baseMap.setNote(serviceDTO.getNote() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getGroupId() != null) {
            CmBaseMap group = this.cmBaseMapDao.selectByPrimaryKey(serviceDTO.getGroupId());
            Assert.notNull((Object)group, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
            baseMap.setGroupId(serviceDTO.getGroupId());
        }
        if (serviceDTO.getSubdomain() != null) {
            baseMap.setSubdomain(serviceDTO.getSubdomain());
        }
        if (serviceDTO.getServiceVague() != null) {
            baseMap.setServiceVague(serviceDTO.getServiceVague() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getOpenAvoidance() != null) {
            baseMap.setOpenAvoidance(serviceDTO.getOpenAvoidance() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        }
        if (serviceDTO.getAnnotationPixelRange() != null) {
            baseMap.setAnnotationPixelRange(serviceDTO.getAnnotationPixelRange());
        }
        if (serviceDTO.getExtension() != null) {
            baseMap.setExtension(serviceDTO.getExtension());
        }
        this.cmBaseMapDao.updateByPrimaryKey(baseMap);
    }

    @Override
    public void deleteBaseMap(String id) {
        if ("-1".equals(id)) {
            return;
        }
        this.cmBaseMapDao.deleteByPrimaryKey(id);
    }

    @Override
    public void setDefaultGroup(String id, Boolean isDefault) {
        CmBaseMap baseMap = this.cmBaseMapDao.selectByPrimaryKey(id);
        Assert.notNull((Object)baseMap, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
        if (isDefault.booleanValue()) {
            ArrayList<Integer> typeList = new ArrayList<Integer>();
            BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(baseMap.getType());
            switch (typeEnum) {
                case GroupMap: 
                case GroupVector: 
                case GroupRaster: 
                case GroupShaded: 
                case GroupMapCustom: {
                    typeList.add(BaseMapItemTypeEnum.GroupMap.getValue());
                    typeList.add(BaseMapItemTypeEnum.GroupVector.getValue());
                    typeList.add(BaseMapItemTypeEnum.GroupRaster.getValue());
                    typeList.add(BaseMapItemTypeEnum.GroupShaded.getValue());
                    typeList.add(BaseMapItemTypeEnum.GroupMapCustom.getValue());
                    break;
                }
                default: {
                    typeList.add(baseMap.getType());
                }
            }
            this.cmBaseMapDao.cancelDefaultCatalog(typeList);
        }
        this.cmBaseMapDao.setDefaultGroup(id);
    }

    @Override
    public void updateServiceOrder(String id, Integer order) {
        List<CmBaseMap> brotherList = this.cmBaseMapDao.selectBrotherService(id);
        brotherList.forEach(service -> {
            if (service.getId().equals(id)) {
                service.setOrder(-order.intValue());
            }
        });
        brotherList.sort((o1, o2) -> {
            if (o1.getOrder() + o2.getOrder() == 0) {
                return o2.getOrder() - o1.getOrder();
            }
            return Math.abs(o1.getOrder()) - Math.abs(o2.getOrder());
        });
        this.sortServiceNodes(brotherList);
    }

    @Override
    public void editGroupPicture(String id, Boolean deletePicture, MultipartFile picture) {
        CmBaseMap baseMap = this.cmBaseMapDao.selectByPrimaryKey(id);
        Assert.notNull((Object)baseMap, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728\uff01");
        if (deletePicture.booleanValue()) {
            this.cmBaseMapDao.updatePictureByPrimaryKey(id, null);
        } else if (picture != null) {
            String base64Code = this.getBase64Image(picture);
            this.cmBaseMapDao.updatePictureByPrimaryKey(id, base64Code.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void sortServiceNodes(List<CmBaseMap> serviceList) {
        int count = serviceList.size();
        for (int i = 0; i < count; ++i) {
            CmBaseMap child = serviceList.get(i);
            child.setOrder(i + 1);
            this.cmBaseMapDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    private void resetAllServiceOrder() {
        List<CmBaseMap> allGroup = this.cmBaseMapDao.selectByGroupId("-1");
        if (allGroup.size() > 0 && allGroup.get(0).getOrder() == null) {
            allGroup.sort(Comparator.comparing(CmBaseMap::getId));
            this.sortServiceNodes(allGroup);
        }
        for (CmBaseMap group : allGroup) {
            List<CmBaseMap> children = this.cmBaseMapDao.selectByGroupId(group.getId());
            if (children.size() <= 0 || children.get(0).getOrder() != null) continue;
            children.sort(Comparator.comparing(CmBaseMap::getId));
            this.sortServiceNodes(children);
        }
    }

    private List<BaseMapDTO> groupBaseMapDto(List<BaseMapDTO> allDto) {
        List allGroup = ListUtil.findAll(allDto, f -> f instanceof BaseMapGroupDTO);
        if (allGroup.size() > 0) {
            for (BaseMapDTO group : allGroup) {
                List serviceList = ListUtil.findAll(allDto, f -> f instanceof BaseMapServiceDTO && group.getId().equals(((BaseMapServiceDTO)f).getGroupId()));
                ((BaseMapGroupDTO)group).setServices(serviceList);
            }
            return allGroup;
        }
        return allDto;
    }

    private BaseMapDTO convertToDto(CmBaseMap baseMap) {
        BaseMapDTO dto;
        BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(baseMap.getType());
        switch (typeEnum) {
            case GroupMap: 
            case GroupTerrain: 
            case GroupVector: 
            case GroupRaster: 
            case GroupShaded: 
            case GroupMapCustom: {
                dto = new BaseMapGroupDTO();
                ((BaseMapGroupDTO)dto).setIsDefault(baseMap.getIsDefault() != null && ConstantsValue.TRUE_VALUE.equals(baseMap.getIsDefault()));
                if (baseMap.getPicture() == null) break;
                ((BaseMapGroupDTO)dto).setPictureBase64(new String((byte[])baseMap.getPicture(), StandardCharsets.UTF_8));
                break;
            }
            case WMTS: 
            case MapServer: 
            case XYZ: 
            case VectorTileData: 
            case VectorTileService: 
            case Annotation3: 
            case BaiduMapService: 
            case TerrainIME: 
            case TerrainArcGIS: 
            case TerrainCesium: {
                dto = new BaseMapServiceDTO();
                ((BaseMapServiceDTO)dto).setServiceUrl(baseMap.getServiceUrl());
                ((BaseMapServiceDTO)dto).setEnable(ConstantsValue.TRUE_VALUE.equals(baseMap.getEnable()));
                ((BaseMapServiceDTO)dto).setMinLevel(baseMap.getMinLevel());
                ((BaseMapServiceDTO)dto).setMaxLevel(baseMap.getMaxLevel());
                ((BaseMapServiceDTO)dto).setVisible2d(ConstantsValue.TRUE_VALUE.equals(baseMap.getVisible2d()));
                ((BaseMapServiceDTO)dto).setVisible3d(ConstantsValue.TRUE_VALUE.equals(baseMap.getVisible3d()));
                ((BaseMapServiceDTO)dto).setNote(ConstantsValue.TRUE_VALUE.equals(baseMap.getNote()));
                ((BaseMapServiceDTO)dto).setGroupId(baseMap.getGroupId());
                ((BaseMapServiceDTO)dto).setSubdomain(baseMap.getSubdomain());
                ((BaseMapServiceDTO)dto).setServiceVague(ConstantsValue.TRUE_VALUE.equals(baseMap.getServiceVague()));
                ((BaseMapServiceDTO)dto).setOpenAvoidance(ConstantsValue.TRUE_VALUE.equals(baseMap.getOpenAvoidance()));
                ((BaseMapServiceDTO)dto).setAnnotationPixelRange(baseMap.getAnnotationPixelRange());
                ((BaseMapServiceDTO)dto).setExtension(baseMap.getExtension());
                break;
            }
            default: {
                return null;
            }
        }
        dto.setId(baseMap.getId());
        dto.setName(baseMap.getName());
        dto.setType(baseMap.getType());
        dto.setOrder(baseMap.getOrder());
        return dto;
    }

    private void completeTypes(List<Integer> typeList) {
        ArrayList<Integer> list = new ArrayList<Integer>(typeList);
        for (Integer type : list) {
            BaseMapItemTypeEnum typeEnum = BaseMapItemTypeEnum.getByValue(type);
            switch (typeEnum) {
                case GroupMap: {
                    if (!typeList.contains(BaseMapItemTypeEnum.WMTS.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.WMTS.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.MapServer.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.MapServer.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.XYZ.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.XYZ.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.VectorTileData.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.VectorTileData.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.VectorTileService.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.VectorTileService.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.Annotation3.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.Annotation3.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.BaiduMapService.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.BaiduMapService.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupVector.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupVector.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupRaster.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupRaster.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupShaded.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupShaded.getValue());
                    }
                    if (typeList.contains(BaseMapItemTypeEnum.GroupMapCustom.getValue())) break;
                    typeList.add(BaseMapItemTypeEnum.GroupMapCustom.getValue());
                    break;
                }
                case GroupVector: 
                case GroupRaster: 
                case GroupShaded: 
                case GroupMapCustom: {
                    if (!typeList.contains(BaseMapItemTypeEnum.WMTS.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.WMTS.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.MapServer.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.MapServer.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.XYZ.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.XYZ.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.VectorTileData.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.VectorTileData.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.VectorTileService.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.VectorTileService.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.Annotation3.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.Annotation3.getValue());
                    }
                    if (typeList.contains(BaseMapItemTypeEnum.BaiduMapService.getValue())) break;
                    typeList.add(BaseMapItemTypeEnum.BaiduMapService.getValue());
                    break;
                }
                case GroupTerrain: {
                    if (!typeList.contains(BaseMapItemTypeEnum.TerrainIME.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.TerrainIME.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.TerrainArcGIS.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.TerrainArcGIS.getValue());
                    }
                    if (typeList.contains(BaseMapItemTypeEnum.TerrainCesium.getValue())) break;
                    typeList.add(BaseMapItemTypeEnum.TerrainCesium.getValue());
                    break;
                }
                case WMTS: 
                case MapServer: 
                case XYZ: 
                case VectorTileData: 
                case VectorTileService: 
                case Annotation3: 
                case BaiduMapService: {
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupMap.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupMap.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupVector.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupVector.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupRaster.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupRaster.getValue());
                    }
                    if (!typeList.contains(BaseMapItemTypeEnum.GroupShaded.getValue())) {
                        typeList.add(BaseMapItemTypeEnum.GroupShaded.getValue());
                    }
                    if (typeList.contains(BaseMapItemTypeEnum.GroupMapCustom.getValue())) break;
                    typeList.add(BaseMapItemTypeEnum.GroupMapCustom.getValue());
                    break;
                }
                case TerrainIME: 
                case TerrainArcGIS: 
                case TerrainCesium: {
                    if (typeList.contains(BaseMapItemTypeEnum.GroupTerrain.getValue())) break;
                    typeList.add(BaseMapItemTypeEnum.GroupTerrain.getValue());
                    break;
                }
            }
        }
    }

    private String getBase64Image(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        Assert.notNull((Object)fileName, (String)"\u672a\u8bc6\u522b\u5230\u56fe\u7247\u7684\u683c\u5f0f\uff01");
        fileName = fileName.toUpperCase(Locale.ROOT);
        if (!fileName.endsWith(".PNG") && !fileName.endsWith(".SVG")) {
            throw new RuntimeException("\u56fe\u7247\u683c\u5f0f\u652f\u6301\uff1apng\u6216svg");
        }
        if (file.getSize() > 205824L) {
            throw new RuntimeException("\u56fe\u7247\u5927\u5c0f\u9650\u5236\uff1a\u6700\u5927200kb");
        }
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            String picture = encoder.encodeBuffer(file.getBytes()).trim();
            picture = picture.replaceAll("\n", "").replaceAll("\r", "");
            String format = "image/png";
            if (fileName.endsWith(".PNG")) {
                format = "image/png";
            } else if (fileName.endsWith(".SVG")) {
                format = "image/svg+xml";
            }
            picture = "data:" + format + ";base64," + picture;
            return picture;
        }
        catch (Exception e) {
            throw new RuntimeException("\u76ee\u5f55\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\uff01", e);
        }
    }
}

