/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmColorItemDao;
import com.geoway.adf.dms.config.dao.CmColorSchemeDao;
import com.geoway.adf.dms.config.entity.CmColorItem;
import com.geoway.adf.dms.config.entity.CmColorScheme;
import com.geoway.adf.dms.config.service.ColorItemService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ColorItemServiceImpl
implements ColorItemService {
    private static final Logger log = LoggerFactory.getLogger(ColorItemServiceImpl.class);
    @Resource
    private CmColorSchemeDao cmColorSchemeDao;
    @Resource
    private CmColorItemDao cmColorItemDao;

    @Override
    public String saveOrUpdateInfo(CmColorItem colorItem) {
        if (StringUtil.isEmptyOrWhiteSpace((String)colorItem.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)colorItem.getId())) {
            CmColorItem updateOne = this.cmColorItemDao.selectByPrimaryKey(colorItem.getId());
            if (updateOne == null) {
                throw new RuntimeException("\u76ee\u6807\u4e0d\u5b58\u5728");
            }
            if (!colorItem.getName().equals(updateOne.getName())) {
                this.checkSameName(colorItem.getName(), colorItem.getColorId());
            }
            this.cmColorItemDao.updateByPrimaryKey(colorItem);
        } else {
            this.checkSameName(colorItem.getName(), colorItem.getColorId());
            colorItem.setId(IdUtil.getSnowflakeNextIdStr());
            this.cmColorItemDao.insert(colorItem);
        }
        return colorItem.getId();
    }

    @Override
    public List<CmColorItem> queryByScheme(String schemeId) {
        return this.queryByScheme(schemeId, null);
    }

    @Override
    public List<CmColorItem> queryByScheme(String schemeId, String keyword) {
        return this.cmColorItemDao.selectByColorId(schemeId, keyword);
    }

    @Override
    public List<CmColorItem> queryBySchemeName(String schemeName) {
        return this.queryBySchemeName(schemeName, null);
    }

    @Override
    public List<CmColorItem> queryBySchemeName(String schemeName, String keyword) {
        List<CmColorScheme> schemes = this.cmColorSchemeDao.selectByName(schemeName);
        if (schemes.size() == 0) {
            return new ArrayList<CmColorItem>();
        }
        return this.queryByScheme(schemes.get(0).getId(), keyword);
    }

    @Override
    public Boolean deleteByIds(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            List<String> idList = Arrays.asList(ids.split(","));
            this.cmColorItemDao.batchDeleteByIds(idList);
            return true;
        }
        return false;
    }

    @Override
    public Boolean deleteByScheme(String schemeId) {
        this.cmColorItemDao.deleteByColorId(schemeId);
        return true;
    }

    @Override
    public Integer batchAddItems(List<CmColorItem> itemList) {
        return this.cmColorItemDao.batchInsert(itemList);
    }

    public void checkSameName(String name, String colorId) {
        CmColorItem one = null;
        List<CmColorItem> sameNameItems = this.cmColorItemDao.selectByName(name, colorId);
        if (sameNameItems != null && sameNameItems.size() > 0) {
            one = sameNameItems.get(0);
        }
        if (one != null) {
            throw new RuntimeException("\u540c\u4e00\u7ea7\u76ee\u5f55\u4e0b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u540d\u79f0\u3010" + name + "\u3011\u5df2\u5b58\u5728!");
        }
    }
}

