/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel;

import com.geoway.adf.dms.common.util.StringUtil;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class DatumModelDataObject {
    private Long id = 0L;
    private String name;
    private String description;
    private String groupName;
    private Integer nodeType;
    private List<String> properties;
    private Boolean isDataKey = false;
    private Boolean necessary = true;
    private Integer depth = 0;
    private String path;
    private List<DatumModelDataObject> children = new ArrayList<DatumModelDataObject>();
    private DatumModelDataObject parentObject;

    public DatumModelDataObject() {
        this.properties = new ArrayList<String>();
    }

    public String getPath() {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.path)) {
            String xPath = this.getName();
            for (DatumModelDataObject parent = this.getParentObject(); parent != null; parent = parent.getParentObject()) {
                xPath = Paths.get(parent.getName(), xPath).toFile().getPath();
                xPath = xPath.replace("\\", "/");
            }
            return xPath;
        }
        return this.path;
    }

    public String getPathWithoutModelName() {
        if (this.getParentObject() == null) {
            return "";
        }
        String xPath = this.getName();
        for (DatumModelDataObject parent = this.getParentObject(); parent != null && parent.getParentObject() != null; parent = parent.getParentObject()) {
            xPath = Paths.get(parent.getName(), xPath).toFile().getPath();
        }
        return xPath;
    }

    public Integer getDepth() {
        if (this.getParentObject() == null) {
            return 0;
        }
        return this.getParentObject().getDepth() + 1;
    }

    public DatumModelDataObject getDataKeyNode() {
        DatumModelDataObject dataKeyNode = null;
        if (this.isDataKey.booleanValue()) {
            dataKeyNode = this;
        } else if (this.children != null && this.children.size() > 0) {
            for (DatumModelDataObject node : this.children) {
                if (node.isDataKey.booleanValue()) {
                    dataKeyNode = node;
                    break;
                }
                dataKeyNode = node.getDataKeyNode();
                if (dataKeyNode == null) continue;
                break;
            }
        }
        return dataKeyNode;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public Boolean getIsDataKey() {
        return this.isDataKey;
    }

    public Boolean getNecessary() {
        return this.necessary;
    }

    public List<DatumModelDataObject> getChildren() {
        return this.children;
    }

    public DatumModelDataObject getParentObject() {
        return this.parentObject;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setNodeType(Integer nodeType) {
        this.nodeType = nodeType;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public void setIsDataKey(Boolean isDataKey) {
        this.isDataKey = isDataKey;
    }

    public void setNecessary(Boolean necessary) {
        this.necessary = necessary;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setChildren(List<DatumModelDataObject> children) {
        this.children = children;
    }

    public void setParentObject(DatumModelDataObject parentObject) {
        this.parentObject = parentObject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatumModelDataObject)) {
            return false;
        }
        DatumModelDataObject other = (DatumModelDataObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$nodeType = this.getNodeType();
        Integer other$nodeType = other.getNodeType();
        if (this$nodeType == null ? other$nodeType != null : !((Object)this$nodeType).equals(other$nodeType)) {
            return false;
        }
        Boolean this$isDataKey = this.getIsDataKey();
        Boolean other$isDataKey = other.getIsDataKey();
        if (this$isDataKey == null ? other$isDataKey != null : !((Object)this$isDataKey).equals(other$isDataKey)) {
            return false;
        }
        Boolean this$necessary = this.getNecessary();
        Boolean other$necessary = other.getNecessary();
        if (this$necessary == null ? other$necessary != null : !((Object)this$necessary).equals(other$necessary)) {
            return false;
        }
        Integer this$depth = this.getDepth();
        Integer other$depth = other.getDepth();
        if (this$depth == null ? other$depth != null : !((Object)this$depth).equals(other$depth)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<String> this$properties = this.getProperties();
        List<String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<DatumModelDataObject> this$children = this.getChildren();
        List<DatumModelDataObject> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        DatumModelDataObject this$parentObject = this.getParentObject();
        DatumModelDataObject other$parentObject = other.getParentObject();
        return !(this$parentObject == null ? other$parentObject != null : !((Object)this$parentObject).equals(other$parentObject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatumModelDataObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $nodeType = this.getNodeType();
        result = result * 59 + ($nodeType == null ? 43 : ((Object)$nodeType).hashCode());
        Boolean $isDataKey = this.getIsDataKey();
        result = result * 59 + ($isDataKey == null ? 43 : ((Object)$isDataKey).hashCode());
        Boolean $necessary = this.getNecessary();
        result = result * 59 + ($necessary == null ? 43 : ((Object)$necessary).hashCode());
        Integer $depth = this.getDepth();
        result = result * 59 + ($depth == null ? 43 : ((Object)$depth).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<DatumModelDataObject> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        DatumModelDataObject $parentObject = this.getParentObject();
        result = result * 59 + ($parentObject == null ? 43 : ((Object)$parentObject).hashCode());
        return result;
    }

    public String toString() {
        return "DatumModelDataObject(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", groupName=" + this.getGroupName() + ", nodeType=" + this.getNodeType() + ", properties=" + this.getProperties() + ", isDataKey=" + this.getIsDataKey() + ", necessary=" + this.getNecessary() + ", depth=" + this.getDepth() + ", path=" + this.getPath() + ", children=" + this.getChildren() + ", parentObject=" + this.getParentObject() + ")";
    }
}

