/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.RealFileModelNodeDTO;
import com.geoway.adf.dms.config.entity.DmDictValue;
import com.geoway.adf.dms.config.filemodel.CustomNameRuler;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.constant.CustomNameRulerTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFolderNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.fs.IFileset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FileModelFromFolderUtil {
    public static String DataFormDicKey = "DIC_DATAFORMAT";

    public static RealFileModelNodeDTO loadPackageTree(Long modelId, IFileset dirFileset, String packageName, List<DmDictValueDTO> fileFormats) {
        RealFileModelNodeDTO rootNode = new RealFileModelNodeDTO(packageName, false, "", "", 2, "");
        rootNode.setModelId(modelId);
        if (dirFileset != null && dirFileset.getIsDirectory()) {
            List subFiles = dirFileset.listFiles();
            if (subFiles == null) {
                return rootNode;
            }
            ArrayList<IFileset> files = new ArrayList<IFileset>();
            for (IFileset item : subFiles) {
                if (item.getIsDirectory()) {
                    FileModelFromFolderUtil.appendFolder(item, rootNode, fileFormats);
                    continue;
                }
                files.add(item);
            }
            FileModelFromFolderUtil.appendFile(files, rootNode, fileFormats);
        }
        return rootNode;
    }

    public static DataPackage getPackage(RealFileModelNodeDTO treeNode) {
        RefObject hasModelKey = new RefObject();
        hasModelKey.set((Object)treeNode.getModelKey());
        DataPackage dataPackage = new DataPackage();
        dataPackage.setName(treeNode.getNodeName());
        dataPackage.setIsDataKey(treeNode.getModelKey());
        FileModelFromFolderUtil.getDataPackageCall(treeNode, dataPackage, (RefObject<Boolean>)hasModelKey);
        if (!((Boolean)hasModelKey.get()).booleanValue()) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u4e3b\u6570\u636e\u6807\u8bc6");
        }
        return dataPackage;
    }

    private static void getDataPackageCall(RealFileModelNodeDTO treeNode, DatumModelDataObject dataPackage, RefObject<Boolean> hasModelKey) {
        for (RealFileModelNodeDTO item : treeNode.getChildren()) {
            if (item.getModelKey().booleanValue()) {
                hasModelKey.set((Object)true);
            }
            FileModelNodeTypeEnum nodeType = FileModelNodeTypeEnum.getByValue(item.getNodeType());
            switch (nodeType) {
                case DataFile: {
                    DataFile dataFile = new DataFile();
                    dataFile.setName(item.getNodeName());
                    dataFile.setDataFormat(item.getFormat());
                    dataFile.setFileExtension(item.getFileExtension());
                    ArrayList<String> properties = new ArrayList<String>();
                    if (StringUtil.isNotEmpty((String)item.getPropertyKey()) && !"\u65e0".equals(item.getPropertyKey())) {
                        properties.add(item.getPropertyKey());
                    }
                    dataFile.setProperties(properties);
                    dataFile.setIsDataKey(item.getModelKey());
                    dataPackage.getChildren().add(dataFile);
                    break;
                }
                case DataFolder: {
                    DataFolder dataFolder = new DataFolder();
                    dataFolder.setName(item.getNodeName());
                    dataFolder.setFolderNameRulerType(DataFolderNameRulerEnum.FixedName);
                    CustomNameRuler ruler = new CustomNameRuler();
                    ruler.setType(CustomNameRulerTypeEnum.String);
                    ruler.setCustomString(dataFolder.getName());
                    dataFolder.setCustomNameRuler(ruler);
                    ArrayList<String> folderProperties = new ArrayList<String>();
                    if (StringUtil.isNotEmpty((String)item.getPropertyKey()) && !"\u65e0".equals(item.getPropertyKey())) {
                        folderProperties.add(item.getPropertyKey());
                    }
                    dataFolder.setProperties(folderProperties);
                    dataFolder.setIsDataKey(item.getModelKey());
                    FileModelFromFolderUtil.getDataPackageCall(item, dataFolder, hasModelKey);
                    dataPackage.getChildren().add(dataFolder);
                    break;
                }
            }
        }
    }

    private static void appendFolder(IFileset folder, RealFileModelNodeDTO pNode, List<DmDictValueDTO> fileFormats) {
        RealFileModelNodeDTO node = pNode.appendNode(folder.getName(), false, "", "", 1, "");
        List subFiles = folder.listFiles();
        if (subFiles != null) {
            ArrayList<IFileset> files = new ArrayList<IFileset>();
            for (IFileset item : subFiles) {
                if (item.getIsDirectory()) {
                    FileModelFromFolderUtil.appendFolder(item, node, fileFormats);
                    continue;
                }
                files.add(item);
            }
            FileModelFromFolderUtil.appendFile(files, node, fileFormats);
        }
    }

    private static void appendFile(List<IFileset> files, RealFileModelNodeDTO pNode, List<DmDictValueDTO> fileFormats) {
        RealFileModelNodeDTO nodeOther = pNode.appendNode("\u5176\u4ed6\u6587\u4ef6", false, "\u5176\u4ed6\u6587\u4ef6", ".*", 0, "\u65e0");
        for (IFileset file : files) {
            boolean onTree = false;
            String ext = file.getExt().toUpperCase(Locale.ROOT);
            for (RealFileModelNodeDTO item : pNode.getChildren()) {
                if (!ext.equals(item.getFileExtension())) continue;
                item.appendNode(file.getName(), false, "", "", 99, "");
                onTree = true;
            }
            if (onTree) continue;
            boolean onDic = false;
            for (DmDictValue dmDictValue : fileFormats) {
                String tmp = dmDictValue.getCode().toUpperCase(Locale.ROOT);
                if (!ext.equals("." + tmp)) continue;
                RealFileModelNodeDTO node = pNode.appendNode(dmDictValue.getName(), false, dmDictValue.getName(), "." + tmp, 0, "\u65e0");
                node.appendNode(file.getName(), false, "", "", 99, "");
                onDic = true;
                break;
            }
            if (onDic) continue;
            nodeOther.appendNode(file.getName(), false, "", "", 99, "");
        }
        if (nodeOther.getChildren().size() == 0) {
            pNode.getChildren().remove(nodeOther);
        }
    }
}

