/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.fs.IFileset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    public static List<IFileset> searchFileData(IFileset parentFolder, Predicate<IFileset> pattern, boolean topDirectoryOnly) {
        return FileHelper.searchFileData(parentFolder, pattern, topDirectoryOnly, -1);
    }

    public static List<IFileset> searchFileData(IFileset parentFolder, Predicate<IFileset> pattern, boolean topDirectoryOnly, int limitCount) {
        ArrayList<IFileset> fileResults = new ArrayList<IFileset>();
        if (parentFolder == null) {
            return fileResults;
        }
        try {
            ArrayDeque<IFileset> queue = new ArrayDeque<IFileset>();
            queue.offer(parentFolder);
            while (!queue.isEmpty()) {
                IFileset current = (IFileset)queue.poll();
                List subFiles = current.listFiles();
                if (subFiles == null || subFiles.isEmpty()) continue;
                for (IFileset file : subFiles) {
                    if (!file.getIsDirectory()) {
                        if (pattern != null && !pattern.test(file)) continue;
                        fileResults.add(file);
                        if (limitCount <= 0 || fileResults.size() < limitCount) continue;
                        return fileResults;
                    }
                    if (topDirectoryOnly) continue;
                    queue.offer(file);
                }
            }
        }
        catch (Exception ex) {
            log.error(parentFolder.getFullPath() + " \u641c\u7d22\u6587\u4ef6\u5f02\u5e38", (Throwable)ex);
        }
        return fileResults;
    }

    public static List<IFileset> getWholeDirectories(IFileset parentFolder, Predicate<IFileset> pattern, boolean topDirectoryOnly) {
        ArrayList<IFileset> dirResults = new ArrayList<IFileset>();
        try {
            ArrayDeque<IFileset> queue = new ArrayDeque<IFileset>();
            queue.offer(parentFolder);
            while (!queue.isEmpty()) {
                IFileset current = (IFileset)queue.poll();
                List subFiles = current.listFiles();
                if (subFiles == null || subFiles.isEmpty()) continue;
                if (pattern != null) {
                    subFiles = ListUtil.findAll((List)subFiles, pattern);
                }
                for (IFileset file : subFiles) {
                    if (!file.getIsDirectory()) continue;
                    if (pattern == null || pattern.test(file)) {
                        dirResults.add(file);
                    }
                    if (topDirectoryOnly) continue;
                    queue.offer(file);
                }
            }
        }
        catch (Exception ex) {
            String msg = parentFolder == null ? "" : parentFolder.getFullPath();
            log.error(msg + " \u6587\u4ef6\u5939\u904d\u5386\u5f02\u5e38", (Throwable)ex);
        }
        return dirResults;
    }

    public static String getNameWithoutExt(IFileset fileName, String ext) {
        if (StringUtil.isEmptyOrWhiteSpace((String)ext)) {
            return FileUtil.getFileNameWithoutExtension((String)fileName.getName());
        }
        return fileName.getName().replace(ext, "");
    }
}

