/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmFrontSchemeDao;
import com.geoway.adf.dms.config.dto.frontscheme.FrontSchemeDTO;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.entity.CmFrontScheme;
import com.geoway.adf.dms.config.service.FrontSchemeService;
import com.geoway.adf.dms.config.service.LoginUserService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class FrontSchemeServiceImpl
implements FrontSchemeService {
    private static final Logger log = LoggerFactory.getLogger(FrontSchemeServiceImpl.class);
    @Resource
    private CmFrontSchemeDao cmFrontSchemeDao;
    @Resource
    private LoginUserService loginUserService;

    @Override
    public List<FrontSchemeDTO> list(String type, String keyword) {
        List<CmFrontScheme> schemeList = this.cmFrontSchemeDao.selectByType(type);
        ArrayList<FrontSchemeDTO> dtoList = new ArrayList<FrontSchemeDTO>();
        boolean bindUser = false;
        String userId = null;
        for (CmFrontScheme cmFrontScheme : schemeList) {
            if (StringUtil.isNotEmpty((String)keyword) && !cmFrontScheme.getName().toLowerCase().contains(keyword.toLowerCase())) continue;
            boolean bl = bindUser = bindUser || ConstantsValue.TRUE_VALUE.equals(cmFrontScheme.getBindingUser());
            if (bindUser) {
                if (userId == null) {
                    ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                    LoginUserInfo userInfo = this.loginUserService.getUserInfo(servletRequestAttributes.getRequest());
                    userId = userInfo.getUserId();
                }
                if (cmFrontScheme.getUserId() != null && !StringUtil.equals(userId, (String)cmFrontScheme.getUserId())) continue;
            }
            dtoList.add(this.convertToDTO(cmFrontScheme));
        }
        return dtoList;
    }

    @Override
    public FrontSchemeDTO getDetail(String type, String name) {
        List<CmFrontScheme> cmFrontSchemeList = this.cmFrontSchemeDao.selectByName(type, name);
        if (cmFrontSchemeList == null || cmFrontSchemeList.size() == 0) {
            return null;
        }
        CmFrontScheme cmFrontScheme = cmFrontSchemeList.get(0);
        FrontSchemeDTO dto = new FrontSchemeDTO();
        dto.setKey(cmFrontScheme.getKey());
        dto.setName(name);
        dto.setType(type);
        dto.setGroup(cmFrontScheme.getGroup());
        dto.setContent(cmFrontScheme.getScheme());
        return dto;
    }

    @Override
    public FrontSchemeDTO getDetailByKey(String key) {
        CmFrontScheme cmFrontScheme = this.cmFrontSchemeDao.selectByPrimaryKey(key);
        if (cmFrontScheme == null) {
            return null;
        }
        FrontSchemeDTO dto = new FrontSchemeDTO();
        dto.setKey(cmFrontScheme.getKey());
        dto.setName(cmFrontScheme.getName());
        dto.setType(cmFrontScheme.getType());
        dto.setGroup(cmFrontScheme.getGroup());
        dto.setContent(cmFrontScheme.getScheme());
        return dto;
    }

    @Override
    public void deleteByName(String type, String name) {
        this.cmFrontSchemeDao.deleteByName(type, name);
    }

    @Override
    public void deleteByKey(String key) {
        this.cmFrontSchemeDao.deleteByPrimaryKey(key);
    }

    @Override
    public String add(FrontSchemeDTO scheme) {
        List<CmFrontScheme> cmFrontSchemeList;
        if (scheme == null) {
            return null;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)scheme.getName())) {
            scheme.setName("");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)scheme.getType())) {
            throw new RuntimeException("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = scheme.getKey();
        if (StringUtil.isEmptyOrWhiteSpace((String)key)) {
            key = UUID.randomUUID().toString();
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)scheme.getName()) && (cmFrontSchemeList = this.cmFrontSchemeDao.selectByName(scheme.getType(), scheme.getName())) != null && cmFrontSchemeList.size() > 0) {
            throw new RuntimeException("\u8be5\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff01");
        }
        CmFrontScheme cmFrontScheme = new CmFrontScheme();
        cmFrontScheme.setKey(key);
        cmFrontScheme.setName(scheme.getName());
        cmFrontScheme.setType(scheme.getType());
        cmFrontScheme.setGroup(scheme.getGroup());
        Integer order = this.cmFrontSchemeDao.queryMaxOrder(cmFrontScheme.getType());
        if (order == null) {
            order = 0;
        }
        cmFrontScheme.setOrder(order + 1);
        cmFrontScheme.setBindingUser(scheme.getBindingUser() == null || scheme.getBindingUser() == false ? ConstantsValue.FALSE_VALUE : ConstantsValue.TRUE_VALUE);
        if (scheme.getBindingUser() != null && scheme.getBindingUser().booleanValue()) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            LoginUserInfo userInfo = this.loginUserService.getUserInfo(servletRequestAttributes.getRequest());
            cmFrontScheme.setUserId(userInfo.getUserId());
        }
        cmFrontScheme.setScheme(scheme.getContent());
        this.cmFrontSchemeDao.insert(cmFrontScheme);
        return cmFrontScheme.getKey();
    }

    @Override
    public String update(FrontSchemeDTO scheme) {
        if (StringUtil.isEmptyOrWhiteSpace((String)scheme.getKey())) {
            return this.add(scheme);
        }
        CmFrontScheme cmFrontScheme = this.cmFrontSchemeDao.selectByPrimaryKey(scheme.getKey());
        if (cmFrontScheme == null) {
            return this.add(scheme);
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)scheme.getName()) && !scheme.getName().equals(cmFrontScheme.getName())) {
            List<CmFrontScheme> cmFrontSchemeList = this.cmFrontSchemeDao.selectByName(cmFrontScheme.getType(), scheme.getName());
            if (cmFrontSchemeList != null && cmFrontSchemeList.size() > 0) {
                throw new RuntimeException("\u8be5\u540d\u79f0\u5df2\u88ab\u4f7f\u7528\uff01");
            }
            cmFrontScheme.setName(scheme.getName());
        }
        if (scheme.getGroup() != null) {
            cmFrontScheme.setGroup(scheme.getGroup());
        }
        if (scheme.getContent() != null) {
            cmFrontScheme.setScheme(scheme.getContent());
        }
        this.cmFrontSchemeDao.updateByPrimaryKey(cmFrontScheme);
        return cmFrontScheme.getKey();
    }

    @Override
    public void move(String key, Integer order) {
        int i;
        if (key == null || order == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        CmFrontScheme frontScheme = this.cmFrontSchemeDao.selectByPrimaryKey(key);
        Assert.notNull((Object)frontScheme, (String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u6b64\u6b21\u79fb\u52a8\u65e0\u6548");
        List<CmFrontScheme> children = this.cmFrontSchemeDao.selectByType(frontScheme.getType());
        children.removeIf(f -> StringUtil.equals((String)f.getKey(), (String)key));
        int preIndex = -1;
        for (i = 0; i < children.size(); ++i) {
            if (!children.get(i).getOrder().equals(order)) continue;
            preIndex = i;
            break;
        }
        if (preIndex == -1 && order > 0) {
            preIndex = order;
        }
        if (preIndex >= children.size()) {
            preIndex = children.size() - 1;
        }
        children.add(preIndex + 1, frontScheme);
        for (i = 0; i < children.size(); ++i) {
            CmFrontScheme child = children.get(i);
            if (child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.cmFrontSchemeDao.updateOrderByPrimaryKey(child.getKey(), child.getOrder());
        }
    }

    private FrontSchemeDTO convertToDTO(CmFrontScheme scheme) {
        FrontSchemeDTO dto = new FrontSchemeDTO();
        dto.setKey(scheme.getKey());
        dto.setName(scheme.getName());
        dto.setType(scheme.getType());
        dto.setGroup(scheme.getGroup());
        dto.setOrder(scheme.getOrder());
        dto.setBindingUser(ConstantsValue.TRUE_VALUE.equals(scheme.getBindingUser()));
        dto.setContent(scheme.getScheme());
        return dto;
    }
}

