/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.component;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.CmMaterial;
import com.geoway.adf.dms.config.properties.MaterialProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public final class MaterialCacheManager {
    private static final Logger log = LoggerFactory.getLogger(MaterialCacheManager.class);
    @Resource
    private MaterialProperties materialProperties;

    public void saveMaterial(String groupId, String sourceName, MultipartFile multipartFile) {
        try {
            File groupPath = this.getStoragePath(groupId);
            File localFile = new File(groupPath, sourceName);
            multipartFile.transferTo(localFile);
        }
        catch (Exception e) {
            log.error(sourceName + " \u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveMaterial(String groupId, String sourceName, byte[] fileConent) {
        try {
            File groupPath = this.getStoragePath(groupId);
            File localFile = new File(groupPath, sourceName);
            Files.write(localFile.toPath(), fileConent, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            log.error(sourceName + " \u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public InputStream getMaterialInputStream(String groupId, String sourceName) {
        try {
            File groupPath = this.getStoragePath(groupId);
            File file = new File(groupPath, sourceName);
            if (!file.exists()) {
                return null;
            }
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        catch (Exception e) {
            log.error(groupId + "/" + sourceName + "\u7d20\u6750\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean viewMaterial(String groupId, String sourceName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream inputStream;
        Object outputStream;
        block3: {
            boolean bl;
            outputStream = null;
            inputStream = null;
            try {
                inputStream = this.getMaterialInputStream(groupId, sourceName);
                if (inputStream == null) break block3;
                FileViewerUtil.viewFileStream((InputStream)inputStream, (String)sourceName, (long)inputStream.available(), (HttpServletRequest)request, (HttpServletResponse)response);
                bl = true;
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream, inputStream});
                throw throwable;
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream, inputStream});
            return bl;
        }
        boolean bl = false;
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream, inputStream});
        return bl;
    }

    public void deleteGroup(String groupId) {
        try {
            File groupPath = this.getStoragePath(groupId);
            if (groupPath.exists()) {
                FileUtil.deleteDir((String)groupPath.toString());
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7d20\u6750\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public void deleteMaterial(CmMaterial cmMaterial) {
        try {
            File groupPath = this.getStoragePath(cmMaterial.getGroupId());
            File file = new File(groupPath, cmMaterial.getSourceName());
            if (file.exists() && !file.delete()) {
                log.error(file.getAbsolutePath() + " \u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error(cmMaterial.getSourceName() + " \u5220\u9664\u7d20\u6750\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public void move2Group(CmMaterial cmMaterial, String orgGroupId, String orgSourceName) {
        try {
            File targetGroupPath = this.getStoragePath(cmMaterial.getGroupId());
            File targetFile = new File(targetGroupPath, cmMaterial.getSourceName());
            File groupPath = this.getStoragePath(orgGroupId);
            File srcFile = new File(groupPath, orgSourceName);
            if (srcFile.exists()) {
                Files.move(srcFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            log.error(orgSourceName + "\u7d20\u6750\u6587\u4ef6\u79fb\u52a8\u5931\u8d25", (Throwable)e);
        }
    }

    private File getStoragePath(String groupId) {
        File groupPath;
        File rootPath;
        String storage_path = this.materialProperties.getFile_path();
        if (StringUtil.isEmptyOrWhiteSpace((String)storage_path)) {
            log.error("\u672a\u914d\u7f6e\u7d20\u6750\u5b58\u50a8\u76ee\u5f55\uff0c\u4f7f\u7528\u9ed8\u8ba4\u76ee\u5f55");
            storage_path = "material";
        }
        if (!(rootPath = new File(storage_path)).isDirectory() || !rootPath.exists()) {
            log.error(rootPath.getAbsolutePath() + "\u7d20\u6750\u5b58\u50a8\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        if (!(groupPath = Paths.get(rootPath.getAbsolutePath(), groupId).toFile()).isDirectory() || !groupPath.exists()) {
            groupPath.mkdir();
        }
        return groupPath;
    }
}

