/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultItemDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultNodeDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.entity.DmFileModel;
import com.geoway.adf.dms.config.filemodel.CustomNameRuler;
import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.ScanFileParam;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.filemodel.ScanInstanceParam;
import com.geoway.adf.dms.config.filemodel.ScanModelParam;
import com.geoway.adf.dms.config.filemodel.constant.CustomNameRulerTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFileNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataFolderNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.DataPackageNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.ModelNameRulerEnum;
import com.geoway.adf.dms.config.filemodel.util.DataInstanceUtil;
import com.geoway.adf.gis.fs.IFileset;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DatumDataModelUtil {
    private static final Logger log = LoggerFactory.getLogger(DatumDataModelUtil.class);

    public static DatumModelDataObject parseDataModel(DmFileModel model) {
        String strData = model.getObject().replace("\u0000", "");
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(strData.getBytes(StandardCharsets.UTF_8));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlInputStream);
            Element confXml = (Element)document.getElementsByTagName("DataPackage").item(0);
            DataPackage dataPackage = DatumDataModelUtil.readDataPackage(confXml);
            dataPackage.setId(model.getId());
            dataPackage.setName(model.getName());
            dataPackage.setDescription(model.getDesc());
            return dataPackage;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("xml\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
    }

    public static String convertToString(DatumModelDataObject dataObject) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement("DataPackage");
            rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            document.appendChild(rootElement);
            DatumDataModelUtil.writeDataPackage(document, rootElement, dataObject);
            return DatumDataModelUtil.writeDocToString(document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("xml\u5e8f\u5217\u5316\u5931\u8d25:" + e.getMessage());
        }
    }

    public static ScanResultDTO scanFileData(DataPackage dataPackage, IFileset directory, boolean needScanInvalidData) {
        ScanResultDTO scanResultDTO = new ScanResultDTO();
        ScanModelParam modelParam = new ScanModelParam(dataPackage);
        modelParam.setNeedScanInvalid(needScanInvalidData);
        DatumDataModelUtil.scanAllCatalogDataByDataKey(modelParam, directory, scanResultDTO);
        return scanResultDTO;
    }

    private static List<DatumModelDataObject> readChildObjects(Element childObjectsElement) {
        ArrayList<DatumModelDataObject> dataObjectList = new ArrayList<DatumModelDataObject>();
        NodeList gwDataObjectList = childObjectsElement.getChildNodes();
        block10: for (int i = 0; i < gwDataObjectList.getLength(); ++i) {
            String type;
            if (!"GwDataObject".equals(gwDataObjectList.item(i).getNodeName())) continue;
            Element gwDataObject = (Element)gwDataObjectList.item(i);
            switch (type = gwDataObject.getAttribute("xsi:type")) {
                case "DataCompactPackage": {
                    dataObjectList.add(DatumDataModelUtil.readDataCompactPackage(gwDataObject));
                    continue block10;
                }
                case "DataFolder": {
                    dataObjectList.add(DatumDataModelUtil.readDataFolder(gwDataObject));
                    continue block10;
                }
                case "DataFile": {
                    dataObjectList.add(DatumDataModelUtil.readDataFile(gwDataObject));
                }
            }
        }
        return dataObjectList;
    }

    private static DataPackage readDataPackage(Element dataPackageElement) {
        DataPackage dataPackage = (DataPackage)DatumDataModelUtil.readGwDataObjectElement(dataPackageElement, "DataPackage");
        ModelNameRulerEnum dataNameRuler = ModelNameRulerEnum.valueOf(DatumDataModelUtil.getFirstChildElementsByTagName(dataPackageElement, "DataNameRuler").getTextContent());
        DataPackageNameRulerEnum packageNameRulerType = DataPackageNameRulerEnum.valueOf(DatumDataModelUtil.getFirstChildElementsByTagName(dataPackageElement, "PackageNameRulerType").getTextContent());
        Boolean related2RealFolder = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(dataPackageElement, "Related2RealFolder").getTextContent());
        dataPackage.setDataNameRuler(dataNameRuler);
        dataPackage.setPackageNameRulerType(packageNameRulerType);
        dataPackage.setRelated2RealFolder(related2RealFolder);
        return dataPackage;
    }

    private static DataCompactPackage readDataCompactPackage(Element dataCompactPackageElement) {
        DataCompactPackage compact = (DataCompactPackage)DatumDataModelUtil.readGwDataObjectElement(dataCompactPackageElement, "DataCompactPackage");
        String packageType = DatumDataModelUtil.getFirstChildElementsByTagName(dataCompactPackageElement, "PackageType").getTextContent();
        String folderNameRulerType = DatumDataModelUtil.getFirstChildElementsByTagName(dataCompactPackageElement, "FolderNameRulerType").getTextContent();
        Boolean canBeEmpty = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(dataCompactPackageElement, "CanBeEmpty").getTextContent());
        Element rulerElement = DatumDataModelUtil.getFirstChildElementsByTagName(dataCompactPackageElement, "CustomNameRuler");
        CustomNameRuler ruler = rulerElement == null ? new CustomNameRuler() : DatumDataModelUtil.readCustomNameRuler(rulerElement);
        compact.setPackageType(packageType);
        compact.setFolderNameRulerType(DataFolderNameRulerEnum.valueOf(folderNameRulerType));
        compact.setCanBeEmpty(canBeEmpty);
        compact.setCustomNameRuler(ruler);
        return compact;
    }

    private static DataFolder readDataFolder(Element dataFolderElement) {
        DataFolder folder = (DataFolder)DatumDataModelUtil.readGwDataObjectElement(dataFolderElement, "DataFolder");
        String folderNameRulerType = DatumDataModelUtil.getFirstChildElementsByTagName(dataFolderElement, "FolderNameRulerType").getTextContent();
        Boolean containsSubFoldersAndFiles = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(dataFolderElement, "ContainsSubFoldersAndFiles").getTextContent());
        Boolean canBeEmpty = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(dataFolderElement, "CanBeEmpty").getTextContent());
        Element rulerElement = DatumDataModelUtil.getFirstChildElementsByTagName(dataFolderElement, "CustomNameRuler");
        CustomNameRuler ruler = rulerElement == null ? new CustomNameRuler() : DatumDataModelUtil.readCustomNameRuler(rulerElement);
        folder.setFolderNameRulerType(DataFolderNameRulerEnum.valueOf(folderNameRulerType));
        folder.setContainsSubFoldersAndFiles(containsSubFoldersAndFiles);
        folder.setCanBeEmpty(canBeEmpty);
        folder.setCustomNameRuler(ruler);
        return folder;
    }

    private static DataFile readDataFile(Element dataFileElement) {
        DataFile dataFile = (DataFile)DatumDataModelUtil.readGwDataObjectElement(dataFileElement, "DataFile");
        String dataFormat = DatumDataModelUtil.getFirstChildElementsByTagName(dataFileElement, "DataFormat").getTextContent();
        String fileExtension = DatumDataModelUtil.getFirstChildElementsByTagName(dataFileElement, "FileExtension").getTextContent();
        Boolean isCompression = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(dataFileElement, "IsCompression").getTextContent());
        String fileNameRuler = DatumDataModelUtil.getFirstChildElementsByTagName(dataFileElement, "FileNameRuler").getTextContent();
        Element rulerElement = DatumDataModelUtil.getFirstChildElementsByTagName(dataFileElement, "CustomNameRuler");
        CustomNameRuler ruler = rulerElement == null ? new CustomNameRuler() : DatumDataModelUtil.readCustomNameRuler(rulerElement);
        dataFile.setDataFormat(dataFormat);
        dataFile.setFileExtension(fileExtension);
        dataFile.setIsCompression(isCompression);
        dataFile.setFileNameRuler(DataFileNameRulerEnum.valueOf(fileNameRuler));
        dataFile.setCustomNameRuler(ruler);
        return dataFile;
    }

    private static DatumModelDataObject readGwDataObjectElement(Element gwDataObjectElement, String className) {
        DatumModelDataObject gwDataObject;
        switch (className) {
            case "DataPackage": {
                gwDataObject = new DataPackage();
                break;
            }
            case "DataCompactPackage": {
                gwDataObject = new DataCompactPackage();
                break;
            }
            case "DataFolder": {
                gwDataObject = new DataFolder();
                break;
            }
            case "DataFile": {
                gwDataObject = new DataFile();
                break;
            }
            default: {
                gwDataObject = new DatumModelDataObject();
            }
        }
        String id = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "ID").getTextContent();
        String name = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "Name").getTextContent();
        String description = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "Description").getTextContent();
        Element propertiesElement = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "Properties");
        ArrayList<String> propertyList = new ArrayList<String>();
        NodeList propertyNodeList = propertiesElement.getChildNodes();
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            if (StringUtil.isEmptyOrWhiteSpace((String)propertyNodeList.item(i).getTextContent())) continue;
            propertyList.add(propertyNodeList.item(i).getTextContent());
        }
        Boolean isDataKey = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "IsDataKey").getTextContent());
        Boolean necessary = Boolean.parseBoolean(DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "Necessary").getTextContent());
        Element childObjectsElement = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "ChildObjects");
        List<DatumModelDataObject> childObjects = DatumDataModelUtil.readChildObjects(childObjectsElement);
        String groupName = DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "GroupName").getTextContent();
        Integer depth = Integer.parseInt(DatumDataModelUtil.getFirstChildElementsByTagName(gwDataObjectElement, "Depth").getTextContent());
        gwDataObject.setId(Long.valueOf(id));
        gwDataObject.setName(name);
        gwDataObject.setDescription(description);
        gwDataObject.setProperties(propertyList);
        gwDataObject.setIsDataKey(isDataKey);
        gwDataObject.setNecessary(necessary);
        if (gwDataObject.getChildren() == null) {
            gwDataObject.setChildren(new ArrayList<DatumModelDataObject>());
        }
        gwDataObject.setGroupName(groupName);
        gwDataObject.setDepth(depth);
        childObjects.forEach(c -> {
            gwDataObject.getChildren().add((DatumModelDataObject)c);
            c.setParentObject(gwDataObject);
        });
        return gwDataObject;
    }

    private static CustomNameRuler readCustomNameRuler(Element rulerElement) {
        CustomNameRuler ruler = new CustomNameRuler();
        String type = DatumDataModelUtil.getFirstChildElementsByTagName(rulerElement, "Type").getTextContent();
        String customString = DatumDataModelUtil.getFirstChildElementsByTagName(rulerElement, "CustomString").getTextContent();
        if (StringUtil.isNotEmpty((String)type)) {
            ruler.setType(CustomNameRulerTypeEnum.valueOf(type));
            ruler.setCustomString(customString);
        }
        return ruler;
    }

    private static String writeDocToString(Document document) {
        String xmlString = "";
        if (document != null) {
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            try {
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.transform(new DOMSource(document.getDocumentElement()), streamResult);
                xmlString = streamResult.getWriter().toString();
                writer.close();
            }
            catch (Exception e) {
                throw new RuntimeException("xml\u5e8f\u5217\u5316\u5931\u8d25:" + e.getMessage());
            }
        }
        return xmlString;
    }

    private static void writeGwDataObject(Document document, Element rootElement, DatumModelDataObject dataObject) {
        DatumDataModelUtil.appendElement(document, rootElement, "ID", dataObject.getId() + "");
        DatumDataModelUtil.appendElement(document, rootElement, "Name", dataObject.getName());
        DatumDataModelUtil.appendElement(document, rootElement, "Description", dataObject.getDescription());
        Element propertiesElement = document.createElement("Properties");
        if (dataObject.getProperties().size() > 0) {
            for (String item : dataObject.getProperties()) {
                Element stringElement = document.createElement("string");
                stringElement.setTextContent(item);
                propertiesElement.appendChild(stringElement);
            }
        }
        rootElement.appendChild(propertiesElement);
        DatumDataModelUtil.appendElement(document, rootElement, "IsDataKey", dataObject.getIsDataKey() != false ? "true" : "false");
        DatumDataModelUtil.appendElement(document, rootElement, "Necessary", dataObject.getNecessary() != false ? "true" : "false");
        Element childObjectsElement = document.createElement("ChildObjects");
        if (dataObject.getChildren().size() > 0) {
            for (DatumModelDataObject item : dataObject.getChildren()) {
                Element dataObjectElement = document.createElement("GwDataObject");
                switch (item.getNodeType()) {
                    case 0: {
                        dataObjectElement.setAttribute("xsi:type", "DataFile");
                        DatumDataModelUtil.writeDataFile(document, dataObjectElement, item);
                        break;
                    }
                    case 1: {
                        dataObjectElement.setAttribute("xsi:type", "DataFolder");
                        DatumDataModelUtil.writeDataFolder(document, dataObjectElement, item);
                        break;
                    }
                    case 5: {
                        dataObjectElement.setAttribute("xsi:type", "DataCompactPackage");
                        DatumDataModelUtil.writeDataCompactPackage(document, dataObjectElement, item);
                        break;
                    }
                }
                childObjectsElement.appendChild(dataObjectElement);
            }
        }
        rootElement.appendChild(childObjectsElement);
        DatumDataModelUtil.appendElement(document, rootElement, "GroupName", dataObject.getGroupName());
        DatumDataModelUtil.appendElement(document, rootElement, "Depth", dataObject.getDepth().toString());
    }

    private static void writeDataPackage(Document document, Element rootElement, DatumModelDataObject dataObject) {
        DatumDataModelUtil.writeGwDataObject(document, rootElement, dataObject);
        DataPackage dataPackage = (DataPackage)dataObject;
        DatumDataModelUtil.appendElement(document, rootElement, "IdentityType", "MainDataFile");
        DatumDataModelUtil.appendElement(document, rootElement, "DataNameRuler", dataPackage.getDataNameRuler().toString());
        DatumDataModelUtil.appendElement(document, rootElement, "PackageNameRulerType", dataPackage.getPackageNameRulerType().toString());
        DatumDataModelUtil.appendElement(document, rootElement, "Related2RealFolder", dataPackage.getRelated2RealFolder() != false ? "true" : "false");
    }

    private static void writeDataCompactPackage(Document document, Element rootElement, DatumModelDataObject dataObject) {
        DatumDataModelUtil.writeGwDataObject(document, rootElement, dataObject);
        DataCompactPackage dataCompactPackage = (DataCompactPackage)dataObject;
        DatumDataModelUtil.appendElement(document, rootElement, "PackageType", dataCompactPackage.getPackageType());
        DatumDataModelUtil.appendElement(document, rootElement, "FolderNameRulerType", dataCompactPackage.getFolderNameRulerType().toString());
        DatumDataModelUtil.writeCustomNameRuler(document, rootElement, dataCompactPackage.getCustomNameRuler());
        DatumDataModelUtil.appendElement(document, rootElement, "CanBeEmpty", dataCompactPackage.getCanBeEmpty() != false ? "true" : "false");
    }

    private static void writeDataFolder(Document document, Element rootElement, DatumModelDataObject dataObject) {
        DatumDataModelUtil.writeGwDataObject(document, rootElement, dataObject);
        DataFolder dataFolder = (DataFolder)dataObject;
        DatumDataModelUtil.appendElement(document, rootElement, "FolderNameRulerType", dataFolder.getFolderNameRulerType().toString());
        DatumDataModelUtil.appendElement(document, rootElement, "ContainsSubFoldersAndFiles", dataFolder.getContainsSubFoldersAndFiles() != false ? "true" : "false");
        DatumDataModelUtil.writeCustomNameRuler(document, rootElement, dataFolder.getCustomNameRuler());
        DatumDataModelUtil.appendElement(document, rootElement, "CanBeEmpty", dataFolder.getCanBeEmpty() != false ? "true" : "false");
    }

    private static void writeDataFile(Document document, Element rootElement, DatumModelDataObject dataObject) {
        DatumDataModelUtil.writeGwDataObject(document, rootElement, dataObject);
        DataFile dataFile = (DataFile)dataObject;
        DatumDataModelUtil.appendElement(document, rootElement, "DataFormat", dataFile.getDataFormat());
        DatumDataModelUtil.appendElement(document, rootElement, "FileExtension", dataFile.getFileExtension());
        Element fileExtensionElement = document.createElement("FileExtensionCollection");
        for (String item : dataFile.getFileExtensionCollection()) {
            Element stringElement = document.createElement("string");
            stringElement.setTextContent(item);
            fileExtensionElement.appendChild(stringElement);
        }
        rootElement.appendChild(fileExtensionElement);
        DatumDataModelUtil.appendElement(document, rootElement, "IsCompression", dataFile.getIsCompression() != false ? "true" : "false");
        DatumDataModelUtil.appendElement(document, rootElement, "FileNameRuler", dataFile.getFileNameRuler().toString());
        Element fileNameRulerCustomStringElement = document.createElement("FileNameRulerCustomString");
        rootElement.appendChild(fileNameRulerCustomStringElement);
        DatumDataModelUtil.writeCustomNameRuler(document, rootElement, dataFile.getCustomNameRuler());
    }

    private static void writeCustomNameRuler(Document document, Element rootElement, CustomNameRuler ruler) {
        if (ruler != null) {
            Element customNameRulerElement = document.createElement("CustomNameRuler");
            Element rulerTypeElement = document.createElement("Type");
            rulerTypeElement.setTextContent(ruler.getType().toString());
            customNameRulerElement.appendChild(rulerTypeElement);
            Element customStringElement = document.createElement("CustomString");
            customStringElement.setTextContent(ruler.getCustomString());
            customNameRulerElement.appendChild(customStringElement);
            rootElement.appendChild(customNameRulerElement);
        }
    }

    private static void appendElement(Document document, Element pElement, String tagName, String textContent) {
        Element element = document.createElement(tagName);
        element.setTextContent(textContent);
        pElement.appendChild(element);
    }

    private static Element getFirstChildElementsByTagName(Element element, String tagName) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!tagName.equals(nodeList.item(i).getNodeName())) continue;
            return (Element)nodeList.item(i);
        }
        return element.getOwnerDocument().createElement("temp");
    }

    private static void scanAllCatalogDataByDataKey(ScanModelParam modelParam, IFileset folder, ScanResultDTO scanResultDTO) {
        IFileset[] keyArray = null;
        log.debug("\u5f00\u59cb\u626b\u63cf\uff1a" + (folder == null ? "" : folder.getFullPath()));
        scanResultDTO.setDataCount(0L);
        scanResultDTO.setInvalidCount(0L);
        scanResultDTO.setScanResultItems(new ArrayList<ScanResultItemDTO>());
        switch (modelParam.getKeyObjType()) {
            case DataFile: {
                keyArray = DataInstanceUtil.scanMainDataFiles(modelParam, folder);
                break;
            }
            case CompactPackage: {
                keyArray = DataInstanceUtil.scanMainCompactPackage(modelParam, folder);
                break;
            }
            case DataFolder: {
                log.debug("\u4e3b\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u4ef6\u5939\uff01");
                keyArray = DataInstanceUtil.scanMainDataFolders(modelParam, folder);
                break;
            }
            case DataPackage: {
                keyArray = DataInstanceUtil.scanMainDataPackages(modelParam, folder);
            }
        }
        if (keyArray == null || keyArray.length == 0) {
            log.error("\u672a\u627e\u5230\u4e3b\u6570\u636e\u6587\u4ef6!");
            throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u6570\u636e\u6587\u4ef6!");
        }
        int max = keyArray.length;
        log.debug("\u4e3b\u6570\u636e\u6587\u4ef6\u6570\u91cf\uff1a" + max);
        ArrayList<IFileset> files = new ArrayList<IFileset>(Arrays.asList(keyArray));
        Integer pos = 0;
        Boolean withinFolders = modelParam.getParentFoldersOfKeyObj().size() > 0;
        Boolean folderValid = true;
        Object parentFolders = null;
        int index = -1;
        ArrayList<ScanFileResultParam> scanFileResultParams = new ArrayList<ScanFileResultParam>();
        int count = keyArray.length;
        ScanFileParam scanFileParam = new ScanFileParam();
        scanFileParam.setFolder(folder);
        scanFileParam.setModelParam(modelParam);
        scanFileParam.setIsPackageType(false);
        scanFileParam.setVirRealPackages(null);
        long newDataCount = 0L;
        long invalidCount = 0L;
        while (files.size() > 0) {
            IFileset keyPath = (IFileset)files.get(0);
            files.remove(keyPath);
            if (keyPath == null) continue;
            log.debug("\u5f00\u59cb\u626b\u63cf\uff1a" + keyPath.getFullPath());
            ScanFileResultParam resultParam = DatumDataModelUtil.scanFilesByMainFile(scanFileParam, keyPath);
            scanFileResultParams.add(resultParam);
            if (!StringUtil.isNotEmpty((String)resultParam.getMainFilePath())) continue;
            ++newDataCount;
            DmFileData data = resultParam.getData();
            ScanResultItemDTO resultItemDTO = new ScanResultItemDTO();
            if (data != null) {
                resultItemDTO.setDataName(data.getDataName());
                resultItemDTO.setMainFilePath(data.getMainPath());
            }
            resultItemDTO.setCheckStatus(resultParam.getScanResult() != false ? "\u5b8c\u6574" : "\u4e0d\u5b8c\u6574");
            resultItemDTO.setMetaFilePath(DatumDataModelUtil.getMetaFilePath(data, modelParam));
            resultItemDTO.setResultTree(DatumDataModelUtil.createResultTree(modelParam.getModel(), data, modelParam));
            scanResultDTO.getScanResultItems().add(resultItemDTO);
            if (resultParam.getScanResult().booleanValue()) continue;
            ++invalidCount;
        }
        modelParam.getModel().setScanFileResultParams(scanFileResultParams);
        scanResultDTO.setDataCount(newDataCount);
        scanResultDTO.setInvalidCount(invalidCount);
    }

    public static ScanFileResultParam scanFilesByMainFile(ScanFileParam param, IFileset keyPath) {
        IFileset folder = param.getFolder();
        ScanModelParam modelParam = param.getModelParam();
        Boolean isPackageType = param.getIsPackageType();
        List<DataPackage> virRealPackages = param.getVirRealPackages();
        boolean flg = false;
        ScanFileResultParam resultParam = new ScanFileResultParam();
        resultParam.setData(null);
        resultParam.setScanResult(false);
        resultParam.setMainFilePath("");
        boolean withinFolders = modelParam.getParentFoldersOfKeyObj().size() > 0;
        boolean folderValid = true;
        ArrayList<Object> parentFolders = new ArrayList();
        int index = -1;
        DmFileData data = null;
        ScanInstanceParam insParam = null;
        if (keyPath == null) {
            return resultParam;
        }
        insParam = new ScanInstanceParam(keyPath, modelParam, folder);
        if (insParam.getPacPath() == null) {
            return resultParam;
        }
        if (withinFolders) {
            folderValid = true;
            String realKeyPath = keyPath.getFullPath().replace("\\", "/");
            parentFolders = new ArrayList<String>(Arrays.asList(realKeyPath.split("/")));
            index = parentFolders.size() - 2;
            for (DataFolder dataFolder : modelParam.getParentFoldersOfKeyObj()) {
                if (DataInstanceUtil.checkFolder(dataFolder, (String)parentFolders.get(index--), insParam.getPacPath().getName(), insParam.getKeyName())) continue;
                folderValid = false;
                break;
            }
        }
        if (!isPackageType.booleanValue()) {
            data = new DmFileData();
        }
        switch (modelParam.getKeyObjType()) {
            case DataFile: {
                flg = DataInstanceUtil.constructCatalogDataByMainFile(modelParam, insParam, data);
                break;
            }
            case CompactPackage: {
                flg = DataInstanceUtil.constructCatalogDataByMainCompactPackage(modelParam, insParam, data);
                break;
            }
            case DataFolder: {
                flg = DataInstanceUtil.constructCatalogDataByMainFolder(modelParam, insParam, data);
                break;
            }
        }
        if (!flg) {
            modelParam.getModel().getScanErrorMessages().addAll(insParam.getScanErrorMsgList());
        }
        resultParam.setData(data);
        resultParam.setScanResult(flg);
        resultParam.setMainFilePath(keyPath.getFullPath());
        return resultParam;
    }

    private static ScanResultNodeDTO createResultTree(DatumModelDataObject node, DmFileData data, ScanModelParam modelParam) {
        ScanResultNodeDTO resultNodeDTO = new ScanResultNodeDTO();
        resultNodeDTO.setPath(node.getPathWithoutModelName());
        resultNodeDTO.setName(node.getName());
        resultNodeDTO.setNodeType(node.getNodeType());
        resultNodeDTO.setChildren(new ArrayList<ScanResultNodeDTO>());
        DataPackage model = modelParam.getModel();
        if (node.getNodeType() == 0) {
            ScanResultNodeDTO resultNode = new ScanResultNodeDTO();
            resultNode.setPath(Paths.get(node.getPathWithoutModelName(), "result").toFile().getPath());
            String pakPath = Paths.get(node.getPathWithoutModelName(), new String[0]).toFile().getPath();
            List resultFiles = data.getFiles().stream().filter(f -> Paths.get(model.getPathWithoutModelName(), f.getPackagePath()).toFile().getPath().equals(pakPath)).collect(Collectors.toList());
            if (resultFiles.size() > 0) {
                resultNode.setNodeType(10);
                resultNode.setName(String.format("\u626b\u63cf\u5230%d\u4e2a\u6587\u4ef6", resultFiles.size()));
                resultNodeDTO.getChildren().add(resultNode);
            } else if (((DataFile)node).getNecessary().booleanValue()) {
                resultNode.setNodeType(9);
                resultNode.setName("<\u6587\u4ef6\u7f3a\u5931>");
                resultNodeDTO.getChildren().add(resultNode);
            }
        }
        if (node.getNodeType() == 1 && !((DataFolder)node).getCanBeEmpty().booleanValue()) {
            String pakPath = Paths.get(node.getPathWithoutModelName(), new String[0]).toFile().getPath();
            List resultFiles = data.getFiles().stream().filter(f -> Paths.get(model.getPathWithoutModelName(), f.getPackagePath()).toFile().getPath().equals(pakPath)).collect(Collectors.toList());
            if (resultFiles.size() == 0) {
                ScanResultNodeDTO resultNode = new ScanResultNodeDTO();
                resultNode.setPath(Paths.get(node.getPathWithoutModelName(), "result").toFile().getPath());
                resultNode.setNodeType(9);
                resultNode.setName("<\u6587\u4ef6\u5939\u7f3a\u5931>");
                resultNodeDTO.getChildren().add(resultNode);
            }
        }
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            for (DatumModelDataObject item : node.getChildren()) {
                resultNodeDTO.getChildren().add(DatumDataModelUtil.createResultTree(item, data, modelParam));
            }
        }
        return resultNodeDTO;
    }

    private static String getMetaFilePath(DmFileData data, ScanModelParam modelParam) {
        ArrayList<DataFile> dataFiles = new ArrayList<DataFile>();
        DatumDataModelUtil.getDataFileByProperty(modelParam.getModel(), "CKMetaFile", dataFiles);
        StringBuilder path = new StringBuilder();
        for (DataFile item : dataFiles) {
            String pakPath = Paths.get(item.getPathWithoutModelName(), new String[0]).toFile().getPath();
            List resultFiles = data.getFiles().stream().filter(f -> Paths.get(modelParam.getModel().getPathWithoutModelName(), f.getPackagePath()).toFile().getPath().equals(pakPath)).collect(Collectors.toList());
            for (FileDataUnit fileDataUnit : resultFiles) {
                path.append(fileDataUnit.getFileSourceLocation());
            }
        }
        String metaPath = path.toString();
        if (StringUtil.isEmpty((String)metaPath)) {
            metaPath = "\u65e0";
        }
        return metaPath;
    }

    private static void getDataFileByProperty(DatumModelDataObject dataObject, String propertyKey, List<DataFile> files) {
        FileModelNodeTypeEnum dataType = FileModelNodeTypeEnum.getByValue(dataObject.getNodeType());
        if (dataType == FileModelNodeTypeEnum.DataFile) {
            DataFile dataFile = (DataFile)dataObject;
            if (dataFile.getProperties().contains(propertyKey)) {
                files.add(dataFile);
            }
        } else {
            for (DatumModelDataObject object : dataObject.getChildren()) {
                object.setParentObject(dataObject);
                DatumDataModelUtil.getDataFileByProperty(object, propertyKey, files);
            }
        }
    }
}

