/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmMetaDataValueDao;
import com.geoway.adf.dms.config.dao.CmMetaTemplateDao;
import com.geoway.adf.dms.config.dao.CmMetaTemplateFieldDao;
import com.geoway.adf.dms.config.dto.meta.MetaDataValueDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateFieldDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateFieldType;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateCreateDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateEditDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateFieldGroupEditDTO;
import com.geoway.adf.dms.config.entity.CmMetaTemplate;
import com.geoway.adf.dms.config.entity.CmMetaTemplateField;
import com.geoway.adf.dms.config.service.MetaTemplateService;
import com.geoway.adf.gis.geodb.field.FieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional(rollbackFor={Exception.class})
public class MetaTemplateServiceImpl
implements MetaTemplateService {
    private static final Logger log = LoggerFactory.getLogger(MetaTemplateServiceImpl.class);
    @Resource
    private CmMetaTemplateDao metaTemplateDao;
    @Resource
    private CmMetaTemplateFieldDao metaTemplateFieldDao;
    @Resource
    private CmMetaDataValueDao metaDataValueDao;
    private static Pattern pattern = Pattern.compile("[0-9]*");

    @Override
    public Long addMetaTemplate(MetaTemplateCreateDTO createDTO) {
        CmMetaTemplate metaTemplate = new CmMetaTemplate();
        Assert.notNull((Object)createDTO.getName(), (String)"\u5143\u6570\u636e\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)createDTO.getKey(), (String)"\u5143\u6570\u636e\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        metaTemplate.setName(createDTO.getName());
        metaTemplate.setKey(createDTO.getKey());
        metaTemplate.setDes(createDTO.getDes());
        metaTemplate.setCategory(createDTO.getCategory());
        CmMetaTemplate sameTemplate = this.metaTemplateDao.selectByKey(createDTO.getKey());
        Assert.isNull((Object)sameTemplate, (String)("\u5143\u6570\u636e\u6a21\u677f" + createDTO.getKey() + "\u5df2\u5b58\u5728\uff01"));
        this.metaTemplateDao.insert(metaTemplate);
        if (createDTO.getFields() != null && createDTO.getFields().size() > 0) {
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (MetaTemplateFieldDTO fieldDTO : createDTO.getFields()) {
                if (fieldNameList.contains(fieldDTO.getName())) {
                    throw new RuntimeException("\u4e0d\u5141\u8bb8\u5305\u542b\u540c\u540d\u5b57\u6bb5\uff01 " + fieldDTO.getName());
                }
                fieldNameList.add(fieldDTO.getName());
            }
            this.metaTemplateFieldDao.batchInsert(ListUtil.convertAll(createDTO.getFields(), f -> {
                CmMetaTemplateField field = this.convertToField((MetaTemplateFieldDTO)f);
                field.setTemplateId(metaTemplate.getId());
                return field;
            }));
        }
        return metaTemplate.getId();
    }

    @Override
    public void updateMetaTemplate(MetaTemplateEditDTO editDTO) {
        CmMetaTemplate cmMetaTemplate = this.metaTemplateDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)cmMetaTemplate, (String)"\u5143\u6570\u636e\u6a21\u677f\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getName() != null) {
            cmMetaTemplate.setName(editDTO.getName());
        }
        if (editDTO.getDes() != null) {
            cmMetaTemplate.setDes(editDTO.getDes());
        }
        if (editDTO.getKey() != null && !editDTO.getKey().equals(cmMetaTemplate.getKey())) {
            CmMetaTemplate sameTemplate = this.metaTemplateDao.selectByKey(editDTO.getKey());
            Assert.isNull((Object)sameTemplate, (String)("\u6807\u8bc6\uff1a" + editDTO.getKey() + "\u91cd\u590d\uff01"));
            cmMetaTemplate.setKey(editDTO.getKey());
        }
        if (editDTO.getFields() != null) {
            List<CmMetaTemplateField> originalFields = this.metaTemplateFieldDao.selectByTemplateId(editDTO.getId());
            if (editDTO.getFields().getAddFields() != null && editDTO.getFields().getAddFields().size() > 0) {
                this.metaTemplateFieldDao.batchInsert(ListUtil.convertAll(editDTO.getFields().getAddFields(), f -> {
                    CmMetaTemplateField field = this.convertToField((MetaTemplateFieldDTO)f);
                    field.setTemplateId(editDTO.getId());
                    return field;
                }));
            }
            if (editDTO.getFields().getUpdateFields() != null && editDTO.getFields().getUpdateFields().size() > 0) {
                HashMap<String, String> renameFields = new HashMap<String, String>(0);
                for (MetaTemplateFieldDTO fieldDTO : editDTO.getFields().getUpdateFields()) {
                    fieldDTO.setTemplateId(editDTO.getId());
                    CmMetaTemplateField field = this.convertToField(fieldDTO);
                    if (field.getId() == null) continue;
                    this.metaTemplateFieldDao.updateByPrimaryKey(field);
                    CmMetaTemplateField targetField = (CmMetaTemplateField)ListUtil.find(originalFields, f -> f.getId().equals(fieldDTO.getId()));
                    if (targetField == null || targetField.getName().equals(fieldDTO.getName())) continue;
                    renameFields.put(targetField.getName(), fieldDTO.getName());
                    this.metaDataValueDao.renameFieldNameByTemplate(targetField.getName(), fieldDTO.getName(), editDTO.getId());
                }
            }
            if (editDTO.getFields().getDeleteFields() != null && editDTO.getFields().getDeleteFields().size() > 0) {
                this.metaTemplateFieldDao.batchDelete(editDTO.getFields().getDeleteFields());
                List targetFields = ListUtil.findAll(originalFields, f -> editDTO.getFields().getDeleteFields().contains(f.getId()));
                if (targetFields.size() > 0) {
                    List deleteNames = ListUtil.convertAll((List)targetFields, CmMetaTemplateField::getName);
                    this.metaDataValueDao.deleteByTemplate(editDTO.getId(), deleteNames);
                }
            }
            List<CmMetaTemplateField> allFields = this.metaTemplateFieldDao.selectByTemplateId(editDTO.getId());
            ArrayList<String> fieldNameList = new ArrayList<String>();
            for (CmMetaTemplateField field : allFields) {
                if (fieldNameList.contains(field.getName())) {
                    throw new RuntimeException("\u4e0d\u5141\u8bb8\u5305\u542b\u540c\u540d\u5b57\u6bb5\uff01 " + field.getName());
                }
                fieldNameList.add(field.getName());
            }
        }
        this.metaTemplateDao.updateByPrimaryKey(cmMetaTemplate);
    }

    @Override
    public List<MetaTemplateDTO> list(String keyword) {
        List<CmMetaTemplate> templates = this.metaTemplateDao.selectByKeyword(keyword, null);
        return ListUtil.convertAll(templates, this::convertToTdo);
    }

    @Override
    public List<MetaTemplateDTO> list(String keyword, String category) {
        List<CmMetaTemplate> templates = this.metaTemplateDao.selectByKeyword(keyword, category);
        return ListUtil.convertAll(templates, this::convertToTdo);
    }

    @Override
    public MetaTemplateDTO getMetaTemplateDetail(Long templateId, Boolean withFields) {
        CmMetaTemplate cmMetaTemplate = this.metaTemplateDao.selectByPrimaryKey(templateId);
        Assert.notNull((Object)cmMetaTemplate, (String)"\u5143\u6570\u636e\u6a21\u677f\u4e0d\u5b58\u5728\uff01");
        MetaTemplateDTO metaTemplate = this.convertToTdo(cmMetaTemplate);
        if (Boolean.TRUE.equals(withFields)) {
            List<CmMetaTemplateField> cmFields = this.metaTemplateFieldDao.selectByTemplateId(templateId);
            metaTemplate.setFields(ListUtil.convertAll(cmFields, this::convertToDto));
        }
        return metaTemplate;
    }

    @Override
    public void deleteMetaTemplate(String templateIds) {
        List templateIdList = StringUtil.split((String)templateIds, (String)",", Long::parseLong);
        this.metaTemplateDao.batchDelete(templateIdList);
        this.metaTemplateFieldDao.batchDeleteByTemplateId(templateIdList);
        for (Long id : templateIdList) {
            this.metaDataValueDao.deleteByTemplate(id, null);
        }
    }

    @Override
    public List<MetaDataValueDTO> readMetaData(String path) {
        ArrayList<MetaDataValueDTO> metaData = new ArrayList<MetaDataValueDTO>();
        List dataList = ExcelUtil.readExcelDataList((String)path);
        for (List values : dataList) {
            String fldValue;
            String fldName;
            if (values.size() < 2) continue;
            if (values.size() == 2) {
                fldName = (String)values.get(0);
                fldValue = (String)values.get(1);
            } else if (values.get(0) == null || pattern.matcher((CharSequence)values.get(0)).matches()) {
                fldName = (String)values.get(1);
                fldValue = (String)values.get(2);
            } else {
                fldName = (String)values.get(0);
                fldValue = (String)values.get(1);
            }
            if (fldName == null || fldName.length() <= 0) continue;
            MetaDataValueDTO item = new MetaDataValueDTO();
            item.setFieldName(fldName.trim());
            item.setValue(fldValue == null ? null : fldValue.trim());
            item.setType(FieldType.String.getValue());
            metaData.add(item);
        }
        return metaData;
    }

    @Override
    public List<MetaTemplateFieldDTO> getMetaMetaTemplateFields(Long templateId) {
        List<CmMetaTemplateField> cmFields = this.metaTemplateFieldDao.selectByTemplateId(templateId);
        List fieldDTOs = ListUtil.convertAll(cmFields, this::convertToDto);
        return fieldDTOs;
    }

    @Override
    public List<MetaTemplateFieldDTO> getMetaMetaTemplateFieldTree(Long templateId) {
        List<CmMetaTemplateField> cmFields = this.metaTemplateFieldDao.selectByTemplateId(templateId);
        List fieldDTOs = ListUtil.convertAll(cmFields, this::convertToDto);
        Map<String, List<MetaTemplateFieldDTO>> map = fieldDTOs.stream().collect(Collectors.groupingBy(f -> f.getPid() == null ? "" : String.valueOf(f.getPid())));
        for (MetaTemplateFieldDTO fieldDTO : fieldDTOs) {
            if (!map.containsKey(String.valueOf(fieldDTO.getId()))) continue;
            fieldDTO.setChildren(map.get(String.valueOf(fieldDTO.getId())));
        }
        return map.get("");
    }

    @Override
    public Long saveMetaTemplateFieldGroup(MetaTemplateFieldGroupEditDTO fieldGroup) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)fieldGroup.getName()), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<CmMetaTemplateField> fields = this.metaTemplateFieldDao.selectByTemplateId(fieldGroup.getTemplateId());
        if (fieldGroup.getId() == null) {
            Assert.notNull((Object)fieldGroup.getTemplateId(), (String)"\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            if (ListUtil.exist(fields, f -> f.getName().equals(fieldGroup.getName()) && MetaTemplateFieldType.Group.getValue() == f.getType().intValue())) {
                throw new RuntimeException("\u540d\u79f0[" + fieldGroup.getName() + "]\u5df2\u5b58\u5728");
            }
            CmMetaTemplateField templateField = new CmMetaTemplateField();
            templateField.setName(fieldGroup.getName());
            templateField.setTemplateId(fieldGroup.getTemplateId());
            templateField.setType(MetaTemplateFieldType.Group.getValue());
            templateField.setOrder(this.getNextOrder(fields));
            this.metaTemplateFieldDao.insert(templateField);
            return templateField.getId();
        }
        CmMetaTemplateField templateField = this.metaTemplateFieldDao.selectByPrimaryKey(fieldGroup.getId());
        Assert.notNull((Object)templateField, (String)"\u5b57\u6bb5\u5206\u7ec4\u4e0d\u5b58\u5728");
        if (MetaTemplateFieldType.Group.getValue() != templateField.getType().intValue()) {
            throw new RuntimeException("\u4e0d\u662f\u5b57\u6bb5\u5206\u7ec4");
        }
        if (ListUtil.exist(fields, f -> f.getName().equals(fieldGroup.getName()) && MetaTemplateFieldType.Group.getValue() == f.getType().intValue() && !fieldGroup.getId().equals(f.getId()))) {
            throw new RuntimeException("\u540d\u79f0[" + fieldGroup.getName() + "]\u5df2\u5b58\u5728");
        }
        templateField.setName(fieldGroup.getName());
        this.metaTemplateFieldDao.updateByPrimaryKey(templateField);
        return templateField.getId();
    }

    @Override
    public Long addMetaTemplateField(MetaTemplateFieldDTO metaTemplateFieldDTO) {
        Assert.notNull((Object)metaTemplateFieldDTO.getTemplateId(), (String)"\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)metaTemplateFieldDTO.getName()), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<CmMetaTemplateField> fields = this.metaTemplateFieldDao.selectByTemplateId(metaTemplateFieldDTO.getTemplateId());
        if (ListUtil.exist(fields, f -> f.getName().equals(metaTemplateFieldDTO.getName()) && MetaTemplateFieldType.Group.getValue() != f.getType().intValue())) {
            throw new RuntimeException("\u540d\u79f0[" + metaTemplateFieldDTO.getName() + "]\u5df2\u5b58\u5728");
        }
        CmMetaTemplateField templateField = this.convertToField(metaTemplateFieldDTO);
        templateField.setOrder(this.getNextOrder(fields));
        this.metaTemplateFieldDao.insert(templateField);
        return templateField.getId();
    }

    @Override
    public void batchAddMetaTemplateField(List<MetaTemplateFieldDTO> metaTemplateFieldDTOs) {
        if (metaTemplateFieldDTOs == null || metaTemplateFieldDTOs.size() == 0) {
            return;
        }
        Long templateId = metaTemplateFieldDTOs.get(0).getTemplateId();
        Assert.notNull((Object)templateId, (String)"\u6a21\u677f\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        for (MetaTemplateFieldDTO metaTemplateFieldDTO : metaTemplateFieldDTOs) {
            if (StringUtil.isEmptyOrWhiteSpace((String)metaTemplateFieldDTO.getName())) {
                log.error("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5904\u7406");
                continue;
            }
            List<CmMetaTemplateField> fields = this.metaTemplateFieldDao.selectByTemplateId(metaTemplateFieldDTO.getTemplateId());
            if (ListUtil.exist(fields, f -> f.getName().equals(metaTemplateFieldDTO.getName()) && MetaTemplateFieldType.Group.getValue() != f.getType().intValue())) {
                log.error("\u5b57\u6bb5\u540d\u79f0[" + metaTemplateFieldDTO.getName() + "]\u5df2\u5b58\u5728");
                continue;
            }
            CmMetaTemplateField templateField = this.convertToField(metaTemplateFieldDTO);
            templateField.setOrder(this.getNextOrder(fields));
            this.metaTemplateFieldDao.insert(templateField);
        }
    }

    @Override
    public Long editMetaTemplateField(MetaTemplateFieldDTO metaTemplateFieldDTO) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)metaTemplateFieldDTO.getName()), (String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CmMetaTemplateField templateField = this.metaTemplateFieldDao.selectByPrimaryKey(metaTemplateFieldDTO.getId());
        Assert.notNull((Object)templateField, (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728");
        List<CmMetaTemplateField> fields = this.metaTemplateFieldDao.selectByTemplateId(metaTemplateFieldDTO.getTemplateId());
        if (ListUtil.exist(fields, f -> f.getName().equals(metaTemplateFieldDTO.getName()) && MetaTemplateFieldType.Group.getValue() != f.getType().intValue() && !metaTemplateFieldDTO.getId().equals(f.getId()))) {
            throw new RuntimeException("\u540d\u79f0[" + metaTemplateFieldDTO.getName() + "]\u5df2\u5b58\u5728");
        }
        CmMetaTemplateField field = this.convertToField(metaTemplateFieldDTO);
        field.setTemplateId(templateField.getTemplateId());
        field.setPid(templateField.getPid());
        field.setOrder(templateField.getOrder());
        this.metaTemplateFieldDao.updateByPrimaryKey(field);
        if (!templateField.getName().equals(field.getName())) {
            this.metaDataValueDao.renameFieldNameByTemplate(templateField.getName(), field.getName(), templateField.getTemplateId());
        }
        return templateField.getId();
    }

    @Override
    public void deleteMetaTemplateField(String fieldIds) {
        String[] strIds;
        for (String strId : strIds = fieldIds.split(",")) {
            Long id = Long.parseLong(strId);
            List<CmMetaTemplateField> children = this.metaTemplateFieldDao.selectByPid(null, id);
            List delIds = ListUtil.convertAll(children, f -> f.getId());
            delIds.add(id);
            this.metaTemplateFieldDao.batchDelete(delIds);
        }
    }

    @Override
    public void moveMetaTemplateField(Long id, Long groupId, Long frontId) {
        CmMetaTemplateField templateField = this.metaTemplateFieldDao.selectByPrimaryKey(id);
        Assert.notNull((Object)templateField, (String)"\u5b57\u6bb5\u4e0d\u5b58\u5728");
        List<CmMetaTemplateField> allFields = this.metaTemplateFieldDao.selectByTemplateId(templateField.getTemplateId());
        List children = ListUtil.findAll(allFields, f -> this.equals(groupId, f.getPid()));
        if (this.equals(templateField.getPid(), groupId)) {
            children.removeIf(f -> f.getId().equals(id));
        } else {
            if (groupId != null) {
                CmMetaTemplateField groupFld = (CmMetaTemplateField)ListUtil.find(allFields, f -> this.equals(f.getId(), groupId));
                log.error(groupFld + "\u7236\u5206\u7ec4\u4e0d\u5b58\u5728");
                Assert.notNull((Object)groupFld, (String)"\u7236\u5206\u7ec4\u4e0d\u5b58\u5728");
                Assert.isTrue((MetaTemplateFieldType.Group.getValue() == groupFld.getType().intValue() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u79fb\u52a8\u5230\u5206\u7ec4\u8282\u70b9\u4e0b");
            }
            templateField.setPid(groupId);
            this.metaTemplateFieldDao.updateByPrimaryKey(templateField);
        }
        if (frontId == null) {
            children.add(0, templateField);
        } else {
            for (int i = 0; i < children.size(); ++i) {
                if (!((CmMetaTemplateField)children.get(i)).getId().equals(frontId)) continue;
                children.add(i + 1, templateField);
                break;
            }
        }
        for (int i = 0; i < children.size(); ++i) {
            CmMetaTemplateField child = (CmMetaTemplateField)children.get(i);
            if (child.getOrder() != null && child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.metaTemplateFieldDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    private MetaTemplateDTO convertToTdo(CmMetaTemplate metaTemplate) {
        MetaTemplateDTO metaTemplateDTO = new MetaTemplateDTO();
        metaTemplateDTO.setId(metaTemplate.getId());
        metaTemplateDTO.setKey(metaTemplate.getKey());
        metaTemplateDTO.setName(metaTemplate.getName());
        metaTemplateDTO.setDes(metaTemplate.getDes());
        return metaTemplateDTO;
    }

    private MetaTemplateFieldDTO convertToDto(CmMetaTemplateField field) {
        MetaTemplateFieldDTO fieldDTO = new MetaTemplateFieldDTO();
        fieldDTO.setId(field.getId());
        fieldDTO.setPid(field.getPid());
        fieldDTO.setTemplateId(field.getTemplateId());
        fieldDTO.setName(field.getName());
        fieldDTO.setFieldType(field.getType());
        fieldDTO.setDictionaryKey(field.getDictionaryKey());
        fieldDTO.setDefaultValue(field.getDefaultValue());
        fieldDTO.setLength(field.getLength());
        boolean nullable = field.getIsNull() == null || field.getIsNull().equals(ConstantsValue.TRUE_VALUE);
        fieldDTO.setNullable(nullable);
        fieldDTO.setOrder(field.getOrder() == null ? 0 : field.getOrder());
        fieldDTO.setMultiSelect(field.getMultiSelect());
        return fieldDTO;
    }

    private CmMetaTemplateField convertToField(MetaTemplateFieldDTO fieldDTO) {
        CmMetaTemplateField field = new CmMetaTemplateField();
        if (fieldDTO.getName() == null) {
            throw new RuntimeException("\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        field.setId(fieldDTO.getId());
        field.setName(fieldDTO.getName());
        field.setPid(fieldDTO.getPid());
        field.setTemplateId(fieldDTO.getTemplateId());
        field.setDictionaryKey(fieldDTO.getDictionaryKey());
        field.setType(fieldDTO.getFieldType() == null ? FieldType.String.getValue() : fieldDTO.getFieldType().intValue());
        field.setDefaultValue(fieldDTO.getDefaultValue());
        field.setIsNull(fieldDTO.getNullable() == null || fieldDTO.getNullable() != false ? ConstantsValue.TRUE_VALUE : ConstantsValue.FALSE_VALUE);
        field.setLength(fieldDTO.getLength() == null ? 2000 : fieldDTO.getLength());
        field.setOrder(fieldDTO.getOrder() == null ? 0 : fieldDTO.getOrder());
        field.setMultiSelect(fieldDTO.getMultiSelect());
        return field;
    }

    private int getNextOrder(List<CmMetaTemplateField> fields) {
        if (fields.size() == 0) {
            return 0;
        }
        CmMetaTemplateField lastField = fields.get(fields.size() - 1);
        return lastField.getOrder() == null ? 1 : lastField.getOrder() + 1;
    }

    private boolean equals(Long id1, Long id2) {
        return id1 == null && id2 == null || id1 != null && id1.equals(id2);
    }
}

