/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.component;

import com.geoway.adf.dms.config.component.MyBatisSchemaInterceptor;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisInterceptorConfig {
    @Resource
    private UserRightProperties userRightProperties;
    private final MyBatisSchemaInterceptor userDynamicSchemaInterceptor;
    private final List<SqlSessionFactory> sqlSessionFactoryList;

    public MybatisInterceptorConfig(List<SqlSessionFactory> sqlSessionFactoryList) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
        this.userDynamicSchemaInterceptor = new MyBatisSchemaInterceptor();
    }

    public void addSqlInterceptor() {
        if (Boolean.TRUE.equals(this.userRightProperties.getTenantEnabled())) {
            for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)this.userDynamicSchemaInterceptor);
            }
        }
    }

    public void addMapper(String mapperName, String ... tableNames) {
        this.userDynamicSchemaInterceptor.addMapper(mapperName, tableNames);
    }
}

