/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel.util;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.filemodel.util.FileHelper;
import com.geoway.adf.gis.fs.IFileset;
import com.github.junrar.Archive;
import com.github.junrar.rarfile.FileHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepressHelper {
    private static final Logger log = LoggerFactory.getLogger(DepressHelper.class);

    public static boolean extract(IFileset targetFileFullName, IFileset destFolder, String packageType, String formatOption) {
        String destFolderPath = Paths.get(destFolder.getFullPath(), FileHelper.getNameWithoutExt(targetFileFullName, packageType)).toString();
        File destFolderFile = new File(destFolderPath);
        if (!destFolderFile.exists()) {
            boolean bl = destFolderFile.mkdirs();
        }
        if (targetFileFullName.getFullPath().toLowerCase(Locale.ROOT).endsWith(".zip")) {
            return DepressHelper.extractZip(targetFileFullName, destFolderPath, formatOption);
        }
        if (targetFileFullName.getFullPath().toLowerCase(Locale.ROOT).endsWith(".rar")) {
            return DepressHelper.extractRar(targetFileFullName, destFolderPath, formatOption);
        }
        if (targetFileFullName.getFullPath().toLowerCase(Locale.ROOT).endsWith(".tar.gz")) {
            return DepressHelper.extractTraGz(targetFileFullName, destFolderPath, formatOption);
        }
        if (targetFileFullName.getFullPath().toLowerCase(Locale.ROOT).endsWith(".tar")) {
            return DepressHelper.extractTra(targetFileFullName, destFolderPath, formatOption);
        }
        if (targetFileFullName.getFullPath().toLowerCase(Locale.ROOT).endsWith(".gz")) {
            return DepressHelper.extractGz(targetFileFullName, destFolderPath, formatOption);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private static boolean extractZip(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        FileOutputStream out = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            ZipEntry entry;
            ZipInputStream zIn = new ZipInputStream(targetFileFullName.openFileStream(), Charset.forName("GBK"));
            while ((entry = zIn.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) continue;
                String zipEntryName = entry.getName();
                String filePath = Paths.get(destFolderPath, zipEntryName).toString();
                File file = new File(filePath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.isDirectory()) {
                    file.mkdirs();
                }
                String extension = FileUtil.getExtension((String)zipEntryName).toLowerCase(Locale.ROOT);
                if (formatList.size() != 0 && !formatList.contains(extension)) continue;
                out = new FileOutputStream(filePath);
                byte[] buf1 = new byte[1024];
                while ((len = zIn.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                ((OutputStream)out).close();
            }
            zIn.close();
            bl = true;
        }
        catch (Exception e) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
            boolean entry = DepressHelper.unZipFilesByZipArchiveInputStream(targetFileFullName, destFolderPath, formatOption);
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
            return entry;
            {
                catch (Exception ex) {
                    try {
                        log.error(targetFileFullName.getFullPath() + " \u89e3\u538b\u6570\u636e\u5931\u8d25\uff01");
                        throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                        throw throwable;
                    }
                }
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
        return bl;
    }

    private static boolean unZipFilesByZipArchiveInputStream(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        InputStream in = null;
        FileOutputStream out = null;
        ZipArchiveInputStream zipIn = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            in = targetFileFullName.openFileStream();
            zipIn = new ZipArchiveInputStream(in, "GBK", true);
            ArchiveEntry archiveEntry = zipIn.getNextEntry();
            while (archiveEntry != null) {
                String entryFileName = archiveEntry.getName();
                if (!archiveEntry.isDirectory()) {
                    File entryFile;
                    String entryFilePath = Paths.get(destFolderPath, entryFileName).toString();
                    File file = new File(entryFilePath);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!(entryFile = new File(entryFilePath)).getParentFile().exists()) {
                        entryFile.getParentFile().mkdirs();
                    }
                    String extension = FileUtil.getExtension((String)entryFileName).toLowerCase(Locale.ROOT);
                    if (formatList.size() == 0 || formatList.contains(extension)) {
                        int len;
                        out = new FileOutputStream(entryFile);
                        byte[] buf1 = new byte[1024];
                        while ((len = zipIn.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                        ((OutputStream)out).close();
                    }
                }
                archiveEntry = zipIn.getNextEntry();
            }
            zipIn.close();
            in.close();
            bl = true;
        }
        catch (Exception e) {
            try {
                log.error(targetFileFullName.getFullPath() + " \u89e3\u538b\u6570\u636e\u5931\u8d25\uff01");
                throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{zipIn, in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{zipIn, in, out});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractTraGz(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        TarInputStream tarIn = null;
        FileOutputStream out = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            tarIn = new TarInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(targetFileFullName.openFileStream())), 2048);
            TarEntry entry = null;
            while ((entry = tarIn.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                String filePath = Paths.get(destFolderPath, entryName).toString();
                if (entry.isDirectory()) {
                    new File(filePath).mkdirs();
                    continue;
                }
                String extension = FileUtil.getExtension((String)entryName).toLowerCase(Locale.ROOT);
                if (formatList.size() != 0 && !formatList.contains(extension)) continue;
                out = new FileOutputStream(filePath);
                byte[] buf1 = new byte[2048];
                while ((len = tarIn.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                ((OutputStream)out).close();
                out = null;
            }
            tarIn.close();
            tarIn = null;
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                log.error(targetFileFullName.getFullPath() + " \u89e3\u538b\u6570\u636e\u5931\u8d25\uff01");
                bl2 = DepressHelper.extractTra(targetFileFullName, destFolderPath, formatOption);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, tarIn});
                throw throwable;
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, tarIn});
            return bl2;
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, tarIn});
        return bl;
    }

    private static boolean extractTra(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        TarInputStream tarIn = null;
        FileOutputStream out = null;
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray;
            for (String format : formatArray = formatOption.split(" ")) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            tarIn = new TarInputStream((InputStream)new BufferedInputStream(targetFileFullName.openFileStream()), 2048);
            TarEntry entry = null;
            while ((entry = tarIn.getNextEntry()) != null) {
                int len;
                String entryName = entry.getName();
                String filePath = Paths.get(destFolderPath, entryName).toString();
                if (entry.isDirectory()) {
                    new File(filePath).mkdirs();
                    continue;
                }
                String extension = FileUtil.getExtension((String)entryName).toLowerCase(Locale.ROOT);
                if (formatList.size() != 0 && !formatList.contains(extension)) continue;
                out = new FileOutputStream(filePath);
                byte[] buf1 = new byte[2048];
                while ((len = tarIn.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                ((OutputStream)out).close();
                out = null;
            }
            tarIn.close();
            tarIn = null;
            bl = true;
        }
        catch (Exception e) {
            try {
                log.error(targetFileFullName.getFullPath() + " \u89e3\u538b\u6570\u636e\u5931\u8d25\uff01");
                throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, tarIn});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, tarIn});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractGz(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        boolean bl;
        GZIPInputStream gzIn = null;
        FileOutputStream out = null;
        try {
            int len;
            gzIn = new GZIPInputStream(new BufferedInputStream(targetFileFullName.openFileStream()));
            String filePath = Paths.get(destFolderPath, FileHelper.getNameWithoutExt(targetFileFullName, "")).toString();
            out = new FileOutputStream(filePath);
            byte[] buf1 = new byte[1024];
            while ((len = gzIn.read(buf1)) > 0) {
                ((OutputStream)out).write(buf1, 0, len);
            }
            ((OutputStream)out).close();
            out = null;
            gzIn.close();
            gzIn = null;
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                log.error("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
                bl2 = DepressHelper.extractTra(targetFileFullName, destFolderPath, formatOption);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, gzIn});
                throw throwable;
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, gzIn});
            return bl2;
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, gzIn});
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean extractRar(IFileset targetFileFullName, String destFolderPath, String formatOption) {
        ArrayList<String> formatList = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)formatOption)) {
            String[] formatArray = formatOption.split(" ");
            for (String format : formatArray) {
                formatList.add(format.toLowerCase(Locale.ROOT));
            }
        }
        try {
            Archive archive = new Archive(targetFileFullName.openFileStream());
            Object object = null;
            try {
                FileHeader fileHeader = archive.nextFileHeader();
                while (fileHeader != null) {
                    String fileName = fileHeader.getFileName();
                    File outputFile = new File(destFolderPath, fileName);
                    if (fileHeader.isDirectory()) {
                        if (!outputFile.exists()) {
                            outputFile.mkdirs();
                        }
                    } else {
                        File parent = outputFile.getParentFile();
                        if (parent != null && !parent.exists()) {
                            parent.mkdirs();
                        }
                        String extension = FileUtil.getExtension((String)fileName).toLowerCase(Locale.ROOT);
                        if (formatList.size() == 0 || formatList.contains(extension)) {
                            try (FileOutputStream os = new FileOutputStream(outputFile);){
                                archive.extractFile(fileHeader, (OutputStream)os);
                            }
                        }
                    }
                    fileHeader = archive.nextFileHeader();
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (archive != null) {
                    if (object != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        archive.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(targetFileFullName.getFullPath() + " \u89e3\u538b\u6570\u636e\u5931\u8d25\uff01");
            throw new RuntimeException("\u89e3\u538b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), e);
        }
    }

    private static boolean extractByRarTool(File zipFile, String destDir, String cmdPath) {
        boolean bool = false;
        if (!zipFile.exists()) {
            return false;
        }
        String cmd = cmdPath + " X -o+ " + zipFile + " " + destDir;
        System.out.println(cmd);
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            if (proc.waitFor() != 0) {
                if (proc.exitValue() == 0) {
                    bool = false;
                }
            } else {
                bool = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u89e3\u538b" + (bool ? "\u6210\u529f" : "\u5931\u8d25"));
        return bool;
    }
}

