/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.FeatureClassUtil;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.geosrv.AtlasServer;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.SelectFileDataUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.ime.IMEServer;
import com.geoway.adf.gis.geosrv.ime.IMEServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.IServicePublishParams;
import com.geoway.adf.gis.geosrv.vtile.VTileDataService;
import com.geoway.adf.gis.geosrv.vtile.VTileServer;
import com.geoway.adf.gis.geosrv.vtile.VTileServicePublishParams;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.PixelDataType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataInputS57ServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(DataInputS57ServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    @Resource
    private GeoServerEngineService geoServerEngineService;

    public DatasetDTO uploadS57DataInput(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.endsWith(".000") && !fileName.endsWith(".zip")) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u6d77\u56fe\u6570\u636e\u6587\u4ef6");
        }
        String id = IdUtil.getSnowflakeNextIdStr();
        Path localPath = UploadPathConfig.getUploadPath().resolve(id);
        localPath.toFile().mkdirs();
        File localFile = localPath.resolve(fileName).toFile();
        file.transferTo(localFile);
        File vectorFile = null;
        File rasterFile = null;
        String styleStr = null;
        if (!localFile.isDirectory() && fileName.toLowerCase().endsWith(".zip")) {
            localPath = Paths.get(localPath.toString(), FileUtil.getFileNameWithoutExtension((String)fileName));
            ZipAndRarUtil.unZipFiles((File)localFile, (String)(localPath + File.separator));
            DirectoryFileStorage fileStorage = new DirectoryFileStorage(localPath.toString(), null, null);
            List<SelectFileDataDTO> fileDataList = SelectFileDataUtil.getDataFromFolderRecursion((IFileStorage)fileStorage, localPath.toString(), Collections.singletonList(FileDataTypeEnum.File), ".rec");
            fileStorage.close();
            if (fileDataList.size() > 0) {
                vectorFile = Paths.get(fileDataList.get(0).getFullPath(), new String[0]).getParent().toFile();
                styleStr = this.readStyleFile("MVCF_style.json");
            } else {
                List<FileDataTypeEnum> filterTypes = Arrays.asList(FileDataTypeEnum.RasterTifFile, FileDataTypeEnum.RasterImgFile, FileDataTypeEnum.RasterGridFile);
                fileDataList = SelectFileDataUtil.getDataFromFolderRecursion((IFileStorage)fileStorage, localPath.toString(), filterTypes, null);
                if (fileDataList.size() > 0) {
                    rasterFile = new File(fileDataList.get(0).getFullPath());
                }
            }
        } else {
            vectorFile = localFile;
            styleStr = this.readStyleFile("S57_style.json");
        }
        if (vectorFile != null) {
            String dataName = FileUtil.getFileNameWithoutExtension((String)fileName);
            return this.inputVector(vectorFile, id, dataName, styleStr);
        }
        if (rasterFile != null) {
            return this.inputRaster(rasterFile.getAbsolutePath());
        }
        throw new RuntimeException("\u672a\u8bfb\u53d6\u5230\u6570\u636e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetDTO inputVector(File localFile, String id, String dataName, String styleStr) throws ExecutionException, InterruptedException, IOException {
        try (IFeatureWorkspace targetWorkspace = null;){
            ServiceDatasetDTO serviceDatasetDTO;
            block20: {
                VTileServer vTileServer = null;
                DataSourceDTO serverDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), DataSourceTypeEnum.AtlasServer.getValue());
                if (serverDTO == null) {
                    serverDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), DataSourceTypeEnum.VTileServer.getValue());
                    if (serverDTO == null) {
                        throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u670d\u52a1\u5f15\u64ce");
                    }
                    vTileServer = new VTileServer(serverDTO.getUrl(), serverDTO.getUserName(), serverDTO.getPassword());
                } else {
                    AtlasServer atlasServer = new AtlasServer(serverDTO.getUrl(), serverDTO.getUserName(), serverDTO.getPassword());
                    vTileServer = atlasServer.getVTileServer();
                }
                VTileServer server = vTileServer;
                Assert.isTrue((boolean)server.testConnect(), (String)"\u670d\u52a1\u5f15\u64ce\u8fde\u63a5\u5931\u8d25");
                String serviceName = dataName;
                ServiceDatasetDTO serviceDataset = null;
                try {
                    serviceDataset = this.geoServerEngineService.getDatasetDetail(serverDTO, ServiceType.VectorTileService, serviceName);
                }
                catch (Exception e) {
                    log.info("\u5730\u56fe\u670d\u52a1" + serviceName + "\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u5165\u5e93\u521b\u5efa\u670d\u52a1");
                }
                if (serviceDataset != null) {
                    ServiceDatasetDTO e = serviceDataset;
                    return e;
                }
                String groupName = dataName + "_" + id;
                String groupId = server.getDataGroupId(groupName, true);
                DataSourceDTO databaseDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.GeoDatabase.getValue(), null);
                if (databaseDTO == null) {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7a7a\u95f4\u6570\u636e\u5e93");
                }
                ConcurrentLinkedQueue dataServiceIds = new ConcurrentLinkedQueue();
                ExtentDTO extentDTO = new ExtentDTO();
                targetWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
                IFeatureWorkspace srcWorkspace = null;
                try {
                    srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)localFile.getAbsolutePath());
                    ArrayList<Future> taskFutures = new ArrayList<Future>();
                    List srcDatasets = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass});
                    for (IGeoDataset srcDataset : srcDatasets) {
                        String srcName = srcDataset.getName();
                        taskFutures.add(this.threadPoolTaskExecutorData.submit(() -> {
                            FeatureClassDTO featureClassDTO = this.inputLayer(localFile.getAbsolutePath(), srcName, id, databaseDTO);
                            if (featureClassDTO == null) {
                                return;
                            }
                            VTileServicePublishParams publishParams = new VTileServicePublishParams();
                            publishParams.setServiceName(srcName.toLowerCase());
                            publishParams.setServiceAliasName(srcName.toLowerCase());
                            publishParams.setPublishDataset(this.renderIndexService.getPublishDataset(featureClassDTO, ServiceType.VectorTileService));
                            publishParams.setGeometryField(featureClassDTO.getShapeField());
                            publishParams.setFieldNameList(ListUtil.convertAll(featureClassDTO.getFields(), f -> f.getName()));
                            publishParams.setFeatureType(featureClassDTO.getFeatureType());
                            publishParams.setCreateDataCache(Boolean.valueOf(false));
                            publishParams.setDataGroupName(groupName);
                            Date startTime = new Date();
                            VTileDataService vTileDataService = server.createDataService(publishParams);
                            log.info("\u53d1\u5e03\u6570\u636e\u670d\u52a1" + publishParams.getServiceName() + "\u7528\u65f6\uff1a" + (new Date().getTime() - startTime.getTime()));
                            dataServiceIds.add(vTileDataService.getId());
                            extentDTO.union(featureClassDTO.getExtent());
                        }));
                    }
                    for (Future future : taskFutures) {
                        future.get();
                    }
                    server.createMapService(serviceName, serviceName, String.join((CharSequence)",", dataServiceIds));
                    Double x = null;
                    Double y = null;
                    if (extentDTO.getXmin() != null) {
                        x = (extentDTO.getXmin() + extentDTO.getXmax()) / 2.0;
                        y = (extentDTO.getYmin() + extentDTO.getYmax()) / 2.0;
                    }
                    server.importStyle(styleStr, serviceName, serviceName, x, y);
                    IGeoService geoService = server.getService(ServiceType.VectorTileService, serviceName);
                    if (geoService == null) {
                        throw new RuntimeException(serviceName + "\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01");
                    }
                    log.info(serviceName + "\u670d\u52a1\u53d1\u5e03\u6210\u529f");
                    serviceDatasetDTO = this.geoServerEngineService.getDatasetDetail(serverDTO, ServiceType.VectorTileService, serviceName);
                    if (srcWorkspace == null) break block20;
                }
                catch (Throwable throwable) {
                    if (srcWorkspace != null) {
                        srcWorkspace.close();
                    }
                    throw throwable;
                }
                srcWorkspace.close();
            }
            return serviceDatasetDTO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureClassDTO inputLayer(String filePath, String srcName, String id, DataSourceDTO databaseDTO) {
        IFeatureWorkspace srcWorkspace = null;
        IFeatureWorkspace targetWorkspace = null;
        try {
            ISpatialReferenceSystem spatialReferenceSystem;
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)filePath);
            targetWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
            IFeatureClass srcFeatureClass = srcWorkspace.openFeatureClass(srcName);
            if (srcFeatureClass == null) {
                throw new RuntimeException(srcName + "\u56fe\u5c42\u6253\u5f00\u5931\u8d25");
            }
            String targetName = srcName + "_" + id;
            IFeatureClass targetFeatureClass = FeatureClassUtil.createFeatureClass((IFeatureClass)srcFeatureClass, (IFeatureWorkspace)targetWorkspace, (String)targetName, (ISpatialReferenceSystem)(spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490)));
            if (targetFeatureClass == null) {
                throw new RuntimeException(targetName + "\u76ee\u6807\u56fe\u5c42\u521b\u5efa\u5931\u8d25");
            }
            Date startTime = new Date();
            VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
            vectorDataTransfer.setIsErrorContinue(true);
            TransferResult result = vectorDataTransfer.copyFeature(srcFeatureClass, targetFeatureClass, null);
            log.info(String.format("%s\u5bfc\u5165%s,\uff0c\u5171%d\u4e2a\uff0c\u6210\u529f%d\u4e2a\uff0c\u7528\u65f6%s", FileUtil.getFileName((String)filePath) + "/" + srcName, result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)new Date())));
            if (!result.isSuccess()) {
                throw new RuntimeException(srcName + "\u5bfc\u5165\u5931\u8d25");
            }
            if (result.getTotalCount() == 0L) {
                FeatureClassDTO featureClassDTO = null;
                return featureClassDTO;
            }
            FeatureClassDTO featureClassDTO = (FeatureClassDTO)GeoDatasetUtil.getGeoDatasetDetail(databaseDTO, (IGeoDataset)targetFeatureClass);
            featureClassDTO.setDataSource(databaseDTO);
            FeatureClassDTO featureClassDTO2 = featureClassDTO;
            return featureClassDTO2;
        }
        finally {
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatasetDTO inputRaster(String rasterFile) {
        try (IFeatureWorkspace targetWorkspace = null;){
            ServiceDatasetDTO serviceDatasetDTO;
            block20: {
                IMosaicDataset targetMosaicDataset;
                DataSourceDTO serverDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), DataSourceTypeEnum.AtlasServer.getValue());
                if (serverDTO == null && (serverDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), DataSourceTypeEnum.IMEServer.getValue())) == null) {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7a7a\u95f4\u670d\u52a1\u5f15\u64ce");
                }
                IMEServer server = new IMEServer(serverDTO.getUrl(), serverDTO.getUserName(), serverDTO.getPassword());
                Assert.isTrue((boolean)server.testConnect(), (String)"\u670d\u52a1\u5f15\u64ce\u8fde\u63a5\u5931\u8d25");
                String dataName = FileUtil.getFileNameWithoutExtension((String)rasterFile);
                String serviceName = PinyinUtil.convertToPinYin((String)dataName);
                ServiceDatasetDTO serviceDataset = null;
                try {
                    serviceDataset = this.geoServerEngineService.getDatasetDetail(serverDTO, ServiceType.DTileService, serviceName);
                }
                catch (Exception e) {
                    log.info("\u5730\u56fe\u670d\u52a1" + serviceName + "\u4e0d\u5b58\u5728\uff0c\u91cd\u65b0\u5165\u5e93\u521b\u5efa\u670d\u52a1");
                }
                if (serviceDataset != null) {
                    ServiceDatasetDTO e = serviceDataset;
                    return e;
                }
                DataSourceDTO databaseDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.GeoDatabase.getValue(), null);
                if (databaseDTO == null) {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7a7a\u95f4\u6570\u636e\u5e93");
                }
                targetWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
                String name = dataName;
                if (name.length() > 30) {
                    name = name.substring(0, 30);
                }
                if ((targetMosaicDataset = targetWorkspace.openMosaicDataset(name)) != null) {
                    int index = 1;
                    String newName = name;
                    while (targetWorkspace.datasetExist(newName)) {
                        newName = name + "_" + index;
                        ++index;
                    }
                    name = newName;
                    ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
                    targetMosaicDataset = targetWorkspace.createMosaicDataset(name, null, spatialReferenceSystem, -1, PixelDataType.Unknown);
                }
                if (targetMosaicDataset == null) {
                    throw new RuntimeException("\u6570\u636e\u96c6" + name + "\u521b\u5efa\u5931\u8d25");
                }
                IRasterDataset rasterDataset = null;
                try {
                    RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFile);
                    rasterDataset = rasterWorkspace.openRasterDataset(rasterFile);
                    boolean isValid = targetMosaicDataset.addRaster(rasterDataset, true);
                    if (!isValid) {
                        throw new RuntimeException(rasterFile + "\u5199\u5165\u6805\u683c\u6570\u636e\u5931\u8d25");
                    }
                    targetMosaicDataset.updateExtent();
                    targetMosaicDataset.calculateCellSizeRanges();
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(databaseDTO, (IGeoDataset)targetMosaicDataset);
                    datasetDTO.setDataSource(databaseDTO);
                    IMEServicePublishParams publishParams = new IMEServicePublishParams();
                    publishParams.setServiceName(serviceName);
                    publishParams.setServiceAliasName(serviceName);
                    publishParams.setServiceType(ServiceType.DTileService);
                    publishParams.setPublishDataset(this.renderIndexService.getPublishDataset(datasetDTO, ServiceType.DTileService));
                    IGeoService geoService = server.publishService((IServicePublishParams)publishParams);
                    if (geoService == null) {
                        throw new RuntimeException(serviceName + "\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff01");
                    }
                    log.info(serviceName + "\u670d\u52a1\u53d1\u5e03\u6210\u529f");
                    serviceDatasetDTO = this.geoServerEngineService.getDatasetDetail(serverDTO, ServiceType.DTileService, serviceName);
                    if (rasterDataset == null) break block20;
                }
                catch (Throwable throwable) {
                    if (rasterDataset != null) {
                        rasterDataset.closeRaster();
                    }
                    throw throwable;
                }
                rasterDataset.closeRaster();
            }
            return serviceDatasetDTO;
        }
    }

    private String readStyleFile(String styleFile) throws IOException {
        InputStream styleStream;
        File customFile = Paths.get(new File("").getAbsolutePath(), "templates", styleFile).toFile();
        if (customFile.exists()) {
            log.info("\u8bfb\u53d6\u6837\u5f0f\u6587\u4ef6\uff1a" + customFile.getAbsolutePath());
            styleStream = Files.newInputStream(customFile.toPath(), new OpenOption[0]);
        } else {
            styleStream = this.getClass().getClassLoader().getResourceAsStream("templates/" + styleFile);
        }
        if (styleStream == null) {
            throw new IOException("\u672a\u8bfb\u53d6\u5230S57\u9ed8\u8ba4\u6837\u5f0f");
        }
        String styleStr = FileCopyUtils.copyToString((Reader)new InputStreamReader(styleStream, StandardCharsets.UTF_8));
        return styleStr;
    }
}

