/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.DmFileDataDao;
import com.geoway.adf.dms.config.dto.filepackage.create.FileDataCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataDTO;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataUnitDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.constant.CatalogFileTypeEnum;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class FileDataServiceImpl
implements FileDataService {
    private static final Logger log = LoggerFactory.getLogger(FileDataServiceImpl.class);
    @Resource
    private DmFileDataDao dmFileDataDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private FileStorageService fileStorageService;

    @Override
    public FileDataUnitDTO getFileDataTree(String dataId) {
        DmFileData dmFileData = this.dmFileDataDao.selectByPrimaryKey(dataId);
        Assert.notNull((Object)dmFileData, (String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff01");
        List fileDataUnits = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
        FileDataUnitDTO rootUnit = new FileDataUnitDTO();
        rootUnit.setDataId(dataId);
        rootUnit.setCatalogFileType("\u6839\u8282\u70b9");
        rootUnit.setNodeType(Integer.valueOf(FileModelNodeTypeEnum.DataFolder.getValue()));
        rootUnit.setName("\u8d44\u6599\u76ee\u5f55");
        rootUnit.setDataAmount("");
        rootUnit.setFileLocation(StringUtil.isEmptyOrWhiteSpace((String)dmFileData.getMainPath()) ? "\\" : dmFileData.getMainPath());
        rootUnit.setFileLocation(rootUnit.getFileLocation().replace("\\", "/"));
        rootUnit.setChildren(new ArrayList());
        return this.completeCatalogFileDTO(rootUnit, fileDataUnits);
    }

    @Override
    public DmFileData getFileData(String dataId) {
        return this.dmFileDataDao.selectByPrimaryKey(dataId);
    }

    @Override
    public List<DmFileData> getFileDataList(List<String> dataIdList) {
        return this.dmFileDataDao.selectByDataIds(dataIdList);
    }

    @Override
    public List<DmFileData> getFileDataListByDatasetId(String datumDatasetId) {
        return this.dmFileDataDao.selectByDatumDatasetId(datumDatasetId);
    }

    @Override
    public void updateFileData(DmFileData fileData) {
        this.dmFileDataDao.updateByPrimaryKey(fileData);
    }

    @Override
    public FileDataDTO getFileDataDetail(String dataId) {
        DmFileData dmFileData = this.dmFileDataDao.selectByPrimaryKey(dataId);
        Assert.notNull((Object)dmFileData, (String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff01");
        FileDataDTO fileDataDTO = new FileDataDTO();
        BeanUtils.copyProperties((Object)dmFileData, (Object)fileDataDTO);
        fileDataDTO.setFileModelId(dmFileData.getPackageId());
        fileDataDTO.setFileCatalog(this.getFileDataTree(dataId));
        return fileDataDTO;
    }

    @Override
    public String addFileData(FileDataCreateDTO createDTO) {
        DmFileData dmFileData = new DmFileData();
        BeanUtils.copyProperties((Object)createDTO, (Object)dmFileData);
        dmFileData.setPackageId(createDTO.getFileModelId());
        dmFileData.setRegisterDate(new Date());
        dmFileData.setIsOnServer(Long.valueOf(createDTO.getIsOnServer() != false ? ConstantsValue.TRUE_VALUE.longValue() : ConstantsValue.FALSE_VALUE.longValue()));
        dmFileData.setCatalogFiles(JSONArray.toJSONString((Object)createDTO.getFiles()));
        dmFileData.setDataId(UUID.randomUUID().toString().replace("-", ""));
        this.dmFileDataDao.insert(dmFileData);
        return dmFileData.getDataId();
    }

    @Override
    public void deleteFileData(String dataId) {
        this.dmFileDataDao.deleteByPrimaryKey(dataId);
    }

    @Override
    public void deleteFileDataByDataset(String datumDatasetId) {
        this.dmFileDataDao.deleteByDatumDatasetId(datumDatasetId);
    }

    @Override
    public Boolean fileDataUnitDownloadCheck(String dataId, String fileLocation) {
        DmFileData dmFileData = this.dmFileDataDao.selectByPrimaryKey(dataId);
        Assert.notNull((Object)dmFileData, (String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff01");
        String srcPath = dmFileData.getSrcMainPath();
        IFileStorage fileStorage = this.fileStorageService.openFileStorage(dmFileData.getServerId());
        if (fileStorage == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5b58\u50a8\u8282\u70b9\uff01");
        }
        fileStorage.connect();
        String serviceUrl = "";
        if (dmFileData.getIsOnServer() != null && dmFileData.getIsOnServer().intValue() == ConstantsValue.TRUE_VALUE.intValue()) {
            String serverId = dmFileData.getServerId();
            DataSourceDTO serverDataSource = this.dataSourceManager.getDataSourceDetail(serverId);
            serviceUrl = serverDataSource.getUrl();
            srcPath = fileStorage.combinePaths(serviceUrl, new String[]{dmFileData.getMainPath()});
        }
        if (!fileStorage.fileExist(srcPath)) {
            fileStorage.close();
            throw new RuntimeException("\u6570\u636e\u5305\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5305\u7684\u6e90\u8def\u5f84\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)fileLocation) || "/".equals(fileLocation)) {
            fileLocation = dmFileData.getMainPath();
        }
        String relFileLocation = fileLocation = fileLocation.replace("\\", "/");
        List fileDataUnits = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
        FileDataUnit targetUnit = (FileDataUnit)ListUtil.find((List)fileDataUnits, unit -> unit.getFileLocation().equals(relFileLocation));
        if (targetUnit != null) {
            String targetPath = targetUnit.getFileSourceLocation();
            if (StringUtil.isNotEmpty((String)serviceUrl)) {
                targetPath = fileStorage.combinePaths(serviceUrl, new String[]{relFileLocation});
            }
            if (!fileStorage.fileExist(targetPath)) {
                fileStorage.close();
                throw new RuntimeException("\u76ee\u6807\u6570\u636e\u4e0d\u5b58\u5728\uff01");
            }
            IFileset fileset = fileStorage.getFile(targetPath);
            if (fileset.getIsDirectory() && fileset.listFiles().size() == 0) {
                fileStorage.close();
                throw new RuntimeException("\u76ee\u6807\u6587\u4ef6\u5939\u4e3a\u7a7a\uff01");
            }
        } else {
            int fileCount = 0;
            for (FileDataUnit fileDataUnit : fileDataUnits) {
                String targetPath = fileDataUnit.getFileSourceLocation();
                if (StringUtil.isNotEmpty((String)serviceUrl)) {
                    targetPath = fileStorage.combinePaths(serviceUrl, new String[]{fileDataUnit.getFileLocation()});
                }
                if (!fileStorage.fileExist(targetPath)) continue;
                ++fileCount;
            }
            if (fileCount == 0) {
                fileStorage.close();
                throw new RuntimeException("\u76ee\u6807\u6587\u4ef6\u5939\u4e3a\u7a7a\uff01");
            }
        }
        fileStorage.close();
        return true;
    }

    @Override
    public void downloadFileDataUnit(String dataId, String fileLocation) {
        String packageDir = OutputPathConfig.getOutputPath().toString();
        this.packageFileDataUnitFilesets(dataId, fileLocation, packageDir, true);
    }

    @Override
    public String packageFileDataUnit(String dataId, String fileLocation, String packageDir) {
        IFileset tempDirZip = this.packageFileDataUnit2Fileset(dataId, fileLocation, packageDir);
        return tempDirZip.getFullPath();
    }

    @Override
    public IFileset packageFileDataUnit2Fileset(String dataId, String fileLocation, String packageDir) {
        return this.packageFileDataUnitFilesets(dataId, fileLocation, packageDir, false);
    }

    @Override
    public void viewFileDataUnit(String dataId, String fileLocation, HttpServletRequest request, HttpServletResponse response) {
        DmFileData dmFileData = this.dmFileDataDao.selectByPrimaryKey(dataId);
        Assert.notNull((Object)dmFileData, (String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff01");
        String filePath = "";
        if (StringUtil.isEmptyOrWhiteSpace((String)fileLocation) || "/".equals(fileLocation)) {
            fileLocation = dmFileData.getMainPath();
        }
        String relFileLocation = fileLocation = fileLocation.replace("\\", "/");
        List fileDataUnits = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
        FileDataUnit dataUnit = (FileDataUnit)ListUtil.find((List)fileDataUnits, f -> f.getFileLocation().equals(relFileLocation));
        Assert.notNull((Object)dataUnit, (String)"\u672a\u627e\u5230\u6570\u636e\u5305\uff01");
        String serverId = dmFileData.getServerId();
        IFileStorage fileStorage = this.fileStorageService.openFileStorage(serverId);
        if (fileStorage == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5b58\u50a8\u8282\u70b9\uff01");
        }
        String url = fileStorage.getStorageUrl();
        filePath = dmFileData.getIsOnServer() != null && dmFileData.getIsOnServer().intValue() == ConstantsValue.TRUE_VALUE.intValue() ? fileStorage.combinePaths(url, new String[]{dataUnit.getFileLocation()}) : dataUnit.getFileSourceLocation();
        if (!fileStorage.fileExist(filePath)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        IFileset fileset = fileStorage.getFile(filePath);
        if (fileset.getIsDirectory()) {
            throw new RuntimeException("\u8be5\u8282\u70b9\u4e3a\u6587\u4ef6\u5939\uff01");
        }
        try {
            FileViewerUtil.viewFileStream((InputStream)fileset.openFileStream(), (String)fileset.getName(), (long)fileset.getSize(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IFileset packageFileDataUnitFilesets(String dataId, String fileLocation, String packageDir, boolean download) {
        DmFileData dmFileData = this.dmFileDataDao.selectByPrimaryKey(dataId);
        Assert.notNull((Object)dmFileData, (String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff01");
        if (StringUtil.isEmptyOrWhiteSpace((String)fileLocation) || "/".equals(fileLocation)) {
            fileLocation = dmFileData.getMainPath();
        }
        String relFileLocation = fileLocation = fileLocation.replace("\\", "/");
        List fileDataUnits = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
        FileDataUnit targetUnit = (FileDataUnit)ListUtil.find((List)fileDataUnits, unit -> unit.getFileLocation().equals(relFileLocation));
        if (dmFileData.getMainPath().equals(relFileLocation)) {
            targetUnit = new FileDataUnit();
            targetUnit.setFileLocation(relFileLocation);
            targetUnit.setDataId(dataId);
            targetUnit.setCatalogFileType(CatalogFileTypeEnum.SingleFolder);
            targetUnit.setPackagePath(dmFileData.getDataName());
        }
        Assert.notNull((Object)targetUnit, (String)"\u672a\u627e\u5230\u6570\u636e\u5305\uff01");
        ArrayList downloadPaths = new ArrayList();
        List downloadUnits = ListUtil.findAll((List)fileDataUnits, unit -> unit.getFileLocation().startsWith(relFileLocation));
        if (downloadUnits.size() > 1) {
            downloadUnits.remove(targetUnit);
        }
        String downloadPath = "";
        String serverId = dmFileData.getServerId();
        IFileStorage fileStorage = this.fileStorageService.openFileStorage(serverId);
        if (fileStorage == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u5b58\u50a8\u8282\u70b9\uff01");
        }
        String url = fileStorage.getStorageUrl();
        if (dmFileData.getIsOnServer() != null && dmFileData.getIsOnServer().intValue() == ConstantsValue.TRUE_VALUE.intValue()) {
            downloadUnits.forEach(unit -> {
                String filePath = fileStorage.combinePaths(url, new String[]{unit.getFileLocation()});
                if (fileStorage.fileExist(filePath)) {
                    downloadPaths.add(fileStorage.getFile(filePath));
                    if (unit.getCatalogFileType() == CatalogFileTypeEnum.FolderWithChildren) {
                        downloadPaths.addAll(this.getWholePath(fileStorage.getFile(filePath)));
                    }
                }
            });
            downloadPath = fileStorage.combinePaths(url, new String[]{targetUnit.getFileLocation()});
        } else {
            downloadUnits.forEach(unit -> {
                if (fileStorage.fileExist(unit.getFileSourceLocation())) {
                    downloadPaths.add(fileStorage.getFile(unit.getFileSourceLocation()));
                }
            });
            downloadPath = targetUnit.getFileSourceLocation();
        }
        try {
            switch (targetUnit.getCatalogFileType()) {
                case SingleFile: {
                    if (fileStorage.fileExist(downloadPath)) {
                        IFileset fileset = fileStorage.getFile(downloadPath);
                        if (download) {
                            DownloadUtil.downloadFile((InputStream)fileset.openFileStream(), (long)fileset.getSize(), (String)fileset.getName());
                            return null;
                        }
                        return fileset;
                    }
                    throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                }
                case SingleFolder: {
                    ArrayList<IFileset> srcFile = new ArrayList<IFileset>();
                    for (IFileset fileItem : downloadPaths) {
                        if (srcFile.contains(fileItem)) continue;
                        if (fileItem != null) {
                            srcFile.add(fileItem);
                            continue;
                        }
                        log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u4e0b\u8f7d\uff01");
                    }
                    if (srcFile.size() == 1) {
                        if (download) {
                            DownloadUtil.downloadFile((InputStream)((IFileset)srcFile.get(0)).openFileStream(), (long)((IFileset)srcFile.get(0)).getSize(), (String)((IFileset)srcFile.get(0)).getName());
                            return null;
                        }
                        return (IFileset)srcFile.get(0);
                    }
                    String zipName = FileUtil.getFileName((String)targetUnit.getPackagePath());
                    String tempZipPath = Paths.get(packageDir, zipName + ".zip").toString();
                    File zipFile = new File(tempZipPath);
                    this.onlyZipSrcFileList(srcFile, zipFile, downloadPath, download);
                    DirectoryFileStorage zipFileStorage = new DirectoryFileStorage(tempZipPath, null, null);
                    return zipFileStorage.getFile(tempZipPath);
                }
                case FolderWithChildren: {
                    IFileset dirFileset = fileStorage.getFile(downloadPath);
                    String zipName = FileUtil.getFileName((String)targetUnit.getPackagePath());
                    String zipPathStr = Paths.get(packageDir, zipName + ".zip").toString();
                    File zipFile = new File(zipPathStr);
                    this.zipDir(dirFileset, zipFile, download, true);
                    DirectoryFileStorage zipFileStorage = new DirectoryFileStorage(packageDir, null, null);
                    return zipFileStorage.getFile(zipPathStr);
                }
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u8282\u70b9\u7c7b\u578b\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u6587\u4ef6\u6570\u636e\u6253\u5305\u5931\u8d25\uff01");
        }
    }

    private FileDataUnitDTO completeCatalogFileDTO(FileDataUnitDTO rootUnit, List<FileDataUnit> fileList) {
        String finalDir;
        List files;
        String dirPath = rootUnit.getFileLocation().replace("\\", "/");
        if (dirPath.endsWith("/") && dirPath.length() > 1) {
            dirPath = dirPath.substring(0, dirPath.length() - 1);
        }
        if ((files = ListUtil.findAll(fileList, arg_0 -> FileDataServiceImpl.lambda$completeCatalogFileDTO$6(finalDir = dirPath, arg_0))).size() > 0) {
            for (FileDataUnit item : files) {
                FileDataUnitDTO fileDTO = new FileDataUnitDTO();
                fileDTO.setFileLocation(item.getFileLocation());
                fileDTO.setFileLocation(fileDTO.getFileLocation().replace("\\", "/"));
                fileDTO.setName(FileUtil.getFileName((String)item.getFileLocation()));
                fileDTO.setDataId(rootUnit.getDataId());
                fileDTO.setChildren(new ArrayList());
                switch (item.getCatalogFileType()) {
                    case SingleFolder: 
                    case FolderWithChildren: {
                        fileDTO.setCatalogFileType("\u6587\u4ef6\u5939");
                        fileDTO.setNodeType(Integer.valueOf(FileModelNodeTypeEnum.DataFolder.getValue()));
                        this.completeCatalogFileDTO(fileDTO, fileList);
                        break;
                    }
                    case SingleFile: {
                        String extension = FileUtil.getExtension((String)item.getFileLocation()).toUpperCase(Locale.ROOT);
                        fileDTO.setCatalogFileType(StringUtil.isEmptyOrWhiteSpace((String)extension) ? "\u6587\u4ef6" : extension.substring(1) + "\u6587\u4ef6");
                        fileDTO.setNodeType(Integer.valueOf(FileModelNodeTypeEnum.DataFile.getValue()));
                        BigDecimal bigDecimal = new BigDecimal(item.getDataAmount());
                        fileDTO.setDataAmount(bigDecimal.divide(new BigDecimal(1024), 0) + " kb");
                        break;
                    }
                }
                rootUnit.getChildren().add(fileDTO);
            }
        }
        return rootUnit;
    }

    private List<IFileset> getWholePath(IFileset fileset) {
        ArrayList<IFileset> filePaths = new ArrayList<IFileset>();
        try {
            List subFiles = fileset.listFiles();
            if (subFiles == null || subFiles.size() == 0) {
                return filePaths;
            }
            for (IFileset file : subFiles) {
                filePaths.add(file);
                if (!file.getIsDirectory()) continue;
                filePaths.addAll(this.getWholePath(file));
            }
            return filePaths;
        }
        catch (Exception ex) {
            log.error(fileset.getFullPath() + " \u641c\u7d22\u6587\u4ef6\u5f02\u5e38", (Throwable)ex);
            return filePaths;
        }
    }

    private void onlyZipSrcFileList(List<IFileset> srcFile, File zipFile, String rootDir, boolean download) {
        byte[] buf = new byte[1024];
        InputStream in = null;
        ZipOutputStream out = null;
        try {
            out = this.getOutputStream(zipFile, download);
            for (IFileset file : srcFile) {
                if (file == null) continue;
                String inZipPath = file.getName();
                if (file.getFullPath().contains(rootDir)) {
                    inZipPath = file.getFullPath().substring(rootDir.length());
                    inZipPath = file.getIsDirectory() ? inZipPath + "/" : inZipPath;
                    inZipPath = StringUtil.trimStart((String)inZipPath.replace("\\", "/"), (String)"/");
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                if (!file.getIsDirectory()) {
                    int len;
                    in = file.openFileStream();
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
    }

    private void zipDir(IFileset dirFileset, File zipFile, boolean download, boolean keepDirStructure) {
        byte[] buf = new byte[1024];
        Object in = null;
        ZipOutputStream out = null;
        try {
            out = this.getOutputStream(zipFile, download);
            FileDataServiceImpl.compress(dirFileset, out, dirFileset.getName(), keepDirStructure);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{in, out});
    }

    private ZipOutputStream getOutputStream(File zipFile, boolean download) {
        Object out = null;
        try {
            if (download) {
                String zipFileName = zipFile.getName();
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                HttpServletRequest request = servletRequestAttributes.getRequest();
                HttpServletResponse response = servletRequestAttributes.getResponse();
                response.resetBuffer();
                String userAgent = request.getHeader("User-Agent");
                String[] IE_BROWSERS = new String[]{"MSIE", "Trident", "Edge"};
                zipFileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(zipFileName, "UTF-8") : new String(zipFileName.getBytes("UTF-8"), "ISO-8859-1");
                response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", zipFileName));
                response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
                response.setContentType("application/x-download");
                response.setCharacterEncoding("UTF-8");
                return new ZipOutputStream((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), Charset.forName("GBK"));
            }
            return new ZipOutputStream((OutputStream)new FileOutputStream(zipFile), Charset.forName("GBK"));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    private static void compress(IFileset sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (!sourceFile.getIsDirectory()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            InputStream in = sourceFile.openFileStream();
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            List listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.size() == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (IFileset file : listFiles) {
                    if (keepDirStructure) {
                        FileDataServiceImpl.compress(file, zos, name + "/" + file.getName(), true);
                        continue;
                    }
                    FileDataServiceImpl.compress(file, zos, file.getName(), false);
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$completeCatalogFileDTO$6(String finalDir, FileDataUnit f) {
        return FileUtil.getDirectoryName((String)f.getFileLocation()).replace("\\", "/").equals(finalDir);
    }
}

