/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.datasource.config.HadoopConfig;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.adf.gis.fs.ftp.FTPFileStorage;
import com.geoway.adf.gis.fs.hdfs.HDFSFileStorage;
import com.geoway.adf.gis.fs.obstorage.MinIOFileStorage;
import com.geoway.adf.gis.fs.obstorage.OBSFileStorage;
import com.geoway.adf.gis.fs.obstorage.OSSFileStorage;
import java.util.Map;

public class FileStorageUtil {
    public static IFileStorage openFileStorage(DataSourceDTO dataSourceDTO) {
        DirectoryFileStorage fileStorage;
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
        switch (dataSourceTypeEnum) {
            case ShareFolder: {
                fileStorage = new DirectoryFileStorage(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case HDFS: {
                String url = dataSourceDTO.getUrl();
                Map<String, String> hdfsConfigs = HadoopConfig.getHdfsConfigs(url);
                fileStorage = new HDFSFileStorage(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword(), hdfsConfigs);
                break;
            }
            case FTP: {
                fileStorage = new FTPFileStorage(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case MinIO: {
                RefObject bucketName = new RefObject();
                String endPoint = FileStorageUtil.paraseEndPoint(dataSourceDTO.getUrl(), (RefObject<String>)bucketName);
                fileStorage = new MinIOFileStorage(endPoint, (String)bucketName.get(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case OBS: {
                RefObject bucketName = new RefObject();
                String endPoint = FileStorageUtil.paraseEndPoint(dataSourceDTO.getUrl(), (RefObject<String>)bucketName);
                fileStorage = new OBSFileStorage(endPoint, (String)bucketName.get(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case OSS: {
                RefObject bucketName = new RefObject();
                String endPoint = FileStorageUtil.paraseEndPoint(dataSourceDTO.getUrl(), (RefObject<String>)bucketName);
                fileStorage = new OSSFileStorage(endPoint, (String)bucketName.get(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
            }
        }
        fileStorage.connect();
        return fileStorage;
    }

    private static String paraseEndPoint(String url, RefObject<String> bucketName) {
        int index = url.lastIndexOf("/");
        if (index > 0) {
            String endPoint = url.substring(0, index);
            bucketName.set((Object)url.substring(index + 1));
            return endPoint;
        }
        throw new IllegalArgumentException("\u5730\u5740\u4e0d\u6b63\u786e\uff1a" + url);
    }
}

