/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.spi.MySqlWallProvider;
import com.alibaba.druid.wall.spi.OracleWallProvider;
import com.alibaba.druid.wall.spi.PGWallProvider;
import com.alibaba.druid.wall.spi.SQLServerWallProvider;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import java.sql.SQLException;

public class GeoTableQueryCheckUtil {
    public static void checkTableQuerySql(DataSourceTypeEnum dataSourceType, String sql) throws SQLException {
        WallProvider provider = GeoTableQueryCheckUtil.getWallProvider(dataSourceType);
        if (provider == null) {
            return;
        }
        WallCheckResult result = provider.check(sql);
        if (!result.getViolations().isEmpty()) {
            Violation violation = (Violation)result.getViolations().get(0);
            throw new SQLException(violation.getMessage(), violation.toString(), violation.getErrorCode());
        }
    }

    public static void checkTableSingleQuery(DataSourceTypeEnum dataSourceType, QueryFilterBasicDTO filter) throws SQLException {
        WallProvider provider = GeoTableQueryCheckUtil.getWallProvider(dataSourceType);
        if (provider == null) {
            return;
        }
        if (filter == null) {
            return;
        }
        String sql = "select " + (StringUtil.isEmptyOrWhiteSpace((String)filter.getFields()) ? "*" : filter.getFields()) + " from tableName ";
        if (StringUtil.isNotEmpty((String)filter.getCondition())) {
            sql = sql + " where " + filter.getCondition();
        }
        if (StringUtil.isNotEmpty((String)filter.getOrderBy())) {
            sql = sql + " order by " + filter.getOrderBy();
        }
        provider.getConfig().setMinusAllow(false);
        provider.getConfig().setIntersectAllow(false);
        WallCheckResult result = provider.check(sql);
        if (result.getViolations().isEmpty()) {
            if (result.getStatementList().size() > 1) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u7684\u67e5\u8be2\u8bed\u53e5");
            }
            SQLStatement statement = (SQLStatement)result.getStatementList().get(0);
            if (!(statement instanceof SQLSelectStatement)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u7684\u67e5\u8be2\u8bed\u53e5");
            }
            SQLSelectStatement selectStatement = (SQLSelectStatement)statement;
            SQLSelectQuery sqlSelectQuery = selectStatement.getSelect().getQuery();
            if (!(sqlSelectQuery instanceof SQLSelectQueryBlock)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u7684\u67e5\u8be2\u8bed\u53e5");
            }
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
            SQLTableSource from = queryBlock.getFrom();
            if (!(from instanceof SQLExprTableSource)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u7684\u67e5\u8be2\u8bed\u53e5");
            }
        } else {
            Violation violation = (Violation)result.getViolations().get(0);
            throw new SQLException(violation.getMessage(), violation.toString(), violation.getErrorCode());
        }
    }

    private static WallProvider getWallProvider(DataSourceTypeEnum dataSourceType) {
        WallConfig wallConfig = new WallConfig();
        wallConfig.setSelectIntoAllow(false);
        wallConfig.setDeleteAllow(false);
        wallConfig.setUpdateAllow(false);
        wallConfig.setInsertAllow(false);
        wallConfig.setReplaceAllow(false);
        wallConfig.setMergeAllow(false);
        wallConfig.setCallAllow(false);
        wallConfig.setSetAllow(false);
        wallConfig.setTruncateAllow(false);
        wallConfig.setCreateTableAllow(false);
        wallConfig.setAlterTableAllow(false);
        wallConfig.setDropTableAllow(false);
        wallConfig.setCommitAllow(false);
        wallConfig.setRollbackAllow(false);
        wallConfig.setMultiStatementAllow(false);
        wallConfig.setSelectWhereAlwayTrueCheck(false);
        wallConfig.setSelectHavingAlwayTrueCheck(false);
        wallConfig.setConditionAndAlwayTrueAllow(true);
        wallConfig.setConditionAndAlwayFalseAllow(true);
        wallConfig.setConditionDoubleConstAllow(true);
        wallConfig.setConstArithmeticAllow(true);
        OracleWallProvider provider = null;
        switch (dataSourceType) {
            case OracleSpatial: {
                provider = new OracleWallProvider(wallConfig);
                break;
            }
            case PostgreSql: 
            case KingBase: 
            case Highgo: 
            case HighgoSecurity: 
            case OpenGauss: {
                provider = new PGWallProvider(wallConfig);
                break;
            }
            case SqlServer: {
                provider = new SQLServerWallProvider(wallConfig);
                break;
            }
            case MySql: {
                provider = new MySqlWallProvider(wallConfig);
                break;
            }
        }
        return provider;
    }
}

