/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.util.FileStorageUtil;
import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.obstorage.OSSFileStorage;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.JdbcWorkspaceFactory;
import com.geoway.adf.gis.geodb.excel.ExcelWorkspaceFactory;
import com.geoway.adf.gis.geodb.ogr.OgrWorkspaceFactory;
import com.geoway.adf.gis.geodb.oracle.OracleWorkspaceFactory;
import com.geoway.adf.gis.geodb.postgresql.HighgoWorkspaceFactory;
import com.geoway.adf.gis.geodb.postgresql.KingbaseWorkspaceFactory;
import com.geoway.adf.gis.geodb.postgresql.PgWorkspaceFactory;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.adf.gis.raster.info.RasterStorageInfo;
import java.net.URL;

public class GeoDatabaseUtil {
    public static IFeatureWorkspace openGeoDatabase(DataSourceDTO databaseDTO) {
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(databaseDTO.getDataSourceType());
        PgWorkspaceFactory workspaceFactory = null;
        switch (dataSourceTypeEnum) {
            case PostgreSql: 
            case Highgo: 
            case OpenGauss: {
                workspaceFactory = new PgWorkspaceFactory();
                break;
            }
            case KingBase: {
                String version = EnvironmentConfig.getProperty((String)"project.kingbase");
                if ("v8r3".equalsIgnoreCase(version)) {
                    workspaceFactory = new KingbaseWorkspaceFactory();
                    break;
                }
                workspaceFactory = new PgWorkspaceFactory();
                break;
            }
            case HighgoSecurity: {
                workspaceFactory = new HighgoWorkspaceFactory();
                break;
            }
            case OracleSpatial: {
                workspaceFactory = new OracleWorkspaceFactory();
                break;
            }
            case MongoDB: {
                break;
            }
        }
        if (workspaceFactory != null) {
            if (workspaceFactory instanceof JdbcWorkspaceFactory) {
                int max_active = EnvironmentConfig.getInteger((String)"spring.datasource.druid.max-active", (Integer)200);
                JdbcWorkspaceFactory jdbcWorkspaceFactory = (JdbcWorkspaceFactory)workspaceFactory;
                jdbcWorkspaceFactory.setPoolMaxActive(Integer.valueOf(max_active));
            }
            IFeatureWorkspace workspace = workspaceFactory.openWorkspace(databaseDTO.getUrl(), databaseDTO.getUserName(), databaseDTO.getPassword(), null);
            return workspace;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
    }

    public static IFeatureWorkspace openFileGeoDatabase(DataSourceDTO databaseDTO, String filePath) {
        if (databaseDTO == null) {
            return WorkspaceUtil.openLocalFileGeodatabase((String)filePath);
        }
        if (UploadPathConfig.isUploadPath((String)filePath)) {
            filePath = UploadPathConfig.getFileFullPath((String)filePath);
        }
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(databaseDTO.getDataSourceType());
        switch (dataSourceTypeEnum) {
            case ShareFolder: {
                return WorkspaceUtil.openLocalFileGeodatabase((String)filePath);
            }
            case MinIO: 
            case OBS: 
            case OSS: 
            case S3: {
                String ext = FileUtil.getExtension((String)StringUtil.trim((String)filePath, (String)"/")).toLowerCase();
                IFeatureWorkspace iWorkspace = null;
                if (!ext.equals(".mdb")) {
                    if (ext.equals(".xls") || ext.equals(".xlsx") || ext.equals(".csv")) {
                        IFileStorage fileStorage = FileStorageUtil.openFileStorage(databaseDTO);
                        fileStorage.connect();
                        iWorkspace = new ExcelWorkspaceFactory().openWorkspace(filePath, fileStorage, null);
                    } else {
                        String vsiPath = GeoDatabaseUtil.vsiPath(filePath, databaseDTO);
                        iWorkspace = new OgrWorkspaceFactory().openWorkspace(vsiPath, databaseDTO.getUserName(), databaseDTO.getPassword(), null);
                    }
                }
                if (iWorkspace == null) {
                    throw new RuntimeException("\u6587\u4ef6 [" + filePath + "] \u6253\u5f00\u5931\u8d25! ");
                }
                return iWorkspace;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
    }

    public static IFeatureWorkspace openFileGeoDatabase(IFileStorage fileStorage, String filePath) {
        String type;
        if (UploadPathConfig.isUploadPath((String)filePath)) {
            filePath = UploadPathConfig.getFileFullPath((String)filePath);
        }
        if ((type = fileStorage.getType()).equals("standard")) {
            return WorkspaceUtil.openLocalFileGeodatabase((String)filePath);
        }
        if (type.equals("object storage")) {
            String ext = FileUtil.getExtension((String)StringUtil.trim((String)filePath, (String)"/")).toLowerCase();
            IFeatureWorkspace iWorkspace = null;
            if (!ext.equals(".mdb")) {
                if (ext.equals(".xls") || ext.equals(".xlsx") || ext.equals(".csv")) {
                    iWorkspace = new ExcelWorkspaceFactory().openWorkspace(filePath, fileStorage, null);
                } else {
                    String vsiPath = fileStorage instanceof OSSFileStorage ? GeoDatabaseUtil.vsiOSSPath(filePath, fileStorage.getUserName(), fileStorage.getPassword()) : GeoDatabaseUtil.vsiS3Path(filePath, fileStorage.getUserName(), fileStorage.getPassword());
                    iWorkspace = new OgrWorkspaceFactory().openWorkspace(vsiPath, fileStorage.getUserName(), fileStorage.getPassword(), null);
                }
            }
            if (iWorkspace == null) {
                throw new RuntimeException("\u6587\u4ef6 [" + filePath + "] \u6253\u5f00\u5931\u8d25! ");
            }
            return iWorkspace;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b\uff1a" + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRasterDataset openRasterDataset(DataSourceDTO databaseDTO, String filePath) {
        if (UploadPathConfig.isUploadPath((String)filePath)) {
            filePath = UploadPathConfig.getFileFullPath((String)filePath);
        }
        if (databaseDTO == null) {
            String rasterFolder = FileUtil.getDirectoryName((String)filePath);
            RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFolder);
            return rasterWorkspace.openRasterDataset(filePath);
        }
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(databaseDTO.getDataSourceType());
        switch (dataSourceTypeEnum) {
            case ShareFolder: {
                String rasterFolder = FileUtil.getDirectoryName((String)filePath);
                RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFolder);
                return rasterWorkspace.openRasterDataset(filePath);
            }
            case MinIO: 
            case OBS: 
            case OSS: 
            case S3: {
                String vsiPath;
                IRasterDataset rasterDataset;
                RasterFileWorkspace tmpRasterWorkspace = new RasterFileWorkspace("");
                if (filePath.endsWith("/")) {
                    try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(databaseDTO);){
                        if (fileStorage.fileExist(filePath + "hdr.adf")) {
                            filePath = filePath + "hdr.adf";
                        }
                    }
                }
                if ((rasterDataset = tmpRasterWorkspace.openRasterDataset(vsiPath = GeoDatabaseUtil.vsiPath(filePath, databaseDTO))) == null) {
                    throw new RuntimeException("\u6587\u4ef6 [" + filePath + "] \u6253\u5f00\u5931\u8d25! ");
                }
                RasterInfo rasterInfo = rasterDataset.getRasterInfo();
                rasterInfo.setRasterPath(filePath);
                RasterStorageInfo storageInfo = new RasterStorageInfo();
                storageInfo.setType(dataSourceTypeEnum.name());
                storageInfo.setUrl(databaseDTO.getUrl());
                storageInfo.setUserName(databaseDTO.getUserName());
                storageInfo.setPassword(databaseDTO.getPassword());
                rasterInfo.setStorageInfo(storageInfo);
                return rasterDataset;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
    }

    public static String vsiPath(String filePath, DataSourceDTO databaseDTO) {
        if (databaseDTO.getDataSourceType().intValue() == DataSourceTypeEnum.OSS.getValue()) {
            return GeoDatabaseUtil.vsiOSSPath(filePath, databaseDTO.getUserName(), databaseDTO.getPassword());
        }
        return GeoDatabaseUtil.vsiS3Path(filePath, databaseDTO.getUserName(), databaseDTO.getPassword());
    }

    public static String vsiS3Path(String filePath, String userName, String password) {
        try {
            URL uri = new URL(filePath);
            String protocol = uri.getProtocol();
            String authority = uri.getAuthority();
            String file = uri.getFile();
            String vsiPath = "/vsis3" + file;
            gdalFunc.setThreadLocalConfigOption((String)"AWS_VIRTUAL_HOSTING", (String)"FALSE");
            gdalFunc.setThreadLocalConfigOption((String)"AWS_REGION", (String)"aws-cn-global");
            gdalFunc.setThreadLocalConfigOption((String)"AWS_HTTPS", (String)("https".equals(protocol) ? "YES" : "NO"));
            gdalFunc.setThreadLocalConfigOption((String)"AWS_S3_ENDPOINT", (String)authority);
            gdalFunc.setThreadLocalConfigOption((String)"AWS_ACCESS_KEY_ID", (String)userName);
            gdalFunc.setThreadLocalConfigOption((String)"AWS_SECRET_ACCESS_KEY", (String)password);
            gdalFunc.setThreadLocalConfigOption((String)"SHAPE_RESTORE_SHX", (String)"NO");
            return vsiPath;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6570\u636e\u8def\u5f84\u4e0d\u6b63\u786e\uff1a" + filePath);
        }
    }

    public static String vsiOSSPath(String filePath, String userName, String password) {
        try {
            URL uri = new URL(filePath);
            String protocol = uri.getProtocol();
            String authority = uri.getAuthority();
            String file = uri.getFile();
            String vsiPath = "/vsioss" + file;
            gdalFunc.setThreadLocalConfigOption((String)"OSS_ENDPOINT", (String)authority);
            gdalFunc.setThreadLocalConfigOption((String)"OSS_ACCESS_KEY_ID", (String)userName);
            gdalFunc.setThreadLocalConfigOption((String)"OSS_SECRET_ACCESS_KEY", (String)password);
            return vsiPath;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6570\u636e\u8def\u5f84\u4e0d\u6b63\u786e\uff1a" + filePath);
        }
    }
}

