/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.FeatureClassUtil;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.dto.input.ExcuteStatus;
import com.geoway.adf.dms.datasource.dto.input.InputDataResultDTO;
import com.geoway.adf.dms.datasource.dto.input.InputResultDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.IMEServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.service.DataInputService;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.SelectFileDataUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.PixelDataType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DataInputServiceImpl
implements DataInputService {
    private static final Logger log = LoggerFactory.getLogger(DataInputServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static Map<String, InputResultDTO> runningTasks = new ConcurrentHashMap<String, InputResultDTO>();

    @Override
    public List<InputDataResultDTO> uploadDataInput(MultipartFile file, Integer srid, Boolean create, Boolean publishService) {
        return this.uploadDataInput(file, srid, create, publishService, null);
    }

    @Override
    public List<InputDataResultDTO> uploadDataInput(MultipartFile file, Integer srid, Boolean create, Boolean publishService, String dsKey) {
        String id = UUID.randomUUID().toString();
        String localPath = this.saveUploadFile(file, id);
        InputResultDTO inputResultDTO = new InputResultDTO();
        inputResultDTO.setStatus(ExcuteStatus.NotStarted);
        inputResultDTO.setDataResult(new ArrayList<InputDataResultDTO>());
        this.inputFiles(inputResultDTO, localPath, srid, create, publishService, dsKey);
        return inputResultDTO.getDataResult();
    }

    @Override
    public String uploadDataInputAsync(MultipartFile file, Integer srid, Boolean create, Boolean publishService) {
        return this.uploadDataInputAsync(file, srid, create, publishService, null);
    }

    @Override
    public String uploadDataInputAsync(MultipartFile file, Integer srid, Boolean create, Boolean publishService, String dsKey) {
        String id = UUID.randomUUID().toString();
        String localPath = this.saveUploadFile(file, id);
        InputResultDTO inputResultDTO = new InputResultDTO();
        inputResultDTO.setStatus(ExcuteStatus.NotStarted);
        inputResultDTO.setDataResult(new ArrayList<InputDataResultDTO>());
        this.threadPoolTaskExecutorData.execute(() -> this.inputFiles(inputResultDTO, localPath, srid, create, publishService, dsKey));
        runningTasks.put(id, inputResultDTO);
        return id;
    }

    @Override
    public InputResultDTO getDataInputResult(String id) {
        if (runningTasks.containsKey(id)) {
            return runningTasks.get(id);
        }
        throw new RuntimeException("\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5bfc\u5165\u4efb\u52a1");
    }

    private String saveUploadFile(MultipartFile file, String id) {
        Path localPath = UploadPathConfig.getUploadPath().resolve(id);
        try {
            localPath.toFile().mkdirs();
            String fileName = file.getOriginalFilename();
            File localFile = localPath.resolve(fileName).toFile();
            file.transferTo(localFile);
            if (!localFile.isDirectory() && fileName.toLowerCase().endsWith(".zip")) {
                localPath = Paths.get(localPath.toString(), FileUtil.getFileNameWithoutExtension((String)fileName));
                ZipAndRarUtil.unZipFiles((File)localFile, (String)(localPath + File.separator));
            }
            return localPath.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputFiles(InputResultDTO inputResultDTO, String localPath, Integer srid, Boolean create, Boolean publishService, String dsKey) {
        try (IFeatureWorkspace targetWorkspace = null;){
            inputResultDTO.setStatus(ExcuteStatus.Running);
            DataSourceDTO databaseDTO = StringUtil.isEmptyOrWhiteSpace((String)dsKey) ? this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.GeoDatabase.getValue(), null) : this.dataSourceService.getDataSourceDetail(dsKey);
            if (databaseDTO == null) {
                throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7a7a\u95f4\u6570\u636e\u5e93");
            }
            targetWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
            List<FileDataTypeEnum> filterTypes = Arrays.asList(FileDataTypeEnum.FileGDB, FileDataTypeEnum.MDB, FileDataTypeEnum.GeoPackage, FileDataTypeEnum.GeoJSON, FileDataTypeEnum.KML, FileDataTypeEnum.GML, FileDataTypeEnum.Shapefile, FileDataTypeEnum.Excel, FileDataTypeEnum.Csv, FileDataTypeEnum.Dbf, FileDataTypeEnum.RasterTifFile, FileDataTypeEnum.RasterImgFile, FileDataTypeEnum.RasterGridFile);
            DirectoryFileStorage fileStorage = new DirectoryFileStorage(localPath, null, null);
            List<SelectFileDataDTO> fileDataList = SelectFileDataUtil.getDataFromFolderRecursion((IFileStorage)fileStorage, localPath, filterTypes, null);
            fileStorage.close();
            block9: for (SelectFileDataDTO fileDataDTO : fileDataList) {
                FileDataTypeEnum fileDataType = FileDataTypeEnum.getByValue(fileDataDTO.getType());
                switch (fileDataType) {
                    case GeoPackage: 
                    case FileGDB: 
                    case MDB: 
                    case KML: 
                    case Shapefile: 
                    case GeoJSON: 
                    case GML: 
                    case FeatureClass: 
                    case PointFeatureClass: 
                    case LineFeatureClass: 
                    case PolygonFeatureClass: 
                    case Excel: 
                    case Csv: 
                    case Dbf: {
                        this.inputVectorFile(inputResultDTO, targetWorkspace, databaseDTO, fileDataDTO.getFullPath(), srid, create, publishService);
                        continue block9;
                    }
                    case RasterTifFile: 
                    case RasterImgFile: 
                    case RasterGridFile: {
                        this.inputRasterFile(inputResultDTO, targetWorkspace, databaseDTO, fileDataDTO.getFullPath(), srid, create, publishService);
                        continue block9;
                    }
                }
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + (Object)((Object)fileDataType));
            }
            inputResultDTO.setStatus(ExcuteStatus.Successed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputVectorFile(InputResultDTO inputResultDTO, IFeatureWorkspace targetWorkspace, DataSourceDTO databaseDTO, String filePath, Integer srid, Boolean create, Boolean publishService) {
        try (IFeatureWorkspace srcWorkspace = null;){
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)filePath);
            List srcGeoDatasets = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass, GeoDatasetType.Table});
            ArrayList<InputDataResultDTO> dataResultDTOS = new ArrayList<InputDataResultDTO>();
            for (IGeoDataset srcGeoDataset : srcGeoDatasets) {
                String srcName = FileUtil.getFileName((String)filePath) + "/" + srcGeoDataset.getName();
                InputDataResultDTO dataResult = new InputDataResultDTO();
                dataResult.setStatus(ExcuteStatus.NotStarted);
                dataResult.setSrcName(srcName);
                inputResultDTO.getDataResult().add(dataResult);
                dataResultDTOS.add(dataResult);
            }
            for (int i = 0; i < srcGeoDatasets.size(); ++i) {
                IGeoDataset srcGeoDataset;
                srcGeoDataset = (IGeoDataset)srcGeoDatasets.get(i);
                InputDataResultDTO dataResult = (InputDataResultDTO)dataResultDTOS.get(i);
                dataResult.setStatus(ExcuteStatus.Running);
                try {
                    IGeoDataset targetGeoDataset = this.createGeoDataset(dataResult, srcGeoDataset, targetWorkspace, srid, create);
                    if (targetGeoDataset == null) {
                        dataResult.setStatus(ExcuteStatus.Failed);
                        continue;
                    }
                    boolean inputSuccess = this.inputVector(dataResult, srcGeoDataset, targetGeoDataset);
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(databaseDTO, targetGeoDataset);
                    dataResult.setTargetDataset(datasetDTO);
                    if (srcGeoDataset.getType() != GeoDatasetType.FeatureClass || !Boolean.TRUE.equals(publishService)) continue;
                    IFeatureClass targetFc = (IFeatureClass)targetGeoDataset;
                    if (!inputSuccess) continue;
                    FeatureClassDTO featureClassDTO = (FeatureClassDTO)datasetDTO;
                    if (dataResult.getSuccessCount() <= 0L) continue;
                    DatasetRenderDTO renderDTO = this.publishVectorService(dataResult, datasetDTO);
                    if (renderDTO != null) {
                        featureClassDTO.setHasRender(true);
                        featureClassDTO.setRender(renderDTO);
                        continue;
                    }
                    featureClassDTO.setHasRender(false);
                    continue;
                }
                catch (Exception ex) {
                    log.error(dataResult.getSrcName() + "\u5bfc\u5165\u5931\u8d25", (Throwable)ex);
                    dataResult.setStatus(ExcuteStatus.Failed);
                    dataResult.setMessage(dataResult.getSrcName() + "\u5bfc\u5165\u5931\u8d25");
                }
            }
        }
    }

    private IGeoDataset createGeoDataset(InputDataResultDTO resultDTO, IGeoDataset srcGeoDataset, IFeatureWorkspace targetWorkspace, int srid, boolean createNew) {
        try {
            String name = srcGeoDataset.getName();
            IGeoDataset targetGeoDataset = GeoDatasetUtil.openDataset(targetWorkspace, srcGeoDataset.getType(), name);
            if (targetGeoDataset != null && createNew) {
                int index = 1;
                String newName = name;
                while (targetWorkspace.datasetExist(newName)) {
                    newName = name + "_" + index;
                    ++index;
                }
                name = newName;
            }
            if (createNew || targetGeoDataset == null) {
                if (srcGeoDataset.getType() == GeoDatasetType.FeatureClass) {
                    IFeatureClass srcFeatureClass = (IFeatureClass)srcGeoDataset;
                    ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
                    if (spatialReferenceSystem == null) {
                        spatialReferenceSystem = srcFeatureClass.getSpatialReferenceSystem();
                    }
                    targetGeoDataset = FeatureClassUtil.createFeatureClass((IFeatureClass)srcFeatureClass, (IFeatureWorkspace)targetWorkspace, (String)name, (ISpatialReferenceSystem)spatialReferenceSystem);
                } else {
                    ITable srcTable = (ITable)srcGeoDataset;
                    targetGeoDataset = FeatureClassUtil.createTable((ITable)srcTable, (IFeatureWorkspace)targetWorkspace, (String)name, null, (String)srcTable.getOidFieldName());
                }
            }
            return targetGeoDataset;
        }
        catch (Exception e) {
            resultDTO.setMessage("\u76ee\u6807\u56fe\u5c42\u521b\u5efa\u5931\u8d25," + e.getMessage());
            log.error("\u76ee\u6807\u56fe\u5c42\u521b\u5efa\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private boolean inputVector(InputDataResultDTO resultDTO, IGeoDataset srcGeoData, IGeoDataset targetGeoData) {
        TransferResult result;
        Date startTime = new Date();
        VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
        vectorDataTransfer.setIsErrorContinue(true);
        vectorDataTransfer.setProgressCallback((sCount, eCount) -> {
            resultDTO.setSuccessCount((Long)sCount);
            resultDTO.setErrorCount((Long)eCount);
        });
        vectorDataTransfer.setCountCallback(iCount -> resultDTO.setTotalCount((Long)iCount));
        vectorDataTransfer.setErrorCallback(msg -> {
            log.error(msg);
            resultDTO.setMessage((String)msg);
        });
        if (targetGeoData.getType() == GeoDatasetType.FeatureClass) {
            result = vectorDataTransfer.copyFeature((IFeatureClass)srcGeoData, (IFeatureClass)targetGeoData, null);
        } else if (targetGeoData.getType() == GeoDatasetType.Table) {
            result = vectorDataTransfer.copyTable((ITable)srcGeoData, (ITable)targetGeoData, null);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + targetGeoData.getType());
        }
        log.info(String.format("%s\u5bfc\u5165%s,\uff0c\u5171%d\u4e2a\uff0c\u6210\u529f%d\u4e2a\uff0c\u7528\u65f6%s", resultDTO.getSrcName(), result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)new Date())));
        resultDTO.setStatus(result.isSuccess() ? ExcuteStatus.Successed : ExcuteStatus.Failed);
        return result.isSuccess();
    }

    private DatasetRenderDTO publishVectorService(InputDataResultDTO resultDTO, DatasetDTO datasetDTO) {
        try {
            String serviceName;
            if (datasetDTO.getRender() != null && Boolean.TRUE.equals(datasetDTO.getRender().getIsCreate())) {
                serviceName = datasetDTO.getRender().getServiceName();
            } else {
                serviceName = PinyinUtil.convertToPinYin((String)datasetDTO.getName());
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
            }
            String datasetId = datasetDTO.getId();
            DatasetRenderDTO renderDTO = null;
            if (datasetDTO.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue()) {
                VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
                serviceCreateDTO.setServiceName(serviceName);
                serviceCreateDTO.setDatasetId(datasetId);
                renderDTO = this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            } else if (datasetDTO.getType().intValue() == DatasetTypeEnum.ModelDataset.getValue()) {
                IMEServiceCreateDTO serviceCreateDTO = new IMEServiceCreateDTO();
                serviceCreateDTO.setServiceName(serviceName);
                serviceCreateDTO.setDatasetId(datasetId);
                renderDTO = this.renderIndexService.createRasterRenderIndex(serviceCreateDTO);
            }
            return renderDTO;
        }
        catch (Exception e) {
            log.error("\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)e);
            resultDTO.setMessage("\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff0c" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputRasterFile(InputResultDTO inputResultDTO, IFeatureWorkspace targetWorkspace, DataSourceDTO databaseDTO, String rasterFile, Integer srid, Boolean create, Boolean publishService) {
        InputDataResultDTO dataResult = new InputDataResultDTO();
        dataResult.setStatus(ExcuteStatus.Running);
        dataResult.setSrcName(rasterFile);
        dataResult.setTotalCount(1L);
        inputResultDTO.getDataResult().add(dataResult);
        try {
            IMosaicDataset targetMosaicDataset;
            String name = FileUtil.getFileNameWithoutExtension((String)rasterFile);
            if (name.length() > 30) {
                name = name.substring(0, 30);
            }
            if ((targetMosaicDataset = targetWorkspace.openMosaicDataset(name)) != null && create.booleanValue() && create.booleanValue()) {
                int index = 1;
                String newName = name;
                while (targetWorkspace.datasetExist(newName)) {
                    newName = name + "_" + index;
                    ++index;
                }
                name = newName;
                targetMosaicDataset = null;
            }
            if (targetMosaicDataset == null) {
                ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
                targetMosaicDataset = targetWorkspace.createMosaicDataset(name, null, spatialReferenceSystem, -1, PixelDataType.Unknown);
            }
            if (targetMosaicDataset == null) {
                dataResult.setStatus(ExcuteStatus.Failed);
                dataResult.setMessage("\u6570\u636e\u96c6" + name + "\u521b\u5efa\u5931\u8d25");
                return;
            }
            IRasterDataset rasterDataset = null;
            try {
                RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFile);
                rasterDataset = rasterWorkspace.openRasterDataset(rasterFile);
                boolean isValid = targetMosaicDataset.addRaster(rasterDataset, true);
                if (!isValid) {
                    dataResult.setStatus(ExcuteStatus.Failed);
                    dataResult.setErrorCount(1L);
                    dataResult.setMessage(rasterFile + "\u5199\u5165\u6805\u683c\u6570\u636e\u5931\u8d25");
                    return;
                }
                targetMosaicDataset.updateRasterStorageInfo(rasterDataset.getRasterInfo().getStorageInfo());
                targetMosaicDataset.updateExtent();
                targetMosaicDataset.calculateCellSizeRanges();
                DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(databaseDTO, (IGeoDataset)targetMosaicDataset);
                dataResult.setTargetDataset(datasetDTO);
                if (Boolean.TRUE.equals(publishService)) {
                    MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)datasetDTO;
                    DatasetRenderDTO renderDTO = this.publishVectorService(dataResult, datasetDTO);
                    if (renderDTO != null) {
                        mosaicDatasetDTO.setHasRender(true);
                        mosaicDatasetDTO.setRender(renderDTO);
                    } else {
                        mosaicDatasetDTO.setHasRender(false);
                    }
                }
                dataResult.setSuccessCount(1L);
                dataResult.setStatus(ExcuteStatus.Successed);
            }
            finally {
                if (rasterDataset != null) {
                    rasterDataset.closeRaster();
                }
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff1a" + rasterFile, (Throwable)e);
            dataResult.setStatus(ExcuteStatus.Failed);
            dataResult.setErrorCount(1L);
            dataResult.setMessage(e.getMessage());
        }
    }
}

