/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.unit.DataSizeUtil;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.config.FileStorageProperties;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.RasterDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.FileDetailDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePermissionDTO;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.dto.file.VectorLayerDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.FileStorageUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.SelectFileDataUtil;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.mbtiles.MBTilesTileDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.multipart.MultipartFile;

@Service
@EnableConfigurationProperties(value={FileStorageProperties.class})
public class FileStorageServiceImpl
implements FileStorageService {
    private static final Logger log = LoggerFactory.getLogger(FileStorageServiceImpl.class);
    @Resource
    private FileStorageProperties fileStorageProperties;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private SysLogService sysLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            boolean bl = fileStorage.connect();
            return bl;
        }
    }

    @Override
    public List<DataSourceDTO> listFileStorage(List<DataSourceTypeEnum> dataSourceTypes, String keyword) {
        ArrayList<DataSourceDTO> dataSourceDTOList = new ArrayList<DataSourceDTO>();
        if (Boolean.TRUE.equals(this.fileStorageProperties.getShowLocalDisk())) {
            File[] files;
            for (File file : files = File.listRoots()) {
                DataSourceDTO localDataSource = this.dataSourceManager.buildLocalFileDataSource(file);
                dataSourceDTOList.add(localDataSource);
            }
        }
        dataSourceDTOList.addAll(this.dataSourceManager.listDataSource(Arrays.asList(DataStoreTypeEnum.FileStorageSystem), dataSourceTypes, keyword));
        return dataSourceDTOList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileDTO> listFile(String key, String serverPath) {
        try (IFileStorage fileStorage = this.openFileStorage(key);){
            List filesetList = fileStorage.listFile(serverPath, false);
            filesetList.sort((f1, f2) -> {
                int result = Integer.compare(f2.getIsDirectory() ? 1 : 0, f1.getIsDirectory() ? 1 : 0);
                if (result == 0) {
                    result = f1.getFullPath().compareTo(f2.getFullPath());
                }
                return result;
            });
            List list = ListUtil.convertAll((List)filesetList, f -> {
                FileDTO fileDTO = new FileDTO();
                this.toFileDTO(fileDTO, (IFileset)f);
                return fileDTO;
            });
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDetailDTO getFileDetail(String key, String path) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            IFileset fileset = fileStorage.getFile(path);
            if (fileset == null) {
                throw new RuntimeException(path + " \u4e0d\u5b58\u5728");
            }
            FileDetailDTO fileDetailDTO = new FileDetailDTO();
            this.toFileDTO(fileDetailDTO, fileset);
            fileDetailDTO.setOwner(fileset.getOwnerName());
            fileDetailDTO.setSize(fileset.getSize());
            if (!fileset.getIsDirectory()) {
                fileDetailDTO.setSizeStr(DataSizeUtil.format((long)fileset.getSize()));
            }
            this.dataSourceManager.clearDataSourcePassword(dataSourceDTO);
            fileDetailDTO.setDataSource(dataSourceDTO);
            fileDetailDTO.setResourceId(String.format("Atlas://\u6570\u636e\u8d44\u6e90/%s/%s", dataSourceDTO.getName(), fileset.getRelativePath().replace("\\", "/")));
            FileDetailDTO fileDetailDTO2 = fileDetailDTO;
            return fileDetailDTO2;
        }
    }

    private void toFileDTO(FileDTO fileDTO, IFileset file) {
        fileDTO.setName(file.getName());
        fileDTO.setExt(file.getExt());
        fileDTO.setFullPath(file.getFullPath());
        fileDTO.setRelativePath(file.getRelativePath());
        fileDTO.setIsDirectory(file.getIsDirectory());
        fileDTO.setModifyTime(file.getModifyTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilePermissionDTO getFilePermission(String key, String path) {
        try (IFileStorage fileStorage = this.openFileStorage(key);){
            IFileset fileset = fileStorage.getFile(path);
            if (fileset == null) {
                throw new RuntimeException(path + " \u4e0d\u5b58\u5728");
            }
            FilePermissionDTO filePermissionDTO = new FilePermissionDTO();
            filePermissionDTO.setCanExecute(fileset.canExecute());
            filePermissionDTO.setCanRead(fileset.canRead());
            filePermissionDTO.setCanWrite(fileset.canWrite());
            FilePermissionDTO filePermissionDTO2 = filePermissionDTO;
            return filePermissionDTO2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(String key, String path, boolean recursive) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            boolean result;
            IFileset fileset = fileStorage.getFile(path);
            if (fileset == null) {
                throw new RuntimeException(path + " \u4e0d\u5b58\u5728");
            }
            if (fileset.getIsDirectory()) {
                if (!recursive && fileStorage.listFile(fileset.getFullPath(), false).size() > 0) {
                    throw new RuntimeException("\u975e\u7a7a\u6587\u4ef6\u5939\u4e0d\u5141\u8bb8\u5220\u9664");
                }
            } else {
                recursive = false;
            }
            if (result = recursive ? this.deleteFileRecursive(fileStorage, fileset) : fileStorage.deleteFile(path)) {
                this.sysLogService.addLog(150, String.format("\u5220\u9664\u6587\u4ef6\uff1a%s > %s", dataSourceDTO.getName(), path));
            }
            boolean bl = result;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(String key, String path, String password) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            boolean result;
            IFileset fileset = fileStorage.getFile(path);
            if (fileset == null) {
                throw new RuntimeException(path + " \u4e0d\u5b58\u5728");
            }
            boolean recursive = false;
            if (fileset.getIsDirectory()) {
                String filePassword = this.fileStorageProperties.getFilePassword();
                if (StringUtil.isNotEmpty((String)filePassword)) {
                    if (StringUtil.isEmpty((String)filePassword) || !StringUtil.MD5((String)filePassword).equals(password)) {
                        throw new RuntimeException("\u5220\u9664\u53e3\u4ee4\u4e0d\u6b63\u786e");
                    }
                    recursive = true;
                } else if (fileStorage.listFile(fileset.getFullPath(), false).size() > 0) {
                    throw new RuntimeException("\u975e\u7a7a\u6587\u4ef6\u5939\u4e0d\u5141\u8bb8\u5220\u9664");
                }
            } else {
                recursive = false;
            }
            if (result = recursive ? this.deleteFileRecursive(fileStorage, fileset) : fileStorage.deleteFile(path)) {
                this.sysLogService.addLog(150, String.format("\u5220\u9664\u6587\u4ef6\uff1a%s > %s", dataSourceDTO.getName(), path));
            }
            boolean bl = result;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDeleteFile(String key, List<String> paths, String password) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)password), (String)"\u5220\u9664\u53e3\u4ee4\u4e0d\u80fd\u4e3a\u7a7a");
        String filePassword = this.fileStorageProperties.getFilePassword();
        if (StringUtil.isEmpty((String)filePassword) || !StringUtil.MD5((String)filePassword).equals(password)) {
            throw new RuntimeException("\u5220\u9664\u53e3\u4ee4\u4e0d\u6b63\u786e");
        }
        Assert.isTrue((paths != null && !paths.isEmpty() ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            for (String path : paths) {
                IFileset fileset = fileStorage.getFile(path);
                if (fileset == null) continue;
                this.deleteFileRecursive(fileStorage, fileset);
            }
            log.warn("\u6279\u91cf\u5220\u9664\u6587\u4ef6\uff1a" + String.join((CharSequence)",", paths));
            this.sysLogService.addLog(150, String.format("\u6279\u91cf\u5220\u9664\u6587\u4ef6\uff1a%s > %s ...", dataSourceDTO.getName(), paths.get(0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileDTO createDirectory(String key, String path, String dirName) {
        try (IFileStorage fileStorage = this.openFileStorage(key);){
            IFileset fileset = fileStorage.createDirectory(path, dirName);
            Assert.notNull((Object)fileset, (String)"\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
            FileDTO fileDTO = new FileDTO();
            this.toFileDTO(fileDTO, fileset);
            FileDTO fileDTO2 = fileDTO;
            return fileDTO2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFile(MultipartFile file, String dbKey, String tarPath, Boolean overwrite) {
        String fileName = file.getOriginalFilename();
        if (StringUtil.isEmptyOrWhiteSpace((String)fileName)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u6587\u4ef6\u540d\uff01");
        }
        try (IFileStorage fileStorage = this.openFileStorage(dbKey);){
            String targetFile = StringUtil.trimEnd((String)tarPath, (String)"/") + "/" + fileName;
            try (InputStream inputStream = file.getInputStream();){
                fileStorage.upload(inputStream, targetFile, overwrite.booleanValue());
            }
            catch (Exception e) {
                throw new RuntimeException("\u6587\u4ef6: " + fileName + "\u4e0a\u4f20\u5931\u8d25", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFileset uploadFile(DataSourceDTO fileDataSource, String srcFile, String targetFile) {
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(fileDataSource);){
            IFileset fileset;
            srcFile = UploadPathConfig.getFullPath((String)srcFile).toString();
            if (StringUtil.isEmptyOrWhiteSpace((String)targetFile)) {
                targetFile = fileDataSource.getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue() ? StringUtil.trimEnd((String)fileDataSource.getUrl(), (String)File.separator) + File.separator + FileUtil.getFileName((String)srcFile) : StringUtil.trimEnd((String)fileDataSource.getUrl(), (String)"/") + "/" + FileUtil.getFileName((String)srcFile);
            }
            IFileset iFileset = fileset = fileStorage.upload(srcFile, targetFile, true);
            return iFileset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void downloadFile(String dsKey, String filePath, HttpServletRequest request, HttpServletResponse response) {
        ServletOutputStream outputStream;
        IFileStorage fileStorage;
        block43: {
            IFileset srcFile;
            block42: {
                fileStorage = null;
                try {
                    DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
                    fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);
                    srcFile = fileStorage.getFile(filePath);
                    if (srcFile == null) {
                        throw new HttpClientErrorException(HttpStatus.NOT_FOUND, filePath + " \u4e0d\u5b58\u5728");
                    }
                    if (fileStorage instanceof IObjectStorage) {
                        if (!srcFile.getIsDirectory()) {
                            IObjectStorage objectStorage = (IObjectStorage)fileStorage;
                            String getUrl = objectStorage.generatePresignedGetUrl(srcFile.getFullPath(), 14400, null, null);
                            try {
                                response.setHeader("Cache-Control", "no-cache");
                                response.sendRedirect(getUrl);
                                return;
                            }
                            catch (IOException e) {
                                log.error(filePath + " \u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
                                throw new HttpClientErrorException(HttpStatus.NOT_FOUND, e.getMessage());
                            }
                        }
                        break block42;
                    }
                    Integer sizeLimit = this.fileStorageProperties.getFileDownloadSizeLimit();
                    if (sizeLimit == null || sizeLimit <= 0 || this.checkFileSize(srcFile, sizeLimit * 1024 * 1024) >= 0L) break block42;
                    throw new HttpClientErrorException(HttpStatus.FORBIDDEN, "\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + sizeLimit + "MB");
                }
                catch (Exception e) {
                    if (e instanceof HttpStatusCodeException) {
                        throw (HttpStatusCodeException)e;
                    }
                    log.error(filePath + " \u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                    throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, filePath + " \u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            response.resetBuffer();
            outputStream = response.getOutputStream();
            try {
                if (!srcFile.getIsDirectory()) {
                    DownloadUtil.setDownloadFileName((String)srcFile.getName(), (HttpServletRequest)request, (HttpServletResponse)response);
                    response.setContentType("application/octet-stream");
                    try (InputStream inputStream = srcFile.openFileStream();){
                        IoUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                        break block43;
                    }
                }
                String zipFileName = FileUtil.getFileNameWithoutExtension((String)srcFile.getName()) + ".zip";
                DownloadUtil.setDownloadFileName((String)zipFileName, (HttpServletRequest)request, (HttpServletResponse)response);
                response.setContentType("application/octet-stream");
                try (ZipOutputStream out = new ZipOutputStream((OutputStream)outputStream, Charset.forName("GBK"));){
                    String inZipPath = srcFile.getName() + "/";
                    out.putNextEntry(new ZipEntry(inZipPath));
                    FileStorageServiceImpl.compress(srcFile, out, srcFile.getName(), true);
                    out.closeEntry();
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream});
        return;
        finally {
            if (fileStorage != null) {
                fileStorage.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDownloadFile(String dsKey, List<String> filePaths, HttpServletRequest request, HttpServletResponse response) {
        try (IFileStorage fileStorage = null;){
            if (filePaths == null || filePaths.isEmpty()) {
                throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6");
            }
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
            fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);
            ArrayList<IFileset> srcFiles = new ArrayList<IFileset>();
            for (String filePath : filePaths) {
                IFileset fileset = fileStorage.getFile(filePath);
                if (fileset == null) continue;
                srcFiles.add(fileset);
            }
            if (srcFiles.isEmpty()) {
                throw new HttpClientErrorException(HttpStatus.NOT_FOUND, "\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6");
            }
            Integer sizeLimit = this.fileStorageProperties.getFileDownloadSizeLimit();
            if (sizeLimit != null && sizeLimit > 0) {
                long srcFileSize = (long)(sizeLimit * 1024) * 1024L;
                for (IFileset fileset : srcFiles) {
                    srcFileSize = this.checkFileSize(fileset, srcFileSize);
                    if (srcFileSize >= 0L) continue;
                    throw new HttpClientErrorException(HttpStatus.FORBIDDEN, "\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7" + sizeLimit + "MB");
                }
            }
            response.resetBuffer();
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                String fileName = DateTimeUtil.dateString((String)"yyyyMMddHHmmss");
                DownloadUtil.setDownloadFileName((String)(fileName + ".zip"), (HttpServletRequest)request, (HttpServletResponse)response);
                response.setContentType("application/octet-stream");
                try (ZipOutputStream out = new ZipOutputStream((OutputStream)outputStream, Charset.forName("GBK"));){
                    for (IFileset fileset : srcFiles) {
                        FileStorageServiceImpl.compress(fileset, out, fileset.getName(), true);
                    }
                    out.closeEntry();
                }
                catch (Exception e) {
                    throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream});
                throw throwable;
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewFile(String dsKey, String filePath, HttpServletRequest request, HttpServletResponse response) {
        block20: {
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
            try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
                IFileset file = fileStorage.getFile(filePath);
                if (file == null || file.getIsDirectory()) {
                    throw new RuntimeException(filePath + " \u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                if (file.getSize() > (long)(this.fileStorageProperties.getFileDownloadSizeLimit() * 1024 * 1024)) {
                    throw new RuntimeException("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\uff0c\u4e0d\u652f\u6301\u9884\u89c8");
                }
                if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue()) {
                    FileViewerUtil.viewFile((File)new File(file.getFullPath()), (HttpServletRequest)request, (HttpServletResponse)response);
                    break block20;
                }
                try (InputStream inputStream = file.openFileStream();){
                    FileViewerUtil.viewFileStream((InputStream)inputStream, (String)file.getName(), (long)file.getSize(), (HttpServletRequest)request, (HttpServletResponse)response);
                }
                catch (Exception e) {
                    log.error(file.getFullPath());
                    throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SelectFileDataDTO> selectFiles(String dsKey, String path, List<FileDataTypeEnum> filterTypes, String customFileExts) {
        DataSourceDTO fileDataSource;
        List<SelectFileDataDTO> lstChildObject = new ArrayList<SelectFileDataDTO>();
        if (StringUtil.isEmptyOrWhiteSpace((String)dsKey)) {
            fileDataSource = this.getFileDataSourceByFilePath(path);
            if (fileDataSource == null) {
                return lstChildObject;
            }
            path = UploadPathConfig.getFileFullPath((String)path);
        } else {
            fileDataSource = this.dataSourceManager.getDataSourceDetail(dsKey);
        }
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(fileDataSource);){
            FileDataTypeEnum parentDataTypeEnum = SelectFileDataUtil.getDataType(fileStorage, path);
            lstChildObject = SelectFileDataUtil.getDataFromFile(fileStorage, path, parentDataTypeEnum, filterTypes, customFileExts);
            lstChildObject.forEach(item -> item.setDsKey(fileDataSource.getKey()));
            List<SelectFileDataDTO> list = lstChildObject;
            return list;
        }
    }

    @Override
    public String uploadSelectFile(MultipartFile file, String uuid, Boolean unzip) {
        String fileName = file.getOriginalFilename();
        Assert.notNull((Object)fileName, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u6587\u4ef6\u540d\uff01");
        if (StringUtil.isEmptyOrWhiteSpace((String)uuid)) {
            uuid = UUID.randomUUID().toString();
        }
        Path path = UploadPathConfig.getUploadPath().resolve(uuid);
        path = path.resolve(Paths.get(fileName, new String[0]));
        try {
            File fileDir = new File(path.getParent().toString());
            if (!fileDir.exists() && !fileDir.mkdirs()) {
                log.error("\u6587\u4ef6\u5939: " + fileDir.getName() + "\u521b\u5efa\u5931\u8d25\uff01");
            }
            file.transferTo(path);
            String resultPath = path.toString();
            if (unzip.booleanValue()) {
                File targetFile = new File(resultPath);
                Path unZipPath = targetFile.toPath();
                if (!targetFile.isDirectory() && fileName.toUpperCase().endsWith(".ZIP")) {
                    unZipPath = Paths.get(targetFile.getParentFile().getPath(), FileUtil.getFileNameWithoutExtension((String)targetFile.getPath()));
                    ZipAndRarUtil.unZipFiles((File)targetFile, (String)(unZipPath + File.separator));
                }
                resultPath = unZipPath.toString();
            }
            resultPath = UploadPathConfig.getUploadRelativePath((String)resultPath);
            return resultPath;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6: " + fileName + "\u4e0a\u4f20\u5931\u8d25", e);
        }
    }

    @Override
    public List<SelectFileDataDTO> listUploadFile(String uuid, List<FileDataTypeEnum> filterTypes, String customFileExts) {
        String uploadPath = UploadPathConfig.getUploadPath().resolve(uuid).toString();
        if (!new File(uploadPath).exists()) {
            return new ArrayList<SelectFileDataDTO>();
        }
        DirectoryFileStorage fileStorage = new DirectoryFileStorage(uploadPath, null, null);
        List<SelectFileDataDTO> lstChildObject = SelectFileDataUtil.getDataFromFolderRecursion((IFileStorage)fileStorage, uploadPath, filterTypes, customFileExts);
        lstChildObject.forEach(s -> {
            s.setRelativePath(this.getRelativeFilePath(uploadPath, s.getFullPath()));
            String uploadFilePath = UploadPathConfig.getUploadRelativePath((String)s.getFullPath());
            s.setFullPath(uploadFilePath);
        });
        return lstChildObject;
    }

    @Override
    public List<VectorLayerDTO> listFileVectorLayer(String dsKey, String path, Boolean withFields) {
        String fileFullPath = UploadPathConfig.getFileFullPath((String)path);
        ArrayList<VectorLayerDTO> lstChildObject = new ArrayList<VectorLayerDTO>();
        try (IFeatureWorkspace workspace = null;){
            DataSourceDTO fileDataSource;
            if (StringUtil.isEmptyOrWhiteSpace((String)dsKey)) {
                fileDataSource = this.getFileDataSourceByFilePath(path);
                if (fileDataSource == null) {
                    log.error("\u672a\u914d\u7f6e\u8def\u5f84\uff1a" + path);
                    ArrayList<VectorLayerDTO> arrayList = lstChildObject;
                    return arrayList;
                }
            } else {
                fileDataSource = this.dataSourceManager.getDataSourceDetail(dsKey);
            }
            workspace = GeoDatabaseUtil.openFileGeoDatabase(fileDataSource, fileFullPath);
            List enumDataset = workspace.getDatasets();
            for (IGeoDataset dataset : enumDataset) {
                lstChildObject.add(this.toVectorLayerDTO(dataset, withFields));
            }
            lstChildObject.sort(Comparator.comparing(VectorLayerDTO::getName));
            ArrayList<VectorLayerDTO> arrayList = lstChildObject;
            return arrayList;
        }
    }

    @Override
    public VectorLayerDTO getFileVectorLayer(String dsKey, String path, Boolean withFields) {
        IFileStorage fileStorage = null;
        IFeatureWorkspace workspace = null;
        try {
            DataSourceDTO fileDataSource;
            if (StringUtil.isEmptyOrWhiteSpace((String)dsKey)) {
                fileDataSource = this.getFileDataSourceByFilePath(path);
                if (fileDataSource == null) {
                    throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + path);
                }
                path = UploadPathConfig.getFileFullPath((String)path);
            } else {
                fileDataSource = this.dataSourceManager.getDataSourceDetail(dsKey);
            }
            fileStorage = FileStorageUtil.openFileStorage(fileDataSource);
            fileStorage.connect();
            IFileset parentFileset = this.getFileWorkspacePath(fileStorage, path);
            if (".txt".equalsIgnoreCase(parentFileset.getExt())) {
                VectorLayerDTO vectorLayerDTO = this.getTxtFileLayer(parentFileset, withFields);
                return vectorLayerDTO;
            }
            String geoDataPath = parentFileset.getFullPath();
            String layerName = FileUtil.getFileNameWithoutExtension((String)path);
            workspace = GeoDatabaseUtil.openFileGeoDatabase(fileStorage, geoDataPath);
            ITable dataset = workspace.openTable(layerName);
            if (dataset == null) {
                throw new RuntimeException(path + " \u6570\u636e\u6253\u5f00\u5931\u8d25\uff01");
            }
            VectorLayerDTO vectorLayerDTO = this.toVectorLayerDTO((IGeoDataset)dataset, withFields);
            return vectorLayerDTO;
        }
        catch (Exception e) {
            throw new RuntimeException(path + " \u8bfb\u53d6\u5931\u8d25\uff01", e);
        }
        finally {
            if (workspace != null) {
                workspace.close();
            }
            if (fileStorage != null) {
                fileStorage.close();
            }
        }
    }

    @Override
    public List<FieldDTO> listFileLayerField(String dsKey, String path) {
        VectorLayerDTO vectorLayer = this.getFileVectorLayer(dsKey, path, true);
        if (vectorLayer != null) {
            return vectorLayer.getFields();
        }
        return new ArrayList<FieldDTO>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleDatasetDTO> listDatasets(String dsKey, String path) {
        try (IFileStorage fileStorage = this.openFileStorage(dsKey);){
            IFileset parentFile = fileStorage.getFile(path);
            if (parentFile == null) {
                throw new RuntimeException(path + " \u4e0d\u5b58\u5728");
            }
            FileDataTypeEnum parentDataTypeEnum = SelectFileDataUtil.getDataType(fileStorage, path);
            ArrayList<FileDataTypeEnum> filterTypes = new ArrayList<FileDataTypeEnum>();
            filterTypes.add(FileDataTypeEnum.FeatureClass);
            filterTypes.add(FileDataTypeEnum.RasterDataset);
            filterTypes.add(FileDataTypeEnum.TileDataset);
            List<SelectFileDataDTO> lstChildObject = SelectFileDataUtil.getDataFromFile(fileStorage, path, parentDataTypeEnum, filterTypes, null);
            ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
            for (SelectFileDataDTO selectFileDataDTO : lstChildObject) {
                if (!selectFileDataDTO.getCanChoose().booleanValue()) continue;
                SimpleDatasetDTO datasetDTO = new SimpleDatasetDTO();
                datasetDTO.setName(selectFileDataDTO.getName());
                datasetDTO.setAliasName(selectFileDataDTO.getName());
                datasetDTO.setFullName(selectFileDataDTO.getFullPath());
                DatasetTypeEnum datasetTypeEnum = DatasetTypeEnum.Unknown;
                switch (FileDataTypeEnum.getByValue(selectFileDataDTO.getType())) {
                    case Shapefile: 
                    case GeoJSON: 
                    case GML: 
                    case MapInfo: 
                    case FeatureClass: {
                        datasetTypeEnum = DatasetTypeEnum.FeatureClass;
                        break;
                    }
                    case PointFeatureClass: {
                        datasetTypeEnum = DatasetTypeEnum.FeatureClass;
                        datasetDTO.setFeatureType(FeatureType.Point.getValue());
                        break;
                    }
                    case LineFeatureClass: {
                        datasetTypeEnum = DatasetTypeEnum.FeatureClass;
                        datasetDTO.setFeatureType(FeatureType.Polyline.getValue());
                        break;
                    }
                    case PolygonFeatureClass: {
                        datasetTypeEnum = DatasetTypeEnum.FeatureClass;
                        datasetDTO.setFeatureType(FeatureType.Polygon.getValue());
                        break;
                    }
                    case RasterDataset: 
                    case RasterTifFile: 
                    case RasterImgFile: 
                    case RasterGridFile: 
                    case RasterDemFile: {
                        datasetTypeEnum = DatasetTypeEnum.RasterDataset;
                        break;
                    }
                    case TileDataset: {
                        datasetTypeEnum = DatasetTypeEnum.TileDataset;
                        break;
                    }
                    case MBTiles: {
                        datasetTypeEnum = DatasetTypeEnum.TileDataset;
                        datasetDTO.setTileType(TileType.TerrainTile.getValue());
                        try {
                            ITileDataset tileDataset;
                            MBTilesTileDataSource tileDataSource = new MBTilesTileDataSource(selectFileDataDTO.getFullPath());
                            if (!tileDataSource.connect() || (tileDataset = tileDataSource.getDataset(null)) == null) break;
                            datasetDTO.setTileType(tileDataset.getType().getValue());
                        }
                        catch (Exception e) {
                            log.error(selectFileDataDTO.getFullPath() + " \u6253\u5f00\u5931\u8d25", (Throwable)e);
                        }
                        break;
                    }
                    case ArcgisTile: {
                        datasetTypeEnum = DatasetTypeEnum.TileDataset;
                        datasetDTO.setTileType(TileType.RasterTile.getValue());
                        break;
                    }
                    case Tiles3d: {
                        datasetTypeEnum = DatasetTypeEnum.TileDataset;
                        datasetDTO.setTileType(TileType.Model3DTile.getValue());
                        break;
                    }
                }
                datasetDTO.setType(datasetTypeEnum.getValue());
                datasetDTO.setId(DatasetUtil.getDatasetId(dsKey, datasetTypeEnum, datasetDTO.getFullName()));
                datasetDTOS.add(datasetDTO);
            }
            ArrayList<SimpleDatasetDTO> arrayList = datasetDTOS;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, DatasetTypeEnum datasetType, String fullName) {
        String datasetId = DatasetUtil.getDatasetId(dataSourceDTO.getKey(), datasetType, fullName);
        DatasetDTO datasetDTO = null;
        if (datasetType == DatasetTypeEnum.FeatureClass) {
            VectorLayerDTO vectorLayerDTO = this.getFileVectorLayer(dataSourceDTO.getKey(), fullName, true);
            FeatureClassDTO featureClassDTO = new FeatureClassDTO();
            featureClassDTO.setName(vectorLayerDTO.getName());
            featureClassDTO.setAliasName(vectorLayerDTO.getName());
            featureClassDTO.setFeatureType(vectorLayerDTO.getFeatureType());
            featureClassDTO.setExtent(vectorLayerDTO.getExtent());
            featureClassDTO.setSpatialRef(vectorLayerDTO.getSpatialRef());
            featureClassDTO.setFields(vectorLayerDTO.getFields());
            datasetDTO = featureClassDTO;
        } else if (datasetType == DatasetTypeEnum.RasterDataset) {
            RasterInfo rasterInfo;
            block23: {
                IRasterDataset rasterDataset = null;
                try {
                    rasterDataset = GeoDatabaseUtil.openRasterDataset(dataSourceDTO, fullName);
                    if (rasterDataset != null) {
                        rasterInfo = rasterDataset.getRasterInfo();
                        break block23;
                    }
                    throw new RuntimeException("\u6805\u683c\u6587\u4ef6\u6253\u5f00\u5931\u8d25\uff1a" + fullName);
                }
                finally {
                    if (rasterDataset != null) {
                        rasterDataset.closeRaster();
                    }
                }
            }
            RasterDatasetDTO rasterDatasetDTO = new RasterDatasetDTO();
            rasterDatasetDTO.setName(FileUtil.getFileName((String)fullName));
            rasterDatasetDTO.setAliasName(rasterDatasetDTO.getName());
            rasterDatasetDTO.setExtent(GeoDatasetUtil.toExtentDTO(rasterInfo.getExtent()));
            rasterDatasetDTO.setSpatialRef(GeoDatasetUtil.toSpatialRefDTO(rasterInfo.getSpatialReferenceSystem()));
            rasterDatasetDTO.setBandCount(rasterInfo.getBandCount());
            rasterDatasetDTO.setInvalidValue(rasterInfo.getInvalidValue() == null ? null : rasterInfo.getInvalidValue()[0]);
            rasterDatasetDTO.setPixelDataType(rasterInfo.getPixelDataType().getValue());
            datasetDTO = rasterDatasetDTO;
        } else if (datasetType == DatasetTypeEnum.TileDataset) {
            TileDatasetDTO tileDatasetDTO;
            block24: {
                tileDatasetDTO = new TileDatasetDTO();
                tileDatasetDTO.setName(FileUtil.getFileName((String)fullName));
                tileDatasetDTO.setAliasName(tileDatasetDTO.getName());
                try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
                    FileDataTypeEnum parentDataTypeEnum = SelectFileDataUtil.getDataType(fileStorage, fullName);
                    if (parentDataTypeEnum == FileDataTypeEnum.MBTiles) {
                        tileDatasetDTO.setTileType(TileType.TerrainTile.getValue());
                        try {
                            ITileDataset tileDataset;
                            MBTilesTileDataSource tileDataSource = new MBTilesTileDataSource(fullName);
                            if (tileDataSource.connect() && (tileDataset = tileDataSource.getDataset(null)) != null) {
                                tileDatasetDTO.setTileType(tileDataset.getType().getValue());
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            log.error(fullName + " \u6253\u5f00\u5931\u8d25", (Throwable)e);
                        }
                        break block24;
                    }
                    if (parentDataTypeEnum == FileDataTypeEnum.ArcgisTile) {
                        tileDatasetDTO.setTileType(TileType.RasterTile.getValue());
                    } else if (parentDataTypeEnum == FileDataTypeEnum.Tiles3d) {
                        tileDatasetDTO.setTileType(TileType.Model3DTile.getValue());
                    }
                }
            }
            datasetDTO = tileDatasetDTO;
        } else {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6570\u636e\uff1a" + fullName);
        }
        datasetDTO.setId(datasetId);
        datasetDTO.setFullName(fullName);
        datasetDTO.setType(datasetType.getValue());
        datasetDTO.setDsKey(dataSourceDTO.getKey());
        datasetDTO.setDataSource(dataSourceDTO);
        this.dataSourceManager.clearDataSourcePassword(dataSourceDTO);
        return datasetDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO queryFilterDTO) {
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
        String fullName = datasetNameInfo.getName();
        if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue()) {
            IFileStorage fileStorage = null;
            IFeatureWorkspace workspace = null;
            try {
                fileStorage = this.openFileStorage(datasetNameInfo.getDsKey());
                IFileset parentFileset = this.getFileWorkspacePath(fileStorage, fullName);
                String geoDataPath = parentFileset.getFullPath();
                String datasetName = FileUtil.getFileNameWithoutExtension((String)fullName);
                workspace = GeoDatabaseUtil.openFileGeoDatabase(fileStorage, geoDataPath);
                IFeatureClass featureClass = workspace.openFeatureClass(datasetName);
                Assert.notNull((Object)featureClass, (String)(datasetName + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                SpatailQueryUtil.initDefaultQueryFilter(queryFilterDTO);
                DataQueryResult queryResult = SpatailQueryUtil.queryFeatureClass(featureClass, queryFilterDTO);
                queryResult.setId(datasetId);
                DataQueryResult dataQueryResult = queryResult;
                return dataQueryResult;
            }
            finally {
                if (workspace != null) {
                    workspace.close();
                }
                if (fileStorage != null) {
                    fileStorage.close();
                }
            }
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6570\u636e\uff1a" + fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryDataCount(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
        String fullName = datasetNameInfo.getName();
        if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.FeatureClass.getValue()) {
            IFileStorage fileStorage = null;
            IFeatureWorkspace workspace = null;
            try {
                long result;
                fileStorage = this.openFileStorage(datasetNameInfo.getDsKey());
                IFileset parentFileset = this.getFileWorkspacePath(fileStorage, fullName);
                String geoDataPath = parentFileset.getFullPath();
                String datasetName = FileUtil.getFileNameWithoutExtension((String)fullName);
                workspace = GeoDatabaseUtil.openFileGeoDatabase(fileStorage, geoDataPath);
                IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
                Assert.notNull((Object)geoDataset, (String)(datasetName + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, geoDataset);
                long l = result = ((ITable)geoDataset).count((IQueryFilter)filter);
                return l;
            }
            finally {
                if (workspace != null) {
                    workspace.close();
                }
                if (fileStorage != null) {
                    fileStorage.close();
                }
            }
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u6570\u636e\uff1a" + fullName);
    }

    @Override
    public IFileStorage openFileStorage(String key) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        return FileStorageUtil.openFileStorage(dataSourceDTO);
    }

    @Override
    public DataSourceDTO getFileDataSourceByFilePath(String filePath) {
        DataSourceDTO fileDataSource;
        if (UploadPathConfig.isUploadPath((String)filePath)) {
            return this.getLocalPathDataSource(UploadPathConfig.getFileFullPath((String)filePath));
        }
        List<DataSourceDTO> fileServers = this.dataSourceManager.listDataSourceWithPassword(Arrays.asList(DataStoreTypeEnum.FileStorageSystem), null);
        if (Boolean.TRUE.equals(this.fileStorageProperties.getShowLocalDisk())) {
            File[] files;
            for (File file : files = File.listRoots()) {
                DataSourceDTO localDataSource = this.dataSourceManager.buildLocalFileDataSource(file);
                fileServers.add(localDataSource);
            }
        }
        if ((fileDataSource = (DataSourceDTO)ListUtil.find(fileServers, s -> filePath.startsWith(s.getUrl()))) == null) {
            return null;
        }
        return fileDataSource;
    }

    @Override
    public IFileStorage openFileStorageByFilePath(String filePath) {
        DataSourceDTO fileDataSource = this.getFileDataSourceByFilePath(filePath);
        if (fileDataSource == null) {
            fileDataSource = this.getLocalPathDataSource(filePath);
        }
        Assert.notNull((Object)fileDataSource, (String)("\u672a\u627e\u5230\u6570\u636e\u6e90\uff1a" + filePath));
        return FileStorageUtil.openFileStorage(fileDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFeatureWorkspace openFileLayerWorkspace(String filePath) {
        DataSourceDTO fileDataSource = null;
        if (UploadPathConfig.isUploadPath((String)filePath)) {
            filePath = UploadPathConfig.getFileFullPath((String)filePath);
            fileDataSource = this.getLocalPathDataSource(filePath);
        } else {
            fileDataSource = this.getFileDataSourceByFilePath(filePath);
            if (fileDataSource == null) {
                fileDataSource = this.getLocalPathDataSource(filePath);
            }
        }
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(fileDataSource);){
            IFeatureWorkspace workspace;
            IFileset parentFileset = this.getFileWorkspacePath(fileStorage, filePath);
            String geoDataPath = parentFileset.getFullPath();
            IFeatureWorkspace iFeatureWorkspace = workspace = GeoDatabaseUtil.openFileGeoDatabase(fileStorage, geoDataPath);
            return iFeatureWorkspace;
        }
    }

    private DataSourceDTO getLocalPathDataSource(String localFilePath) {
        File localFile = new File(localFilePath);
        File parentFile = localFile.getParentFile();
        if (parentFile == null) {
            parentFile = localFile;
        }
        if (!parentFile.exists()) {
            throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + localFilePath);
        }
        if (parentFile.isFile()) {
            parentFile = parentFile.getParentFile();
        }
        return this.dataSourceManager.buildLocalFileDataSource(parentFile);
    }

    private IFileset getFileWorkspacePath(IFileStorage fileStorage, String fileFullName) {
        IFileset fileset = fileStorage.getFile(fileFullName);
        if (fileset != null) {
            return fileset;
        }
        IFileset parentFileset = fileStorage.getParentFile(fileFullName);
        Assert.notNull((Object)parentFileset, (String)(fileFullName + " \u8def\u5f84\u4e0d\u5b58\u5728"));
        return parentFileset;
    }

    private VectorLayerDTO toVectorLayerDTO(IGeoDataset dataset, Boolean withFields) {
        VectorLayerDTO vectorLayerDTO = new VectorLayerDTO();
        vectorLayerDTO.setFeatureType(FeatureType.Unknown.getValue());
        vectorLayerDTO.setName(dataset.getName());
        vectorLayerDTO.setAliasName(dataset.getAliasName());
        if (dataset instanceof IFeatureClass) {
            IFeatureClass featureClass = (IFeatureClass)dataset;
            vectorLayerDTO.setFeatureType(featureClass.getFeatureType().getValue());
            vectorLayerDTO.setSpatialRef(GeoDatasetUtil.toSpatialRefDTO(featureClass.getSpatialReferenceSystem()));
            vectorLayerDTO.setExtent(GeoDatasetUtil.toExtentDTO(featureClass.getExtent()));
        }
        if (dataset instanceof ITable && withFields.booleanValue()) {
            List fieldDTOS = ListUtil.convertAll((Object[])((ITable)dataset).getFields().toArray(), FieldUtil::convertField);
            vectorLayerDTO.setFields(fieldDTOS);
        }
        return vectorLayerDTO;
    }

    private String getRelativeFilePath(String parentPath, String uploadFilePath) {
        String resultPath = uploadFilePath.substring(parentPath.length() + 1);
        resultPath = StringUtil.trim((String)resultPath.replace("\\", "/"), (String)"/");
        return resultPath;
    }

    private long checkFileSize(IFileset file, long sizeLimit) {
        LinkedList<IFileset> queue = new LinkedList<IFileset>();
        queue.add(file);
        while (!queue.isEmpty()) {
            IFileset current = (IFileset)queue.poll();
            if (current.getIsDirectory()) {
                List subFiles = current.listFiles();
                if (subFiles == null) continue;
                for (IFileset subFile : subFiles) {
                    if (subFile.getIsDirectory()) {
                        queue.add(subFile);
                        continue;
                    }
                    if ((sizeLimit -= subFile.getSize()) >= 0L) continue;
                    return sizeLimit;
                }
                continue;
            }
            if ((sizeLimit -= current.getSize()) >= 0L) continue;
            return sizeLimit;
        }
        return sizeLimit;
    }

    private boolean deleteFileRecursive(IFileStorage fileStorage, IFileset file) {
        List list = fileStorage.listFile(file.getFullPath(), false);
        if (list != null) {
            for (IFileset f : list) {
                if (f.getIsDirectory()) {
                    this.deleteFileRecursive(fileStorage, f);
                    continue;
                }
                f.delete();
            }
        }
        return file.delete();
    }

    private static void compress(IFileset sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        if (!sourceFile.getIsDirectory()) {
            zos.putNextEntry(new ZipEntry(name));
            try (InputStream inputStream = sourceFile.openFileStream();){
                IoUtil.copy((InputStream)inputStream, (OutputStream)zos);
            }
            zos.closeEntry();
        } else {
            List listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.size() == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (IFileset file : listFiles) {
                    if (keepDirStructure) {
                        FileStorageServiceImpl.compress(file, zos, name + "/" + file.getName(), true);
                        continue;
                    }
                    FileStorageServiceImpl.compress(file, zos, file.getName(), false);
                }
            }
        }
    }

    private VectorLayerDTO getTxtFileLayer(IFileset txtFile, Boolean withFields) {
        String layerName = FileUtil.getFileNameWithoutExtension((String)txtFile.getName());
        VectorLayerDTO vectorLayer = new VectorLayerDTO();
        vectorLayer.setName(layerName);
        vectorLayer.setAliasName(layerName);
        vectorLayer.setExtent(null);
        vectorLayer.setSpatialRef(null);
        vectorLayer.setFeatureType(FeatureType.Unknown.getValue());
        if (withFields.booleanValue()) {
            ArrayList<String> data = new ArrayList<String>();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(txtFile.openFileStream()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    data.add(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(txtFile.getFullPath() + " \u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            ArrayList<FieldDTO> fields = new ArrayList<FieldDTO>();
            String[] fieldArr = ((String)data.get(0)).split("\t");
            Assert.state((fieldArr.length >= 3 ? 1 : 0) != 0, (String)"txt\u683c\u5f0f\u4e0d\u6b63\u786e");
            for (String field : fieldArr) {
                FieldDTO fieldDTO = new FieldDTO();
                fieldDTO.setName(field);
                fieldDTO.setAliasName(field);
                fieldDTO.setFieldType(Integer.valueOf(FieldType.Unknown.getValue()));
                fields.add(fieldDTO);
            }
            vectorLayer.setFields(fields);
        }
        return vectorLayer;
    }
}

