/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.GdbUtil;
import com.geoway.adf.dms.common.gis.ShpfileUtil;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.input.AtlasDataInputParams;
import com.geoway.adf.dms.datasource.dto.input.DataInputExportTaskResultDTO;
import com.geoway.adf.dms.datasource.dto.input.DataInputParams;
import com.geoway.adf.dms.datasource.dto.input.ExcuteStatus;
import com.geoway.adf.dms.datasource.dto.input.RasterDataInputParams;
import com.geoway.adf.dms.datasource.dto.output.AtlasExportParams;
import com.geoway.adf.dms.datasource.dto.output.Data2AtlasExportParams;
import com.geoway.adf.dms.datasource.dto.output.DataExportParams;
import com.geoway.adf.dms.datasource.dto.output.OutputVectorFormatEnum;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.IMEServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.service.AtlasDataSourceService;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatasetInputExportService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DatasetInputExportServiceImpl
implements DatasetInputExportService {
    private static final Logger log = LoggerFactory.getLogger(DatasetInputExportServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private FileStorageService fileStorageService;
    @Resource
    private AtlasDataSourceService atlasDataSourceService;
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static Map<String, DataInputExportTaskResultDTO> allTasks = new ConcurrentHashMap<String, DataInputExportTaskResultDTO>();

    @Override
    public String dataInput(DataInputParams inputParam) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(inputParam.getDatasetId());
        String srcName = datasetNameInfo.getShortName();
        DataInputExportTaskResultDTO task = this.initTask(null, inputParam.getDatasetId(), datasetNameInfo.getDsKey(), "\u5bfc\u5165", srcName);
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            this.inputVectorData(task, inputParam);
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public String rasterInput(RasterDataInputParams inputParam) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(inputParam.getDatasetId());
        String srcName = datasetNameInfo.getShortName();
        DataInputExportTaskResultDTO task = this.initTask(null, inputParam.getDatasetId(), datasetNameInfo.getDsKey(), "\u5bfc\u5165", srcName);
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            this.inputRasterData(task, inputParam);
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public String dataExport(DataExportParams exportParam) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(exportParam.getDatasetId());
        String srcName = datasetNameInfo.getShortName();
        if (StringUtil.isEmptyOrWhiteSpace((String)exportParam.getTargetName())) {
            exportParam.setTargetName(srcName);
        }
        DataInputExportTaskResultDTO task = this.initTask(null, exportParam.getDatasetId(), datasetNameInfo.getDsKey(), "\u5bfc\u51fa", srcName);
        task.setTargetName(exportParam.getTargetName());
        Path localPath = OutputPathConfig.getOutputPath().resolve(task.getTaskId());
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            this.exportVectorData(task, localPath.toString(), exportParam);
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public String atlasExport(AtlasExportParams exportParam) {
        DataInputExportTaskResultDTO task = this.initTask(null, exportParam.getAtlasDatasetName(), exportParam.getAtlasKey(), "\u5bfc\u51fa", exportParam.getAtlasDatasetName());
        task.setTargetName(exportParam.getTargetName());
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            try {
                task.setStatus(ExcuteStatus.Running.name());
                task.setTotalCount(1L);
                Path localPath = OutputPathConfig.getOutputPath().resolve(task.getTaskId()).toAbsolutePath();
                String targetName = exportParam.getTargetName();
                String targetFile = localPath.resolve(targetName).toString();
                OutputVectorFormatEnum format = OutputVectorFormatEnum.getByValue(exportParam.getFormat());
                switch (format) {
                    case GeoPackage: {
                        targetFile = Paths.get(targetFile + ".gpkg", exportParam.getAtlasDatasetName()).toString();
                        break;
                    }
                    case FileGDB: {
                        targetFile = Paths.get(targetFile + ".gdb", exportParam.getAtlasDatasetName()).toString();
                        break;
                    }
                    case Shapefile: {
                        targetFile = Paths.get(targetFile, exportParam.getAtlasDatasetName() + ".shp").toString();
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + exportParam.getFormat());
                    }
                }
                if (!localPath.toFile().exists()) {
                    localPath.toFile().mkdir();
                }
                this.atlasDataSourceService.downloadFileData(exportParam.getAtlasKey(), exportParam.getAtlasDatasetName(), targetFile);
                task.setStatus(ExcuteStatus.Successed.name());
                task.setProcess(100L);
                task.setMessage("\u5927\u6570\u636e\u8d44\u6e90\u6c60\u6570\u636e\u5bfc\u51fa\u6210\u529f\uff01");
                String zipFile = localPath.resolve(targetName + ".zip").toString();
                ZipAndRarUtil.toZip((String)new File(targetFile).getParent(), (String)zipFile, (boolean)true);
            }
            catch (Exception e) {
                log.error("\u5927\u6570\u636e\u8d44\u6e90\u6c60\u6570\u636e\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
                task.setStatus(ExcuteStatus.Failed.name());
                task.setMessage("\u5927\u6570\u636e\u8d44\u6e90\u6c60\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public String dataExport2Atlas(Data2AtlasExportParams exportParam) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(exportParam.getGeoDatasetId());
        String srcName = datasetNameInfo.getShortName();
        if (StringUtil.isEmptyOrWhiteSpace((String)exportParam.getAtlasDatasetName())) {
            exportParam.setAtlasDatasetName(srcName);
        }
        DataInputExportTaskResultDTO task = this.initTask(null, exportParam.getGeoDatasetId(), datasetNameInfo.getDsKey(), "\u5bfc\u51fa", srcName);
        task.setTargetName(exportParam.getAtlasDatasetName());
        task.setTaskType("\u5bfc\u51fa\u5230\u8d44\u6e90\u6c60");
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            try {
                task.setStatus(ExcuteStatus.Running.name());
                task.setTotalCount(1L);
                this.atlasDataSourceService.uploadGeoDatabaseData(exportParam.getGeoDatasetId(), exportParam.getAtlasKey(), exportParam.getAtlasDatasetName());
                task.setStatus(ExcuteStatus.Successed.name());
                task.setProcess(100L);
            }
            catch (Exception e) {
                log.error("\u5bfc\u51fa\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60\u5931\u8d25", (Throwable)e);
                task.setStatus(ExcuteStatus.Failed.name());
                task.setMessage("\u5bfc\u51fa\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public String dataInput2Atlas(AtlasDataInputParams inputParam) {
        String srcName = FileUtil.getFileNameWithoutExtension((String)inputParam.getDataPath());
        DataInputExportTaskResultDTO task = this.initTask(null, inputParam.getDataPath(), inputParam.getDsKey(), "\u5bfc\u5165", srcName);
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            try {
                task.setStatus(ExcuteStatus.Running.name());
                task.setTotalCount(1L);
                this.atlasDataSourceService.uploadFileData(inputParam.getDsKey(), inputParam.getDataPath(), inputParam.getDatasetName(), inputParam.getOverwrite());
                task.setStatus(ExcuteStatus.Successed.name());
                task.setProcess(100L);
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60\u5931\u8d25", (Throwable)e);
                task.setStatus(ExcuteStatus.Failed.name());
                task.setMessage("\u5bfc\u5165\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        allTasks.put(task.getTaskId(), task);
        return task.getTaskName();
    }

    @Override
    public PageList<DataInputExportTaskResultDTO> getAllTask(int pageIndex, int rows, String keyword, String taskType, String status, String dbKey) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        List<DataInputExportTaskResultDTO> allTaskList = new ArrayList<DataInputExportTaskResultDTO>(allTasks.values());
        allTaskList.sort((o1, o2) -> o1.getCreateTime().before(o2.getCreateTime()) ? 0 : -1);
        if (StringUtil.isNotEmpty((String)dbKey)) {
            allTaskList = ListUtil.findAll(allTaskList, task -> dbKey.equals(task.getDbKey()));
        }
        PageInfo pageInfo = new PageInfo(allTaskList);
        long total = pageInfo.getTotal();
        PageHelper.clearPage();
        if (StringUtil.isNotEmpty((String)keyword)) {
            allTaskList = ListUtil.findAll(allTaskList, task -> task.getTaskName().contains(keyword));
        }
        if (StringUtil.isNotEmpty((String)taskType)) {
            allTaskList = ListUtil.findAll(allTaskList, task -> task.getTaskType().equals(taskType));
        }
        if (StringUtil.isNotEmpty((String)status)) {
            List statusList = StringUtil.split((String)status, (String)",", String::valueOf);
            allTaskList = ListUtil.findAll(allTaskList, task -> ListUtil.find((List)statusList, s -> s.equals(task.getStatus())) != null);
        }
        return new PageList(allTaskList, Long.valueOf(total));
    }

    @Override
    public Integer getRunningTaskCount() {
        List<DataInputExportTaskResultDTO> allTask = new ArrayList<DataInputExportTaskResultDTO>(allTasks.values());
        allTask = ListUtil.findAll(allTask, task -> ExcuteStatus.Running.name().equals(task.getStatus()));
        return allTask.size();
    }

    @Override
    public void deleteTask(String taskId) {
        allTasks.remove(taskId);
    }

    @Override
    public void downloadExportData(String taskId) {
        DataInputExportTaskResultDTO task;
        if (allTasks.containsKey(taskId)) {
            task = allTasks.get(taskId);
            if (!"\u5bfc\u51fa".equals(task.getTaskType())) {
                throw new RuntimeException("\u5bfc\u51fa\u4efb\u52a1\u4e0d\u652f\u6301\u4e0b\u8f7d\uff01");
            }
            if (!task.getStatus().equals(ExcuteStatus.Successed.name())) {
                throw new RuntimeException(task.getMessage());
            }
        } else {
            throw new RuntimeException("\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        Path localPath = OutputPathConfig.getOutputPath().resolve(task.getTaskId());
        DownloadUtil.downloadFile((String)(localPath.resolve(task.getTargetName()) + ".zip"));
    }

    DataInputExportTaskResultDTO initTask(String uuid, String datasetId, String dbKey, String taskType, String datasetName) {
        DataInputExportTaskResultDTO task = new DataInputExportTaskResultDTO();
        if (StringUtil.isEmptyOrWhiteSpace((String)uuid)) {
            uuid = UUID.randomUUID().toString();
        }
        String id = uuid;
        task.setDatasetId(datasetId);
        task.setDbKey(dbKey);
        task.setTaskId(id);
        Date createTime = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        task.setCreateTime(createTime);
        String taskName = String.format("%s_%s_%s", datasetName, taskType, format.format(createTime));
        task.setTaskName(taskName);
        task.setTaskType(taskType);
        task.setProcess(0L);
        task.setTotalCount(0L);
        task.setErrorCount(0L);
        task.setSuccessCount(0L);
        task.setStatus(ExcuteStatus.NotStarted.name());
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputVectorData(DataInputExportTaskResultDTO task, DataInputParams inputParam) {
        IFeatureWorkspace targetWorkspace = null;
        IFeatureWorkspace srcWorkspace = null;
        Date start = new Date();
        try {
            TransferResult result;
            String dsKey;
            DataSourceDTO databaseDTO;
            IGeoDataset srcGeoData;
            DatasetNameInfo datasetNameInfo;
            task.setStatus(ExcuteStatus.Running.name());
            if (StringUtil.isNotEmpty((String)inputParam.getSourceDatasetId())) {
                datasetNameInfo = new DatasetNameInfo(inputParam.getSourceDatasetId());
                srcWorkspace = this.geoDatabaseService.openGeoWorkspace(datasetNameInfo.getDsKey());
                srcGeoData = srcWorkspace.openGeoDataset(datasetNameInfo.getName());
                if (srcGeoData == null) {
                    throw new RuntimeException(String.format("\u6253\u5f00\u6570\u636e\u6e90\u56fe\u5c42[%s]\u5931\u8d25\uff01", datasetNameInfo.getName()));
                }
            } else if (StringUtil.isNotEmpty((String)inputParam.getDataPath())) {
                String sourceDataPath = inputParam.getDataPath();
                String fileName = FileUtil.getFileNameWithoutExtension((String)sourceDataPath);
                srcWorkspace = this.fileStorageService.openFileLayerWorkspace(sourceDataPath);
                srcGeoData = srcWorkspace.openGeoDataset(fileName);
                if (srcGeoData == null) {
                    throw new RuntimeException(String.format("\u6253\u5f00\u6570\u636e\u6e90\u56fe\u5c42[%s]\u5931\u8d25\uff01", fileName));
                }
            } else {
                throw new RuntimeException("\u672a\u8bbe\u7f6e\u5f85\u5bfc\u5165\u6e90\u6570\u636e");
            }
            if ((databaseDTO = this.dataSourceService.getDataSourceDetail(dsKey = (datasetNameInfo = DatasetUtil.getDatasetNameInfo(inputParam.getDatasetId())).getDsKey())) == null) {
                throw new RuntimeException("\u83b7\u53d6\u7a7a\u95f4\u6570\u636e\u5e93\u5931\u8d25\uff01");
            }
            targetWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
            String name = datasetNameInfo.getName();
            GeoDatasetType geoDatasetType = GeoDatasetUtil.convertDatasetType(datasetType);
            IGeoDataset targetGeoData = GeoDatasetUtil.openDataset(targetWorkspace, geoDatasetType, name);
            Assert.notNull((Object)targetGeoData, (String)(name + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            if (inputParam.getOverwrite().booleanValue()) {
                ITable table = (ITable)targetGeoData;
                QueryFilter filter = new QueryFilter();
                filter.setWhereClause(null);
                long deleteCount = table.count((IQueryFilter)filter);
                if (deleteCount > 0L) {
                    table.deleteRow((IQueryFilter)filter);
                }
            }
            if ((result = this.copyVectorData(task, srcGeoData, targetGeoData, inputParam.getFieldMap(), null)).isSuccess()) {
                task.setProcess(100L);
                task.setStatus(ExcuteStatus.Successed.name());
                if (inputParam.getAutoCreateIndex() != null && inputParam.getAutoCreateIndex().booleanValue() && targetGeoData instanceof IFeatureClass) {
                    this.publishVectorService(inputParam.getDatasetId(), targetGeoData.getName(), task);
                }
            } else {
                task.setStatus(ExcuteStatus.Failed.name());
                if (StringUtil.isNotEmpty((String)result.getErrorMessage())) {
                    task.appendMsg(result.getErrorMessage());
                }
            }
            Date end = new Date();
            task.appendMsg(String.format("\u5171%d\u6761\u8bb0\u5f55\uff0c\u6210\u529f\u5bfc\u5165%d\u6761\uff0c\u5931\u8d25%d\u6761\uff0c\u8017\u65f6\uff1a%s", task.getTotalCount(), task.getSuccessCount(), task.getErrorCount(), DateTimeUtil.getTimeIntervalStr((Date)start, (Date)end)));
            log.info(task.getMessage());
        }
        catch (Exception e) {
            task.setStatus(ExcuteStatus.Failed.name());
            task.appendMsg(e.getMessage());
            log.error("\u6570\u636e\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputRasterData(DataInputExportTaskResultDTO task, RasterDataInputParams inputParam) {
        Date start = new Date();
        try (IFeatureWorkspace targetWorkspace = null;){
            task.setStatus(ExcuteStatus.Running.name());
            task.setTotalCount(Long.valueOf(inputParam.getDataPathArray().length));
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(inputParam.getDatasetId());
            String dsKey = datasetNameInfo.getDsKey();
            targetWorkspace = this.geoDatabaseService.openGeoWorkspace(dsKey);
            Assert.notNull((Object)targetWorkspace, (String)"\u6253\u5f00\u76ee\u6807\u6570\u636e\u5e93\u5931\u8d25\uff01");
            IMosaicDataset targetMosaicDataset = targetWorkspace.openMosaicDataset(datasetNameInfo.getName());
            Assert.notNull((Object)targetMosaicDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            if (inputParam.getOverwrite().booleanValue()) {
                QueryFilter filter = new QueryFilter();
                targetMosaicDataset.getCatalog().deleteFeature((IQueryFilter)filter);
            }
            boolean success = true;
            DataSourceDTO fileDataSource = null;
            for (String dataPath : inputParam.getDataPathArray()) {
                IRasterDataset rasterDataset = null;
                try {
                    String sourceDataPath;
                    TransferResult result;
                    if (fileDataSource == null) {
                        fileDataSource = this.fileStorageService.getFileDataSourceByFilePath(dataPath);
                    }
                    if (!(result = this.addRasterToMosaicDataset(targetMosaicDataset, rasterDataset = GeoDatabaseUtil.openRasterDataset(fileDataSource, sourceDataPath = UploadPathConfig.getFileFullPath((String)dataPath)))).isSuccess()) {
                        success = false;
                        task.setErrorCount(task.getErrorCount() + 1L);
                    } else {
                        task.setSuccessCount(task.getSuccessCount() + 1L);
                    }
                    double sCount = task.getSuccessCount() + task.getErrorCount();
                    double count = task.getTotalCount().longValue();
                    double process = sCount / count * 100.0;
                    task.setProcess((long)process);
                    if (!StringUtil.isNotEmpty((String)result.getErrorMessage())) continue;
                    task.appendMsg(result.getErrorMessage());
                }
                catch (Exception e) {
                    success = false;
                    task.setErrorCount(task.getErrorCount() + 1L);
                    task.appendMsg(dataPath + "\u6253\u5f00\u5931\u8d25\uff01");
                }
                finally {
                    if (rasterDataset != null) {
                        rasterDataset.closeRaster();
                    }
                }
            }
            task.setStatus(success ? ExcuteStatus.Successed.name() : ExcuteStatus.Failed.name());
            task.setProcess(100L);
            if (success) {
                targetMosaicDataset.updateExtent();
                targetMosaicDataset.calculateCellSizeRanges();
                if (inputParam.getAutoCreateIndex() != null && inputParam.getAutoCreateIndex().booleanValue()) {
                    this.publishRasterService(inputParam.getDatasetId(), targetMosaicDataset.getName(), task);
                }
            }
            Date end = new Date();
            task.appendMsg(String.format("\u5171%d\u5e45\u6570\u636e\uff0c\u6210\u529f\u5bfc\u5165%d\u5e45\uff0c\u5931\u8d25%d\u5e45\uff0c\u8017\u65f6\uff1a%s", task.getTotalCount(), task.getSuccessCount(), task.getErrorCount(), DateTimeUtil.getTimeIntervalStr((Date)start, (Date)end)));
            log.info(task.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportVectorData(DataInputExportTaskResultDTO task, String resultPath, DataExportParams exportParam) {
        IFeatureWorkspace targetWorkspace = null;
        IFeatureWorkspace srcWorkspace = null;
        Date start = new Date();
        try {
            task.setStatus(ExcuteStatus.Running.name());
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(exportParam.getDatasetId());
            String dsKey = datasetNameInfo.getDsKey();
            DataSourceDTO databaseDTO = this.dataSourceService.getDataSourceDetail(dsKey);
            if (databaseDTO == null) {
                throw new RuntimeException("\u83b7\u53d6\u7a7a\u95f4\u6570\u636e\u5e93\u5931\u8d25\uff01");
            }
            QueryFilter srcFilter = null;
            if (StringUtil.isNotEmpty((String)exportParam.getCondition())) {
                QueryFilterBasicDTO queryFilterDTO = new QueryFilterBasicDTO();
                queryFilterDTO.setCondition(exportParam.getCondition());
                GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(databaseDTO.getDataSourceType()), queryFilterDTO);
                srcFilter = new QueryFilter();
                srcFilter.setWhereClause(exportParam.getCondition());
            }
            srcWorkspace = GeoDatabaseUtil.openGeoDatabase(databaseDTO);
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
            String name = datasetNameInfo.getName();
            GeoDatasetType geoDatasetType = GeoDatasetUtil.convertDatasetType(datasetType);
            IGeoDataset srcDataset = GeoDatasetUtil.openDataset(srcWorkspace, geoDatasetType, name);
            Assert.notNull((Object)srcDataset, (String)(name + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            boolean isFeature = srcDataset instanceof IFeatureClass;
            Path localPath = Paths.get(resultPath, new String[0]);
            String targetName = exportParam.getTargetName();
            String targetFile = localPath.resolve(targetName).toString();
            Map fieldMap = null;
            OutputVectorFormatEnum format = OutputVectorFormatEnum.getByValue(exportParam.getFormat());
            switch (format) {
                case GeoPackage: {
                    targetFile = targetFile + ".gpkg";
                    break;
                }
                case FileGDB: {
                    targetFile = targetFile + ".gdb";
                    fieldMap = GdbUtil.sensitiveFieldNameReName((List)ListUtil.convertAll((Object[])((ITable)srcDataset).getFields().toArray(), IField::getName));
                    break;
                }
                case MDB: {
                    targetFile = targetFile + ".mdb";
                    isFeature = false;
                    fieldMap = GdbUtil.sensitiveFieldNameReName((List)ListUtil.convertAll((Object[])((ITable)srcDataset).getFields().toArray(), IField::getName));
                    break;
                }
                case Shapefile: {
                    fieldMap = ShpfileUtil.fieldNameTruncate((List)ListUtil.convertAll((Object[])((ITable)srcDataset).getFields().toArray(), IField::getName));
                    break;
                }
                case GeoJSON: {
                    targetFile = targetFile + ".geojson";
                    break;
                }
                case GML: {
                    targetFile = targetFile + ".gml";
                    break;
                }
                case KML: {
                    targetFile = targetFile + ".kml";
                    break;
                }
                case Excel: {
                    targetFile = targetFile + ".xlsx";
                    isFeature = false;
                    break;
                }
                case Csv: {
                    targetFile = targetFile + ".csv";
                    isFeature = false;
                    break;
                }
                case Dbf: {
                    targetFile = targetFile + ".dbf";
                    isFeature = false;
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + exportParam.getFormat());
                }
            }
            if (!localPath.toFile().exists()) {
                localPath.toFile().mkdir();
            }
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetFile);
            ITable targetDataset = this.createDataset((ITable)srcDataset, isFeature, targetWorkspace, targetName, fieldMap);
            Assert.notNull((Object)targetDataset, (String)(targetName + "\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01"));
            TransferResult result = this.copyVectorData(task, srcDataset, (IGeoDataset)targetDataset, fieldMap, (IQueryFilter)srcFilter);
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
            if (result.isSuccess()) {
                task.setProcess(100L);
                task.setStatus(ExcuteStatus.Successed.name());
            } else {
                task.setStatus(ExcuteStatus.Failed.name());
                if (StringUtil.isNotEmpty((String)result.getErrorMessage())) {
                    task.appendMsg(result.getErrorMessage());
                }
            }
            if (task.getStatus().equals(ExcuteStatus.Successed.name())) {
                String zipFile = localPath.resolve(targetName + ".zip").toString();
                ZipAndRarUtil.toZip((String)targetFile, (String)zipFile, (boolean)true);
            }
            Date end = new Date();
            task.appendMsg(String.format("\u5171%d\u6761\u8bb0\u5f55\uff0c\u6210\u529f\u5bfc\u51fa%d\u6761\uff0c\u5931\u8d25%d\u6761\uff0c\u8017\u65f6\uff1a%s", task.getTotalCount(), task.getSuccessCount(), task.getErrorCount(), DateTimeUtil.getTimeIntervalStr((Date)start, (Date)end)));
            log.info(task.getMessage());
        }
        catch (Exception e) {
            task.setStatus(ExcuteStatus.Failed.name());
            task.appendMsg(e.getMessage());
            log.error("\u6570\u636e\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
            if (srcWorkspace != null) {
                srcWorkspace.close();
            }
        }
    }

    private TransferResult copyVectorData(DataInputExportTaskResultDTO task, IGeoDataset srcGeoData, IGeoDataset targetGeoData, Map<String, String> fieldMap, IQueryFilter srcFilter) {
        TransferResult result;
        VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
        vectorDataTransfer.setIsErrorContinue(true);
        vectorDataTransfer.setFieldMap(fieldMap);
        vectorDataTransfer.setProgressCallback((sCount, eCount) -> {
            task.setSuccessCount((Long)sCount);
            task.setErrorCount((Long)eCount);
            double count = task.getTotalCount().longValue();
            if (count > 0.0) {
                double process = (double)(sCount + eCount) / count * 100.0;
                task.setProcess((long)process);
            }
        });
        vectorDataTransfer.setCountCallback(iCount -> task.setTotalCount((Long)iCount));
        vectorDataTransfer.setErrorCallback(msg -> task.setMessage((String)msg));
        if (targetGeoData.getType() == GeoDatasetType.FeatureClass) {
            result = vectorDataTransfer.copyFeature((IFeatureClass)srcGeoData, (IFeatureClass)targetGeoData, srcFilter);
        } else if (targetGeoData.getType() == GeoDatasetType.Table) {
            result = vectorDataTransfer.copyTable((ITable)srcGeoData, (ITable)targetGeoData, srcFilter);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + targetGeoData.getType());
        }
        return result;
    }

    protected TransferResult addRasterToMosaicDataset(IMosaicDataset targetMosaicDataset, IRasterDataset sourceRasterDataset) {
        TransferResult result = new TransferResult();
        String srcRasterPath = sourceRasterDataset.getRasterInfo().getRasterPath();
        try {
            IFeatureClass pFeatureClass = targetMosaicDataset.getCatalog();
            String whereClause = "urihash = '" + srcRasterPath + "'";
            QueryFilter filterProp = new QueryFilter();
            filterProp.setWhereClause(whereClause);
            if (pFeatureClass.featureCount((IQueryFilter)filterProp) > 0L) {
                result.setSuccess(true);
                result.setErrorMessage(srcRasterPath + "\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8df3\u8fc7\u4e0d\u5165\u5e93\uff01");
                return result;
            }
            boolean isValid = targetMosaicDataset.addRaster(sourceRasterDataset, true);
            if (!isValid) {
                result.setSuccess(false);
                result.setErrorMessage(srcRasterPath + "\u5199\u5165\u6805\u683c\u6570\u636e\u5931\u8d25");
            }
            targetMosaicDataset.updateRasterStorageInfo(sourceRasterDataset.getRasterInfo().getStorageInfo());
            result.setSuccess(true);
            return result;
        }
        catch (Exception e) {
            log.error(srcRasterPath + " \u5bfc\u5165\u5931\u8d25", (Throwable)e);
            result.setSuccess(false);
            result.setErrorMessage(srcRasterPath + " \u5bfc\u5165\u5931\u8d25:" + e.getMessage());
            return result;
        }
    }

    private ITable createDataset(ITable srcDataset, boolean isFeature, IFeatureWorkspace tarWorkspace, String tarFcName, Map<String, String> fieldMap) {
        isFeature = isFeature && srcDataset instanceof IFeatureClass;
        Fields newFields = new Fields();
        for (int i = 0; i < srcDataset.getFields().getFieldCount(); ++i) {
            IField tempField = srcDataset.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.OID) {
                newFields.addField(tempField);
                continue;
            }
            if (tempField.getFieldType() == FieldType.Shape) {
                if (!isFeature) continue;
                ISpatialReferenceSystem tarSR = ((IFeatureClass)srcDataset).getSpatialReferenceSystem();
                ((GeometryField)tempField).setSpatialReferenceSystem(tarSR);
                newFields.addField(tempField);
                continue;
            }
            if (fieldMap != null && fieldMap.size() > 0) {
                tempField.setName(fieldMap.get(tempField.getName()));
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        if (isFeature) {
            IFeatureClass srcFc = (IFeatureClass)srcDataset;
            IFeatureClass iFeatClass = tarWorkspace.createFeatureClass(tarFcName, (IFields)newFields, srcFc.getFeatureType(), srcFc.getShapeFieldName(), srcFc.getSubTypeFieldName());
            if (iFeatClass != null) {
                iFeatClass.createSpatialIndex();
            }
            return (ITable)iFeatClass;
        }
        ITable iTable = tarWorkspace.createTable(tarFcName, (IFields)newFields);
        return iTable;
    }

    private DatasetRenderDTO publishVectorService(String datasetId, String name, DataInputExportTaskResultDTO task) {
        try {
            String serviceName;
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
            if (datasetDTO.getRender() != null && Boolean.TRUE.equals(datasetDTO.getRender().getIsCreate())) {
                serviceName = datasetDTO.getRender().getServiceName();
            } else {
                serviceName = PinyinUtil.convertToPinYin((String)name).toLowerCase(Locale.ROOT);
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
            }
            VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
            serviceCreateDTO.setServiceName(serviceName);
            serviceCreateDTO.setDatasetId(datasetId);
            return this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
        }
        catch (Exception e) {
            log.error("\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)e);
            task.setStatus(ExcuteStatus.Failed.name());
            task.appendMsg("\u77e2\u91cf\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff0c" + e.getMessage());
            return null;
        }
    }

    protected void publishRasterService(String datasetId, String name, DataInputExportTaskResultDTO task) {
        try {
            String serviceName;
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
            if (datasetDTO.getRender() != null && Boolean.TRUE.equals(datasetDTO.getRender().getIsCreate())) {
                serviceName = datasetDTO.getRender().getServiceName();
            } else {
                serviceName = PinyinUtil.convertToPinYin((String)name);
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
            }
            IMEServiceCreateDTO serviceCreateDTO = new IMEServiceCreateDTO();
            serviceCreateDTO.setServiceName(serviceName);
            serviceCreateDTO.setDatasetId(datasetId);
            this.renderIndexService.createRasterRenderIndex(serviceCreateDTO);
        }
        catch (Exception e) {
            log.error("\u6805\u683c\u670d\u52a1\u53d1\u5e03\u5931\u8d25", (Throwable)e);
            task.setStatus(ExcuteStatus.Failed.name());
            task.appendMsg("\u6805\u683c\u670d\u52a1\u53d1\u5e03\u5931\u8d25\uff0c" + e.getMessage());
        }
    }
}

