/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.SystemUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsBackupDao;
import com.geoway.adf.dms.datasource.dto.backup.BackupDataSourceDTO;
import com.geoway.adf.dms.datasource.dto.backup.BackupDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.entity.DsBackup;
import com.geoway.adf.dms.datasource.service.DataSourceBackupService;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class DataSourceBackupServiceImpl
implements DataSourceBackupService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceBackupServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DsBackupDao dsBackupDao;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static List<String> inBackup = new ArrayList<String>();

    @Override
    public List<DataSourceDTO> listDataSource(List<DataStoreTypeEnum> dataStoreTypes, String keyword) {
        ArrayList<DataSourceDTO> result = new ArrayList<DataSourceDTO>();
        ArrayList<DataSourceTypeEnum> sourceTypes = new ArrayList<DataSourceTypeEnum>();
        sourceTypes.add(DataSourceTypeEnum.PostgreSql);
        sourceTypes.add(DataSourceTypeEnum.ShareFolder);
        List<DataSourceDTO> dataSourceList = this.dataSourceService.listDataSource(dataStoreTypes, sourceTypes, keyword);
        String backupDir = Paths.get(EnvironmentConfig.getProperty((String)"project.backup-path", (String)"backup"), new String[0]).toAbsolutePath().toString();
        List<DsBackup> dsBackupList = this.dsBackupDao.queryLatest();
        dataSourceList.forEach(item -> {
            DsBackup dsBackup;
            DataSourceTypeEnum dataSourceType = DataSourceTypeEnum.getByValue(item.getDataSourceType());
            String backupState = "";
            Date backupTime = null;
            if (dsBackupList != null && dsBackupList.size() > 0 && (dsBackup = (DsBackup)ListUtil.find((List)dsBackupList, f -> item.getKey().equals(f.getDsKey()))) != null) {
                backupTime = dsBackup.getBackupTime();
                backupState = "\u5df2\u5b8c\u6210";
            }
            if (inBackup.contains(item.getKey())) {
                backupState = "\u5907\u4efd\u4e2d";
            }
            switch (dataSourceType) {
                case PostgreSql: {
                    BackupDatabaseDTO backupDataSource = new BackupDatabaseDTO();
                    BeanUtils.copyProperties((Object)item, (Object)backupDataSource);
                    backupDataSource.setBackupDir(backupDir);
                    backupDataSource.setBackupState(backupState);
                    backupDataSource.setBackupTime(backupTime);
                    result.add(backupDataSource);
                    break;
                }
                case ShareFolder: {
                    BackupDataSourceDTO backupDataSource = new BackupDataSourceDTO();
                    BeanUtils.copyProperties((Object)item, (Object)backupDataSource);
                    backupDataSource.setBackupDir(backupDir);
                    backupDataSource.setBackupState(backupState);
                    backupDataSource.setBackupTime(backupTime);
                    result.add(backupDataSource);
                    break;
                }
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean backup(String dsKey, String targetDir) {
        if (inBackup.contains(dsKey)) {
            throw new RuntimeException("\u5907\u4efd\u4e2d\u7684\u4e0d\u80fd\u8fdb\u884c\u5907\u4efd\uff01");
        }
        try {
            DataSourceDTO dataSource = this.dataSourceService.getDataSourceDetail(dsKey);
            DataSourceTypeEnum dataSourceType = DataSourceTypeEnum.getByValue(dataSource.getDataSourceType());
            if (StringUtil.isEmptyOrWhiteSpace((String)targetDir)) {
                targetDir = Paths.get(EnvironmentConfig.getProperty((String)"project.backup-path", (String)"backup"), new String[0]).toAbsolutePath().toString();
            }
            Date backupDate = new Date();
            switch (dataSourceType) {
                case PostgreSql: {
                    Path pgsqlPath = Paths.get(EnvironmentConfig.getProperty((String)"project.tool-path", (String)""), new String[0]).toAbsolutePath();
                    Path pgsqlBinPath = Paths.get(pgsqlPath.toString(), "pgsql", "bin");
                    if (!pgsqlPath.toFile().exists()) {
                        throw new RuntimeException("\u672a\u914d\u7f6epgsql\u5907\u4efd\u5de5\u5177");
                    }
                    File dir = new File(targetDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    DatabaseDTO databaseDTO = (DatabaseDTO)dataSource;
                    String fileName = databaseDTO.getDbName() + DateTimeUtil.dateString((Date)backupDate, (String)"yyyyMMddHHmmss");
                    String pgBackupDir = targetDir;
                    if (!SystemUtil.isWindows()) {
                        throw new RuntimeException("\u4ec5\u652f\u6301Windows\u5e73\u53f0");
                    }
                    this.threadPoolTaskExecutorData.execute(() -> this.backupPostgreSql(dataSource, pgBackupDir, fileName, backupDate, pgsqlBinPath, databaseDTO));
                    Boolean bl = true;
                    return bl;
                }
                case ShareFolder: {
                    String dirName = FileUtil.getFileName((String)dataSource.getUrl()) + DateTimeUtil.dateString((Date)backupDate, (String)"yyyyMMddHHmmss");
                    String shareFolderBackupDir = Paths.get(targetDir, dirName).toString();
                    File sourceDir = new File(dataSource.getUrl());
                    if (!sourceDir.exists()) {
                        throw new RuntimeException("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff1a" + sourceDir);
                    }
                    DsBackup record = new DsBackup();
                    record.setDsKey(dataSource.getKey());
                    record.setBackupPath(shareFolderBackupDir);
                    record.setBackupTime(backupDate);
                    this.dsBackupDao.insert(record);
                    this.threadPoolTaskExecutorData.execute(() -> this.backupShareFolder(dataSource, shareFolderBackupDir));
                    Boolean bl = true;
                    return bl;
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            inBackup.remove(dsKey);
        }
    }

    @Override
    public List<DsBackup> listBackupRecords(String dsKey) {
        return this.dsBackupDao.selectByDsKey(dsKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPostgreSql(DataSourceDTO dataSource, String targetDir, String fileName, Date backupDate, Path pgsqlPath, DatabaseDTO databaseDTO) {
        inBackup.add(dataSource.getKey());
        try {
            if (SystemUtil.isWindows()) {
                String line;
                String backupFilePath = Paths.get(targetDir, fileName + ".sql").toString();
                DsBackup record = new DsBackup();
                record.setDsKey(dataSource.getKey());
                record.setBackupPath(backupFilePath);
                record.setBackupTime(backupDate);
                this.dsBackupDao.insert(record);
                File backupFile = new File(backupFilePath);
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                String user = databaseDTO.getUserName().replaceAll("[\\\\\"]", "\\\\$0");
                String password = databaseDTO.getPassword().replaceAll("[\\\\\"]", "\\\\$0");
                String dbName = databaseDTO.getDbName().replaceAll("[\\\\\"]", "\\\\$0");
                String arguments = String.format("-F p -b \"host=%s port=%s user=%s password=%s dbname=%s\" >%s", databaseDTO.getHost(), databaseDTO.getPort(), user, password, dbName, backupFilePath);
                String root = pgsqlPath.toString().substring(0, 1);
                String cmd = String.format("%s:&cd %s&pg_dump %s", root, pgsqlPath, arguments);
                ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", cmd);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "GBK"));
                Path logFilePath = Paths.get(targetDir, fileName + "_log.txt");
                if (logFilePath.toFile().exists()) {
                    logFilePath.toFile().delete();
                }
                logFilePath.toFile().createNewFile();
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFilePath.toString()), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                }
                process.waitFor();
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            inBackup.remove(dataSource.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupShareFolder(DataSourceDTO dataSource, String targetDir) {
        inBackup.add(dataSource.getKey());
        try {
            FileUtil.copy((String)dataSource.getUrl(), (String)targetDir);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            inBackup.remove(dataSource.getKey());
        }
    }
}

