/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsStatisticDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.entity.DsStatistic;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceStatisticService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.TileDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class DatasetStatisticServiceImpl
implements DataSourceStatisticService {
    private static final Logger log = LoggerFactory.getLogger(DatasetStatisticServiceImpl.class);
    @Resource
    private DsStatisticDao statisticDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private TileDatabaseService tileDatabaseService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static List<String> runningDataSourceList = Collections.synchronizedList(new ArrayList());

    @Override
    public void dataSourceStatistic(String dsKey) {
        if (StringUtil.isEmpty((String)dsKey)) {
            ArrayList<DataStoreTypeEnum> dataStoreTypeEnums = new ArrayList<DataStoreTypeEnum>();
            dataStoreTypeEnums.add(DataStoreTypeEnum.GeoDatabase);
            dataStoreTypeEnums.add(DataStoreTypeEnum.DatumDatabase);
            dataStoreTypeEnums.add(DataStoreTypeEnum.ModelDatabase);
            dataStoreTypeEnums.add(DataStoreTypeEnum.NoSQLDatabase);
            List<DataSourceDTO> dataSourceDTOS = this.dataSourceManager.listDataSourceWithPassword(dataStoreTypeEnums, null);
            dataSourceDTOS.forEach(this::statDataSource);
        } else {
            if (runningDataSourceList.contains(dsKey)) {
                throw new RuntimeException("\u6570\u636e\u6e90\u6b63\u5728\u6267\u884c\u7edf\u8ba1");
            }
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
            this.statDataSource(dataSourceDTO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DsStatistic datasetStatistic(String datasetId) {
        if (StringUtil.isEmptyOrWhiteSpace((String)datasetId)) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u8981\u7edf\u8ba1\u7684\u6570\u636e\u96c6\uff01");
        }
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(nameInfo.getDsKey());
        switch (DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType())) {
            case GeoDatabase: {
                try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
                    IGeoDataset geoDataset = featureWorkspace.openGeoDataset(nameInfo.getName());
                    DsStatistic dsStatistic = this.statGeoDataset(dataSourceDTO, geoDataset);
                    return dsStatistic;
                }
            }
            case DatumDatabase: 
            case ModelDatabase: {
                try (IFeatureWorkspace geoWorkspace = GeoDatabaseUtil.openGeoDatabase(((DatumDatabaseDTO)dataSourceDTO).getGeoDatabase());){
                    DsStatistic dsStatistic = this.statDatumDataset((DatumDatabaseDTO)dataSourceDTO, geoWorkspace, datasetId);
                    return dsStatistic;
                }
            }
            case NoSQLDatabase: {
                if (dataSourceDTO.getDataSourceType().intValue() != DataSourceTypeEnum.MongoDB.getValue()) break;
                try (ITileDataSource tileDataSource = null;){
                    tileDataSource = this.tileDatabaseService.openTileDataSource(dataSourceDTO);
                    DsStatistic dsStatistic = this.statTileDataset(tileDataSource, datasetId);
                    return dsStatistic;
                }
            }
        }
        return null;
    }

    @Override
    public void dataSourceStatisticAsync(String dsKey) {
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutor.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            this.dataSourceStatistic(dsKey);
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
    }

    @Override
    public List<String> listRunningDataSource() {
        return runningDataSourceList;
    }

    @Override
    public List<DsStatistic> listStatistic(String dsKey) {
        return this.statisticDao.selectByDsKey(dsKey);
    }

    @Override
    public DsStatistic getDataStatistic(String datasetId) {
        return this.statisticDao.selectByPrimaryKey(datasetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void statDataSource(DataSourceDTO dataSourceDTO) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (runningDataSourceList.contains(dataSourceDTO.getKey())) {
                return;
            }
            runningDataSourceList.add(dataSourceDTO.getKey());
        }
        try {
            switch (DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType())) {
                case GeoDatabase: {
                    this.statGeoDatabase(dataSourceDTO);
                    return;
                }
                case NoSQLDatabase: {
                    this.statTileDatabase(dataSourceDTO);
                    return;
                }
                case FileStorageSystem: {
                    return;
                }
                case ServiceServer: {
                    return;
                }
                case DatumDatabase: 
                case ModelDatabase: {
                    this.statDatumDatabase((DatumDatabaseDTO)dataSourceDTO);
                    return;
                }
                case GraphDatabase: {
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.error(dataSourceDTO.getName() + " \u7edf\u8ba1\u5931\u8d25", (Throwable)e);
            return;
        }
        finally {
            runningDataSourceList.remove(dataSourceDTO.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statGeoDatabase(DataSourceDTO dataSourceDTO) {
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            List allDatasets = featureWorkspace.getDatasets();
            for (IGeoDataset geoDataset : allDatasets) {
                try {
                    this.statGeoDataset(dataSourceDTO, geoDataset);
                }
                catch (Exception e) {
                    log.error(dataSourceDTO.getName() + "->" + geoDataset.getFullName() + " \u7edf\u8ba1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private DsStatistic statGeoDataset(DataSourceDTO dataSourceDTO, IGeoDataset geoDataset) {
        switch (geoDataset.getType()) {
            case GroupDataset: 
            case FeatureDataset: {
                if (geoDataset.getSubsets() == null) break;
                for (IGeoDataset subset : geoDataset.getSubsets()) {
                    this.statGeoDataset(dataSourceDTO, subset);
                }
                break;
            }
            case FeatureClass: 
            case Table: 
            case MosaicDataset: {
                long count = geoDataset instanceof ITable ? ((ITable)geoDataset).count(null) : geoDataset.getDataCount().longValue();
                long size = geoDataset.getDataSize();
                DsStatistic dsStatistic = new DsStatistic();
                dsStatistic.setId(GeoDatasetUtil.getGeoDatasetId(dataSourceDTO.getKey(), geoDataset));
                dsStatistic.setDsKey(dataSourceDTO.getKey());
                dsStatistic.setName(geoDataset.getName());
                dsStatistic.setType(GeoDatasetUtil.convertDatasetType(geoDataset.getType()).getValue());
                dsStatistic.setDataCount(count);
                dsStatistic.setDataSize(size);
                dsStatistic.setUpdateTime(new Date());
                this.statisticDao.deleteByPrimaryKey(dsStatistic.getId());
                this.statisticDao.insert(dsStatistic);
                return dsStatistic;
            }
            case TableView: {
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statDatumDatabase(DatumDatabaseDTO dataSourceDTO) {
        List<SimpleDatasetDTO> datasetDTOS = this.datumDatabaseService.listDatasets(dataSourceDTO);
        if (datasetDTOS.size() == 0) {
            return;
        }
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO.getGeoDatabase());){
            for (SimpleDatasetDTO datasetDTO : datasetDTOS) {
                try {
                    this.statDatumDataset(dataSourceDTO, featureWorkspace, datasetDTO.getId());
                }
                catch (Exception e) {
                    log.error(dataSourceDTO.getName() + "->" + datasetDTO.getFullName() + " \u7edf\u8ba1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private DsStatistic statDatumDataset(DatumDatabaseDTO dataSourceDTO, IFeatureWorkspace featureWorkspace, String datasetId) {
        String sqlSize;
        Object valueSize;
        String geoDatasetId = this.datumDatabaseService.getGeoDatasetId(datasetId);
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo(geoDatasetId);
        String datasetName = nameInfo.getName();
        if (nameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
            datasetName = "GWMD_" + nameInfo.getShortName() + "_CAT";
        }
        long count = 0L;
        long size = 0L;
        String sqlCount = "select count(*) from " + datasetName;
        Object valueCount = featureWorkspace.queryScalar(sqlCount, new Object[0]);
        if (valueCount != null) {
            count = Long.parseLong(valueCount.toString());
        }
        if ((valueSize = featureWorkspace.queryScalar(sqlSize = "select sum(F_DATASIZE) from " + datasetName, new Object[0])) != null) {
            size = Long.parseLong(valueSize.toString());
        }
        DsStatistic dsStatistic = new DsStatistic();
        dsStatistic.setId(datasetId);
        dsStatistic.setDsKey(dataSourceDTO.getKey());
        dsStatistic.setName(datasetName);
        dsStatistic.setType(DatasetTypeEnum.DatumDataset.getValue());
        dsStatistic.setDataCount(count);
        dsStatistic.setDataSize(size);
        dsStatistic.setUpdateTime(new Date());
        this.statisticDao.deleteByPrimaryKey(dsStatistic.getId());
        this.statisticDao.insert(dsStatistic);
        return dsStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statTileDatabase(DataSourceDTO dataSourceDTO) {
        List<SimpleDatasetDTO> datasetDTOS = this.tileDatabaseService.listDatasets(dataSourceDTO);
        if (datasetDTOS.size() == 0) {
            return;
        }
        try (ITileDataSource tileDataSource = this.tileDatabaseService.openTileDataSource(dataSourceDTO);){
            for (SimpleDatasetDTO datasetDTO : datasetDTOS) {
                try {
                    this.statTileDataset(tileDataSource, datasetDTO.getId());
                }
                catch (Exception e) {
                    log.error(dataSourceDTO.getName() + "->" + datasetDTO.getFullName() + " \u7edf\u8ba1\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private DsStatistic statTileDataset(ITileDataSource tileDataSource, String datasetId) {
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        ITileDataset tileDataset = tileDataSource.getDataset(nameInfo.getName());
        if (tileDataset == null) {
            return null;
        }
        long count = tileDataset.getDataCount();
        long size = tileDataset.getDataSize();
        DsStatistic dsStatistic = new DsStatistic();
        dsStatistic.setId(datasetId);
        dsStatistic.setDsKey(nameInfo.getDsKey());
        dsStatistic.setName(nameInfo.getName());
        dsStatistic.setType(nameInfo.getType());
        dsStatistic.setDataCount(count);
        dsStatistic.setDataSize(size);
        dsStatistic.setUpdateTime(new Date());
        this.statisticDao.deleteByPrimaryKey(dsStatistic.getId());
        this.statisticDao.insert(dsStatistic);
        return dsStatistic;
    }
}

