/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.graph.DatabaseQueryResultDTO;
import com.geoway.adf.dms.datasource.dto.graph.GraphDatabaseDetailDTO;
import com.geoway.adf.dms.datasource.dto.graph.GraphLabelDTO;
import com.geoway.adf.dms.datasource.dto.graph.LabelDTO;
import com.geoway.adf.dms.datasource.dto.graph.RelationDTO;
import com.geoway.adf.dms.datasource.entity.DsGraphLabel;
import com.geoway.adf.dms.datasource.service.GraphDatabaseService;
import com.geoway.adf.dms.datasource.service.GraphLabelService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GraphDatabaseServiceImpl
implements GraphDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(GraphDatabaseServiceImpl.class);
    @Resource
    private GraphLabelService graphLabelService;

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.Neo4j.getValue()) {
            try (Driver driver = GraphDatabase.driver((String)dataSourceDTO.getUrl(), (AuthToken)AuthTokens.basic((String)dataSourceDTO.getUserName(), (String)dataSourceDTO.getPassword()));){
                driver.verifyConnectivity();
                boolean bl = true;
                return bl;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u56fe\u5e93\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
    }

    @Override
    public GraphDatabaseDetailDTO getDetail(DataSourceDTO dataSourceDTO) {
        GraphDatabaseDetailDTO detail = new GraphDatabaseDetailDTO();
        try (Driver driver = this.getNeo4jDriver(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());){
            Session session = driver.session();
            detail.setLabelTypes(this.getTypes(session, "CALL db.labels()"));
            detail.setRelationTypes(this.getTypes(session, "CALL db.relationshipTypes"));
            detail.setLabelCont(this.getCount(session, "MATCH (n) RETURN COUNT(n)"));
            detail.setRelationCount(this.getCount(session, "MATCH ()-[r]->() RETURN COUNT(r)"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
        }
        return detail;
    }

    @Override
    public GraphDatabaseDetailDTO getDetail(DataSourceDTO dataSourceDTO, Boolean withLabelAliasName) {
        GraphDatabaseDetailDTO detailDTO = this.getDetail(dataSourceDTO);
        if (Boolean.TRUE.equals(withLabelAliasName)) {
            DsGraphLabel graphLabel;
            List<DsGraphLabel> graphLabelList = this.graphLabelService.list(dataSourceDTO.getKey());
            ArrayList<GraphLabelDTO> graphLabels = new ArrayList<GraphLabelDTO>();
            for (String label : detailDTO.getLabelTypes()) {
                graphLabel = (DsGraphLabel)ListUtil.find(graphLabelList, f -> f.getName().equals(label) && f.getLabelType() == 0);
                graphLabels.add(this.createGraphLabelDTO(label, 0, graphLabel));
            }
            for (String label : detailDTO.getRelationTypes()) {
                graphLabel = (DsGraphLabel)ListUtil.find(graphLabelList, f -> f.getName().equals(label) && f.getLabelType() == 1);
                graphLabels.add(this.createGraphLabelDTO(label, 1, graphLabel));
            }
            detailDTO.setGraphLabels(graphLabels);
        }
        return detailDTO;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatabaseQueryResultDTO queryLabels(DataSourceDTO dataSourceDTO, String type, Integer limit, String keyword) {
        DatabaseQueryResultDTO queryResult = new DatabaseQueryResultDTO();
        ArrayList<LabelDTO> nodeList = new ArrayList<LabelDTO>();
        ArrayList<RelationDTO> relationList = new ArrayList<RelationDTO>();
        String cql = String.format("MATCH (n:`%s`) RETURN n LIMIT %d", type, limit);
        if (StringUtil.isEmptyOrWhiteSpace((String)type)) {
            cql = String.format("MATCH (n) RETURN n LIMIT %d", limit);
        }
        try (Driver driver = this.getNeo4jDriver(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());){
            Session session = driver.session();
            if (StringUtil.isNotEmpty((String)keyword)) {
                Long indexCount = this.getCount(session, "show indexes yield name where name = 'allFullIndex' return count(*)");
                if (indexCount < 1L) {
                    this.createFullTextIndex(dataSourceDTO);
                }
                if (keyword.length() == 1) {
                    keyword = String.format("*%s*", keyword);
                }
                cql = String.format("call db.index.fulltext.queryNodes('allFullIndex','%s') yield node return node limit %d", keyword, limit);
            }
            Result result = session.run(cql);
            while (result.hasNext()) {
                List values = result.next().values();
                for (Value value : values) {
                    if (value instanceof NodeValue) {
                        Node node = value.asNode();
                        LabelDTO labelDTO = this.convertNode(node);
                        if (nodeList.contains(labelDTO)) continue;
                        nodeList.add(labelDTO);
                        continue;
                    }
                    if (value instanceof RelationshipValue) {
                        Relationship relationship = value.asRelationship();
                        RelationDTO relationDTO = this.convertRelation(relationship);
                        if (relationList.contains(relationDTO)) continue;
                        relationList.add(relationDTO);
                        continue;
                    }
                    if (!(value instanceof PathValue)) continue;
                    Path path = value.asPath();
                    for (Node node : path.nodes()) {
                        LabelDTO labelDTO = this.convertNode(node);
                        if (nodeList.contains(labelDTO)) continue;
                        nodeList.add(labelDTO);
                    }
                    for (Relationship relationship : path.relationships()) {
                        RelationDTO relationDTO = this.convertRelation(relationship);
                        if (relationList.contains(relationDTO)) continue;
                        relationList.add(relationDTO);
                    }
                }
            }
            if (nodeList.size() > 0 && StringUtil.isNotEmpty((String)keyword)) {
                DatabaseQueryResultDTO relationResult;
                if (keyword.length() == 1) {
                    keyword = String.format("*%s*", keyword);
                }
                if ((relationResult = this.queryRelations(session, cql = String.format("call db.index.fulltext.queryNodes('allFullIndex','%s') yield node Match p=(node)-[*1..1]->() return p limit %d", keyword, limit))).getNodes() != null && relationResult.getNodes().size() > 0) {
                    DatabaseQueryResultDTO databaseQueryResultDTO = relationResult;
                    return databaseQueryResultDTO;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
        }
        queryResult.setNodes(nodeList);
        queryResult.setEdges(relationList);
        return queryResult;
    }

    @Override
    public DatabaseQueryResultDTO queryRelations(DataSourceDTO dataSourceDTO, String type, Integer limit) {
        DatabaseQueryResultDTO queryResult = new DatabaseQueryResultDTO();
        String cql = String.format("MATCH p=()-[r:`%s`]->() RETURN p LIMIT %d", type, limit);
        if (StringUtil.isEmptyOrWhiteSpace((String)type)) {
            cql = String.format("MATCH p=()-->() RETURN p LIMIT %d", limit);
        }
        try (Driver driver = this.getNeo4jDriver(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());){
            Session session = driver.session();
            queryResult = this.queryRelations(session, cql);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
        }
        return queryResult;
    }

    private DatabaseQueryResultDTO queryRelations(Session session, String cql) {
        DatabaseQueryResultDTO queryResult = new DatabaseQueryResultDTO();
        ArrayList<LabelDTO> nodeList = new ArrayList<LabelDTO>();
        ArrayList<RelationDTO> relationList = new ArrayList<RelationDTO>();
        Result result = session.run(cql);
        while (result.hasNext()) {
            List values = result.next().values();
            for (Value value : values) {
                Path path = value.asPath();
                for (Node node : path.nodes()) {
                    LabelDTO labelDTO = this.convertNode(node);
                    if (nodeList.contains(labelDTO)) continue;
                    nodeList.add(labelDTO);
                }
                for (Relationship relationship : path.relationships()) {
                    relationList.add(this.convertRelation(relationship));
                }
            }
        }
        queryResult.setNodes(nodeList);
        queryResult.setEdges(relationList);
        return queryResult;
    }

    private Driver getNeo4jDriver(String url, String userName, String password) {
        return GraphDatabase.driver((String)url, (AuthToken)AuthTokens.basic((String)userName, (String)password));
    }

    private List<String> getTypes(Session session, String cql) {
        ArrayList<String> types = new ArrayList<String>();
        Result result = session.run(cql);
        while (result.hasNext()) {
            List values = result.next().values();
            for (Value value : values) {
                types.add(value.asString());
            }
        }
        return types;
    }

    private Long getCount(Session session, String cql) {
        Long count = null;
        Result result = session.run(cql);
        while (result.hasNext()) {
            List values = result.next().values();
            count = ((Value)values.get(0)).asLong();
        }
        return count;
    }

    private LabelDTO convertNode(Node node) {
        LabelDTO labelDTO = new LabelDTO();
        labelDTO.setId(node.id() + "");
        ArrayList<String> labels = new ArrayList<String>();
        node.labels().forEach(labels::add);
        labelDTO.setTypes(labels);
        labelDTO.setProperties(node.asMap());
        return labelDTO;
    }

    private RelationDTO convertRelation(Relationship relationship) {
        RelationDTO relationDTO = new RelationDTO();
        relationDTO.setId(relationship.id() + "");
        relationDTO.setType(relationship.type());
        relationDTO.setSource(relationship.startNodeId() + "");
        relationDTO.setTarget(relationship.endNodeId() + "");
        relationDTO.setProperties(relationship.asMap());
        return relationDTO;
    }

    private void createFullTextIndex(DataSourceDTO dataSourceDTO) {
        try (Driver driver = this.getNeo4jDriver(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());){
            Session session = driver.session();
            List<String> labelTypes = this.getTypes(session, "CALL db.labels()");
            List<String> propertyTypes = this.getTypes(session, "CALL db.propertyKeys");
            String labels = String.join((CharSequence)"|", ListUtil.convertAll(labelTypes, f -> "`" + f + "`"));
            String propertyKeys = String.join((CharSequence)",", ListUtil.convertAll(propertyTypes, f -> "n." + f));
            String cql = String.format("create fulltext index allFullIndex for (n:%s) on each [%s] options{indexConfig:{`fulltext.analyzer`:'cjk'}}", labels, propertyKeys);
            session.run(cql);
        }
        catch (Exception e) {
            log.error("\u5168\u6587\u68c0\u7d22\u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
    }

    private GraphLabelDTO createGraphLabelDTO(String label, Integer type, DsGraphLabel graphLabel) {
        GraphLabelDTO dto = new GraphLabelDTO();
        dto.setName(label);
        dto.setType(type);
        if (graphLabel != null) {
            dto.setAliasName(graphLabel.getAliasName());
        } else {
            dto.setAliasName(label);
        }
        return dto;
    }
}

