/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;

public class FieldUtil {
    public static IField convertField(FieldDTO fieldDTO) {
        Field sFld = new Field();
        sFld.setName(fieldDTO.getName().trim());
        sFld.setAliasName(StringUtil.isEmpty((String)fieldDTO.getAliasName()) ? fieldDTO.getName() : fieldDTO.getAliasName());
        sFld.setFieldType(FieldType.getByValue((Integer)fieldDTO.getFieldType()));
        sFld.setNullable(Boolean.valueOf(fieldDTO.getNullable() != null && fieldDTO.getNullable() != false));
        sFld.setDefaultValue((Object)fieldDTO.getDefaultValue());
        sFld.setLength(fieldDTO.getLength());
        sFld.setScale(fieldDTO.getScale());
        return sFld;
    }

    public static FieldDTO convertField(IField iField) {
        FieldDTO fieldDTO = new FieldDTO();
        fieldDTO.setName(iField.getName().trim());
        fieldDTO.setPhysicalName(iField.getPhysicalName());
        fieldDTO.setAliasName(iField.getAliasName());
        fieldDTO.setFieldType(Integer.valueOf(iField.getFieldType().getValue()));
        fieldDTO.setNullable(iField.getNullable());
        fieldDTO.setDefaultValue(iField.getDefaultValue() == null ? null : iField.getDefaultValue().toString());
        if (iField.getLength() != null && iField.getLength() > 0) {
            fieldDTO.setLength(iField.getLength());
        }
        if (iField.getScale() != null && iField.getScale() > 0) {
            fieldDTO.setScale(iField.getScale());
        }
        return fieldDTO;
    }

    public static IField buildObjectIdField(String name, String aliasName) {
        Field oidFld = new Field();
        oidFld.setName(name.trim());
        oidFld.setAliasName(StringUtil.isEmpty((String)aliasName) ? name : aliasName);
        oidFld.setFieldType(FieldType.OID);
        return oidFld;
    }

    public static IField buildShapeField(String name, String aliasName, GeometryType geometryType, int srid) {
        GeometryField geoField = new GeometryField();
        geoField.setName(name.trim());
        geoField.setAliasName(StringUtil.isEmpty((String)aliasName) ? name : aliasName);
        geoField.setFieldType(FieldType.Shape);
        geoField.setGeometryType(geometryType);
        geoField.setSpatialReferenceSystem(SpatialReferenceSystemFunc.createSpatialReference((int)srid));
        return geoField;
    }

    public static String getFieldTypeStr(FieldType fieldType) {
        switch (fieldType) {
            case Boolean: {
                return "\u5e03\u5c14\u578b";
            }
            case Byte: {
                return "\u5b57\u8282\u578b";
            }
            case DateTime: {
                return "\u65e5\u671f\u578b";
            }
            case Decimal: {
                return "\u9ad8\u7cbe\u5ea6\u578b";
            }
            case Double: {
                return "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b";
            }
            case Short: {
                return "\u77ed\u6574\u578b";
            }
            case Int: {
                return "\u6574\u578b";
            }
            case Long: {
                return "\u957f\u6574\u578b";
            }
            case Float: {
                return "\u5355\u7cbe\u5ea6\u6d6e\u70b9\u578b";
            }
            case String: {
                return "\u5b57\u7b26\u578b";
            }
            case Blob: {
                return "\u4e8c\u8fdb\u5236";
            }
            case Text: {
                return "\u6587\u672c\u578b";
            }
            case Shape: {
                return "\u51e0\u4f55\u578b";
            }
            case OID: {
                return "\u4e3b\u952eId";
            }
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    public static FieldType getFieldTypeByStr(String typeStr) {
        FieldType fieldType = FieldType.String;
        if (StringUtil.isNotEmpty((String)typeStr)) {
            switch (typeStr = typeStr.replace(" ", "")) {
                case "\u5e03\u5c14\u578b": {
                    fieldType = FieldType.Boolean;
                    break;
                }
                case "\u5b57\u8282\u578b": {
                    fieldType = FieldType.Byte;
                    break;
                }
                case "\u77ed\u6574\u578b": {
                    fieldType = FieldType.Short;
                    break;
                }
                case "\u6574\u578b": {
                    fieldType = FieldType.Int;
                    break;
                }
                case "\u957f\u6574\u578b": {
                    fieldType = FieldType.Long;
                    break;
                }
                case "\u6d6e\u70b9\u578b": 
                case "\u5355\u7cbe\u5ea6\u6d6e\u70b9\u578b": {
                    fieldType = FieldType.Float;
                    break;
                }
                case "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b": {
                    fieldType = FieldType.Double;
                    break;
                }
                case "\u9ad8\u7cbe\u5ea6\u578b": {
                    fieldType = FieldType.Decimal;
                    break;
                }
                case "\u65e5\u671f": 
                case "\u65e5\u671f\u578b": {
                    fieldType = FieldType.DateTime;
                    break;
                }
                case "\u5b57\u7b26": 
                case "\u5b57\u7b26\u4e32": 
                case "\u5b57\u7b26\u578b": {
                    fieldType = FieldType.String;
                    break;
                }
                case "\u6587\u672c\u578b": {
                    fieldType = FieldType.Text;
                    break;
                }
                case "\u4e8c\u8fdb\u5236": {
                    fieldType = FieldType.Blob;
                    break;
                }
                case "\u51e0\u4f55\u578b": {
                    fieldType = FieldType.Shape;
                    break;
                }
                case "\u4e3b\u952eId": {
                    fieldType = FieldType.OID;
                    break;
                }
            }
        }
        return fieldType;
    }
}

