/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.SpatialRefDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.GroupDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableViewDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IGroupDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoDatasetUtil {
    private static final Logger log = LoggerFactory.getLogger(GeoDatasetUtil.class);

    public static String getGeoDatasetId(String dsKey, IGeoDataset dataset) {
        int idx = dataset.getFullName().indexOf(".");
        String oldFullName = idx > 0 ? dataset.getFullName().substring(0, idx) + "." + dataset.getName() : dataset.getFullName();
        return DatasetUtil.getDatasetId(dsKey, GeoDatasetUtil.convertDatasetType(dataset.getType()), oldFullName);
    }

    public static IGeoDataset openDataset(IFeatureWorkspace workspace, GeoDatasetType datasetType, String name) {
        switch (datasetType) {
            case GroupDataset: {
                return workspace.openGroupDataset(name);
            }
            case FeatureDataset: {
                return workspace.openFeatureDataset(name);
            }
            case FeatureClass: {
                return workspace.openFeatureClass(name);
            }
            case Table: {
                return workspace.openTable(name);
            }
            case TableView: {
                return workspace.openTableView(name);
            }
            case MosaicDataset: {
                return workspace.openMosaicDataset(name);
            }
        }
        return workspace.openGeoDataset(name);
    }

    public static SimpleDatasetDTO getSimpleDatasetDTO(String dsKey, IGeoDataset dataset) {
        return GeoDatasetUtil.getSimpleDatasetDTO(dsKey, dataset, true);
    }

    public static SimpleDatasetDTO getSimpleDatasetDTO(String dsKey, IGeoDataset dataset, boolean containSubsets) {
        try {
            SimpleDatasetDTO datasetDTO;
            switch (dataset.getType()) {
                case GroupDataset: {
                    IGroupDataset groupDataset = (IGroupDataset)dataset;
                    datasetDTO = new SimpleDatasetDTO();
                    if (!containSubsets) break;
                    ArrayList<SimpleDatasetDTO> subDatasetDTOs = new ArrayList<SimpleDatasetDTO>();
                    for (IGeoDataset subset : groupDataset.getSubsets()) {
                        subDatasetDTOs.add(GeoDatasetUtil.getSimpleDatasetDTO(dsKey, subset));
                    }
                    datasetDTO.setSubsets(subDatasetDTOs);
                    break;
                }
                case FeatureDataset: {
                    IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                    datasetDTO = new SimpleDatasetDTO();
                    if (!containSubsets) break;
                    ArrayList<SimpleDatasetDTO> subDatasetDTOs = new ArrayList<SimpleDatasetDTO>();
                    for (IGeoDataset subset : featureDataset.getSubsets()) {
                        subDatasetDTOs.add(GeoDatasetUtil.getSimpleDatasetDTO(dsKey, subset));
                    }
                    datasetDTO.setSubsets(subDatasetDTOs);
                    break;
                }
                case FeatureClass: {
                    IFeatureClass featureClass = (IFeatureClass)dataset;
                    datasetDTO = new SimpleDatasetDTO();
                    datasetDTO.setFeatureType(featureClass.getFeatureType().getValue());
                    break;
                }
                case TableView: {
                    ITableView tableView = (ITableView)dataset;
                    datasetDTO = new SimpleDatasetDTO();
                    if (tableView.getFeatureType().getValue() <= FeatureType.Unknown.getValue()) break;
                    datasetDTO.setFeatureType(tableView.getFeatureType().getValue());
                    break;
                }
                default: {
                    datasetDTO = new SimpleDatasetDTO();
                }
            }
            datasetDTO.setId(GeoDatasetUtil.getGeoDatasetId(dsKey, dataset));
            datasetDTO.setName(dataset.getName());
            datasetDTO.setFullName(dataset.getFullName());
            datasetDTO.setAliasName(dataset.getAliasName());
            datasetDTO.setType(GeoDatasetUtil.convertDatasetType(dataset.getType()).getValue());
            return datasetDTO;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u96c6{}\u8f6c\u6362\u5f02\u5e38\uff1a", (Object)dataset.getName(), (Object)e);
            return null;
        }
    }

    public static DatasetDTO getGeoDatasetDTO(String dsKey, IGeoDataset dataset) {
        try {
            DatasetDTO datasetDTO;
            switch (dataset.getType()) {
                case GroupDataset: {
                    IGroupDataset groupDataset = (IGroupDataset)dataset;
                    GroupDatasetDTO groupDatasetDTO = new GroupDatasetDTO();
                    ArrayList<DatasetDTO> subDatasetDTOs = new ArrayList<DatasetDTO>();
                    for (IGeoDataset subset : groupDataset.getSubsets()) {
                        subDatasetDTOs.add(GeoDatasetUtil.getGeoDatasetDTO(dsKey, subset));
                    }
                    groupDatasetDTO.setSubsets(subDatasetDTOs);
                    datasetDTO = groupDatasetDTO;
                    break;
                }
                case FeatureDataset: {
                    IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                    FeatureDatasetDTO featureDatasetDTO = new FeatureDatasetDTO();
                    featureDatasetDTO.setSpatialRef(GeoDatasetUtil.toSpatialRefDTO(featureDataset.getSpatialReferenceSystem()));
                    ArrayList<DatasetDTO> subDatasetDTOs = new ArrayList<DatasetDTO>();
                    for (IGeoDataset subset : featureDataset.getSubsets()) {
                        subDatasetDTOs.add(GeoDatasetUtil.getGeoDatasetDTO(dsKey, subset));
                    }
                    featureDatasetDTO.setSubsets(subDatasetDTOs);
                    datasetDTO = featureDatasetDTO;
                    break;
                }
                case FeatureClass: {
                    IFeatureClass featureClass = (IFeatureClass)dataset;
                    FeatureClassDTO featureClassDTO = new FeatureClassDTO();
                    featureClassDTO.setFeatureType(featureClass.getFeatureType().getValue());
                    featureClassDTO.setExtent(GeoDatasetUtil.toExtentDTO(featureClass.getExtent()));
                    featureClassDTO.setSpatialRef(GeoDatasetUtil.toSpatialRefDTO(featureClass.getSpatialReferenceSystem()));
                    featureClassDTO.setOidField(featureClass.getOidFieldName());
                    featureClassDTO.setShapeField(featureClass.getShapeFieldName());
                    if (StringUtil.isNotEmpty((String)featureClass.getParentDatasetName())) {
                        String parentFullName = featureClass.getParentDatasetName();
                        int index = dataset.getFullName().indexOf(".");
                        if (index > 0) {
                            String schema = dataset.getFullName().substring(0, index);
                            parentFullName = schema + "." + featureClass.getParentDatasetName();
                        }
                        featureClassDTO.setParentId(DatasetUtil.getDatasetId(dsKey, DatasetTypeEnum.FeatureDataset, parentFullName));
                    }
                    datasetDTO = featureClassDTO;
                    break;
                }
                case Table: {
                    ITable table = (ITable)dataset;
                    TableDatasetDTO tableDatasetDTO = new TableDatasetDTO();
                    tableDatasetDTO.setOidField(table.getOidFieldName());
                    datasetDTO = tableDatasetDTO;
                    break;
                }
                case TableView: {
                    ITableView tableView = (ITableView)dataset;
                    TableViewDTO tableViewDTO = new TableViewDTO();
                    if (tableView.getFeatureType().getValue() > FeatureType.Unknown.getValue()) {
                        tableViewDTO.setFeatureType(tableView.getFeatureType().getValue());
                    }
                    datasetDTO = tableViewDTO;
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = (IMosaicDataset)dataset;
                    MosaicDatasetDTO mosaicDatasetDTO = new MosaicDatasetDTO();
                    mosaicDatasetDTO.setSpatialRef(GeoDatasetUtil.toSpatialRefDTO(mosaicDataset.getSpatialReferenceSystem()));
                    mosaicDatasetDTO.setExtent(GeoDatasetUtil.toExtentDTO(mosaicDataset.getExtent()));
                    if (mosaicDataset.getRasterInfo() != null) {
                        mosaicDatasetDTO.setBandCount(mosaicDataset.getRasterInfo().getBandCount());
                        mosaicDatasetDTO.setPixelDataType(mosaicDataset.getRasterInfo().getPixelDataType().getValue());
                        mosaicDatasetDTO.setInvalidValue(mosaicDataset.getRasterInfo().getInvalidValue()[0]);
                    }
                    datasetDTO = mosaicDatasetDTO;
                    break;
                }
                default: {
                    datasetDTO = new DatasetDTO();
                }
            }
            datasetDTO.setDsKey(dsKey);
            datasetDTO.setId(GeoDatasetUtil.getGeoDatasetId(dsKey, dataset));
            datasetDTO.setName(dataset.getName());
            datasetDTO.setFullName(dataset.getFullName());
            datasetDTO.setAliasName(dataset.getAliasName());
            datasetDTO.setType(GeoDatasetUtil.convertDatasetType(dataset.getType()).getValue());
            return datasetDTO;
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u96c6{}\u8f6c\u6362\u5f02\u5e38\uff1a", (Object)dataset.getName(), (Object)e);
            return null;
        }
    }

    public static DatasetDTO getGeoDatasetDetail(DataSourceDTO dataSourceDTO, IGeoDataset dataset) {
        DatasetDTO datasetDTO = null;
        String dsKey = dataSourceDTO.getKey();
        switch (dataset.getType()) {
            case GroupDataset: {
                IGroupDataset groupDataset = (IGroupDataset)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)groupDataset);
                break;
            }
            case FeatureDataset: {
                IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)featureDataset);
                break;
            }
            case FeatureClass: {
                IFeatureClass featureClass = (IFeatureClass)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)featureClass);
                if (datasetDTO == null) {
                    throw new RuntimeException("[" + dataset.getName() + "]\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25");
                }
                IFields fields = featureClass.getFields();
                List fieldDTOS = ListUtil.convertAll((Object[])fields.toArray(), FieldUtil::convertField);
                ((FeatureClassDTO)datasetDTO).setFields(fieldDTOS);
                break;
            }
            case Table: {
                ITable table = (ITable)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)table);
                if (datasetDTO == null) {
                    throw new RuntimeException("[" + dataset.getName() + "]\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25");
                }
                IFields tFields = table.getFields();
                List tFieldDTOS = ListUtil.convertAll((Object[])tFields.toArray(), FieldUtil::convertField);
                ((TableDatasetDTO)datasetDTO).setFields(tFieldDTOS);
                break;
            }
            case TableView: {
                ITableView tableView = (ITableView)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)tableView);
                if (datasetDTO == null) {
                    throw new RuntimeException("[" + dataset.getName() + "]\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25");
                }
                ((TableViewDTO)datasetDTO).setDefinitionSql(tableView.getDefinitionSql());
                if (!(tableView instanceof ITable)) break;
                IFields tFields = ((ITable)tableView).getFields();
                List tFieldDTOS = ListUtil.convertAll((Object[])tFields.toArray(), FieldUtil::convertField);
                ((TableViewDTO)datasetDTO).setFields(tFieldDTOS);
                break;
            }
            case MosaicDataset: {
                IMosaicDataset mosaicDataset = (IMosaicDataset)dataset;
                datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, (IGeoDataset)mosaicDataset);
                if (datasetDTO == null) {
                    throw new RuntimeException("[" + dataset.getName() + "]\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25");
                }
                IFields fields = mosaicDataset.getCatalog().getFields();
                List fieldDTOS = ListUtil.convertAll((Object[])fields.toArray(), FieldUtil::convertField);
                ((MosaicDatasetDTO)datasetDTO).setFields(fieldDTOS);
                break;
            }
        }
        if (datasetDTO == null) {
            throw new RuntimeException("[" + dataset.getName() + "]\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25");
        }
        return datasetDTO;
    }

    public static ExtentDTO toExtentDTO(IEnvelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            return null;
        }
        ExtentDTO extentDTO = new ExtentDTO();
        extentDTO.setXmin(Double.valueOf(envelope.getXMin()));
        extentDTO.setYmin(Double.valueOf(envelope.getYMin()));
        extentDTO.setXmax(Double.valueOf(envelope.getXMax()));
        extentDTO.setYmax(Double.valueOf(envelope.getYMax()));
        if (envelope.getZMin() <= envelope.getZMax()) {
            extentDTO.setZmin(Double.valueOf(envelope.getZMin()));
            extentDTO.setZmax(Double.valueOf(envelope.getZMax()));
        }
        return extentDTO;
    }

    public static IEnvelope toEnvelope(ExtentDTO extentDTO) {
        if (extentDTO == null) {
            return null;
        }
        if (extentDTO.getXmin() == null || extentDTO.getXmax() == null || extentDTO.getYmin() == null || extentDTO.getYmax() == null) {
            return null;
        }
        IEnvelope envelope = GeometryFunc.createEnvelope((double)extentDTO.getXmin(), (double)extentDTO.getYmin(), (double)extentDTO.getXmax(), (double)extentDTO.getYmax());
        if (extentDTO.getZmin() != null && extentDTO.getZmax() != null) {
            envelope.setZMin(extentDTO.getZmin().doubleValue());
            envelope.setZMax(extentDTO.getZmax().doubleValue());
        }
        return envelope;
    }

    public static SpatialRefDTO toSpatialRefDTO(ISpatialReferenceSystem spatialReferenceSystem) {
        if (spatialReferenceSystem == null) {
            return null;
        }
        SpatialRefDTO spatialRefDTO = new SpatialRefDTO();
        spatialRefDTO.setSrid(Integer.valueOf(spatialReferenceSystem.getSrid()));
        spatialRefDTO.setWkt(spatialReferenceSystem.getWkt());
        spatialRefDTO.setName(spatialReferenceSystem.getName());
        spatialRefDTO.setType(spatialReferenceSystem.getType());
        return spatialRefDTO;
    }

    public static DatasetTypeEnum convertDatasetType(GeoDatasetType geoDatasetType) {
        switch (geoDatasetType) {
            case GroupDataset: {
                return DatasetTypeEnum.GroupDataset;
            }
            case FeatureDataset: {
                return DatasetTypeEnum.FeatureDataset;
            }
            case FeatureClass: {
                return DatasetTypeEnum.FeatureClass;
            }
            case MosaicDataset: {
                return DatasetTypeEnum.MosaicDataset;
            }
            case Table: {
                return DatasetTypeEnum.Table;
            }
            case TableView: {
                return DatasetTypeEnum.TableView;
            }
        }
        return DatasetTypeEnum.Unknown;
    }

    public static GeoDatasetType convertDatasetType(DatasetTypeEnum datasetTypeEnum) {
        switch (datasetTypeEnum) {
            case GroupDataset: {
                return GeoDatasetType.GroupDataset;
            }
            case FeatureDataset: {
                return GeoDatasetType.FeatureDataset;
            }
            case FeatureClass: {
                return GeoDatasetType.FeatureClass;
            }
            case MosaicDataset: {
                return GeoDatasetType.MosaicDataset;
            }
            case Table: {
                return GeoDatasetType.Table;
            }
            case TableView: {
                return GeoDatasetType.TableView;
            }
        }
        return GeoDatasetType.Unknown;
    }
}

