/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dao.DsGraphLabelDao;
import com.geoway.adf.dms.datasource.entity.DsGraphLabel;
import com.geoway.adf.dms.datasource.service.GraphLabelService;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GraphLabelServiceImpl
implements GraphLabelService {
    private static final Logger log = LoggerFactory.getLogger(GraphLabelServiceImpl.class);
    @Resource
    private DsGraphLabelDao dsGraphLabelDao;

    @Override
    public List<DsGraphLabel> list(String dsKey) {
        return this.dsGraphLabelDao.selectByDsKey(dsKey);
    }

    @Override
    public Boolean tryAddLabel(DsGraphLabel graphLabel) {
        if (StringUtil.isEmptyOrWhiteSpace((String)graphLabel.getName())) {
            log.error("\u6807\u7b7e\u6dfb\u52a0\u5931\u8d25\uff1a\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)graphLabel.getDsKey())) {
            log.error("\u6807\u7b7e\u6dfb\u52a0\u5931\u8d25\uff1a\u6570\u636e\u6e90\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        DsGraphLabel dsGraphLabel = new DsGraphLabel();
        dsGraphLabel.setAliasName(StringUtil.isEmptyOrWhiteSpace((String)graphLabel.getAliasName()) ? "" : graphLabel.getAliasName());
        dsGraphLabel.setName(graphLabel.getName());
        dsGraphLabel.setLabelType(graphLabel.getLabelType() == null ? 0 : graphLabel.getLabelType());
        dsGraphLabel.setId(UUID.randomUUID().toString().replace("-", ""));
        dsGraphLabel.setDsKey(graphLabel.getDsKey());
        List<DsGraphLabel> sameNameList = this.dsGraphLabelDao.selectByName(dsGraphLabel.getDsKey(), graphLabel.getName(), dsGraphLabel.getLabelType());
        if (sameNameList == null || sameNameList.size() == 0) {
            this.dsGraphLabelDao.insert(dsGraphLabel);
            return true;
        }
        if (StringUtil.isNotEmpty((String)graphLabel.getAliasName()) && !sameNameList.get(0).getAliasName().equals(graphLabel.getAliasName())) {
            DsGraphLabel sameNameLabel = sameNameList.get(0);
            sameNameLabel.setAliasName(graphLabel.getAliasName());
            this.dsGraphLabelDao.updateByPrimaryKey(sameNameLabel);
        }
        return true;
    }

    @Override
    public void delete(String id) {
        this.dsGraphLabelDao.deleteByPrimaryKey(id);
    }
}

