/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.license.LicenseCheckAnnotation;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsDataStoreDao;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.RasterDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableViewDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.encrypt.DataSourceParamsEncrypt;
import com.geoway.adf.dms.datasource.entity.DsDataStore;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.AtlasDataSourceService;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.GraphDatabaseService;
import com.geoway.adf.dms.datasource.service.ModelDatabaseService;
import com.geoway.adf.dms.datasource.service.TileDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geosrv.ServiceType;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@LicenseCheckAnnotation(moduleIds={64001, 64100, 64600, 65044})
public class DataSourceServiceImpl
implements DataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DataSourceServiceImpl.class);
    @Resource
    private DsDataStoreDao dataStoreDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private FileStorageService fileStorageService;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Resource
    private TileDatabaseService tileDatabaseService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private ModelDatabaseService modelDatabaseService;
    @Resource
    private GraphDatabaseService graphDatabaseService;
    @Resource
    private AtlasDataSourceService atlasDataSourceService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DataSourceParamsEncrypt dataSourceParamsEncrypt;

    @Override
    public List<DataSourceDTO> listDataSource(List<DataStoreTypeEnum> dataStoreTypes, List<DataSourceTypeEnum> dataSourceTypes, String keyword) {
        return this.dataSourceManager.listDataSource(dataStoreTypes, dataSourceTypes, keyword);
    }

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.testConnect(dataSourceDTO);
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                return this.tileDatabaseService.testConnect(dataSourceDTO);
            }
            case FileStorageSystem: {
                return this.fileStorageService.testConnect(dataSourceDTO);
            }
            case ServiceServer: {
                return this.geoServerEngineService.testConnect(dataSourceDTO);
            }
            case DatumDatabase: {
                return this.datumDatabaseService.testConnect(dataSourceDTO);
            }
            case ModelDatabase: {
                return this.modelDatabaseService.testConnect(dataSourceDTO);
            }
            case GraphDatabase: {
                return this.graphDatabaseService.testConnect(dataSourceDTO);
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.testConnect(dataSourceDTO);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addDataSource(DataSourceDTO dataSourceDTO) {
        dataSourceDTO.setUrl(dataSourceDTO.getUrl().trim());
        if (dataSourceDTO.getDataStoreType().intValue() == DataStoreTypeEnum.ServiceServer.getValue()) {
            dataSourceDTO.setUrl(StringUtil.trimEnd((String)dataSourceDTO.getUrl(), (String)"/"));
        }
        if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue()) {
            Path path = Paths.get(dataSourceDTO.getUrl(), new String[0]).normalize();
            dataSourceDTO.setUrl(path.toString());
        }
        if (this.dataStoreDao.selectByName(dataSourceDTO.getName()) != null) {
            throw new RuntimeException("\u8fde\u63a5\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)dataSourceDTO.getUrl())) {
            throw new RuntimeException("\u8fde\u63a5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String key = this.dataSourceManager.generateDataSourceKey(dataSourceDTO);
        if (this.dataStoreDao.selectByPrimaryKey(key) != null) {
            throw new RuntimeException("\u6570\u636e\u6e90\u8fde\u63a5\u5df2\u5b58\u5728");
        }
        DsDataStore dsDataStore = new DsDataStore();
        BeanUtils.copyProperties((Object)dataSourceDTO, (Object)dsDataStore);
        dsDataStore.setIsDefault(ConstantsValue.FALSE_VALUE.shortValue());
        dsDataStore.setKey(key);
        dsDataStore = this.dataSourceParamsEncrypt.encryptDataSource(dsDataStore);
        this.dataStoreDao.insert(dsDataStore);
        this.addSysLog("\u65b0\u589e", dsDataStore);
        return key;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDataSource(DataSourceDTO dataSourceDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)dataSourceDTO.getUrl())) {
            throw new RuntimeException("\u8fde\u63a5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        dataSourceDTO.setUrl(dataSourceDTO.getUrl().trim());
        if (dataSourceDTO.getDataStoreType().intValue() == DataStoreTypeEnum.ServiceServer.getValue()) {
            dataSourceDTO.setUrl(StringUtil.trimEnd((String)dataSourceDTO.getUrl(), (String)"/"));
        }
        if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue()) {
            Path path = Paths.get(dataSourceDTO.getUrl(), new String[0]).normalize();
            dataSourceDTO.setUrl(path.toString());
        }
        DsDataStore existDataStore = this.dataStoreDao.selectByPrimaryKey(dataSourceDTO.getKey());
        Assert.notNull((Object)existDataStore, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff01");
        if (!existDataStore.getName().equals(dataSourceDTO.getName()) && this.dataStoreDao.selectByName(dataSourceDTO.getName()) != null) {
            throw new RuntimeException("\u8fde\u63a5\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        this.testConnect(dataSourceDTO);
        existDataStore.setName(dataSourceDTO.getName());
        existDataStore.setUrl(dataSourceDTO.getUrl());
        existDataStore.setUserName(dataSourceDTO.getUserName());
        existDataStore.setPassword(dataSourceDTO.getPassword());
        existDataStore = this.dataSourceParamsEncrypt.encryptDataSource(existDataStore);
        this.dataStoreDao.updateByPrimaryKey(existDataStore);
        this.addSysLog("\u4fee\u6539", existDataStore);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDataSource(String key, Boolean deleteBizInfo) {
        DsDataStore dsDataStore = this.dataStoreDao.selectByPrimaryKey(key);
        Assert.notNull((Object)dsDataStore, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff01");
        this.dataStoreDao.deleteByPrimaryKey(key);
        this.addSysLog("\u5220\u9664", dsDataStore);
    }

    @Override
    public DataSourceDTO getDataSourceDetail(String key) {
        return this.dataSourceManager.getDataSourceDetail(key);
    }

    @Override
    public DataSourceDTO getDataSourceDetailWithoutPwd(String key) {
        return this.dataSourceManager.getDataSourceWithoutPassword(key);
    }

    @Override
    public DataSourceDTO getDefaultDataSource(Integer dataStoreType, Integer dataSourceType) {
        DsDataStore dataStore = this.dataStoreDao.selectDefaultDataStore(dataStoreType, dataSourceType);
        if (dataStore != null) {
            return this.dataSourceManager.convertDataSource(dataStore);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDefaultDataSource(String key, boolean isDefault) {
        DsDataStore dsDataStore = this.dataStoreDao.selectByPrimaryKey(key);
        Assert.notNull((Object)dsDataStore, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff01");
        DataStoreTypeEnum storeTypeEnum = DataStoreTypeEnum.getByValue(dsDataStore.getDataStoreType());
        switch (storeTypeEnum) {
            case GeoDatabase: 
            case FileStorageSystem: 
            case DatumDatabase: 
            case ModelDatabase: 
            case GraphDatabase: 
            case AtlasDataSource: {
                if (isDefault) {
                    this.dataStoreDao.cancelDefaultDataStore(storeTypeEnum.getValue(), null);
                }
                this.dataStoreDao.setDefaultDataStore(key, ConstantsValue.integerValue((Boolean)isDefault));
                break;
            }
            case NoSQLDatabase: 
            case ServiceServer: {
                if (isDefault) {
                    this.dataStoreDao.cancelDefaultDataStore(storeTypeEnum.getValue(), dsDataStore.getDataSourceType());
                }
                this.dataStoreDao.setDefaultDataStore(key, ConstantsValue.integerValue((Boolean)isDefault));
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)storeTypeEnum));
            }
        }
        this.addSysLog("\u8bbe\u7f6e\u9ed8\u8ba4", dsDataStore);
    }

    @Override
    public List<SimpleDatasetDTO> listDatasets(String dsKey) {
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(dsKey);
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.listDatasets(dataSourceDTO);
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                return this.tileDatabaseService.listDatasets(dataSourceDTO);
            }
            case ServiceServer: {
                return this.geoServerEngineService.listDatasets(dataSourceDTO);
            }
            case DatumDatabase: {
                return this.datumDatabaseService.listDatasets(dataSourceDTO);
            }
            case ModelDatabase: {
                return this.modelDatabaseService.listDatasets(dataSourceDTO);
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.listDatasets(dataSourceDTO);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    public DatasetDTO getDatasetDetail(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.getDatasetDetail(dataSourceDTO, datasetType, datasetNameInfo.getName());
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                return this.tileDatabaseService.getDatasetDetail(dataSourceDTO, datasetNameInfo.getName());
            }
            case ServiceServer: {
                ServiceType serviceType = ServiceType.getByValue((Integer)datasetNameInfo.getType());
                return this.geoServerEngineService.getDatasetDetail(dataSourceDTO, serviceType, datasetNameInfo.getName());
            }
            case DatumDatabase: {
                return this.datumDatabaseService.getDatasetDetail(dataSourceDTO, datasetNameInfo.getName());
            }
            case ModelDatabase: {
                return this.modelDatabaseService.getDatasetDetail(dataSourceDTO, datasetNameInfo.getName());
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.getDatasetDetail(dataSourceDTO, datasetNameInfo.getName());
            }
            case FileStorageSystem: {
                return this.fileStorageService.getDatasetDetail(dataSourceDTO, datasetType, datasetNameInfo.getName());
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    public DatasetDTO getDatasetDetail(String dsKey, String datasetName) {
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(dsKey);
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.getDatasetDetail(dataSourceDTO, DatasetTypeEnum.Unknown, datasetName);
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                return this.tileDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case ServiceServer: {
                return this.geoServerEngineService.getDatasetDetail(dataSourceDTO, ServiceType.Unknown, datasetName);
            }
            case DatumDatabase: {
                return this.datumDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case ModelDatabase: {
                return this.modelDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.getDatasetDetail(dataSourceDTO, datasetName);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    public DatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, DatasetTypeEnum datasetTypeEnum, String datasetName) {
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.getDatasetDetail(dataSourceDTO, datasetTypeEnum, datasetName);
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                return this.tileDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case ServiceServer: {
                return this.geoServerEngineService.getDatasetDetail(dataSourceDTO, ServiceType.Unknown, datasetName);
            }
            case DatumDatabase: {
                return this.datumDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case ModelDatabase: {
                return this.modelDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.getDatasetDetail(dataSourceDTO, datasetName);
            }
            case FileStorageSystem: {
                return this.fileStorageService.getDatasetDetail(dataSourceDTO, datasetTypeEnum, datasetName);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    public DatasetDTO getDatasetDetailWithoutPwd(String id) {
        DatasetDTO datasetDTO = this.getDatasetDetail(id);
        if (datasetDTO != null && datasetDTO.getDataSource() != null) {
            this.dataSourceManager.clearDataSourcePassword(datasetDTO.getDataSource());
        }
        return datasetDTO;
    }

    @Override
    public DatasetDTO getDatasetDetailWithoutException(String id) {
        DatasetNameInfo datasetNameInfo;
        try {
            datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        }
        catch (Exception e) {
            log.error(id, (Throwable)e);
            DatasetDTO dataset = new DatasetDTO();
            dataset.setValid(false);
            dataset.setInvalidMessage(e.getMessage());
            dataset.setId(id);
            return dataset;
        }
        String datasetName = datasetNameInfo.getName();
        DataSourceDTO dataSourceDTO = null;
        DatasetDTO dataset = null;
        String errorMsg = null;
        try {
            dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
            DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
            switch (dataStoreTypeEnum) {
                case GeoDatabase: {
                    dataset = this.geoDatabaseService.getDatasetDetail(dataSourceDTO, DatasetTypeEnum.Unknown, datasetName);
                    break;
                }
                case NoSQLDatabase: 
                case TileFileSource: {
                    dataset = this.tileDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
                    break;
                }
                case ServiceServer: {
                    ServiceType serviceType = ServiceType.getByValue((Integer)datasetNameInfo.getType());
                    dataset = this.geoServerEngineService.getDatasetDetail(dataSourceDTO, serviceType, datasetName);
                    break;
                }
                case DatumDatabase: {
                    dataset = this.datumDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
                    break;
                }
                case ModelDatabase: {
                    dataset = this.modelDatabaseService.getDatasetDetail(dataSourceDTO, datasetName);
                    break;
                }
                case AtlasDataSource: {
                    dataset = this.atlasDataSourceService.getDatasetDetail(dataSourceDTO, datasetName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
                }
            }
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
            if (StringUtil.isEmptyOrWhiteSpace((String)errorMsg) && e instanceof UndeclaredThrowableException) {
                errorMsg = ((UndeclaredThrowableException)e).getUndeclaredThrowable().getMessage();
            }
            log.error(id + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25", (Throwable)e);
        }
        if (dataSourceDTO != null) {
            this.dataSourceManager.clearDataSourcePassword(dataSourceDTO);
        }
        if (dataset == null) {
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
            switch (datasetType) {
                case FeatureClass: {
                    dataset = new FeatureClassDTO();
                    break;
                }
                case Table: {
                    dataset = new TableDatasetDTO();
                    break;
                }
                case TileDataset: {
                    dataset = new TileDatasetDTO();
                    break;
                }
                case RasterDataset: {
                    dataset = new RasterDatasetDTO();
                    break;
                }
                case MosaicDataset: {
                    dataset = new MosaicDatasetDTO();
                    break;
                }
                case TableView: {
                    dataset = new TableViewDTO();
                    break;
                }
                case DatumDataset: {
                    dataset = new DatumDatasetDTO();
                    break;
                }
                case ServiceDataset: {
                    dataset = new ServiceDatasetDTO();
                    break;
                }
                default: {
                    dataset = new DatasetDTO();
                }
            }
            dataset.setValid(false);
            dataset.setInvalidMessage(errorMsg);
            dataset.setId(id);
            dataset.setName(datasetNameInfo.getShortName());
            dataset.setFullName(datasetNameInfo.getName());
            dataset.setType(datasetNameInfo.getType());
            dataset.setDsKey(datasetNameInfo.getDsKey());
            dataset.setDataSource(dataSourceDTO);
            dataset.setHasRender(false);
            try {
                DatasetMetaDTO datasetMetaDTO = this.dataSourceManager.getDatasetMeta(id);
                if (datasetMetaDTO != null) {
                    dataset.setDataPhase(datasetMetaDTO.getDataPhase());
                    dataset.setRender(datasetMetaDTO.getRender());
                    dataset.setHasRender(datasetMetaDTO.getRender() != null);
                    dataset.setFunctionServices(datasetMetaDTO.getFunctionServices());
                }
            }
            catch (Exception e) {
                log.error(id + "\u5143\u6570\u636e\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            }
        }
        return dataset;
    }

    @Override
    public List<FieldDTO> getDatasetFields(String datasetId) {
        DatasetDTO dataset = this.getDatasetDetailWithoutException(datasetId);
        List<Object> fieldDTOList = new ArrayList<FieldDTO>();
        if (!dataset.getValid().booleanValue()) {
            return fieldDTOList;
        }
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(dataset.getType());
        switch (datasetType) {
            case FeatureClass: {
                fieldDTOList = ((FeatureClassDTO)dataset).getFields();
                break;
            }
            case Table: {
                fieldDTOList = ((TableDatasetDTO)dataset).getFields();
                break;
            }
            case MosaicDataset: {
                fieldDTOList = ((MosaicDatasetDTO)dataset).getFields();
                break;
            }
            case DatumDataset: {
                List<DatumFieldDTO> allFields = ((DatumDatasetDTO)dataset).getFields();
                fieldDTOList = ListUtil.convertAll(allFields, f -> f);
                break;
            }
            default: {
                return fieldDTOList;
            }
        }
        return fieldDTOList;
    }

    @Override
    public void deleteDataset(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                this.geoDatabaseService.deleteDataset(id);
                break;
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                this.tileDatabaseService.deleteTileDataset(id);
                break;
            }
            case ServiceServer: {
                this.geoServerEngineService.deleteService(id);
                break;
            }
            case DatumDatabase: {
                this.datumDatabaseService.deleteDatumDataset(id);
                break;
            }
            case ModelDatabase: {
                this.modelDatabaseService.deleteModelDataset(id);
                break;
            }
            case AtlasDataSource: {
                this.atlasDataSourceService.deleteDataset(id);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
            }
        }
    }

    @Override
    public DataQueryResult queryData(String datasetId, QueryFilterDTO queryFilterDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.queryGeoDataset(datasetId, queryFilterDTO);
            }
            case AtlasDataSource: {
                return this.atlasDataSourceService.queryGeoDataset(datasetId, queryFilterDTO);
            }
            case DatumDatabase: 
            case ModelDatabase: {
                return this.datumDatabaseService.queryGeoDataset(datasetId, queryFilterDTO);
            }
            case FileStorageSystem: {
                return this.fileStorageService.queryGeoDataset(datasetId, queryFilterDTO);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + dataStoreTypeEnum.getDesc());
    }

    @Override
    public Long queryDataCount(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.queryDataCount(datasetId, queryFilterDTO);
            }
            case DatumDatabase: 
            case ModelDatabase: {
                return this.datumDatabaseService.queryDataCount(datasetId, queryFilterDTO);
            }
            case FileStorageSystem: {
                return this.fileStorageService.queryDataCount(datasetId, queryFilterDTO);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    @Override
    public List<Object> queryDataFieldUniqValues(String datasetId, QueryFilterBasicDTO queryFilterDTO, Integer limit) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DataSourceDTO dataSourceDTO = this.getDataSourceDetail(datasetNameInfo.getDsKey());
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataSourceDTO.getDataStoreType());
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                return this.geoDatabaseService.queryDataFieldUniqValues(datasetId, queryFilterDTO, limit);
            }
            case DatumDatabase: 
            case ModelDatabase: {
                return this.datumDatabaseService.queryDataFieldUniqValues(datasetId, queryFilterDTO, limit);
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b\uff1a" + (Object)((Object)dataStoreTypeEnum));
    }

    private void addSysLog(String operate, DsDataStore dataStore) {
        DataStoreTypeEnum dataStoreTypeEnum = DataStoreTypeEnum.getByValue(dataStore.getDataStoreType());
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataStore.getDataSourceType());
        int eventId = 0;
        switch (dataStoreTypeEnum) {
            case GeoDatabase: {
                eventId = 100;
                break;
            }
            case NoSQLDatabase: 
            case TileFileSource: {
                eventId = 120;
                break;
            }
            case FileStorageSystem: {
                eventId = 150;
                break;
            }
            case ServiceServer: {
                eventId = 140;
                break;
            }
            case DatumDatabase: {
                eventId = 110;
                break;
            }
            case GraphDatabase: {
                eventId = 130;
                break;
            }
            case AtlasDataSource: {
                eventId = 160;
                break;
            }
            case ModelDatabase: {
                eventId = 170;
            }
        }
        this.sysLogService.addLog(eventId, String.format("%s%s(%s)\uff1a%s", operate, dataStoreTypeEnum.getDesc(), dataSourceTypeEnum.getDesc(), dataStore.getName()));
    }
}

