/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.datasource.dao.DsDatasetRelationDao;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.entity.DsDatasetRelation;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatasetRelationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class DatasetRelationServiceImpl
implements DatasetRelationService {
    private static final Logger log = LoggerFactory.getLogger(DatasetRelationServiceImpl.class);
    @Resource
    private DsDatasetRelationDao dsDatasetRelationDao;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public List<DsDatasetRelation> getAll() {
        return this.dsDatasetRelationDao.selectAll();
    }

    @Override
    public List<DsDatasetRelation> getDatasetRelations(String datasetId) {
        return this.dsDatasetRelationDao.selectByDatasetId(datasetId);
    }

    @Override
    public List<DsDatasetRelation> getDatasetRelations(String datasetId, String relation) {
        return this.dsDatasetRelationDao.selectByRelation(datasetId, relation);
    }

    @Override
    public boolean addRelation(DsDatasetRelation record) {
        return this.dsDatasetRelationDao.insert(record) > 0;
    }

    @Override
    public boolean batchAddRelation(List<DsDatasetRelation> list) {
        return this.dsDatasetRelationDao.batchInsert(list) > 0;
    }

    @Override
    public boolean deleteDatasetRelation(String datasetId) {
        return this.dsDatasetRelationDao.deleteByDatasetId(datasetId) > 0;
    }

    @Override
    public Map<String, DatasetDTO> getRelateDatasetDetail(String datasetId) {
        HashMap<String, DatasetDTO> relationMap = new HashMap<String, DatasetDTO>();
        List<DsDatasetRelation> relations = this.dsDatasetRelationDao.selectByDatasetId(datasetId);
        for (DsDatasetRelation relation : relations) {
            String relationDatasetId = relation.getSourceId().equals(datasetId) ? relation.getTargetId() : relation.getSourceId();
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetailWithoutException(relationDatasetId);
            relationMap.put(relation.getRelation(), datasetDTO);
        }
        return relationMap;
    }
}

