/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import cn.hutool.core.io.unit.DataSizeUtil;
import cn.hutool.core.lang.Assert;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.ObjectStorageBucketDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FileObjectStorageService;
import com.geoway.adf.dms.datasource.util.FileStorageUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.obstorage.AmazonS3FileStorage;
import com.geoway.adf.gis.fs.obstorage.BucketInfo;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import com.geoway.adf.gis.fs.obstorage.MinIOFileStorage;
import com.geoway.adf.gis.fs.obstorage.OBSFileStorage;
import com.geoway.adf.gis.fs.obstorage.OSSFileStorage;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FileObjectStorageServiceImpl
implements FileObjectStorageService {
    @Resource
    private DataSourceManager dataSourceManager;

    @Override
    public List<String> listObjectStorageBuckets(DataSourceDTO dataSourceDTO) {
        MinIOFileStorage objectStorage;
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
        switch (dataSourceTypeEnum) {
            case MinIO: {
                objectStorage = new MinIOFileStorage(dataSourceDTO.getUrl(), null, dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case OBS: {
                objectStorage = new OBSFileStorage(dataSourceDTO.getUrl(), null, dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case OSS: {
                objectStorage = new OSSFileStorage(dataSourceDTO.getUrl(), null, dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case S3: {
                objectStorage = new AmazonS3FileStorage(dataSourceDTO.getUrl(), null, dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
            }
        }
        ((IFileStorage)objectStorage).connect();
        return objectStorage.listBucketNames();
    }

    @Override
    public ObjectStorageBucketDTO getBucketInfo(String dsKey) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            if (fileStorage instanceof IObjectStorage) {
                IObjectStorage objectStorage = (IObjectStorage)fileStorage;
                BucketInfo bucketInfo = objectStorage.getBucketInfo();
                ObjectStorageBucketDTO objectStorageBucketDTO = new ObjectStorageBucketDTO();
                objectStorageBucketDTO.setBucketName(bucketInfo.getBucketName());
                objectStorageBucketDTO.setBucketPolicy(bucketInfo.getBucketPolicy());
                objectStorageBucketDTO.setCreationDate(bucketInfo.getCreationDate());
                objectStorageBucketDTO.setStorageSize(DataSizeUtil.format((long)bucketInfo.getStorageSize()));
                ObjectStorageBucketDTO objectStorageBucketDTO2 = objectStorageBucketDTO;
                return objectStorageBucketDTO2;
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
        }
    }

    @Override
    public String generatePresignedGetUrl(String dsKey, String filePath, int expirationSeconds, Map<String, String> headers, Map<String, String> queryParams) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            IFileset file = fileStorage.getFile(filePath);
            Assert.notNull((Object)file, (String)("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath), (Object[])new Object[0]);
            Assert.isTrue((!file.getIsDirectory() ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6587\u4ef6\u5939\u7c7b\u578b", (Object[])new Object[0]);
            if (fileStorage instanceof IObjectStorage) {
                IObjectStorage objectStorage = (IObjectStorage)fileStorage;
                String string = objectStorage.generatePresignedGetUrl(file.getFullPath(), expirationSeconds, headers, queryParams);
                return string;
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
        }
    }

    @Override
    public String generatePresignedPutUrl(String dsKey, String filePath, int expirationSeconds, Map<String, String> headers, Map<String, String> queryParams) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        try (IFileStorage fileStorage = FileStorageUtil.openFileStorage(dataSourceDTO);){
            if (fileStorage instanceof IObjectStorage) {
                IObjectStorage objectStorage = (IObjectStorage)fileStorage;
                String string = objectStorage.generatePresignedPutUrl(filePath, expirationSeconds, headers, queryParams);
                return string;
            }
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
        }
    }
}

