/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.RasterDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.GeoDatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.model.ModelDatasetDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetUtil {
    private static final Logger log = LoggerFactory.getLogger(DatasetUtil.class);

    public static DatasetNameInfo getDatasetNameInfo(String id) {
        return new DatasetNameInfo(id);
    }

    public static String getDatasetId(String dsKey, DatasetTypeEnum datasetTypeEnum, String datasetName) {
        return DatasetNameInfo.buildDatasetId(dsKey, datasetTypeEnum.getValue(), datasetName);
    }

    public static ExtentDTO getDatasetExtent(DatasetDTO dataset) {
        if (dataset == null || !dataset.getValid().booleanValue()) {
            return null;
        }
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(dataset.getType());
        ExtentDTO extent = null;
        switch (datasetType) {
            case DatumDataset: {
                if (!(dataset instanceof GeoDatumDatasetDTO)) break;
                extent = ((GeoDatumDatasetDTO)dataset).getExtent();
                break;
            }
            case ModelDataset: {
                if (!(dataset instanceof ModelDatasetDTO)) break;
                extent = ((ModelDatasetDTO)dataset).getExtent();
                break;
            }
            case FeatureClass: {
                extent = ((FeatureClassDTO)dataset).getExtent();
                break;
            }
            case MosaicDataset: {
                extent = ((MosaicDatasetDTO)dataset).getExtent();
                break;
            }
            case RasterDataset: {
                extent = ((RasterDatasetDTO)dataset).getExtent();
                break;
            }
            case TileDataset: {
                extent = ((TileDatasetDTO)dataset).getExtent();
                break;
            }
        }
        return extent;
    }
}

