/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateFieldDTO;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.create.GroupDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.GroupFeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.GroupTableCreateDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.event.DatasetCreateEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GroupDatasetService;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IGroupDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GroupDatasetServiceImpl
implements GroupDatasetService {
    private static final Logger log = LoggerFactory.getLogger(GroupDatasetServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private GeoTemplateService geoTemplateService;
    @Resource
    private FileStorageService fileStorageService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createGroupDataset(GroupDatasetCreateDTO groupDatasetCreateDTO) {
        String dsKey = groupDatasetCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            Object item;
            List srcDatasetList;
            IFeatureWorkspace srcWorkspace;
            DataSourceDTO fileDataSource;
            Map<String, List<Object>> templateGroup;
            String newDatasetName = groupDatasetCreateDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)groupDatasetCreateDTO.getSchemaName())) {
                newDatasetName = groupDatasetCreateDTO.getSchemaName() + "." + groupDatasetCreateDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            String aliasName = groupDatasetCreateDTO.getAliasName() == null ? groupDatasetCreateDTO.getName() : groupDatasetCreateDTO.getAliasName();
            IGroupDataset groupDataset = featureWorkspace.createGroupDataset(groupDatasetCreateDTO.getName(), aliasName);
            Assert.notNull((Object)groupDataset, (String)"\u5b9e\u4f53\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01");
            this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", groupDataset.getType().getDesc(), dataSourceDTO.getName(), groupDataset.getFullName()));
            String datasetId = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)groupDataset);
            String dataPhase = groupDatasetCreateDTO.getDataPhase();
            if (StringUtil.isNotEmpty((String)dataPhase) || StringUtil.isNotEmpty((String)groupDatasetCreateDTO.getTypeDesc())) {
                DatasetMetaDTO datasetMetaDTO = new DatasetMetaDTO();
                datasetMetaDTO.setDataPhase(dataPhase);
                if (StringUtil.isNotEmpty((String)groupDatasetCreateDTO.getTypeDesc())) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"typeDesc", (Object)groupDatasetCreateDTO.getTypeDesc());
                    datasetMetaDTO.setDetail(jsonObject.toJSONString(new JSONWriter.Feature[0]));
                }
                this.dataSourceManager.saveDatasetMeta(datasetId, datasetMetaDTO);
            }
            if (StringUtil.isNotEmpty((String)groupDatasetCreateDTO.getGeoTemplateId())) {
                GeoTemplateDTO geoTemplateDTO = this.geoTemplateService.getGeoTemplate(groupDatasetCreateDTO.getGeoTemplateId(), null);
                this.createByGeoTemplate(groupDatasetCreateDTO, dataSourceDTO, groupDataset, geoTemplateDTO);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, datasetId));
                String string = datasetId;
                return string;
            }
            if (groupDatasetCreateDTO.getFeatureClassList() != null) {
                templateGroup = groupDatasetCreateDTO.getFeatureClassList().stream().collect(Collectors.groupingBy(GroupFeatureClassCreateDTO::getSrcPath));
                for (String templateFile : templateGroup.keySet()) {
                    fileDataSource = this.fileStorageService.getFileDataSourceByFilePath(templateFile);
                    srcWorkspace = GeoDatabaseUtil.openFileGeoDatabase(fileDataSource, templateFile);
                    Assert.notNull((Object)srcWorkspace, (String)"\u6a21\u677f\u6570\u636e\u6253\u5f00\u5931\u8d25\uff01");
                    try {
                        List<Object> featureClassList = templateGroup.get(templateFile);
                        srcDatasetList = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass});
                        for (IGeoDataset dataset : srcDatasetList) {
                            item = (GroupFeatureClassCreateDTO)ListUtil.find(featureClassList, f -> dataset.getName().equals(f.getSrcName()));
                            if (item == null) continue;
                            ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)((GroupFeatureClassCreateDTO)item).getSrid());
                            IFeatureClass featureClass = this.createFeatureClass((IFeatureClass)dataset, ((GroupFeatureClassCreateDTO)item).getTargetName(), groupDataset, spatialReferenceSystem);
                            this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
                            if (!StringUtil.isNotEmpty((String)dataPhase)) continue;
                            String id = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureClass);
                            this.dataSourceManager.saveDatasetDataPhase(id, dataPhase);
                        }
                    }
                    finally {
                        srcWorkspace.close();
                    }
                }
            }
            if (groupDatasetCreateDTO.getTableList() != null) {
                templateGroup = groupDatasetCreateDTO.getTableList().stream().collect(Collectors.groupingBy(GroupTableCreateDTO::getSrcPath));
                for (String templateFile : templateGroup.keySet()) {
                    fileDataSource = this.fileStorageService.getFileDataSourceByFilePath(templateFile);
                    srcWorkspace = GeoDatabaseUtil.openFileGeoDatabase(fileDataSource, templateFile);
                    Assert.notNull((Object)srcWorkspace, (String)"\u6a21\u677f\u6570\u636e\u6253\u5f00\u5931\u8d25\uff01");
                    try {
                        List<Object> tableList = templateGroup.get(templateFile);
                        srcDatasetList = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.Table});
                        for (IGeoDataset dataset : srcDatasetList) {
                            item = (GroupTableCreateDTO)ListUtil.find(tableList, f -> dataset.getName().equals(f.getSrcName()));
                            if (item == null) continue;
                            ITable table = this.createTable((ITable)dataset, ((GroupTableCreateDTO)item).getTargetName(), groupDataset);
                            this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", table.getType().getDesc(), dataSourceDTO.getName(), table.getFullName()));
                            if (!StringUtil.isNotEmpty((String)dataPhase)) continue;
                            String id = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)table);
                            this.dataSourceManager.saveDatasetDataPhase(id, dataPhase);
                        }
                    }
                    finally {
                        srcWorkspace.close();
                    }
                }
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, datasetId));
            String string = datasetId;
            return string;
        }
    }

    private IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, String name, IGroupDataset targetGroupDataset, ISpatialReferenceSystem spatialReferenceSystem) {
        String shapeFieldName = srcFeatClass.getShapeFieldName();
        Fields newFields = new Fields();
        for (int i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
            IField tempField = srcFeatClass.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.Shape) {
                tempField.setName(shapeFieldName);
                ((GeometryField)tempField).setSpatialReferenceSystem(spatialReferenceSystem);
                ((GeometryField)tempField).setCoordinateType(CoordinateType.XY);
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        this.addSystemFields((IFields)newFields);
        IFeatureClass featureClass = targetGroupDataset.createFeatureClass(name, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
        if (featureClass == null) {
            throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25");
        }
        featureClass.createSpatialIndex();
        return featureClass;
    }

    private ITable createTable(ITable srcTable, String name, IGroupDataset targetGroupDataset) {
        Fields newFields = new Fields();
        for (int i = 0; i < srcTable.getFields().getFieldCount(); ++i) {
            IField tempField = srcTable.getFields().getField(i).clone();
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        this.addSystemFields((IFields)newFields);
        ITable table = targetGroupDataset.createTable(name, (IFields)newFields);
        Assert.notNull((Object)table, (String)"\u8868\u683c\u521b\u5efa\u5931\u8d25\uff01");
        return table;
    }

    private void createByGeoTemplate(GroupDatasetCreateDTO groupDatasetCreateDTO, DataSourceDTO dataSourceDTO, IGroupDataset groupDataset, GeoTemplateDTO geoTemplate) {
        GeoTemplateDatasetDTO templateDatasetDTO;
        List templateDatasetDTOS = geoTemplate.getDatasets();
        String shapeFieldName = "shape";
        String objectIdFieldName = "objectid";
        if (groupDatasetCreateDTO.getFeatureClassList() != null) {
            for (GroupFeatureClassCreateDTO featureClassCreateDTO : groupDatasetCreateDTO.getFeatureClassList()) {
                templateDatasetDTO = (GeoTemplateDatasetDTO)ListUtil.find((List)templateDatasetDTOS, f -> featureClassCreateDTO.getSrcName().equalsIgnoreCase(f.getName()));
                if (templateDatasetDTO == null) continue;
                ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)featureClassCreateDTO.getSrid());
                Fields newFields = new Fields();
                Field oidFld = new Field();
                oidFld.setName(objectIdFieldName);
                oidFld.setAliasName(objectIdFieldName);
                oidFld.setFieldType(FieldType.OID);
                newFields.addField((IField)oidFld);
                FeatureType featureType = FeatureType.getByValue((Integer)templateDatasetDTO.getType());
                GeometryType geometryType = GeometryType.Unknown;
                switch (featureType) {
                    case Point: {
                        geometryType = GeometryType.Point;
                        break;
                    }
                    case Polyline: {
                        geometryType = GeometryType.Polyline;
                        break;
                    }
                    case Polygon: {
                        geometryType = GeometryType.MultiPolygon;
                        break;
                    }
                    case Unknown: {
                        throw new RuntimeException(templateDatasetDTO.getName() + "\u6a21\u677f\u56fe\u5c42\u51e0\u4f55\u7c7b\u578b\u4e0d\u6b63\u786e");
                    }
                }
                GeometryField geoField = new GeometryField();
                geoField.setSpatialReferenceSystem(spatialReferenceSystem);
                geoField.setName(shapeFieldName);
                geoField.setAliasName(shapeFieldName);
                geoField.setFieldType(FieldType.Shape);
                geoField.setGeometryType(geometryType);
                newFields.addField((IField)geoField);
                for (GeoTemplateFieldDTO templateField : templateDatasetDTO.getFields()) {
                    IField sFld = FieldUtil.convertField((FieldDTO)templateField);
                    newFields.addField(sFld);
                }
                this.addSystemFields((IFields)newFields);
                IFeatureClass featureClass = groupDataset.createFeatureClass(featureClassCreateDTO.getTargetName(), (IFields)newFields, featureType, geoField.getName(), null);
                if (featureClass != null) {
                    featureClass.createSpatialIndex();
                }
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
                if (!StringUtil.isNotEmpty((String)groupDatasetCreateDTO.getDataPhase())) continue;
                String id = GeoDatasetUtil.getGeoDatasetId(dataSourceDTO.getKey(), (IGeoDataset)featureClass);
                this.dataSourceManager.saveDatasetDataPhase(id, groupDatasetCreateDTO.getDataPhase());
            }
        }
        if (groupDatasetCreateDTO.getTableList() != null) {
            for (GroupTableCreateDTO tableCreateDTO : groupDatasetCreateDTO.getTableList()) {
                templateDatasetDTO = (GeoTemplateDatasetDTO)ListUtil.find((List)templateDatasetDTOS, f -> tableCreateDTO.getSrcName().equalsIgnoreCase(f.getName()));
                if (templateDatasetDTO == null) continue;
                Fields newFields = new Fields();
                Field oidFld = new Field();
                oidFld.setName(objectIdFieldName);
                oidFld.setAliasName(objectIdFieldName);
                oidFld.setFieldType(FieldType.OID);
                newFields.addField((IField)oidFld);
                for (GeoTemplateFieldDTO templateField : templateDatasetDTO.getFields()) {
                    IField sFld = FieldUtil.convertField((FieldDTO)templateField);
                    newFields.addField(sFld);
                }
                ITable table = groupDataset.createTable(tableCreateDTO.getTargetName(), (IFields)newFields);
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", table.getType().getDesc(), dataSourceDTO.getName(), table.getFullName()));
                if (!StringUtil.isNotEmpty((String)groupDatasetCreateDTO.getDataPhase())) continue;
                String id = GeoDatasetUtil.getGeoDatasetId(dataSourceDTO.getKey(), (IGeoDataset)table);
                this.dataSourceManager.saveDatasetDataPhase(id, groupDatasetCreateDTO.getDataPhase());
            }
        }
    }

    private void addSystemFields(IFields newFields) {
        if (newFields.findFieldIndex("f_frame") < 0) {
            newFields.addField((IField)new Field("f_frame", "\u5206\u5e45\u540d\u79f0", FieldType.String, 60));
        }
        if (newFields.findFieldIndex("f_importtime") < 0) {
            newFields.addField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime));
        }
    }
}

