/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataUnitDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatumDatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ModelDatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsDatumDao;
import com.geoway.adf.dms.datasource.dao.DsDatumFieldsDao;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassEditDTO;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TableCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TableEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseUrlDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.dms.datasource.dto.datum.GeoDatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.GeoMosaicDatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.ThumbDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumFieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePathDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePathRepairDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.entity.DsDatum;
import com.geoway.adf.dms.datasource.entity.DsDatumField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.DatumDatasetWrapper;
import com.geoway.adf.dms.datasource.service.FeatureClassService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.service.TableDatasetService;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional(rollbackFor={Exception.class})
public class DatumDatabaseServiceImpl
implements DatumDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatumDatabaseServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private FeatureClassService featureClassService;
    @Resource
    private MosaicDatasetService mosaicDatasetService;
    @Resource
    private TableDatasetService tableDatasetService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DsDatumFieldsDao datumFieldsDao;
    @Resource
    private DsDatumDao datumDao;
    @Resource
    private FileModelService fileModelService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private ThumbService thumbService;
    @Resource
    private FileStorageService fileStorageService;
    private DatumDatasetWrapper datumDatasetWrapper = null;

    @Autowired(required=false)
    public void initDatumDatasetWrapper(DatumDatasetWrapper datumDatasetWrapper) {
        this.datumDatasetWrapper = datumDatasetWrapper;
    }

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        String url = dataSourceDTO.getUrl();
        if (StringUtil.isEmptyOrWhiteSpace((String)url)) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u5b58\u50a8\u6570\u636e\u5e93\u4e0e\u5b58\u50a8\u8282\u70b9\uff01");
        }
        DatumDatabaseUrlDTO urlDTO = (DatumDatabaseUrlDTO)JSON.parseObject((String)url, DatumDatabaseUrlDTO.class);
        Assert.notNull((Object)urlDTO, (String)"\u8bf7\u68c0\u67e5url\u683c\u5f0f\uff01");
        return urlDTO.getGeoDatabaseKey() != null && urlDTO.getFileStorageKeys() != null && urlDTO.getFileStorageKeys().size() > 0;
    }

    @Override
    public List<DatumDatabaseDTO> listDatumDatabase(List<DataStoreTypeEnum> dataStoreTypes, String keyword) {
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(dataStoreTypes, Collections.singletonList(DataSourceTypeEnum.DatumDatabase), keyword);
        List result = ListUtil.convertAll(list, f -> (DatumDatabaseDTO)f);
        return result;
    }

    @Override
    public DatumDatabaseDTO getDatumDatabaseDetail(String key) {
        return (DatumDatabaseDTO)this.dataSourceManager.getDataSourceDetail(key);
    }

    @Override
    public DatumDatabaseDTO getDatumDatabaseDetailWithOutPassWord(String key) {
        return (DatumDatabaseDTO)this.dataSourceManager.getDataSourceWithoutPassword(key);
    }

    @Override
    public DatasetPageList<SimpleDatasetDTO> listDatumDataset(String dsKey, List<DatumDatasetTypeEnum> datumTypes, String keyword, Integer pageIndex, Integer rows) {
        List dsDatumList = this.datumDao.selectByDsKey(dsKey);
        if (datumTypes != null && datumTypes.size() > 0) {
            dsDatumList = ListUtil.findAll(dsDatumList, dsDatum -> datumTypes.contains((Object)DatumDatasetTypeEnum.getByValue(dsDatum.getDatumDatasetType())));
        }
        if (StringUtil.isNotEmpty((String)keyword)) {
            dsDatumList = ListUtil.findAll(dsDatumList, dsDatum -> dsDatum.getName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)) || dsDatum.getAliasName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)));
        }
        ArrayList<SimpleDatasetDTO> result = new ArrayList<SimpleDatasetDTO>();
        HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
        typeCount.put(DatumDatasetTypeEnum.DatumDataset.getValue(), 0);
        typeCount.put(DatumDatasetTypeEnum.GeoDatumDataset.getValue(), 0);
        typeCount.put(DatumDatasetTypeEnum.GeoMosaicDatumDataset.getValue(), 0);
        for (DsDatum dsDatum2 : dsDatumList) {
            SimpleDatasetDTO simpleDatasetDTO = this.convertSimpleDatasetDTO(dsDatum2);
            result.add(simpleDatasetDTO);
            typeCount.put(dsDatum2.getDatumDatasetType(), typeCount.get(dsDatum2.getDatumDatasetType()) == null ? 1 : (Integer)typeCount.get(dsDatum2.getDatumDatasetType()) + 1);
        }
        DatasetPageList<SimpleDatasetDTO> datasetPageList = new DatasetPageList<SimpleDatasetDTO>(result, pageIndex, rows);
        datasetPageList.setTypeCounts(typeCount);
        return datasetPageList;
    }

    @Override
    public List<SimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        List<DsDatum> dsDatumList = this.datumDao.selectByDsKey(dataSourceDTO.getKey());
        ArrayList<SimpleDatasetDTO> result = new ArrayList<SimpleDatasetDTO>();
        for (DsDatum dsDatum : dsDatumList) {
            SimpleDatasetDTO simpleDatasetDTO = this.convertSimpleDatasetDTO(dsDatum);
            result.add(simpleDatasetDTO);
        }
        return result;
    }

    @Override
    public DatumDatasetDTO getDatasetDetail(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DatumDatabaseDTO dataSourceDTO = this.getDatumDatabaseDetail(datasetNameInfo.getDsKey());
        return this.getDatasetDetail(dataSourceDTO, datasetNameInfo.getName());
    }

    @Override
    public DatumDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String name) {
        DatumDatasetDTO wrapperDataset;
        List<FieldDTO> fieldDTOList;
        DatumDatasetDTO datumDatasetDTO;
        DsDatum dsDatum = this.datumDao.selectByDsKeyAndName(dataSourceDTO.getKey(), name);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        DatumDatasetTypeEnum datumType = DatumDatasetTypeEnum.getByValue(dsDatum.getDatumDatasetType());
        DatasetTypeEnum datasetType = DatasetTypeEnum.Unknown;
        switch (datumType) {
            case DatumDataset: {
                datasetType = DatasetTypeEnum.Table;
                break;
            }
            case GeoDatumDataset: {
                datasetType = DatasetTypeEnum.FeatureClass;
                break;
            }
            case GeoMosaicDatumDataset: {
                datasetType = DatasetTypeEnum.MosaicDataset;
                break;
            }
        }
        DatumDatabaseDTO datumDatabaseDTO = (DatumDatabaseDTO)dataSourceDTO;
        Assert.notNull((Object)datumDatabaseDTO, (String)"\u6587\u4ef6\u6570\u636e\u5e93\u4e0d\u5b58\u5728\uff01");
        Assert.notNull((Object)datumDatabaseDTO.getGeoDatabase(), (String)"\u5173\u8054\u7684\u7a7a\u95f4\u6570\u636e\u5e93\u4e0d\u5b58\u5728\uff01");
        DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(datumDatabaseDTO.getGeoDatabase(), datasetType, dsDatum.getName());
        switch (datasetType) {
            case FeatureClass: {
                datumDatasetDTO = new GeoDatumDatasetDTO();
                BeanUtils.copyProperties((Object)datasetDTO, (Object)datumDatasetDTO);
                fieldDTOList = ((FeatureClassDTO)datasetDTO).getFields();
                break;
            }
            case MosaicDataset: {
                datumDatasetDTO = new GeoMosaicDatumDatasetDTO();
                BeanUtils.copyProperties((Object)datasetDTO, (Object)datumDatasetDTO);
                fieldDTOList = ((MosaicDatasetDTO)datasetDTO).getFields();
                break;
            }
            default: {
                datumDatasetDTO = new DatumDatasetDTO();
                BeanUtils.copyProperties((Object)datasetDTO, (Object)datumDatasetDTO);
                fieldDTOList = ((TableDatasetDTO)datasetDTO).getFields();
            }
        }
        datumDatasetDTO.setId(dsDatum.getDatasetId());
        datumDatasetDTO.setDsKey(dataSourceDTO.getKey());
        datumDatasetDTO.setName(dsDatum.getName());
        datumDatasetDTO.setAliasName(dsDatum.getAliasName());
        datumDatasetDTO.setDatumType(datumType.getValue());
        datumDatasetDTO.setGeoDatasetId(dsDatum.getGeoDatasetId());
        datumDatasetDTO.setType(DatasetTypeEnum.DatumDataset.getValue());
        datumDatasetDTO.setTypeDesc(DatasetTypeEnum.DatumDataset.getDesc());
        datumDatasetDTO.setFields(new ArrayList<DatumFieldDTO>());
        List<DsDatumField> dsDatumFieldList = this.datumFieldsDao.selectByDatasetId(dsDatum.getDatasetId());
        for (DsDatumField dsDatumField : dsDatumFieldList) {
            FieldDTO fieldDTO = (FieldDTO)ListUtil.find(fieldDTOList, f -> f.getName().trim().equalsIgnoreCase(dsDatumField.getName().trim()));
            if (fieldDTO == null) continue;
            DatumFieldDTO datumFieldDTO = new DatumFieldDTO();
            BeanUtils.copyProperties((Object)fieldDTO, (Object)((Object)datumFieldDTO));
            datumFieldDTO.setDatumName(ConstantsValue.boolValue((Short)dsDatumField.getDatumName()));
            datumFieldDTO.setIdentify(ConstantsValue.boolValue((Short)dsDatumField.getIdentify()));
            datumFieldDTO.setSystemField(ConstantsValue.boolValue((Short)dsDatumField.getSystem()));
            datumDatasetDTO.getFields().add(datumFieldDTO);
        }
        List identifyFields = ListUtil.findAll(datumDatasetDTO.getFields(), DatumFieldDTO::getIdentify);
        datumDatasetDTO.setIdentifyFields(ListUtil.convertAll((List)identifyFields, FieldDTO::getName));
        DatumFieldDTO datumNameField = (DatumFieldDTO)((Object)ListUtil.find(datumDatasetDTO.getFields(), DatumFieldDTO::getDatumName));
        if (datumNameField != null) {
            datumDatasetDTO.setDatumNameField(datumNameField.getName());
        }
        String fileModelIds = dsDatum.getDataModelIds();
        if (dsDatum.getDataModelIds().endsWith(",")) {
            fileModelIds = fileModelIds.substring(0, fileModelIds.length() - 1);
        }
        List fileModelIdList = ListUtil.convertAll((Object[])fileModelIds.split(","), Long::parseLong);
        List allFileModels = this.fileModelService.list(null);
        allFileModels = ListUtil.findAll((List)allFileModels, f -> fileModelIdList.contains(f.getModelId()));
        datumDatasetDTO.setFileModels(allFileModels);
        datumDatasetDTO.setDataSource(this.getDatumDatabaseDetailWithOutPassWord(dataSourceDTO.getKey()));
        if (this.datumDatasetWrapper != null && (wrapperDataset = this.datumDatasetWrapper.wrapDatumDatasetDetail(datumDatasetDTO)) != null) {
            return wrapperDataset;
        }
        return datumDatasetDTO;
    }

    @Override
    public String createDatumDataset(DatumDatasetCreateDTO createDTO) {
        List allFields;
        String geoDatasetId;
        DsDatum sameNameDatum = this.datumDao.selectByDsKeyAndName(createDTO.getDsKey(), createDTO.getName());
        Assert.isNull((Object)sameNameDatum, (String)"\u5df2\u5b58\u5728\u540c\u540d\u6570\u636e\u96c6\uff01");
        DatumDatasetTypeEnum datumType = DatumDatasetTypeEnum.getByValue(createDTO.getDatumDatasetType());
        DatumDatabaseDTO datumDatabaseDTO = (DatumDatabaseDTO)this.dataSourceManager.getDataSourceDetail(createDTO.getDsKey());
        Assert.notNull((Object)datumDatabaseDTO, (String)"\u83b7\u53d6\u6570\u636e\u6e90\u8be6\u60c5\u5931\u8d25\uff01");
        DatabaseDTO geoDatabase = datumDatabaseDTO.getGeoDatabase();
        List userFieldNames = ListUtil.convertAll(createDTO.getFields(), f -> f.getName().toUpperCase(Locale.ROOT));
        List<FieldDTO> fields = this.checkDatumField(createDTO.getFields());
        String datumDatasetId = createDTO.getModelDatasetType() == null ? DatasetUtil.getDatasetId(datumDatabaseDTO.getKey(), DatasetTypeEnum.DatumDataset, createDTO.getName()) : DatasetUtil.getDatasetId(datumDatabaseDTO.getKey(), DatasetTypeEnum.ModelDataset, createDTO.getName());
        switch (datumType) {
            case DatumDataset: {
                TableCreateDTO tableCreateDTO = new TableCreateDTO();
                tableCreateDTO.setDsKey(geoDatabase.getKey());
                tableCreateDTO.setName(createDTO.getName());
                tableCreateDTO.setAliasName(createDTO.getAliasName());
                tableCreateDTO.setFields(fields);
                geoDatasetId = this.tableDatasetService.createTable(tableCreateDTO);
                TableDatasetDTO tableDataset = (TableDatasetDTO)this.geoDatabaseService.getDatasetDetail(geoDatabase, DatasetTypeEnum.Table, createDTO.getName());
                allFields = ListUtil.convertAll(tableDataset.getFields(), f -> this.convertToDsDatumField((FieldDTO)f, datumDatasetId));
                break;
            }
            case GeoDatumDataset: {
                FeatureClassCreateDTO featureClassCreateDTO = new FeatureClassCreateDTO();
                featureClassCreateDTO.setDsKey(geoDatabase.getKey());
                featureClassCreateDTO.setName(createDTO.getName());
                featureClassCreateDTO.setAliasName(createDTO.getAliasName());
                featureClassCreateDTO.setFeatureType(createDTO.getFeatureType());
                featureClassCreateDTO.setDataPhase(createDTO.getDataPhase());
                featureClassCreateDTO.setSrid(createDTO.getSrid());
                featureClassCreateDTO.setFields(fields);
                geoDatasetId = this.featureClassService.createFeatureClass(featureClassCreateDTO);
                FeatureClassDTO featureClass = (FeatureClassDTO)this.geoDatabaseService.getDatasetDetail(geoDatabase, DatasetTypeEnum.FeatureClass, createDTO.getName());
                allFields = ListUtil.convertAll(featureClass.getFields(), f -> this.convertToDsDatumField((FieldDTO)f, datumDatasetId));
                break;
            }
            case GeoMosaicDatumDataset: {
                MosaicDatasetCreateDTO mosaicDatasetCreateDTO = new MosaicDatasetCreateDTO();
                mosaicDatasetCreateDTO.setDsKey(geoDatabase.getKey());
                mosaicDatasetCreateDTO.setName(createDTO.getName());
                mosaicDatasetCreateDTO.setAliasName(createDTO.getAliasName());
                mosaicDatasetCreateDTO.setSrid(createDTO.getSrid());
                mosaicDatasetCreateDTO.setDataPhase(createDTO.getDataPhase());
                mosaicDatasetCreateDTO.setBandCount(-1);
                mosaicDatasetCreateDTO.setPixelDataType(0);
                mosaicDatasetCreateDTO.setInvalidValue(0.0);
                geoDatasetId = this.mosaicDatasetService.createMosaicDataset(mosaicDatasetCreateDTO);
                MosaicDatasetEditDTO mosaicDatasetEditDTO = new MosaicDatasetEditDTO();
                mosaicDatasetEditDTO.setId(geoDatasetId);
                mosaicDatasetEditDTO.setAliasName(createDTO.getAliasName());
                mosaicDatasetEditDTO.setDataPhase(createDTO.getDataPhase());
                FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
                fieldsEditDTO.setAddFields(fields);
                mosaicDatasetEditDTO.setFields(fieldsEditDTO);
                this.mosaicDatasetService.updateMosaicDataset(mosaicDatasetEditDTO);
                MosaicDatasetDTO mosaicDataset = (MosaicDatasetDTO)this.geoDatabaseService.getDatasetDetail(geoDatabase, DatasetTypeEnum.MosaicDataset, createDTO.getName());
                allFields = ListUtil.convertAll(mosaicDataset.getFields(), f -> this.convertToDsDatumField((FieldDTO)f, datumDatasetId));
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b\uff01");
            }
        }
        ArrayList<DsDatumField> dsDatumFieldList = new ArrayList<DsDatumField>(allFields);
        DatumFieldDTO identifyField = (DatumFieldDTO)((Object)ListUtil.find(createDTO.getFields(), DatumFieldDTO::getIdentify));
        List nameFields = ListUtil.findAll(createDTO.getFields(), DatumFieldDTO::getDatumName);
        List nameFieldList = ListUtil.convertAll((List)nameFields, f -> f.getName().toUpperCase(Locale.ROOT));
        dsDatumFieldList.forEach(field -> {
            if (field.getName().equalsIgnoreCase(identifyField.getName())) {
                field.setIdentify(ConstantsValue.TRUE_SHORT);
            }
            if (nameFieldList.contains(field.getName().toUpperCase(Locale.ROOT))) {
                field.setDatumName(ConstantsValue.TRUE_SHORT);
            }
            if (!userFieldNames.contains(field.getName().toUpperCase(Locale.ROOT))) {
                field.setSystem(ConstantsValue.TRUE_SHORT);
            }
        });
        this.datumFieldsDao.batchInsert(dsDatumFieldList);
        DsDatum dsDatum = new DsDatum();
        dsDatum.setDatasetId(datumDatasetId);
        dsDatum.setGeoDatasetId(geoDatasetId);
        dsDatum.setDataStoreKey(createDTO.getDsKey());
        dsDatum.setSpatialDsKey(geoDatabase.getKey());
        dsDatum.setName(createDTO.getName());
        dsDatum.setAliasName(createDTO.getAliasName());
        dsDatum.setDatumDatasetType(createDTO.getDatumDatasetType());
        List fileModelIds = ListUtil.convertAll(createDTO.getFileModelIds(), Object::toString);
        dsDatum.setDataModelIds(String.join((CharSequence)",", fileModelIds) + ",");
        dsDatum.setSrid(createDTO.getSrid().longValue());
        dsDatum.setFeatureType(createDTO.getFeatureType() == null ? null : Long.valueOf(createDTO.getFeatureType().longValue()));
        int eventId = 111;
        String log = String.format("\u521b\u5efa%s\uff1a%s > %s", datumType.getDesc(), datumDatabaseDTO.getName(), dsDatum.getName());
        if (createDTO.getModelDatasetType() != null) {
            ModelDatasetTypeEnum modelType = ModelDatasetTypeEnum.getByValue(createDTO.getModelDatasetType());
            dsDatum.setModelType(modelType.getValue());
            eventId = 171;
            log = String.format("\u521b\u5efa%s\uff1a%s > %s", modelType.getDesc(), datumDatabaseDTO.getName(), dsDatum.getName());
        } else {
            dsDatum.setModelType(null);
        }
        this.datumDao.insert(dsDatum);
        this.sysLogService.addLog(eventId, log);
        return datumDatasetId;
    }

    @Override
    public void updateDatumDataset(DatumDatasetEditDTO editDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(editDTO.getId());
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        DatumDatasetTypeEnum datumType = DatumDatasetTypeEnum.getByValue(dsDatum.getDatumDatasetType());
        FieldsEditDTO fieldsEditDTO = null;
        if (editDTO.getFields() != null) {
            fieldsEditDTO = new FieldsEditDTO();
            fieldsEditDTO.setAddFields(ListUtil.convertAll(editDTO.getFields().getAddFields(), item -> item));
            fieldsEditDTO.setUpdateFields(ListUtil.convertAll(editDTO.getFields().getUpdateFields(), item -> item));
            fieldsEditDTO.setDeleteFields(editDTO.getFields().getDeleteFields());
            this.updateDatumFieldsInfo(dsDatum.getDatasetId(), editDTO.getFields());
        }
        switch (datumType) {
            case DatumDataset: {
                TableEditDTO tableEditDTO = new TableEditDTO();
                tableEditDTO.setId(dsDatum.getGeoDatasetId());
                tableEditDTO.setAliasName(editDTO.getAliasName());
                tableEditDTO.setFields(fieldsEditDTO);
                this.tableDatasetService.updateTable(tableEditDTO);
                break;
            }
            case GeoDatumDataset: {
                FeatureClassEditDTO featureClassEditDTO = new FeatureClassEditDTO();
                featureClassEditDTO.setId(dsDatum.getGeoDatasetId());
                featureClassEditDTO.setAliasName(editDTO.getAliasName());
                featureClassEditDTO.setDataPhase(editDTO.getDataPhase());
                featureClassEditDTO.setFields(fieldsEditDTO);
                this.featureClassService.updateFeatureClass(featureClassEditDTO);
                break;
            }
            case GeoMosaicDatumDataset: {
                MosaicDatasetEditDTO mosaicDatasetEditDTO = new MosaicDatasetEditDTO();
                mosaicDatasetEditDTO.setId(dsDatum.getGeoDatasetId());
                mosaicDatasetEditDTO.setAliasName(editDTO.getAliasName());
                mosaicDatasetEditDTO.setDataPhase(editDTO.getDataPhase());
                mosaicDatasetEditDTO.setFields(fieldsEditDTO);
                this.mosaicDatasetService.updateMosaicDataset(mosaicDatasetEditDTO);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b\uff01");
            }
        }
        dsDatum.setAliasName(editDTO.getAliasName());
        if (editDTO.getFileModelIds() != null && editDTO.getFileModelIds().size() > 0) {
            List fileModelIds = ListUtil.convertAll(editDTO.getFileModelIds(), Object::toString);
            dsDatum.setDataModelIds(String.join((CharSequence)",", fileModelIds) + ",");
        }
        this.datumDao.updateByPrimaryKey(dsDatum);
        String datasourceName = this.dataSourceManager.getDataSourceName(datasetNameInfo.getDsKey());
        int eventId = 111;
        String log = String.format("\u4fee\u6539%s\uff1a%s > %s", datumType.getDesc(), datasourceName, dsDatum.getName());
        if (dsDatum.getModelType() != null) {
            ModelDatasetTypeEnum modelType = ModelDatasetTypeEnum.getByValue(dsDatum.getModelType());
            eventId = 171;
            log = String.format("\u4fee\u6539%s\uff1a%s > %s", modelType.getDesc(), datasourceName, dsDatum.getName());
        }
        this.sysLogService.addLog(eventId, log);
    }

    @Override
    public void updateDatumFields(String datasetId, DatumFieldsEditDTO fields) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        this.updateDatumFieldsInfo(datasetId, fields);
        FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
        fieldsEditDTO.setAddFields(ListUtil.convertAll(fields.getAddFields(), item -> item));
        fieldsEditDTO.setUpdateFields(ListUtil.convertAll(fields.getUpdateFields(), item -> item));
        fieldsEditDTO.setDeleteFields(fields.getDeleteFields());
        this.geoDatabaseService.updateDatasetFields(dsDatum.getGeoDatasetId(), fieldsEditDTO);
    }

    @Override
    public void deleteDatumDataset(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(id);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        try {
            this.geoDatabaseService.deleteDataset(dsDatum.getGeoDatasetId());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u6570\u636e\u96c6\u5bf9\u5e94\u7684\u7a7a\u95f4\u6570\u636e\u96c6\u5220\u9664\u5931\u8d25\uff01", (Throwable)e);
        }
        this.datumDao.deleteByPrimaryKey(dsDatum.getDatasetId());
        this.datumFieldsDao.deleteByDatasetId(dsDatum.getDatasetId());
        this.fileDataService.deleteFileDataByDataset(id);
        DatumDatasetTypeEnum datumType = DatumDatasetTypeEnum.getByValue(dsDatum.getDatumDatasetType());
        String datasourceName = this.dataSourceManager.getDataSourceName(datasetNameInfo.getDsKey());
        int eventId = 111;
        String log = String.format("\u5220\u9664%s\uff1a%s > %s", datumType.getDesc(), datasourceName, dsDatum.getName());
        if (dsDatum.getModelType() != null) {
            ModelDatasetTypeEnum modelType = ModelDatasetTypeEnum.getByValue(dsDatum.getModelType());
            eventId = 171;
            log = String.format("\u5220\u9664%s\uff1a%s > %s", modelType.getDesc(), datasourceName, dsDatum.getName());
        }
        this.sysLogService.addLog(eventId, log);
    }

    @Override
    public List<SimpleDatasetDTO> getDatumDatasetByFileModel(Long modelId) {
        String fileModelId = modelId + ",";
        List<DsDatum> dsDatumList = this.datumDao.selectByFileModelId(fileModelId);
        ArrayList<SimpleDatasetDTO> result = new ArrayList<SimpleDatasetDTO>();
        for (DsDatum dsDatum : dsDatumList) {
            SimpleDatasetDTO simpleDatasetDTO = this.convertSimpleDatasetDTO(dsDatum);
            result.add(simpleDatasetDTO);
        }
        return result;
    }

    @Override
    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO queryFilterDTO) {
        List<ThumbDTO> thumbs;
        DataQueryResult queryResult;
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        List queryFields = StringUtil.split((String)queryFilterDTO.getFields(), (String)",", f -> f);
        boolean removeDataIdFld = false;
        if (!"*".equals(queryFilterDTO.getFields()) && !queryFields.contains("F_DATAID")) {
            queryFields.add("F_DATAID");
            queryFilterDTO.setFields(String.join((CharSequence)",", queryFields));
            removeDataIdFld = true;
        }
        if ((queryResult = this.geoDatabaseService.queryGeoDataset(dsDatum.getGeoDatasetId(), queryFilterDTO)).getData() != null && queryResult.getData().size() > 0 && (thumbs = this.thumbService.queryThumbs(ListUtil.convertAll(queryResult.getData(), f -> f.getAttributes().get("F_DATAID").toString()), 64)) != null && thumbs.size() > 0) {
            queryResult.getData().forEach(item -> {
                String dataId = item.getAttributes().get("F_DATAID").toString();
                ThumbDTO thumb = (ThumbDTO)ListUtil.find((List)thumbs, f -> f.getDataId().equals(dataId));
                item.getAttributes().put("F_THUMB", thumb == null ? null : thumb.getImageBase64());
            });
            queryResult.getFields().add(0, new ReturnField("F_THUMB", "\u7f29\u7565\u56fe", FieldType.String.getValue()));
            if (removeDataIdFld) {
                ReturnField returnField = (ReturnField)ListUtil.find(queryResult.getFields(), f -> f.getName().equals("F_DATAID"));
                queryResult.getFields().remove(returnField);
            }
        }
        queryResult.setId(datasetId);
        return queryResult;
    }

    @Override
    public long queryDataCount(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        return this.geoDatabaseService.queryDataCount(dsDatum.getGeoDatasetId(), queryFilterDTO);
    }

    @Override
    public List<Object> queryDataFieldUniqValues(String datasetId, QueryFilterBasicDTO queryFilterDTO, Integer limit) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        return this.geoDatabaseService.queryDataFieldUniqValues(dsDatum.getGeoDatasetId(), queryFilterDTO, limit);
    }

    @Override
    public String getGeoDatasetId(String datasetId) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        if (dsDatum == null) {
            return null;
        }
        return dsDatum.getGeoDatasetId();
    }

    @Override
    public DatasetMetaDTO getDatumDatasetMeta(String datasetId) {
        String geoDatasetId = this.getGeoDatasetId(datasetId);
        return this.dataSourceManager.getDatasetMeta(geoDatasetId);
    }

    @Override
    public String getDatumDataId(String datasetId, Object objectId) {
        FeatureResult targetData;
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        DataQueryResult dataQueryResult = this.geoDatabaseService.queryByObjectId(dsDatum.getGeoDatasetId(), objectId, "F_DATAID", false);
        if (dataQueryResult != null && dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0 && (targetData = dataQueryResult.getData().get(0)).getAttributes().get("F_DATAID") != null) {
            return targetData.getAttributes().get("F_DATAID").toString();
        }
        return null;
    }

    @Override
    public FileDataUnitDTO getDatasetFileData(String datasetId, Object objectId) {
        String dataId = this.getDatumDataId(datasetId, objectId);
        return this.fileDataService.getFileDataTree(dataId);
    }

    @Override
    public List<FilePathDTO> getDatasetFilePathList(String datasetId) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        ArrayList<FilePathDTO> filePathList = new ArrayList<FilePathDTO>();
        List<DmFileData> fileDataList = this.fileDataService.getFileDataListByDatasetId(datasetId);
        HashMap<String, String> map = new HashMap<String, String>(0);
        for (DmFileData fileData : fileDataList) {
            String fileStorageKey = fileData.getServerId();
            String location = fileData.getMainPath();
            String key = fileStorageKey + location;
            if (map.containsKey(key)) continue;
            IFileStorage fileStorage = this.fileStorageService.openFileStorage(fileStorageKey);
            FilePathDTO filePath = new FilePathDTO();
            filePath.setFileStorageKey(fileStorageKey);
            filePath.setPath(fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{location}));
            filePath.setLocation(location);
            map.put(key, filePath.getPath());
            filePathList.add(filePath);
        }
        return filePathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairFilePath(List<FilePathRepairDTO> repairList) {
        if (repairList == null || repairList.size() == 0) {
            return;
        }
        String datasetId = repairList.get(0).getDatasetId();
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo(dsDatum.getGeoDatasetId());
        ArrayList<DataStoreTypeEnum> dataStoreTypes = new ArrayList<DataStoreTypeEnum>();
        dataStoreTypes.add(DataStoreTypeEnum.FileStorageSystem);
        ArrayList<DataSourceTypeEnum> dataSourceTypes = new ArrayList<DataSourceTypeEnum>();
        List<DataSourceDTO> fileStorageList = this.dataSourceManager.listDataSource(dataStoreTypes, dataSourceTypes, null);
        for (FilePathRepairDTO item : repairList) {
            if (!datasetId.equals(item.getDatasetId())) {
                throw new RuntimeException("\u8bf7\u7edf\u4e00\u6570\u636e\u96c6\u6807\u8bc6\uff01");
            }
            FilePathDTO newFilePath = item.getNewPath();
            if (StringUtil.isEmptyOrWhiteSpace((String)newFilePath.getFileStorageKey())) {
                throw new RuntimeException("\u8bf7\u4ece\u5b58\u50a8\u8282\u70b9\u9009\u62e9\u8def\u5f84\uff1a" + newFilePath.getPath());
            }
            DataSourceDTO dataSource = (DataSourceDTO)ListUtil.find(fileStorageList, f -> f.getKey().equals(newFilePath.getFileStorageKey()));
            if (!newFilePath.getPath().replace("\\", "/").startsWith(dataSource.getUrl().replace("\\", "/"))) {
                throw new RuntimeException(String.format("\u8f6c\u6362\u540e\u8def\u5f84\u3010%s\u3011\u4e0e\u5b58\u50a8\u8282\u70b9\u4e0d\u5339\u914d", newFilePath.getPath()));
            }
            String url = dataSource.getUrl().replace("\\", "/");
            String targetLocation = newFilePath.getPath().replace("\\", "/").substring(url.length());
            if (StringUtil.isEmptyOrWhiteSpace((String)targetLocation)) {
                targetLocation = "/";
            }
            if (!targetLocation.startsWith("/")) {
                targetLocation = "/" + targetLocation;
            }
            item.getNewPath().setLocation(targetLocation);
        }
        DataSourceDTO targetDatabase = this.dataSourceManager.getGeoDatabaseDetail(nameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(targetDatabase);
        ICursor cursor = null;
        try {
            boolean isMosaicDatum = nameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue();
            String tableName = isMosaicDatum ? nameInfo.getName().replace(nameInfo.getShortName(), "GWMD_" + nameInfo.getShortName() + "_CAT") : nameInfo.getName();
            ITable table = workspace.openTable(tableName);
            boolean hasServerIdFld = table.getFields().findFieldIndex("F_SERVERID") > -1;
            HashMap<String, DmFileData> fileDataMap = new HashMap<String, DmFileData>(0);
            List<DmFileData> fileDataList = this.fileDataService.getFileDataListByDatasetId(datasetId);
            for (DmFileData fileData : fileDataList) {
                fileDataMap.put(fileData.getDataId(), fileData);
            }
            cursor = table.updateRow(null);
            IRow row = null;
            while ((row = cursor.nextRow()) != null) {
                String srcPath;
                String uri;
                Object uriObject;
                String location;
                String fileStorageKey;
                FilePathRepairDTO repairItem;
                Object dataIdObj = row.getValue("F_DATAID");
                if (dataIdObj == null || (repairItem = (FilePathRepairDTO)ListUtil.find(repairList, arg_0 -> DatumDatabaseServiceImpl.lambda$repairFilePath$21(fileStorageKey = ((DmFileData)fileDataMap.get(dataIdObj.toString())).getServerId(), location = ((DmFileData)fileDataMap.get(dataIdObj.toString())).getMainPath(), arg_0))) == null) continue;
                if (hasServerIdFld) {
                    row.setValue("F_SERVERID", (Object)repairItem.getNewPath().getFileStorageKey());
                    row.setValue("F_LOCATION", (Object)repairItem.getNewPath().getLocation());
                }
                if (isMosaicDatum && (uriObject = row.getValue("urihash")) != null && StringUtil.isNotEmpty((String)uriObject.toString()) && (uri = uriObject.toString().replace("\\", "/")).startsWith(srcPath = repairItem.getSrcPath().getPath().replace("\\", "/"))) {
                    String mewUri = uri.replace(srcPath, repairItem.getNewPath().getPath());
                    row.setValue("urihash", (Object)mewUri.replace("\\", "/"));
                }
                String dataId = dataIdObj.toString();
                cursor.updateRow(row);
                this.updateDataPath(dataId, repairItem);
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
    }

    @Override
    public List<DatumFieldDTO> getSystemFields() {
        ArrayList<DatumFieldDTO> systemFieldList = new ArrayList<DatumFieldDTO>();
        Field dataIdFld = new Field("F_DATAID", "\u6570\u636eID", FieldType.String, 32);
        systemFieldList.add(this.convertToDatumField(dataIdFld));
        Field dataNameFld = new Field("F_DATANAME", "\u6570\u636e\u540d\u79f0", FieldType.String, 255);
        systemFieldList.add(this.convertToDatumField(dataNameFld));
        Field dataSize = new Field("F_DATASIZE", "\u6570\u636e\u5927\u5c0f", FieldType.Long);
        systemFieldList.add(this.convertToDatumField(dataSize));
        return systemFieldList;
    }

    private List<FieldDTO> checkDatumField(List<DatumFieldDTO> datumFieldList) {
        DatumFieldDTO identifyField = (DatumFieldDTO)((Object)ListUtil.find(datumFieldList, DatumFieldDTO::getIdentify));
        Assert.notNull((Object)((Object)identifyField), (String)"\u8bf7\u8bbe\u7f6e\u6807\u8bc6\u5b57\u6bb5\uff01");
        List nameFields = ListUtil.findAll(datumFieldList, DatumFieldDTO::getDatumName);
        if (nameFields.size() == 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\u5b57\u6bb5\uff01");
        }
        if (nameFields.size() > 1) {
            throw new RuntimeException("\u4ec5\u4e00\u4e2a\u5b57\u6bb5\u53ef\u8bbe\u7f6e\u4e3a\u540d\u79f0\u5b57\u6bb5\uff01");
        }
        List<DatumFieldDTO> systemFields = this.getSystemFields();
        systemFields.forEach(field -> {
            DatumFieldDTO item = (DatumFieldDTO)((Object)((Object)ListUtil.find((List)datumFieldList, f -> f.getName().equalsIgnoreCase(field.getName()))));
            if (item != null) {
                datumFieldList.remove((Object)item);
                field.setIdentify(item.getIdentify());
                field.setDatumName(item.getDatumName());
            }
        });
        datumFieldList.addAll(0, systemFields);
        return ListUtil.convertAll(datumFieldList, f -> f);
    }

    private DatumFieldDTO convertToDatumField(Field field) {
        FieldDTO fieldDTO = FieldUtil.convertField((IField)field);
        DatumFieldDTO datumField = new DatumFieldDTO();
        BeanUtils.copyProperties((Object)fieldDTO, (Object)((Object)datumField));
        datumField.setDatumName(false);
        datumField.setIdentify(false);
        datumField.setSystemField(true);
        return datumField;
    }

    private DsDatumField convertToDsDatumField(DatumFieldDTO datumFieldDTO, String datasetId) {
        DsDatumField dsDatumField = new DsDatumField();
        dsDatumField.setName(datumFieldDTO.getName().trim());
        dsDatumField.setAliasName(datumFieldDTO.getAliasName());
        dsDatumField.setDatasetId(datasetId);
        dsDatumField.setIdentify(ConstantsValue.shortValue((Boolean)datumFieldDTO.getIdentify()));
        dsDatumField.setDatumName(ConstantsValue.shortValue((Boolean)datumFieldDTO.getDatumName()));
        dsDatumField.setSystem(ConstantsValue.FALSE_SHORT);
        return dsDatumField;
    }

    private DsDatumField convertToDsDatumField(FieldDTO fieldDTO, String datasetId) {
        DsDatumField dsDatumField = new DsDatumField();
        dsDatumField.setName(fieldDTO.getName().trim());
        dsDatumField.setAliasName(fieldDTO.getAliasName());
        dsDatumField.setDatasetId(datasetId);
        dsDatumField.setIdentify(ConstantsValue.FALSE_VALUE.shortValue());
        dsDatumField.setDatumName(ConstantsValue.FALSE_VALUE.shortValue());
        dsDatumField.setSystem(ConstantsValue.FALSE_VALUE.shortValue());
        return dsDatumField;
    }

    private DsDatumField buildDatumField(String name, String aliasName, String datasetId) {
        DsDatumField field = new DsDatumField();
        field.setDatasetId(datasetId);
        field.setName(name);
        field.setAliasName(aliasName);
        field.setDatumName(ConstantsValue.FALSE_VALUE.shortValue());
        field.setIdentify(ConstantsValue.FALSE_VALUE.shortValue());
        field.setSystem(ConstantsValue.FALSE_VALUE.shortValue());
        return field;
    }

    private void updateDatumFieldsInfo(String datasetId, DatumFieldsEditDTO fields) {
        List nameFields;
        DsDatumField dsDatumField;
        List<DsDatumField> dsDatumFieldList = this.datumFieldsDao.selectByDatasetId(datasetId);
        if (fields.getAddFields() != null) {
            Iterator<String> addFields = new ArrayList();
            for (DatumFieldDTO addField : fields.getAddFields()) {
                DsDatumField dsDatumField2 = this.convertToDsDatumField(addField, datasetId);
                addFields.add((String)((Object)dsDatumField2));
            }
            if (addFields.size() > 0) {
                this.datumFieldsDao.batchInsert((List<DsDatumField>)((Object)addFields));
                dsDatumFieldList.addAll((Collection<DsDatumField>)((Object)addFields));
            }
        }
        if (fields.getUpdateFields() != null) {
            for (DatumFieldDTO updateField : fields.getUpdateFields()) {
                dsDatumField = (DsDatumField)ListUtil.find(dsDatumFieldList, f -> f.getName().equalsIgnoreCase(updateField.getName()));
                dsDatumField.setAliasName(updateField.getAliasName());
                dsDatumField.setDatumName(ConstantsValue.shortValue((Boolean)updateField.getDatumName()));
                dsDatumField.setIdentify(ConstantsValue.shortValue((Boolean)updateField.getIdentify()));
                this.datumFieldsDao.updateByPrimaryKey(dsDatumField);
            }
        }
        if (fields.getDeleteFields() != null) {
            for (String deleteField : fields.getDeleteFields()) {
                dsDatumField = (DsDatumField)ListUtil.find(dsDatumFieldList, f -> f.getName().equalsIgnoreCase(deleteField));
                this.datumFieldsDao.deleteByPrimaryKey(dsDatumField.getId());
                dsDatumFieldList.remove(dsDatumField);
            }
        }
        if ((nameFields = ListUtil.findAll(dsDatumFieldList, f -> ConstantsValue.boolValue((Short)f.getDatumName()))).size() == 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u540d\u79f0\u5b57\u6bb5\uff01");
        }
        if (nameFields.size() > 1) {
            throw new RuntimeException("\u4ec5\u4e00\u4e2a\u5b57\u6bb5\u53ef\u8bbe\u7f6e\u4e3a\u540d\u79f0\u5b57\u6bb5\uff01");
        }
        DsDatumField identifyField = (DsDatumField)ListUtil.find(dsDatumFieldList, f -> ConstantsValue.boolValue((Short)f.getIdentify()));
        if (identifyField == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6807\u8bc6\u5b57\u6bb5\uff01");
        }
    }

    protected SimpleDatasetDTO convertSimpleDatasetDTO(DsDatum dsDatum) {
        SimpleDatasetDTO wrapDataset;
        SimpleDatasetDTO simpleDatasetDTO = new SimpleDatasetDTO();
        simpleDatasetDTO.setId(dsDatum.getDatasetId());
        simpleDatasetDTO.setName(dsDatum.getName());
        simpleDatasetDTO.setAliasName(dsDatum.getAliasName());
        simpleDatasetDTO.setType(DatasetTypeEnum.DatumDataset.getValue());
        simpleDatasetDTO.setTypeDesc(DatasetTypeEnum.DatumDataset.getDesc());
        simpleDatasetDTO.setDatumType(dsDatum.getDatumDatasetType());
        simpleDatasetDTO.setFeatureType(dsDatum.getFeatureType() == null ? null : Integer.valueOf(dsDatum.getFeatureType().intValue()));
        simpleDatasetDTO.setHasRender(StringUtil.isNotEmpty((String)dsDatum.getDatasetRender()));
        if (this.datumDatasetWrapper != null && (wrapDataset = this.datumDatasetWrapper.wrapDatumDataset(simpleDatasetDTO)) != null) {
            return wrapDataset;
        }
        return simpleDatasetDTO;
    }

    protected void updateDataPath(String dataId, FilePathRepairDTO repairItem) {
        DmFileData fileData = this.fileDataService.getFileData(dataId);
        if (fileData == null) {
            return;
        }
        FilePathDTO newFilePath = repairItem.getNewPath();
        fileData.setMainPath(newFilePath.getLocation());
        fileData.setServerId(newFilePath.getFileStorageKey());
        List files = JSONArray.parseArray((String)fileData.getCatalogFiles(), FileDataUnit.class);
        String srcLocation = repairItem.getSrcPath().getLocation().replace("\\", "/");
        String tarLocation = newFilePath.getLocation().replace("\\", "/");
        for (FileDataUnit file : files) {
            String fileLocation = file.getFileLocation().replace("\\", "/").substring(srcLocation.length());
            if (tarLocation.endsWith("/") && fileLocation.startsWith("/")) {
                fileLocation = fileLocation.substring(1);
            }
            fileLocation = tarLocation + fileLocation;
            file.setFileLocation(fileLocation);
            if (file.getServerId() == null) continue;
            file.setServerId(newFilePath.getFileStorageKey());
        }
        fileData.setCatalogFiles(JSONArray.toJSONString((Object)files));
        this.fileDataService.updateFileData(fileData);
    }

    private static /* synthetic */ boolean lambda$repairFilePath$21(String fileStorageKey, String location, FilePathRepairDTO f) {
        return fileStorageKey.equals(f.getSrcPath().getFileStorageKey()) && location.equals(f.getSrcPath().getLocation());
    }
}

