/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.dao.DmDistrictDao;
import com.geoway.adf.dms.datasource.dao.DmDistrictItemDao;
import com.geoway.adf.dms.datasource.dao.DmDistrictLevelDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictCreateDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemImportDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelCreateDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelTreeDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictTreeDTO;
import com.geoway.adf.dms.datasource.dto.district.DmDistrictDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.entity.DmDistrict;
import com.geoway.adf.dms.datasource.entity.DmDistrictItem;
import com.geoway.adf.dms.datasource.entity.DmDistrictLevel;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class DistrictServiceImpl
implements DistrictService {
    private static final Logger log = LoggerFactory.getLogger(DistrictServiceImpl.class);
    @Resource
    private UserRightProperties userRightProperties;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private DmDistrictDao dmDistrictDao;
    @Resource
    private DmDistrictLevelDao districtLevelDao;
    @Resource
    private DmDistrictItemDao dmDistrictItemDao;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DataSourceService dataSourceService;
    private DistrictServiceImpl self;

    public DistrictServiceImpl(ApplicationContext context) {
        this.self = (DistrictServiceImpl)context.getBean(DistrictServiceImpl.class);
    }

    @Cacheable(value={"DistrictCache"}, keyGenerator="customKeyGenerator")
    public Map<String, List<DmDistrictItem>> getAllDistrictItem(Long districtId) {
        List<DmDistrictItem> allItems = this.dmDistrictItemDao.selectByDistrictId(districtId, null);
        HashMap<String, List<DmDistrictItem>> childrenMap = new HashMap<String, List<DmDistrictItem>>();
        for (DmDistrictItem item : allItems) {
            String key = String.valueOf(item.getPid());
            if (!childrenMap.containsKey(key)) {
                childrenMap.put(String.valueOf(item.getPid()), new ArrayList());
            }
            List children = (List)childrenMap.get(key);
            children.add(item);
        }
        return childrenMap;
    }

    @Override
    public List<DmDistrictDTO> list() {
        ArrayList<DmDistrictDTO> result = new ArrayList<DmDistrictDTO>();
        List<DmDistrict> districtList = this.dmDistrictDao.queryByKeyword("");
        districtList.forEach(item -> {
            DmDistrictDTO dto = new DmDistrictDTO();
            BeanUtils.copyProperties((Object)item, (Object)dto);
            dto.setIsDefault(item.getIsDefault() != null && item.getIsDefault().equals(ConstantsValue.TRUE_VALUE.shortValue()));
            result.add(dto);
        });
        return result;
    }

    @Override
    public List<DistrictTreeDTO> tree() {
        List<DmDistrictDTO> list = this.list();
        ArrayList<DistrictTreeDTO> listTree = new ArrayList<DistrictTreeDTO>();
        List<DmDistrictLevel> allLevels = this.districtLevelDao.selectAll();
        Map<Long, List<DmDistrictLevel>> levelGroup = allLevels.stream().collect(Collectors.groupingBy(DmDistrictLevel::getDistrictId));
        list.forEach(district -> {
            DistrictTreeDTO treeItem = new DistrictTreeDTO();
            BeanUtils.copyProperties((Object)district, (Object)treeItem);
            treeItem.setKey(district.getId() + "");
            treeItem.setLevelChildren(new ArrayList<DistrictLevelTreeDTO>());
            if (levelGroup.containsKey(treeItem.getId())) {
                List levelList = (List)levelGroup.get(treeItem.getId());
                levelList.forEach(level -> {
                    DistrictLevelDTO dto = this.convertDistrictLevel((DmDistrictLevel)level);
                    DistrictLevelTreeDTO treeDTO = new DistrictLevelTreeDTO();
                    BeanUtils.copyProperties((Object)dto, (Object)treeDTO);
                    treeDTO.setKey(treeItem.getKey() + "-" + treeDTO.getIndex());
                    treeItem.getLevelChildren().add(treeDTO);
                });
                treeItem.getLevelChildren().sort(Comparator.comparingInt(DistrictLevelDTO::getIndex));
            }
            listTree.add(treeItem);
        });
        return listTree;
    }

    @Override
    public Long addDistrict(DistrictCreateDTO createDTO) {
        DmDistrict district = new DmDistrict();
        Assert.notNull((Object)createDTO.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)createDTO.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.state((boolean)this.districtCodeNotExist(createDTO.getCode()), (String)"\u65b9\u6848\u5df2\u5b58\u5728!");
        district.setName(createDTO.getName());
        district.setDataPhase(createDTO.getDataPhase());
        district.setType(createDTO.getType());
        district.setDesc(createDTO.getDesc());
        district.setCode(createDTO.getCode());
        district.setIsDefault(ConstantsValue.FALSE_VALUE.shortValue());
        this.dmDistrictDao.insert(district);
        return district.getId();
    }

    @Override
    public void setDefaultDistrict(Boolean isDefault, Long id) {
        DmDistrict district = this.dmDistrictDao.selectByPrimaryKey(id);
        Assert.notNull((Object)district, (String)"\u533a\u57df\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        if (isDefault.booleanValue()) {
            this.dmDistrictDao.cancelDefaultDistrict();
        }
        short isDefaultShort = isDefault != false ? ConstantsValue.TRUE_VALUE.shortValue() : ConstantsValue.FALSE_VALUE.shortValue();
        this.dmDistrictDao.setDefaultDistrict(id, isDefaultShort);
    }

    @Override
    public DistrictItemDTO getDefaultDistrictItem(Long districtId) {
        DmDistrict district = null;
        if (districtId == null) {
            List<DmDistrict> list = this.dmDistrictDao.queryDefault();
            if (list == null || list.size() == 0) {
                return null;
            }
            district = list.get(0);
        } else {
            district = this.dmDistrictDao.selectByPrimaryKey(districtId);
        }
        if (district == null) {
            return null;
        }
        List<String> userXzqdms = this.getUserXzqdm();
        if (userXzqdms != null) {
            List<DmDistrictItem> userDistrictItems = this.dmDistrictItemDao.selectByCodes(district.getId(), userXzqdms);
            if (userDistrictItems.size() == 0) {
                log.error("\u7528\u6237\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", userXzqdms));
                return null;
            }
            if (userDistrictItems.size() == 1) {
                return this.transferToItemDetail(userDistrictItems.get(0), userDistrictItems.get(0).getLevelIndex().shortValue());
            }
            return null;
        }
        if (district.getDefaultItemId() == null) {
            return null;
        }
        DistrictItemDTO defaultItem = null;
        try {
            DmDistrictItem item = this.dmDistrictItemDao.selectByPrimaryKey(district.getDefaultItemId());
            if (item == null) {
                log.error("\u9ed8\u8ba4\u533a\u57df\u5355\u5143\u4e0d\u5b58\u5728");
                return null;
            }
            defaultItem = this.transferToItemDetail(item, -1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return defaultItem;
    }

    @Override
    public void setDefaultDistrictItem(Long districtId, Long id) {
        if (id == null) {
            log.info(districtId + "\u6e05\u9664\u9ed8\u8ba4\u533a\u57df\uff01");
        }
        this.dmDistrictDao.setDefaultDistrictItem(districtId, id);
    }

    @Override
    public void updateDistrict(DistrictEditDTO editDTO) {
        DmDistrict district = this.dmDistrictDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)district, (String)"\u533a\u57df\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getCode() != null && !editDTO.getCode().equals(district.getCode())) {
            Assert.state((boolean)this.districtCodeNotExist(editDTO.getCode()), (String)"\u65b9\u6848\u5df2\u5b58\u5728!");
            district.setCode(editDTO.getCode());
        }
        if (editDTO.getName() != null) {
            district.setName(editDTO.getName());
        }
        if (editDTO.getDataPhase() != null) {
            district.setDataPhase(editDTO.getDataPhase());
        }
        if (editDTO.getType() != null) {
            district.setType(editDTO.getType());
        }
        if (editDTO.getDesc() != null) {
            district.setDesc(editDTO.getDesc());
        }
        this.dmDistrictDao.updateByPrimaryKey(district);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDistrict(Long id) {
        this.districtLevelDao.deleteByDistrictId(id);
        this.dmDistrictItemDao.deleteByDistrictId(id);
        this.dmDistrictDao.deleteByPrimaryKey(id);
    }

    @Override
    public void addDistrictLevel(DistrictLevelCreateDTO createDTO) {
        DmDistrictLevel level = new DmDistrictLevel();
        level.setDistrictId(createDTO.getDistrictId());
        level.setName(createDTO.getName());
        level.setDesc(createDTO.getDesc());
        level.setIndex(this.getNextDistrictLevel(createDTO.getDistrictId()));
        this.districtLevelDao.insert(level);
    }

    @Override
    public void updateDistrictLevel(DistrictLevelEditDTO editDTO) {
        DmDistrictLevel level = this.districtLevelDao.selectByPrimaryKey(editDTO.getDistrictId(), editDTO.getIndex());
        Assert.notNull((Object)level, (String)"\u533a\u57df\u7ea7\u522b\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getName() != null) {
            level.setName(editDTO.getName());
        }
        if (editDTO.getDesc() != null) {
            level.setDesc(editDTO.getDesc());
        }
        if (editDTO.getDistrictId() != null) {
            level.setDistrictId(editDTO.getDistrictId());
        }
        if (editDTO.getDatasetId() != null) {
            level.setDatasetId(editDTO.getDatasetId());
        }
        if (editDTO.getNameFldName() != null) {
            level.setNameFldName(editDTO.getNameFldName());
        }
        if (editDTO.getCodeFldName() != null) {
            level.setCodeFldName(editDTO.getCodeFldName());
        }
        this.districtLevelDao.updateByPrimaryKey(level);
    }

    @Override
    public void deleteDistrictLevel(Long districtId, Short index) {
        Assert.state((!this.itemLevelExist(districtId, index) ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u533a\u57df\u5355\u5143\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        this.districtLevelDao.deleteAfterIndex(districtId, index);
    }

    @Override
    public List<DistrictLevelDTO> getDistrictLevels(Long districtId) {
        short minLevel = -1;
        List<String> userXzqdms = this.getUserXzqdm();
        if (userXzqdms != null) {
            List<DmDistrictItem> userDistrictItems = this.dmDistrictItemDao.selectByCodes(districtId, userXzqdms);
            if (userDistrictItems.size() == 0) {
                log.error("\u7528\u6237\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", userXzqdms));
                return new ArrayList<DistrictLevelDTO>();
            }
            minLevel = userDistrictItems.stream().min(Comparator.comparing(DmDistrictItem::getLevelIndex)).get().getLevelIndex();
        }
        ArrayList<DistrictLevelDTO> result = new ArrayList<DistrictLevelDTO>();
        List<DmDistrictLevel> levelList = this.districtLevelDao.selectByDistrictId(districtId);
        for (DmDistrictLevel districtLevel : levelList) {
            if (districtLevel.getIndex() < minLevel) continue;
            DistrictLevelDTO dto = this.convertDistrictLevel(districtLevel);
            result.add(dto);
        }
        return result;
    }

    @Override
    public DistrictLevelDTO getDistrictLevelDetail(Long districtId, Short index) {
        DmDistrictLevel level = this.districtLevelDao.selectByPrimaryKey(districtId, index);
        Assert.notNull((Object)level, (String)"\u533a\u57df\u7ea7\u522b\u4e0d\u5b58\u5728\uff01");
        DistrictLevelDTO dto = this.convertDistrictLevel(level);
        try {
            if (StringUtil.isNotEmpty((String)level.getDatasetId())) {
                DatasetDTO dataset = this.dataSourceService.getDatasetDetailWithoutPwd(level.getDatasetId());
                dto.setDataset(dataset);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533a\u57df\u7ea7\u522b\u5173\u8054\u6570\u636e\u96c6\u5931\u8d25\uff01", (Throwable)e);
        }
        return dto;
    }

    @Override
    @CacheEvict(value={"DistrictCache"}, allEntries=true)
    public void updateDistrictItem(DistrictItemEditDTO editDTO) {
        DmDistrictItem item = this.dmDistrictItemDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)item, (String)"\u533a\u57df\u5355\u5143\u4e0d\u5b58\u5728\uff01");
        if (editDTO.getName() != null) {
            item.setName(editDTO.getName());
        }
        if (editDTO.getCode() != null) {
            item.setCode(editDTO.getCode());
        }
        this.dmDistrictItemDao.updateByPrimaryKey(item);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DistrictCache"}, allEntries=true)
    public void deleteDistrictItem(Long districtId, Long id) {
        List<DmDistrictItem> childItems = this.dmDistrictItemDao.selectByPId(districtId, id, null);
        if (childItems != null && childItems.size() > 0) {
            childItems.forEach(child -> this.deleteDistrictItem(districtId, child.getId()));
        }
        this.dmDistrictItemDao.deleteByPrimaryKey(id);
    }

    @Override
    public List<DistrictItemDTO> getDistrictItem(Long districtId, Long pid, String pCode, String keyword, Boolean withChildren, Integer searchCount) {
        Map<String, List<DmDistrictItem>> childrenMap;
        ArrayList<DistrictItemDTO> itemDTOList = new ArrayList<DistrictItemDTO>();
        if (pid == null && StringUtil.isNotEmpty((String)pCode)) {
            List<DmDistrictItem> pItems = this.dmDistrictItemDao.selectByCode(districtId, null, pCode);
            DmDistrictItem pItem = pItems.size() > 0 ? pItems.get(0) : null;
            Assert.notNull((Object)pItem, (String)("\u7236\u653f\u533a" + pCode + "\u4e0d\u5b58\u5728"));
            pid = pItem.getId();
        }
        pid = pid == null ? -1L : pid;
        Map<String, List<DmDistrictItem>> allChildrenMap = this.self.getAllDistrictItem(districtId);
        ArrayList<DmDistrictItem> itemList = new ArrayList<DmDistrictItem>();
        List<String> userXzqdms = this.getUserXzqdm();
        if (userXzqdms != null) {
            List<DmDistrictItem> userDistrictItems = this.dmDistrictItemDao.selectByCodes(districtId, userXzqdms);
            if (userDistrictItems.size() == 0) {
                log.error("\u7528\u6237\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", userXzqdms));
                return new ArrayList<DistrictItemDTO>();
            }
            userDistrictItems.sort(Comparator.comparing(DmDistrictItem::getLevelIndex));
            ArrayList<Long> pidList = new ArrayList<Long>();
            if (pid == -1L) {
                for (DmDistrictItem item : userDistrictItems) {
                    Long itemPid = item.getPid() == null ? -1L : item.getPid();
                    if (pidList.contains(itemPid)) continue;
                    pidList.add(itemPid);
                }
            } else {
                pidList.add(pid);
            }
            childrenMap = new LinkedHashMap<String, List<DmDistrictItem>>();
            short level = userDistrictItems.get(0).getLevelIndex();
            for (DmDistrictItem userDistrictItem : userDistrictItems) {
                if (userDistrictItem.getLevelIndex() != level) continue;
                String key = String.valueOf(userDistrictItem.getPid() == null ? -1L : userDistrictItem.getPid());
                List items = childrenMap.computeIfAbsent(key, k -> new ArrayList());
                items.add(userDistrictItem);
                this.getChildrenMap(userDistrictItem.getId(), childrenMap, allChildrenMap);
            }
            if (StringUtil.isNotEmpty((String)keyword)) {
                withChildren = false;
                for (Long id : pidList) {
                    itemList.addAll(this.getAllSubItems(id, keyword, childrenMap));
                }
            } else {
                for (Long id : pidList) {
                    if (!childrenMap.containsKey(String.valueOf(id))) continue;
                    itemList.addAll((Collection)childrenMap.get(String.valueOf(id)));
                }
            }
        } else {
            childrenMap = allChildrenMap;
            if (StringUtil.isNotEmpty((String)keyword)) {
                withChildren = false;
                itemList.addAll(this.getAllSubItems(pid, keyword, childrenMap));
            } else if (childrenMap.containsKey(String.valueOf(pid))) {
                itemList.addAll((Collection)childrenMap.get(String.valueOf(pid)));
            }
        }
        if (itemList.size() == 0) {
            return itemDTOList;
        }
        itemList.sort(Comparator.comparing(DmDistrictItem::getCode));
        for (DmDistrictItem item : itemList) {
            if (searchCount != null && itemDTOList.size() >= searchCount) break;
            DistrictItemDTO dto = this.transferToItemDto(item);
            if (withChildren.booleanValue()) {
                dto.setChildren(this.getItemChildren(childrenMap, dto.getId()));
            } else {
                dto.setChildren(new ArrayList<DistrictItemDTO>());
            }
            itemDTOList.add(dto);
        }
        return itemDTOList;
    }

    @Override
    public List<DistrictItemDTO> getDistrictItemList(Long districtId) {
        ArrayList<DistrictItemDTO> itemDTOList = new ArrayList<DistrictItemDTO>();
        Map<String, List<DmDistrictItem>> itemMap = this.self.getAllDistrictItem(districtId);
        List<DmDistrictItem> itemList = this.getAllSubItems(-1L, null, itemMap);
        for (DmDistrictItem item : itemList) {
            DistrictItemDTO dto = this.transferToItemDto(item);
            itemDTOList.add(dto);
        }
        return itemDTOList;
    }

    @Override
    public Map<String, List<DistrictItemDTO>> getDistrictItemsGroup(Long districtId, Long pid, String keyword, Boolean withChildren) {
        List<DistrictItemDTO> items = this.getDistrictItem(districtId, pid, null, keyword, withChildren, null);
        TreeMap<String, List<DistrictItemDTO>> pinyinGroups = new TreeMap<String, List<DistrictItemDTO>>();
        for (DistrictItemDTO item : items) {
            String pinyin;
            String string = pinyin = item.getPinYinName().length() > 0 ? item.getPinYinName().substring(0, 1) : "";
            if (!pinyinGroups.containsKey(pinyin)) {
                pinyinGroups.put(pinyin, new ArrayList());
            }
            ((List)pinyinGroups.get(pinyin)).add(item);
        }
        return pinyinGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"DistrictCache"}, allEntries=true)
    public void importDistrictItems(DistrictItemImportDTO importDTO) {
        short importLevel = importDTO.getLevelIndex();
        Long districtId = importDTO.getDistrictId();
        boolean import2Root = false;
        HashMap pItems = new HashMap(0);
        List<DmDistrictLevel> levelList = this.districtLevelDao.selectByDistrictId(districtId);
        DmDistrictLevel districtLevel = (DmDistrictLevel)ListUtil.find(levelList, l -> l.getIndex().equals(importLevel));
        if (levelList.size() == 0 || districtLevel == null) {
            throw new RuntimeException("\u65e0\u53ef\u5bfc\u5165\u7ea7\u522b\uff01");
        }
        if (importLevel == levelList.get(0).getIndex()) {
            import2Root = true;
        }
        Long firstItemId = null;
        List<DmDistrictItem> allItems = this.dmDistrictItemDao.selectByDistrictId(districtId, null);
        allItems.forEach(item -> {
            if (importLevel == this.getChildLevel(item.getLevelIndex(), levelList).getIndex()) {
                pItems.put(item.getCode(), item);
            }
            if (item.getLevelIndex() >= importLevel) {
                this.dmDistrictItemDao.deleteByPrimaryKey(item.getId());
            }
        });
        if (!import2Root && pItems.size() == 0) {
            throw new RuntimeException("\u672a\u68c0\u7d22\u5230\u5b58\u5728\u7684\u7236\u7ea7\u522b\u5355\u5143\uff01");
        }
        String nameFldName = importDTO.getNameField();
        String codeFldName = importDTO.getCodeField();
        String pCodeFldName = importDTO.getPCodeField();
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(nameFldName);
        fields.add(codeFldName);
        if (!import2Root) {
            fields.add(pCodeFldName);
        }
        DatasetNameInfo disDatasetNameInfo = DatasetUtil.getDatasetNameInfo(importDTO.getDatasetId());
        DatabaseDTO disDataSourceDTO = this.geoDatabaseService.getDatabaseDetail(disDatasetNameInfo.getDsKey());
        List dataList = null;
        try (IFeatureWorkspace disWorkspace = GeoDatabaseUtil.openGeoDatabase(disDataSourceDTO);){
            IFeatureClass districtLayer = disWorkspace.openFeatureClass(disDatasetNameInfo.getName());
            if (districtLayer == null) {
                throw new RuntimeException("\u884c\u653f\u533a\u56fe\u5c42\u6253\u5f00\u5931\u8d25");
            }
            String sql = MessageFormat.format("select {0},st_x(st_PointOnSurface({1})) as f_x,st_y(st_PointOnSurface({1})) as f_y,box2d({1}) as box from {2}", String.join((CharSequence)",", fields), districtLayer.getShapeFieldName(), districtLayer.getFullName());
            dataList = disWorkspace.queryList(sql, new Object[0]);
            if (dataList.size() == 0) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e\uff01");
            }
        }
        ArrayList<String> codeList = new ArrayList<String>();
        for (Map data : dataList) {
            String name = data.get(nameFldName.toLowerCase()) == null ? "" : data.get(nameFldName.toLowerCase()).toString();
            String code = data.get(codeFldName.toLowerCase()) == null ? "" : data.get(codeFldName.toLowerCase()).toString();
            DmDistrictItem pDistrictItem = null;
            if (StringUtil.isEmptyOrWhiteSpace((String)name) || StringUtil.isEmptyOrWhiteSpace((String)code)) continue;
            if (!import2Root) {
                String pCode = data.get(pCodeFldName.toLowerCase()) == null ? "" : data.get(pCodeFldName.toLowerCase()).toString();
                if (!pItems.containsKey(pCode)) continue;
                pDistrictItem = (DmDistrictItem)pItems.get(pCode);
            }
            if (codeList.contains(code)) continue;
            Double centerX = data.get("f_x") == null ? null : Double.valueOf(data.get("f_x").toString());
            Double centerY = data.get("f_y") == null ? null : Double.valueOf(data.get("f_y").toString());
            Object box = data.get("box");
            Double xmin = null;
            Double ymin = null;
            Double xmax = null;
            Double ymax = null;
            if (box != null) {
                String[] boxExtent = box.toString().substring(4, box.toString().length() - 1).split(",");
                String[] minValues = boxExtent[0].split(" ");
                String[] maxValues = boxExtent[1].split(" ");
                xmin = Double.parseDouble(minValues[0]);
                ymin = Double.parseDouble(minValues[1]);
                xmax = Double.parseDouble(maxValues[0]);
                ymax = Double.parseDouble(maxValues[1]);
            }
            DmDistrictItem disItem = new DmDistrictItem();
            disItem.setName(name);
            String pinYinName = PinyinUtil.convertToPinYin((String)name).toUpperCase(Locale.ROOT);
            disItem.setExt(pinYinName);
            disItem.setCode(code);
            disItem.setDistrictId(districtId);
            disItem.setLevelIndex(importLevel);
            disItem.setPid(pDistrictItem == null ? -1L : pDistrictItem.getId());
            disItem.setCenterX(centerX);
            disItem.setCenterY(centerY);
            disItem.setXmin(xmin);
            disItem.setYmin(ymin);
            disItem.setXmax(xmax);
            disItem.setYmax(ymax);
            this.dmDistrictItemDao.insert(disItem);
            if (firstItemId == null) {
                firstItemId = disItem.getId();
            }
            codeList.add(code);
        }
        districtLevel.setDatasetId(importDTO.getDatasetId());
        districtLevel.setCodeFldName(importDTO.getCodeField());
        districtLevel.setNameFldName(importDTO.getNameField());
        this.districtLevelDao.updateByPrimaryKey(districtLevel);
        if (this.getDefaultDistrictItem(districtId) == null && firstItemId != null) {
            this.setDefaultDistrictItem(districtId, firstItemId);
        }
    }

    @Override
    public DistrictItemDTO getDistrictItemDetail(Long id) {
        DmDistrictItem item = this.dmDistrictItemDao.selectByPrimaryKey(id);
        Assert.notNull((Object)item, (String)"\u533a\u57df\u5355\u5143\u4e0d\u5b58\u5728\uff01");
        int minLevel = -1;
        List<String> userXzqdms = this.getUserXzqdm();
        if (userXzqdms != null) {
            List<DmDistrictItem> userDistrictItems = this.dmDistrictItemDao.selectByCodes(item.getDistrictId(), userXzqdms);
            if (userDistrictItems.size() == 0) {
                log.error("\u7528\u6237\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", userXzqdms));
            } else {
                minLevel = userDistrictItems.stream().min(Comparator.comparing(DmDistrictItem::getLevelIndex)).get().getLevelIndex().shortValue();
            }
        }
        DistrictItemDTO result = this.transferToItemDetail(item, minLevel);
        return result;
    }

    @Override
    public DistrictItemDTO getDistrictItemDetail(Long districtId, String itemCode) {
        return this.getDistrictItemDetail(districtId, null, itemCode);
    }

    @Override
    public DistrictItemDTO getDistrictItemDetail(Long districtId, Integer level, String itemCode) {
        List<DmDistrictItem> items;
        if (districtId == null) {
            List<DmDistrict> list = this.dmDistrictDao.queryDefault();
            if (list == null || list.size() == 0) {
                throw new RuntimeException("\u672a\u914d\u7f6e\u9ed8\u8ba4\u653f\u533a\u65b9\u6848");
            }
            districtId = list.get(0).getId();
        }
        DmDistrictItem item = (items = this.dmDistrictItemDao.selectByCode(districtId, level, itemCode)).size() > 0 ? items.get(0) : null;
        Assert.notNull((Object)item, (String)("\u533a\u57df\u5355\u5143" + itemCode + "\u4e0d\u5b58\u5728"));
        int minLevel = -1;
        List<String> userXzqdms = this.getUserXzqdm();
        if (userXzqdms != null) {
            List<DmDistrictItem> userDistrictItems = this.dmDistrictItemDao.selectByCodes(item.getDistrictId(), userXzqdms);
            if (userDistrictItems.size() == 0) {
                log.error("\u7528\u6237\u884c\u653f\u533a\u4ee3\u7801\u4e0d\u5b58\u5728\uff1a" + String.join((CharSequence)",", userXzqdms));
            } else {
                minLevel = userDistrictItems.stream().min(Comparator.comparing(DmDistrictItem::getLevelIndex)).get().getLevelIndex().shortValue();
            }
        }
        DistrictItemDTO result = this.transferToItemDetail(item, minLevel);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGeometry getDistrictItemGeometry(Long itemId) {
        DmDistrictItem item = this.dmDistrictItemDao.selectByPrimaryKey(itemId);
        Assert.notNull((Object)item, (String)"\u533a\u57df\u5355\u5143\u4e0d\u5b58\u5728\uff01");
        DmDistrictLevel districtLevel = this.districtLevelDao.selectByPrimaryKey(item.getDistrictId(), item.getLevelIndex());
        Assert.notNull((Object)districtLevel, (String)"\u533a\u57df\u5c42\u7ea7\u4e0d\u5b58\u5728\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(districtLevel.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        IFeatureCursor cursor = null;
        try {
            IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)"\u533a\u57df\u5c42\u7ea7\u6570\u636e\u6e90\u914d\u7f6e\u6709\u8bef\uff01");
            QueryFilter filter = new QueryFilter();
            filter.setWhereClause(String.format("%s='%s'", districtLevel.getCodeFldName(), item.getCode()));
            filter.setLimit(Integer.valueOf(1));
            filter.setSubFields(featureClass.getShapeFieldName());
            cursor = featureClass.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            if (feature != null) {
                IGeometry iGeometry = feature.getGeometry();
                return iGeometry;
            }
            IGeometry iGeometry = null;
            return iGeometry;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DistrictItemDTO> queryDistrictItem(Long districtId, Short level, String geometry) {
        if (districtId == null) {
            List<DmDistrict> list = this.dmDistrictDao.queryDefault();
            if (list == null || list.size() == 0) {
                throw new RuntimeException("\u672a\u914d\u7f6e\u9ed8\u8ba4\u653f\u533a\u65b9\u6848");
            }
            districtId = list.get(0).getId();
        }
        DmDistrictLevel districtLevel = this.districtLevelDao.selectByPrimaryKey(districtId, level);
        Assert.notNull((Object)districtLevel, (String)"\u533a\u57df\u5c42\u7ea7\u4e0d\u5b58\u5728\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(districtLevel.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        IFeatureCursor cursor = null;
        try {
            List<DistrictItemDTO> list;
            IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)"\u533a\u57df\u5c42\u7ea7\u6570\u636e\u6e90\u914d\u7f6e\u6709\u8bef\uff01");
            ArrayList<String> itemCodeList = new ArrayList<String>();
            SpatialQueryFilter filter = new SpatialQueryFilter();
            filter.setSpatialRel(SpatialRelationType.Intersects);
            filter.setGeometry(GeometryFunc.createGeometry((String)geometry));
            filter.setSubFields(districtLevel.getCodeFldName());
            filter.setLimit(Integer.valueOf(100));
            cursor = featureClass.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                Object code = feature.getValue(districtLevel.getCodeFldName());
                if (code != null) {
                    itemCodeList.add(code.toString());
                }
                feature = cursor.nextFeature();
            }
            if (itemCodeList.size() == 0) {
                list = new ArrayList<DistrictItemDTO>();
                return list;
            }
            list = ListUtil.convertAll(this.dmDistrictItemDao.selectByCodes(districtId, itemCodeList), this::transferToItemDto);
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
    }

    private boolean districtCodeNotExist(String code) {
        return this.dmDistrictDao.queryByCode(code).size() == 0;
    }

    private short getNextDistrictLevel(Long districtId) {
        Short index = this.districtLevelDao.queryMaxIndex(districtId);
        if (index == null) {
            index = 0;
        }
        return (short)(index + 1);
    }

    private DistrictItemDTO transferToItemDetail(DmDistrictItem item, int minLevel) {
        DistrictItemDTO dto = this.transferToItemDto(item);
        List<DistrictItemDTO> parent = this.getItemParent(dto, minLevel);
        Collections.reverse(parent);
        dto.setParent(parent);
        return dto;
    }

    private DistrictItemDTO transferToItemDto(DmDistrictItem item) {
        DistrictItemDTO dto = new DistrictItemDTO();
        BeanUtils.copyProperties((Object)item, (Object)dto);
        dto.setPinYinName(item.getExt());
        ExtentDTO extentDTO = new ExtentDTO();
        extentDTO.setXmin(item.getXmin());
        extentDTO.setYmin(item.getYmin());
        extentDTO.setXmax(item.getXmax());
        extentDTO.setYmax(item.getYmax());
        dto.setExtent(extentDTO);
        return dto;
    }

    private DistrictItemDTO sortByCode(DistrictItemDTO districtItem) {
        List<DistrictItemDTO> districtItems = districtItem.getChildren();
        if (districtItems != null) {
            districtItems.sort(Comparator.comparing(DistrictItemDTO::getCode));
            districtItem.setChildren(districtItems);
        }
        return districtItem;
    }

    private boolean itemLevelExist(Long districtId, Short level) {
        return this.dmDistrictItemDao.selectByLevelIndex(districtId, level).size() > 0;
    }

    private DmDistrictLevel getChildLevel(Short level, List<DmDistrictLevel> levelList) {
        DmDistrictLevel fatherLevel = (DmDistrictLevel)ListUtil.find(levelList, l -> l.getIndex().equals(level));
        int listIndex = levelList.indexOf(fatherLevel);
        if (listIndex < levelList.size() - 1) {
            return levelList.get(listIndex + 1);
        }
        DmDistrictLevel notExistLevel = new DmDistrictLevel();
        notExistLevel.setIndex(this.getNextDistrictLevel(fatherLevel.getDistrictId()));
        return notExistLevel;
    }

    private List<DistrictItemDTO> getItemChildren(Map<String, List<DmDistrictItem>> childrenMap, Long pId) {
        ArrayList<DistrictItemDTO> result = new ArrayList<DistrictItemDTO>();
        List<DmDistrictItem> children = childrenMap.get(String.valueOf(pId));
        if (children == null) {
            return result;
        }
        for (DmDistrictItem item : children) {
            DistrictItemDTO dto = this.transferToItemDto(item);
            dto.setChildren(this.getItemChildren(childrenMap, dto.getId()));
            result.add(dto);
        }
        result.sort(Comparator.comparing(DistrictItemDTO::getCode));
        return result;
    }

    private void getChildrenMap(Long pid, Map<String, List<DmDistrictItem>> childrenMap, Map<String, List<DmDistrictItem>> allChildrenMap) {
        List<DmDistrictItem> children = allChildrenMap.get(String.valueOf(pid));
        if (children != null) {
            ArrayList<DmDistrictItem> newChildren = new ArrayList<DmDistrictItem>(children);
            childrenMap.put(String.valueOf(pid), newChildren);
            for (DmDistrictItem subItem : newChildren) {
                this.getChildrenMap(subItem.getId(), childrenMap, allChildrenMap);
            }
        }
    }

    private List<DmDistrictItem> getAllSubItems(Long pId, String keyword, Map<String, List<DmDistrictItem>> childrenMap) {
        ArrayList<DmDistrictItem> result = new ArrayList<DmDistrictItem>();
        List<DmDistrictItem> children = childrenMap.get(String.valueOf(pId));
        if (children == null) {
            return result;
        }
        for (DmDistrictItem item : children) {
            if (keyword != null && !keyword.isEmpty() && (item.getName().contains(keyword) || item.getCode().startsWith(keyword))) {
                result.add(item);
            }
            result.addAll(this.getAllSubItems(item.getId(), keyword, childrenMap));
        }
        return result;
    }

    private List<DistrictItemDTO> getItemParent(DistrictItemDTO itemDTO, int minLevel) {
        ArrayList<DistrictItemDTO> result = new ArrayList<DistrictItemDTO>();
        long pid = itemDTO.getPid();
        for (int index = 0; pid > 0L && index < 15; ++index) {
            DmDistrictItem pItem = this.dmDistrictItemDao.selectByPrimaryKey(pid);
            if (pItem != null) {
                if (pItem.getLevelIndex() < minLevel) break;
                pid = pItem.getPid();
                result.add(this.transferToItemDto(pItem));
                continue;
            }
            pid = -1L;
        }
        return result;
    }

    private DistrictLevelDTO convertDistrictLevel(DmDistrictLevel level) {
        DistrictLevelDTO dto = new DistrictLevelDTO();
        BeanUtils.copyProperties((Object)level, (Object)dto);
        if (StringUtil.isNotEmpty((String)dto.getCodeFldName())) {
            dto.setCodeFldName(dto.getCodeFldName().toLowerCase(Locale.ROOT));
        }
        if (StringUtil.isNotEmpty((String)dto.getNameFldName())) {
            dto.setNameFldName(dto.getNameFldName().toLowerCase(Locale.ROOT));
        }
        if (StringUtil.isNotEmpty((String)level.getDatasetRender())) {
            dto.setRender((DatasetRenderDTO)JSON.parseObject((String)level.getDatasetRender(), DatasetRenderDTO.class));
        }
        return dto;
    }

    private List<String> getUserXzqdm() {
        if (this.userRightProperties.getXzqhEnable().booleanValue()) {
            String xzqdm;
            LoginUserInfo loginUserInfo = ThreadLocalUtil.getCurrentUser();
            if (loginUserInfo == null) {
                ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                HttpServletRequest request = servletRequestAttributes.getRequest();
                loginUserInfo = this.loginUserService.getUserInfo(request);
                Assert.notNull((Object)loginUserInfo, (String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237");
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)(xzqdm = loginUserInfo.getXzqdm()))) {
                return null;
            }
            if (Boolean.TRUE.equals(loginUserInfo.getTenantAdmin())) {
                return null;
            }
            if (this.userRightProperties.getAdminRoleId() != null && loginUserInfo.getRoleId() != null && Arrays.asList(loginUserInfo.getRoleId().split(",")).contains(this.userRightProperties.getAdminRoleId())) {
                return null;
            }
            return Arrays.asList(xzqdm.split(","));
        }
        return null;
    }
}

