/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.event.DatasetCreateEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FeatureClassService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FeatureClassServiceImpl
implements FeatureClassService {
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public String createFeatureClass(FeatureClassCreateDTO featureClassCreateDTO) {
        String dsKey = featureClassCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureClass featureClass;
            String newDatasetName = featureClassCreateDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)featureClassCreateDTO.getSchemaName())) {
                newDatasetName = featureClassCreateDTO.getSchemaName() + "." + featureClassCreateDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            Assert.notNull(featureClassCreateDTO.getFields(), (String)"\u5b57\u6bb5\u4e0d\u80fd\u672a\u7a7a");
            FeatureType featureType = FeatureType.getByValue((Integer)featureClassCreateDTO.getFeatureType());
            Fields fields = new Fields();
            IField oidField = FieldUtil.buildObjectIdField("objectid", "ObjectID");
            IField shapeField = FieldUtil.buildShapeField("shape", "Shape", this.convertFeatureType(featureType), featureClassCreateDTO.getSrid());
            fields.addField(oidField);
            fields.addField(shapeField);
            for (FieldDTO fieldDTO : featureClassCreateDTO.getFields()) {
                if (fieldDTO.getFieldType().intValue() == FieldType.OID.getValue()) {
                    oidField.setName(fieldDTO.getName());
                    oidField.setAliasName(fieldDTO.getAliasName());
                    continue;
                }
                if (fieldDTO.getFieldType().intValue() == FieldType.Shape.getValue()) {
                    shapeField.setName(fieldDTO.getName());
                    shapeField.setAliasName(fieldDTO.getAliasName());
                    continue;
                }
                if (fields.contains(fieldDTO.getName())) continue;
                fields.addField(FieldUtil.convertField(fieldDTO));
            }
            if (StringUtil.isEmpty((String)featureClassCreateDTO.getParentId())) {
                featureClass = featureWorkspace.createFeatureClass(newDatasetName, (IFields)fields, featureType, shapeField.getName(), "");
            } else {
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(featureClassCreateDTO.getParentId());
                IFeatureDataset parentFeatureDataset = featureWorkspace.openFeatureDataset(datasetNameInfo.getName());
                if (parentFeatureDataset == null) {
                    throw new RuntimeException(datasetNameInfo.getName() + " \u8981\u7d20\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25");
                }
                featureClass = parentFeatureDataset.createFeatureClass(newDatasetName, (IFields)fields, featureType, shapeField.getName(), "");
            }
            if (featureClass != null) {
                featureClass.createSpatialIndex();
                if (StringUtil.isNotEmpty((String)featureClassCreateDTO.getAliasName()) && !featureClassCreateDTO.getAliasName().equals(featureClassCreateDTO.getName())) {
                    featureClass.alterAliasName(featureClassCreateDTO.getAliasName());
                }
                String id = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureClass);
                if (StringUtil.isNotEmpty((String)featureClassCreateDTO.getDataPhase())) {
                    this.dataSourceManager.saveDatasetDataPhase(id, featureClassCreateDTO.getDataPhase());
                }
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, id));
                String string = id;
                return string;
            }
            throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFeatureClass(FeatureClassEditDTO featureClassEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(featureClassEditDTO.getId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureClass featureClass = featureWorkspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            if (!StringUtil.equals((String)featureClass.getAliasName(), (String)featureClassEditDTO.getAliasName())) {
                featureClass.alterAliasName(featureClassEditDTO.getAliasName());
            }
            this.dataSourceManager.saveDatasetDataPhase(featureClassEditDTO.getId(), featureClassEditDTO.getDataPhase());
            IEnvelope envelope = GeoDatasetUtil.toEnvelope(featureClassEditDTO.getExtent());
            if (envelope != null) {
                featureClass.changeExtent(envelope);
            }
            if (featureClassEditDTO.getFields() != null) {
                this.geoDatabaseService.updateDatasetFields((IGeoDataset)featureClass, featureClassEditDTO.getFields(), dataSourceDTO);
            }
            this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSpatialIndex(String datasetId) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureClass featureClass = featureWorkspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            featureClass.createSpatialIndex();
            this.sysLogService.addLog(101, String.format("\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropSpatialIndex(String datasetId) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureClass featureClass = featureWorkspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            featureClass.deleteSpatialIndex();
            this.sysLogService.addLog(101, String.format("\u5220\u9664\u7a7a\u95f4\u7d22\u5f15\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
        }
    }

    private GeometryType convertFeatureType(FeatureType featureType) {
        switch (featureType) {
            case Point: {
                return GeometryType.Point;
            }
            case Polyline: {
                return GeometryType.Polyline;
            }
        }
        return GeometryType.MultiPolygon;
    }
}

