/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.dto.NameMapping;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateFieldDTO;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.create.FeatureDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.event.DatasetCreateEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.FeatureDatasetService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class FeatureDatasetServiceImpl
implements FeatureDatasetService {
    private static final Logger log = LoggerFactory.getLogger(FeatureDatasetServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private GeoTemplateService geoTemplateService;
    @Resource
    private FileStorageService fileStorageService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createFeatureDataset(FeatureDatasetCreateDTO featureDatasetCreateDTO) {
        String dsKey = featureDatasetCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String string;
            String newDatasetName = featureDatasetCreateDTO.getName().trim();
            if (!StringUtil.isEmptyOrWhiteSpace((String)featureDatasetCreateDTO.getSchemaName())) {
                newDatasetName = featureDatasetCreateDTO.getSchemaName() + "." + newDatasetName;
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)featureDatasetCreateDTO.getSrid());
            IFeatureDataset featureDataset = featureWorkspace.createFeatureDataset(newDatasetName, spatialReferenceSystem);
            Assert.notNull((Object)featureDataset, (String)(newDatasetName + " \u8981\u7d20\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01"));
            if (StringUtil.isNotEmpty((String)featureDatasetCreateDTO.getAliasName()) && !featureDatasetCreateDTO.getAliasName().equals(featureDatasetCreateDTO.getName())) {
                featureDataset.alterAliasName(featureDatasetCreateDTO.getAliasName());
            }
            this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureDataset.getType().getDesc(), dataSourceDTO.getName(), featureDataset.getFullName()));
            String datasetId = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureDataset);
            String dataPhase = featureDatasetCreateDTO.getDataPhase();
            if (StringUtil.isNotEmpty((String)dataPhase)) {
                this.dataSourceManager.saveDatasetDataPhase(datasetId, dataPhase);
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)featureDatasetCreateDTO.getGeoTemplateId())) {
                GeoTemplateDTO geoTemplate = this.geoTemplateService.getGeoTemplate(featureDatasetCreateDTO.getGeoTemplateId(), null);
                for (NameMapping nameMapping : featureDatasetCreateDTO.getFeatureClassNameList()) {
                    GeoTemplateDatasetDTO datasetDTO = (GeoTemplateDatasetDTO)ListUtil.find((List)geoTemplate.getDatasets(), d -> d.getName().equalsIgnoreCase(nameMapping.getSrcName()));
                    if (datasetDTO != null) {
                        if (datasetDTO.getType() == null && (datasetDTO.getType().intValue() == FeatureType.Point.getValue() || datasetDTO.getType().intValue() == FeatureType.Polyline.getValue() || datasetDTO.getType().intValue() == FeatureType.Polygon.getValue())) {
                            IFeatureClass featureClass = this.createFeatureClass(datasetDTO, nameMapping.getTargetName().trim(), featureDataset);
                            this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
                            if (!StringUtil.isNotEmpty((String)dataPhase)) continue;
                            String id = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureClass);
                            this.dataSourceManager.saveDatasetDataPhase(id, dataPhase);
                            continue;
                        }
                        log.error(datasetDTO.getType() + " \u6a21\u677f\u56fe\u5c42\u7c7b\u578b\u4e0d\u652f\u6301");
                        continue;
                    }
                    log.error(nameMapping.getSrcName() + " \u6a21\u677f\u56fe\u5c42\u4e0d\u5b58\u5728\uff01");
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, datasetId));
                String string2 = datasetId;
                return string2;
            }
            String templateFile = featureDatasetCreateDTO.getTemplateFile();
            DataSourceDTO fileDataSource = this.fileStorageService.getFileDataSourceByFilePath(templateFile);
            IFeatureWorkspace srcWorkspace = GeoDatabaseUtil.openFileGeoDatabase(fileDataSource, templateFile);
            Assert.notNull((Object)srcWorkspace, (String)"\u6a21\u677f\u6570\u636e\u6253\u5f00\u5931\u8d25\uff01");
            try {
                List srcDatasetList = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass});
                for (IGeoDataset dataset : srcDatasetList) {
                    NameMapping nameMapping = (NameMapping)ListUtil.find(featureDatasetCreateDTO.getFeatureClassNameList(), nm -> dataset.getName().equals(nm.getSrcName()));
                    if (nameMapping == null) continue;
                    IFeatureClass featureClass = this.createFeatureClass((IFeatureClass)dataset, nameMapping.getTargetName().trim(), featureDataset);
                    this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", featureClass.getType().getDesc(), dataSourceDTO.getName(), featureClass.getFullName()));
                    if (!StringUtil.isNotEmpty((String)dataPhase)) continue;
                    String id = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureClass);
                    this.dataSourceManager.saveDatasetDataPhase(id, dataPhase);
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, datasetId));
                string = datasetId;
            }
            catch (Throwable throwable) {
                srcWorkspace.close();
                throw throwable;
            }
            srcWorkspace.close();
            return string;
        }
    }

    private IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, String name, IFeatureDataset targetFeatureDataset) {
        IFeatureClass featureClass;
        String shapeFieldName = srcFeatClass.getShapeFieldName();
        Fields newFileds = new Fields();
        for (int i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
            IField tempField = srcFeatClass.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.Shape) {
                tempField.setName(shapeFieldName);
                ((GeometryField)tempField).setSpatialReferenceSystem(targetFeatureDataset.getSpatialReferenceSystem());
                ((GeometryField)tempField).setCoordinateType(CoordinateType.XY);
            }
            if (newFileds.findFieldIndex(tempField.getName()) >= 0) continue;
            newFileds.addField(tempField);
        }
        if (newFileds.findFieldIndex("f_frame") < 0) {
            newFileds.addField((IField)new Field("f_frame", "\u5206\u5e45\u540d\u79f0", FieldType.String, 60));
        }
        if (newFileds.findFieldIndex("f_importtime") < 0) {
            newFileds.addField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime));
        }
        if ((featureClass = targetFeatureDataset.createFeatureClass(name, (IFields)newFileds, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName())) == null) {
            throw new RuntimeException(name + " \u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25");
        }
        featureClass.createSpatialIndex();
        return featureClass;
    }

    private IFeatureClass createFeatureClass(GeoTemplateDatasetDTO datasetDTO, String name, IFeatureDataset targetFeatureDataset) {
        IFeatureClass featureClass;
        String shapeFieldName = "shape";
        String objectIdFieldName = "objectid";
        Fields newFields = new Fields();
        for (GeoTemplateFieldDTO templateField : datasetDTO.getFields()) {
            IField tempField = FieldUtil.convertField((FieldDTO)templateField);
            if (tempField.getFieldType() == FieldType.Shape || tempField.getFieldType() == FieldType.OID || newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        while (newFields.findFieldIndex(objectIdFieldName) > 0) {
            objectIdFieldName = objectIdFieldName + "_1";
        }
        newFields.addField(FieldUtil.buildObjectIdField(objectIdFieldName, "ObjectID"));
        if (newFields.findFieldIndex(shapeFieldName) > 0) {
            shapeFieldName = shapeFieldName + "_1";
        }
        IField shapeField = FieldUtil.buildShapeField(shapeFieldName, "Shape", this.convertFeatureType(FeatureType.getByValue((Integer)datasetDTO.getType())), targetFeatureDataset.getSpatialReferenceSystem().getSrid());
        ((GeometryField)shapeField).setCoordinateType(CoordinateType.XY);
        newFields.addField(shapeField);
        if (newFields.findFieldIndex("f_frame") < 0) {
            newFields.addField((IField)new Field("f_frame", "\u5206\u5e45\u540d\u79f0", FieldType.String, 60));
        }
        if (newFields.findFieldIndex("f_importtime") < 0) {
            newFields.addField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime));
        }
        if ((featureClass = targetFeatureDataset.createFeatureClass(name, (IFields)newFields, FeatureType.getByValue((Integer)datasetDTO.getType()), shapeFieldName, "")) == null) {
            throw new RuntimeException(name + " \u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25");
        }
        featureClass.createSpatialIndex();
        return featureClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFeatureDataset(FeatureDatasetEditDTO featureDatasetEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(featureDatasetEditDTO.getId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureDataset featureDataset = null;
            if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.FeatureDataset.getValue()) {
                featureDataset = featureWorkspace.openFeatureDataset(datasetNameInfo.getName());
            } else if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.GroupDataset.getValue()) {
                featureDataset = featureWorkspace.openGroupDataset(datasetNameInfo.getName());
            }
            Assert.notNull((Object)featureDataset, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            if (!StringUtil.equals((String)featureDataset.getAliasName(), (String)featureDatasetEditDTO.getAliasName())) {
                featureDataset.alterAliasName(featureDatasetEditDTO.getAliasName());
            }
            this.dataSourceManager.saveDatasetDataPhase(featureDatasetEditDTO.getId(), featureDatasetEditDTO.getDataPhase());
            if (featureDatasetEditDTO.getFeatureClassAliasNameList() != null) {
                for (IGeoDataset subset : featureDataset.getSubsets()) {
                    NameMapping nameMapping = (NameMapping)ListUtil.find(featureDatasetEditDTO.getFeatureClassAliasNameList(), n -> n.getSrcName().equalsIgnoreCase(subset.getName()));
                    if (nameMapping == null || subset.getAliasName().equalsIgnoreCase(nameMapping.getTargetName())) continue;
                    subset.alterAliasName(nameMapping.getTargetName());
                    this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\u522b\u540d\uff1a%s > %s", subset.getType().getDesc(), dataSourceDTO.getName(), subset.getFullName()));
                }
            }
            this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\uff1a%s > %s", featureDataset.getType().getDesc(), dataSourceDTO.getName(), featureDataset.getFullName()));
        }
    }

    private GeometryType convertFeatureType(FeatureType featureType) {
        switch (featureType) {
            case Point: {
                return GeometryType.Point;
            }
            case Polyline: {
                return GeometryType.Polyline;
            }
        }
        return GeometryType.MultiPolygon;
    }
}

