/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.dto.SpatialRefDTO;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasFeatureClassDTO;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasDataLineApi;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasGisToolkitApi;
import com.geoway.atlas.gis.toolkit.meta.bean.FeatureField;
import com.geoway.atlas.gis.toolkit.meta.bean.ProgressTracker;
import com.geoway.atlas.gis.toolkit.meta.bean.SpatialRef;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.beans.BeanUtils;

public class AtlasDataSourceUtil {
    public static AtlasFeatureClassDTO convertAtlasFeatureClass(String featureClassName, SimpleFeatureType simpleFeatureType) {
        FeatureField[] fields = AtlasGisToolkitApi.getFeatureFields((SimpleFeatureType)simpleFeatureType);
        SpatialRef spatialRef = AtlasGisToolkitApi.getCoordinateReferenceSystem((SimpleFeatureType)simpleFeatureType);
        Envelope envelope = AtlasGisToolkitApi.getEnvelope((SimpleFeatureType)simpleFeatureType);
        AtlasFeatureClassDTO featureClassDTO = new AtlasFeatureClassDTO();
        featureClassDTO.setName(featureClassName);
        featureClassDTO.setAliasName(featureClassName);
        featureClassDTO.setFullName(featureClassName);
        featureClassDTO.setType(DatasetTypeEnum.FeatureClass.getValue());
        featureClassDTO.setTypeDesc(DatasetTypeEnum.FeatureClass.getDesc());
        try {
            Byte geoType = AtlasGisToolkitApi.getGeometryType((SimpleFeatureType)simpleFeatureType);
            if (geoType >> 2 == 0) {
                featureClassDTO.setFeatureType(FeatureType.Point.getValue());
            } else if (geoType >> 2 == 1) {
                featureClassDTO.setFeatureType(FeatureType.Polyline.getValue());
            } else if (geoType >> 2 == 2) {
                featureClassDTO.setFeatureType(FeatureType.Polygon.getValue());
            } else {
                featureClassDTO.setFeatureType(FeatureType.Unknown.getValue());
            }
        }
        catch (Exception e) {
            featureClassDTO.setFeatureType(FeatureType.Unknown.getValue());
        }
        SpatialRefDTO spatialRefDTO = new SpatialRefDTO();
        if (spatialRef != null) {
            BeanUtils.copyProperties((Object)spatialRef, (Object)spatialRefDTO);
            featureClassDTO.setSpatialRef(spatialRefDTO);
        }
        if (envelope != null) {
            ExtentDTO extentDTO = new ExtentDTO();
            extentDTO.setXmin(Double.valueOf(envelope.getMinX()));
            extentDTO.setYmin(Double.valueOf(envelope.getMinY()));
            extentDTO.setXmax(Double.valueOf(envelope.getMaxX()));
            extentDTO.setYmax(Double.valueOf(envelope.getMaxY()));
            featureClassDTO.setExtent(extentDTO);
        }
        ArrayList<FieldDTO> fieldDTOS = new ArrayList<FieldDTO>();
        for (FeatureField featureField : fields) {
            FieldDTO fieldDTO = new FieldDTO();
            BeanUtils.copyProperties((Object)featureField, (Object)fieldDTO);
            fieldDTOS.add(fieldDTO);
        }
        featureClassDTO.setFields(fieldDTOS);
        featureClassDTO.setShapeField(simpleFeatureType.getGeometryDescriptor().getLocalName());
        return featureClassDTO;
    }

    public static void inputData(String inputFeatureClassUrl, String inputDataFormat, String outputFeatureClassUrl, String outputDataFormat, Boolean overwrite) {
        ProgressTracker progressTracker = new ProgressTracker();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        AtlasDataLineApi.runDataLineTask((String)inputDataFormat, (String)inputFeatureClassUrl, null, (String)outputDataFormat, (String)outputFeatureClassUrl, null, (ExecutorService)executorService, (ProgressTracker)progressTracker);
    }
}

