/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDTO;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.FileDetailDTO;
import com.geoway.adf.dms.datasource.dto.file.FilePermissionDTO;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.dto.file.VectorLayerDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;

public interface FileStorageService {
    public boolean testConnect(DataSourceDTO var1);

    public List<DataSourceDTO> listFileStorage(List<DataSourceTypeEnum> var1, String var2);

    public List<DataSourceDTO> listFileStorage(List<DataSourceTypeEnum> var1, String var2, String var3);

    public List<FileDTO> listFile(String var1, String var2);

    public FileDetailDTO getFileDetail(String var1, String var2);

    public FilePermissionDTO getFilePermission(String var1, String var2);

    public boolean deleteFile(String var1, String var2, boolean var3);

    public boolean deleteFile(String var1, String var2, String var3);

    public void batchDeleteFile(String var1, List<String> var2, String var3);

    public FileDTO createDirectory(String var1, String var2, String var3);

    public void uploadFile(MultipartFile var1, String var2, String var3, Boolean var4);

    public IFileset uploadFile(DataSourceDTO var1, String var2, String var3);

    public void downloadFile(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    public void batchDownloadFile(String var1, List<String> var2, HttpServletRequest var3, HttpServletResponse var4);

    public void viewFile(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4);

    public List<SelectFileDataDTO> selectFiles(String var1, String var2, List<FileDataTypeEnum> var3, String var4);

    public String uploadSelectFile(MultipartFile var1, String var2, Boolean var3);

    public List<SelectFileDataDTO> listUploadFile(String var1, List<FileDataTypeEnum> var2, String var3);

    public List<VectorLayerDTO> listFileVectorLayer(String var1, String var2, Boolean var3);

    public VectorLayerDTO getFileVectorLayer(String var1, String var2, Boolean var3);

    public List<FieldDTO> listFileLayerField(String var1, String var2);

    public List<SimpleDatasetDTO> listDatasets(String var1, String var2);

    public DatasetDTO getDatasetDetail(DataSourceDTO var1, DatasetTypeEnum var2, String var3);

    public DataQueryResult queryGeoDataset(String var1, QueryFilterDTO var2);

    public long queryDataCount(String var1, QueryFilterBasicDTO var2);

    public IFileStorage openFileStorage(String var1);

    public DataSourceDTO getFileDataSourceByFilePath(String var1);

    public IFileStorage openFileStorageByFilePath(String var1);

    public IFeatureWorkspace openFileLayerWorkspace(String var1);
}

