/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.TileFileSourceFormatEnum;
import com.geoway.adf.dms.datasource.dao.DsTileDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.TileDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TileDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TileFileDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.TileFileDataSourceDTO;
import com.geoway.adf.dms.datasource.entity.DsTile;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.TileDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileDataSource;
import com.geoway.adf.gis.tile.mbtiles.MBTilesTileDataSource;
import com.geoway.adf.gis.tile.meta.SpatialReference;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TileDatabaseServiceImpl
implements TileDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(TileDatabaseServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DsTileDao dsTileDao;

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);
        Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        tileDataSource.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listAllDatabaseNames(DataSourceDTO dataSource) {
        if (dataSource.getDataSourceType().intValue() == DataSourceTypeEnum.MongoDB.getValue()) {
            MongoTileDataSource tileDataSource = new MongoTileDataSource(dataSource.getUrl(), dataSource.getUserName(), dataSource.getPassword());
            if (!tileDataSource.connect()) {
                throw new RuntimeException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            }
            try {
                List list = tileDataSource.listDatabaseNames();
                return list;
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u5e93\u5217\u8868\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
                ArrayList<String> arrayList = new ArrayList<String>();
                return arrayList;
            }
            finally {
                tileDataSource.close();
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSource.getDataSourceType());
    }

    @Override
    public List<DataSourceDTO> listDatabase(List<DataSourceTypeEnum> sourceTypes, String keyword) {
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(Collections.singletonList(DataStoreTypeEnum.NoSQLDatabase), sourceTypes, keyword);
        return list;
    }

    @Override
    public List<DataSourceDTO> listDatabase(List<DataSourceTypeEnum> sourceTypes, String keyword, String category) {
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(Collections.singletonList(DataStoreTypeEnum.NoSQLDatabase), sourceTypes, keyword, category);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
        if (!this.isFileTile(dataSourceDTO.getKey())) {
            Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            try (ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);){
                List tileDatasets = tileDataSource.getDatasets();
                for (ITileDataset tileDataset : tileDatasets) {
                    SimpleDatasetDTO datasetDTO = this.convert2SimpleDTO(dataSourceDTO, tileDataset);
                    datasetDTOS.add(datasetDTO);
                }
            }
        } else {
            List<DsTile> tiles = this.dsTileDao.selectAll();
            for (DsTile dsTile : tiles) {
                SimpleDatasetDTO datasetDTO = this.convert2SimpleDTO(dataSourceDTO, dsTile);
                datasetDTOS.add(datasetDTO);
            }
        }
        this.dataSourceManager.fillSimpleDatasetMeta(dataSourceDTO.getKey(), datasetDTOS);
        return datasetDTOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetPageList<SimpleDatasetDTO> listTileDatasets(String key, List<TileType> tileTypes, String keyword, Integer pageIndex, Integer rows) {
        if (!this.isFileTile(key)) {
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
            ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
            HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
            typeCount.put(TileType.RasterTile.getValue(), 0);
            typeCount.put(TileType.TerrainTile.getValue(), 0);
            typeCount.put(TileType.Model3DTile.getValue(), 0);
            Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            try (ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);){
                List tileDatasets = tileDataSource.getDatasets(tileTypes == null || tileTypes.size() == 0 ? null : tileTypes.toArray(new TileType[0]));
                for (ITileDataset tileDataset : tileDatasets) {
                    if (!StringUtil.isEmptyOrWhiteSpace((String)keyword) && !tileDataset.getName().contains(keyword)) continue;
                    SimpleDatasetDTO datasetDTO = this.convert2SimpleDTO(dataSourceDTO, tileDataset);
                    datasetDTOS.add(datasetDTO);
                    typeCount.put(datasetDTO.getTileType(), typeCount.get(datasetDTO.getTileType()) == null ? 1 : (Integer)typeCount.get(datasetDTO.getTileType()) + 1);
                }
            }
            this.dataSourceManager.fillSimpleDatasetMeta(dataSourceDTO.getKey(), datasetDTOS);
            DatasetPageList<SimpleDatasetDTO> datasetPageList = new DatasetPageList<SimpleDatasetDTO>(datasetDTOS, pageIndex, rows);
            datasetPageList.setTypeCounts(typeCount);
            return datasetPageList;
        }
        return this.listFileTileDatasets(tileTypes, keyword, null, pageIndex, rows);
    }

    @Override
    public DatasetPageList<SimpleDatasetDTO> listFileTileDatasets(List<TileType> tileTypes, String keyword, String category, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail("tile");
        ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
        HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
        typeCount.put(TileType.RasterTile.getValue(), 0);
        typeCount.put(TileType.TerrainTile.getValue(), 0);
        typeCount.put(TileType.Model3DTile.getValue(), 0);
        List<DsTile> tiles = this.dsTileDao.selectByType(tileTypes == null || tileTypes.size() == 0 ? null : ListUtil.convertAll(tileTypes, TileType::getValue), keyword, category);
        for (DsTile dsTile : tiles) {
            SimpleDatasetDTO datasetDTO = this.convert2SimpleDTO(dataSourceDTO, dsTile);
            datasetDTOS.add(datasetDTO);
            typeCount.put(datasetDTO.getTileType(), typeCount.get(datasetDTO.getTileType()) == null ? 1 : (Integer)typeCount.get(datasetDTO.getTileType()) + 1);
        }
        this.dataSourceManager.fillSimpleDatasetMeta(dataSourceDTO.getKey(), datasetDTOS);
        DatasetPageList<SimpleDatasetDTO> datasetPageList = new DatasetPageList<SimpleDatasetDTO>(datasetDTOS, pageIndex, rows);
        datasetPageList.setTypeCounts(typeCount);
        return datasetPageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TileDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String name) {
        try (ITileDataSource tileDataSource = null;){
            TileDatasetDTO datasetDTO;
            ITileDataset tileDataset;
            if (this.isFileTile(dataSourceDTO.getKey())) {
                String id = DatasetUtil.getDatasetId("tile", DatasetTypeEnum.TileDataset, name);
                DsTile dsTile = this.dsTileDao.selectByPrimaryKey(id);
                Assert.notNull((Object)dsTile, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
                dataSourceDTO.setDataSourceType(DataSourceTypeEnum.ShareFolder.getValue());
                dataSourceDTO.setUrl(dsTile.getPath());
                dataSourceDTO.setUserName(dsTile.getUserName());
                dataSourceDTO.setPassword(dsTile.getPassword());
                ((TileFileDataSourceDTO)dataSourceDTO).setTileSourceFormat(dsTile.getSourceFormat());
                tileDataSource = this.getTileFileSource(dsTile);
                tileDataset = tileDataSource.getDataset(name);
                Assert.notNull((Object)tileDataset, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
                datasetDTO = this.convert2DTO(dataSourceDTO, tileDataset);
                datasetDTO.setId(id);
                datasetDTO.setName(dsTile.getName());
                datasetDTO.setAliasName(dsTile.getAliasName());
            } else {
                tileDataSource = this.openTileDataSource(dataSourceDTO);
                tileDataset = tileDataSource.getDataset(name);
                Assert.notNull((Object)tileDataset, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
                datasetDTO = this.convert2DTO(dataSourceDTO, tileDataset);
            }
            this.dataSourceManager.setDatasetMeta(datasetDTO);
            datasetDTO.setResourceId(String.format("Atlas://\u6570\u636e\u8d44\u6e90/%s/%s/%s", dataSourceDTO.getName(), tileDataset.getType().getDesc(), tileDataset.getName()));
            TileDatasetDTO tileDatasetDTO = datasetDTO;
            return tileDatasetDTO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTileDataset(TileDatasetCreateDTO tileDatasetCreateDTO) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(tileDatasetCreateDTO.getDsKey());
        Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);){
            ITileDataset tile = tileDataSource.getDataset(tileDatasetCreateDTO.getName());
            Assert.isNull((Object)tile, (String)"\u6570\u636e\u96c6\u540d\u79f0\u5df2\u5b58\u5728\uff01");
            TileMeta tileMeta = new TileMeta();
            tileMeta.setName(tileDatasetCreateDTO.getName());
            tileMeta.setAliasName(tileDatasetCreateDTO.getAliasName());
            tileMeta.setTileType(TileType.getByValue((Integer)tileDatasetCreateDTO.getTileType()));
            ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)tileDatasetCreateDTO.getSrid());
            if (spatialReferenceSystem != null) {
                TileSchema tileSchema = new TileSchema();
                SpatialReference spatialReference = new SpatialReference();
                spatialReference.setWkid(spatialReferenceSystem.getSrid());
                spatialReference.setWkt(spatialReferenceSystem.getWkt());
                tileSchema.setSpatialReference(spatialReference);
                tileMeta.setTileSchema(tileSchema);
            }
            ITileDataset tileDataset = tileDataSource.createDataset(tileMeta);
            this.sysLogService.addLog(121, String.format("\u521b\u5efa%s\uff1a%s > %s", tileDataset.getType().getDesc(), dataSourceDTO.getName(), tileDataset.getName()));
            String string = DatasetUtil.getDatasetId(tileDatasetCreateDTO.getDsKey(), DatasetTypeEnum.TileDataset, tileDatasetCreateDTO.getName());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTileDataset(TileDatasetEditDTO tileDatasetEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(tileDatasetEditDTO.getId());
        if (this.isFileTile(datasetNameInfo.getDsKey())) {
            DsTile dsTile = this.dsTileDao.selectByPrimaryKey(tileDatasetEditDTO.getId());
            Assert.notNull((Object)dsTile, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
            dsTile.setId(tileDatasetEditDTO.getId());
            dsTile.setAliasName(tileDatasetEditDTO.getAliasName());
            this.dsTileDao.updateByPrimaryKeySelective(dsTile);
        } else {
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
            Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            try (ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);){
                ITileDataset tileDataset = tileDataSource.getDataset(datasetNameInfo.getName());
                Assert.notNull((Object)tileDataset, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
                TileMeta tileMeta = tileDataset.getTileMeta();
                tileMeta.setAliasName(tileDatasetEditDTO.getAliasName());
                if (tileDatasetEditDTO.getExtent() != null) {
                    ExtentDTO extentDTO = tileDatasetEditDTO.getExtent();
                    tileMeta.setXmin(extentDTO.getXmin());
                    tileMeta.setXmax(extentDTO.getXmax());
                    tileMeta.setYmax(extentDTO.getYmax());
                    tileMeta.setYmin(extentDTO.getYmin());
                }
                tileDataset.updateTileMeta(tileMeta);
                this.sysLogService.addLog(121, String.format("\u4fee\u6539\u74e6\u7247\u6570\u636e\u96c6\uff1a%s > %s", dataSourceDTO.getName(), tileDataset.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTileDataset(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        if (this.isFileTile(datasetNameInfo.getDsKey())) {
            this.dsTileDao.deleteByPrimaryKey(id);
            this.geoServerEngineService.deleteRelateService(id);
            this.sysLogService.addLog(121, String.format("\u521b\u5efa\u6587\u4ef6\u74e6\u7247\u6570\u636e\u96c6\uff1a%s", datasetNameInfo.getName()));
        } else {
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
            Assert.notNull((Object)tileDataSource, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            try (ITileDataSource tileDataSource = this.openTileDataSource(dataSourceDTO);){
                tileDataSource.deleteDataset(datasetNameInfo.getName());
                this.geoServerEngineService.deleteRelateService(id);
                this.sysLogService.addLog(121, String.format("\u521b\u5efa\u74e6\u7247\u6570\u636e\u96c6\uff1a%s > %s", dataSourceDTO.getName(), datasetNameInfo.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testFileTileDataset(TileFileDatasetCreateDTO tile) {
        try (ITileDataSource tileDataSource = null;){
            DsTile dsTile = new DsTile();
            dsTile.setSourceFormat(tile.getSourceFormat());
            dsTile.setPath(tile.getPath());
            dsTile.setUserName(tile.getUserName());
            dsTile.setPassword(tile.getPassword());
            tileDataSource = this.getTileFileSource(dsTile);
            ITileDataset tileDataset = tileDataSource.getDataset("");
            if (tileDataset == null) {
                throw new RuntimeException(tile.getPath() + "\u74e6\u7247\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TileDatasetDTO addFileTileDataset(TileFileDatasetCreateDTO tile) {
        Assert.notNull((Object)tile.getName(), (String)"\u672a\u8bbe\u7f6e\u6570\u636e\u96c6\u540d\u79f0");
        Assert.notNull((Object)tile.getSourceFormat(), (String)"\u672a\u8bbe\u7f6e\u74e6\u7247\u6570\u636e\u6e90\u7c7b\u578b");
        Assert.notNull((Object)tile.getPath(), (String)"\u672a\u8bbe\u7f6e\u74e6\u7247\u6570\u636e\u6e90\u8def\u5f84");
        try (ITileDataSource tileDataSource = null;){
            DsTile dsTile = new DsTile();
            dsTile.setSourceFormat(tile.getSourceFormat());
            dsTile.setPath(tile.getPath());
            dsTile.setUserName(tile.getUserName());
            dsTile.setPassword(tile.getPassword());
            dsTile.setCategory(tile.getCategory());
            tileDataSource = this.getTileFileSource(dsTile);
            ITileDataset tileDataset = tileDataSource.getDataset("");
            if (tileDataset == null) {
                throw new RuntimeException(tile.getPath() + "\u74e6\u7247\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
            }
            TileMeta tileMeta = tileDataset.getTileMeta();
            if (this.dsTileDao.selectByName(tile.getName()) != null) {
                throw new RuntimeException("\u74e6\u7247\u6570\u636e\u96c6\u540d\u79f0[" + tile.getName() + "]\u5df2\u5b58\u5728");
            }
            dsTile.setId(DatasetUtil.getDatasetId("tile", DatasetTypeEnum.TileDataset, tile.getName()));
            dsTile.setName(tile.getName());
            dsTile.setAliasName(tile.getName());
            dsTile.setTileType(tileMeta.getTileType().getValue());
            this.dsTileDao.insert(dsTile);
            this.sysLogService.addLog(121, String.format("\u6dfb\u52a0\u6587\u4ef6\u74e6\u7247\u6570\u636e\u96c6\uff1a%s > %s", tile.getPath(), dsTile.getName()));
            TileFileDataSourceDTO dataSourceDTO = new TileFileDataSourceDTO();
            dataSourceDTO.setKey("tile");
            dataSourceDTO.setDataStoreType(DataStoreTypeEnum.TileFileSource.getValue());
            dataSourceDTO.setTileSourceFormat(tile.getSourceFormat());
            TileDatasetDTO datasetDTO = this.convert2DTO(dataSourceDTO, tileDataset);
            datasetDTO.setId(dsTile.getId());
            datasetDTO.setName(dsTile.getName());
            datasetDTO.setAliasName(dsTile.getAliasName());
            TileDatasetDTO tileDatasetDTO = datasetDTO;
            return tileDatasetDTO;
        }
    }

    @Override
    public ITileDataSource openTileDataSource(DataSourceDTO dataSourceDTO) {
        if (dataSourceDTO.getDataSourceType().intValue() != DataSourceTypeEnum.MongoDB.getValue()) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
        }
        MongoTileDataSource tileDataSource = new MongoTileDataSource(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
        if (!tileDataSource.connect()) {
            throw new RuntimeException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25");
        }
        return tileDataSource;
    }

    private SimpleDatasetDTO convert2SimpleDTO(DataSourceDTO dataSourceDTO, ITileDataset tileDataset) {
        SimpleDatasetDTO datasetDTO = new SimpleDatasetDTO();
        datasetDTO.setId(DatasetUtil.getDatasetId(dataSourceDTO.getKey(), DatasetTypeEnum.TileDataset, tileDataset.getName()));
        datasetDTO.setName(tileDataset.getName());
        datasetDTO.setFullName(tileDataset.getName());
        datasetDTO.setAliasName(tileDataset.getAliasName());
        datasetDTO.setType(DatasetTypeEnum.TileDataset.getValue());
        datasetDTO.setTileType(tileDataset.getType().getValue());
        return datasetDTO;
    }

    private SimpleDatasetDTO convert2SimpleDTO(DataSourceDTO dataSourceDTO, DsTile dsTile) {
        SimpleDatasetDTO datasetDTO = new SimpleDatasetDTO();
        datasetDTO.setId(dsTile.getId());
        datasetDTO.setName(dsTile.getName());
        datasetDTO.setFullName(dsTile.getName());
        datasetDTO.setAliasName(dsTile.getAliasName());
        datasetDTO.setType(DatasetTypeEnum.TileDataset.getValue());
        datasetDTO.setTileType(dsTile.getTileType());
        return datasetDTO;
    }

    private TileDatasetDTO convert2DTO(DataSourceDTO dataSourceDTO, ITileDataset tileDataset) {
        TileDatasetDTO datasetDTO = new TileDatasetDTO();
        datasetDTO.setDataSource(dataSourceDTO);
        datasetDTO.setId(DatasetUtil.getDatasetId(dataSourceDTO.getKey(), DatasetTypeEnum.TileDataset, tileDataset.getName()));
        datasetDTO.setName(tileDataset.getName());
        datasetDTO.setFullName(tileDataset.getName());
        datasetDTO.setAliasName(tileDataset.getAliasName());
        datasetDTO.setType(DatasetTypeEnum.TileDataset.getValue());
        datasetDTO.setTypeDesc(DatasetTypeEnum.TileDataset.getDesc());
        datasetDTO.setTileSchema(tileDataset.getTileMeta().getTileSchema());
        datasetDTO.setLevels(tileDataset.getTileMeta().getLevels());
        datasetDTO.setTileType(tileDataset.getType().getValue());
        if (tileDataset.getTileMeta().getXmin() != null) {
            ExtentDTO extentDTO = new ExtentDTO();
            datasetDTO.setExtent(extentDTO);
            extentDTO.setXmin(tileDataset.getTileMeta().getXmin());
            extentDTO.setXmax(tileDataset.getTileMeta().getXmax());
            extentDTO.setYmin(tileDataset.getTileMeta().getYmin());
            extentDTO.setYmax(tileDataset.getTileMeta().getYmax());
        }
        return datasetDTO;
    }

    private boolean isFileTile(String dsKey) {
        return "tile".equals(dsKey);
    }

    private ITileDataSource getTileFileSource(DsTile tile) {
        ArcGISTileDataSource tileDataSource;
        TileFileSourceFormatEnum fileFortmatEnum = TileFileSourceFormatEnum.getByValue(tile.getSourceFormat());
        switch (fileFortmatEnum) {
            case ArcGIS: {
                if (!FileUtil.isDirExsit((String)tile.getPath()).booleanValue()) {
                    log.error(tile.getPath());
                    throw new RuntimeException("\u74e6\u7247\u8def\u5f84\u4e0d\u5b58\u5728");
                }
                tileDataSource = new ArcGISTileDataSource(tile.getPath());
                break;
            }
            case MbTiles: {
                if (!FileUtil.isFileExsit((String)tile.getPath()).booleanValue()) {
                    log.error(tile.getPath());
                    throw new RuntimeException("\u74e6\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                tileDataSource = new MBTilesTileDataSource(tile.getPath());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u74e6\u7247\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)fileFortmatEnum));
            }
        }
        if (!tileDataSource.connect()) {
            throw new RuntimeException(tile.getPath() + "\u8fde\u63a5\u5931\u8d25");
        }
        return tileDataSource;
    }
}

