/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseEditDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatabaseCreateDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatabaseEditDTO;
import com.geoway.adf.dms.datasource.service.DatumDataSourceService;
import com.geoway.adf.dms.datasource.service.ModelDataSourceService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ModelDataSourceServiceImpl
implements ModelDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(ModelDataSourceServiceImpl.class);
    @Resource
    private DatumDataSourceService datumDataSourceService;

    @Override
    public String createModelDatabase(ModelDatabaseCreateDTO modelDatabaseCreateDTO) {
        DatumDatabaseCreateDTO createDTO = new DatumDatabaseCreateDTO();
        createDTO.setName(modelDatabaseCreateDTO.getName());
        createDTO.setDataStoreType(DataStoreTypeEnum.ModelDatabase.getValue());
        createDTO.setGeoDatabaseKey(modelDatabaseCreateDTO.getGeoDatabaseKey());
        createDTO.setFileStorageKeys(modelDatabaseCreateDTO.getFileStorageKeys());
        createDTO.setCategory(modelDatabaseCreateDTO.getCategory());
        return this.datumDataSourceService.createDatumDatabase(createDTO);
    }

    @Override
    public void updateModelDatabase(ModelDatabaseEditDTO modelDatabaseEditDTO) {
        DatumDatabaseEditDTO editDTO = new DatumDatabaseEditDTO();
        editDTO.setKey(modelDatabaseEditDTO.getKey());
        editDTO.setName(modelDatabaseEditDTO.getName());
        editDTO.setFileStorageKeys(modelDatabaseEditDTO.getFileStorageKeys());
        this.datumDataSourceService.updateDatumDatabase(editDTO);
    }

    @Override
    public void deleteModelDatabase(String key, Boolean deleteBizInfo) {
        this.datumDataSourceService.deleteDatumDatabase(key, deleteBizInfo);
    }
}

