/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.geosrv;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.ime.IMEServer;
import com.geoway.adf.gis.geosrv.publish.IServicePublishParams;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.adf.gis.geosrv.vtile.VTileServer;
import com.geoway.adf.gis.geosrv.vtile.VTileServicePublishParams;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasServer
implements IGeoServer {
    private static final Logger logger = LoggerFactory.getLogger(AtlasServer.class);
    private final String url;
    private final String userName;
    private final String password;
    private final Map<String, String> headers;
    private final IMEServer imeServer;
    private final VTileServer vTileServer;

    public AtlasServer(String url, String userName, String password) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.headers = null;
        this.imeServer = new IMEServer(url, userName, password);
        this.vTileServer = this.createVTileServer();
    }

    public AtlasServer(String url, String userName, String password, Map<String, String> headers) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.headers = headers != null && !headers.isEmpty() ? headers : null;
        this.imeServer = new IMEServer(url, userName, password, this.headers);
        this.vTileServer = this.createVTileServer();
    }

    private VTileServer createVTileServer() {
        String sysInfoStr = HttpClientUtil.doGet((String)String.format("%s/rest/setting/sysInfo", this.url), null, this.headers, (int)10000);
        JSONObject sysInfoJson = JSONObject.parseObject((String)sysInfoStr);
        if (!"OK".equalsIgnoreCase(sysInfoJson.getString("status"))) {
            logger.error("\u83b7\u53d6\u77e2\u91cf\u74e6\u7247\u914d\u7f6e\u5931\u8d25!" + sysInfoJson.getString("message"));
            return null;
        }
        String resultStr = sysInfoJson.get((Object)"result") == null ? "" : sysInfoJson.get((Object)"result").toString();
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        return new VTileServer(resultJson.getString("vtile"), this.userName, this.password, this.headers);
    }

    public IMEServer getImeServer() {
        return this.imeServer;
    }

    public VTileServer getVTileServer() {
        return this.vTileServer;
    }

    public boolean testConnect() {
        return this.imeServer.testConnect();
    }

    public String getUrl() {
        return this.imeServer.getUrl();
    }

    public List<IGeoService> getServices() {
        List serviceList = this.vTileServer.getServices();
        serviceList.addAll(this.imeServer.getServices());
        return serviceList;
    }

    public PageList<IGeoService> getServices(List<ServiceType> serviceTypes, String keyword, int pageIndex, int rows) {
        PageList serviceList = new PageList();
        boolean addImeService = true;
        if (serviceTypes != null && serviceTypes.size() == 1 && serviceTypes.contains(ServiceType.VectorTileService)) {
            addImeService = false;
        }
        if (serviceTypes == null || serviceTypes.contains(ServiceType.VectorTileService)) {
            serviceList = this.vTileServer.getServices(serviceTypes, keyword, pageIndex, rows);
            if (serviceTypes != null) {
                serviceTypes.remove(ServiceType.VectorTileService);
            }
        }
        int index = pageIndex;
        if (serviceList.getTotal() > 0L) {
            int count = pageIndex * rows - serviceList.getTotal().intValue();
            index = count / rows;
            if (count < 0) {
                index = 0;
            }
        }
        if (addImeService) {
            PageList imeServiceList = this.imeServer.getServices(serviceTypes, keyword, index, rows);
            if (serviceList.getList().size() < rows) {
                for (IGeoService geoService : imeServiceList.getList()) {
                    serviceList.getList().add(geoService);
                    if (serviceList.getList().size() != rows) continue;
                    break;
                }
            }
            serviceList.setTotal(Long.valueOf(serviceList.getTotal() + imeServiceList.getTotal()));
        }
        return serviceList;
    }

    public void deleteService(ServiceType type, String serviceName) {
        if (type == ServiceType.VectorTileService) {
            this.vTileServer.deleteService(type, serviceName);
        } else {
            this.imeServer.deleteService(type, serviceName);
        }
    }

    public IGeoService getService(ServiceType type, String serviceName) {
        IGeoService geoService = null;
        geoService = type == ServiceType.VectorTileService ? this.vTileServer.getService(type, serviceName) : this.imeServer.getService(type, serviceName);
        if (type == ServiceType.Unknown && geoService == null) {
            geoService = this.vTileServer.getService(ServiceType.VectorTileService, serviceName);
        }
        return geoService;
    }

    public IGeoService publishService(IServicePublishParams publishParams) {
        if (publishParams instanceof VTileServicePublishParams) {
            return this.vTileServer.publishService(publishParams);
        }
        return this.imeServer.publishService(publishParams);
    }

    public void reCreateCache(IGeoService service) {
        if (service.getServiceType() == ServiceType.VectorTileService) {
            this.vTileServer.reCreateCache(service);
        } else {
            this.imeServer.reCreateCache(service);
        }
    }

    public IGeoService publishTempService(IServicePublishParams params) {
        if (params instanceof VTileServicePublishParams) {
            return this.vTileServer.publishTempService(params);
        }
        return this.imeServer.publishTempService(params);
    }
}

