/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.basic.geometry;

import com.geoway.adf.gis.basic.geometry.Coordinate;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;

public interface IGeometry {
    public Object getObject();

    public GeometryType getType();

    public CoordinateType getCoordinateType();

    public void changeDimension(CoordinateType var1);

    public IEnvelope getEnvelope();

    public String toWkt();

    public String toEWkt(int var1);

    public byte[] toWkb();

    public byte[] toEWkb(int var1);

    public boolean isEmpty();

    public IGeometry clone();

    public boolean isValid();

    public IGeometry makeValid();

    public IGeometry simplify(double var1);

    public double getArea();

    public double getLenth();

    public Coordinate getCentroid();

    public Coordinate getPointOnSurface();

    public IGeometry buffer(double var1);

    public IGeometry difference(IGeometry var1);

    public IGeometry intersection(IGeometry var1);

    public IGeometry union(IGeometry var1);

    public IGeometry projectToCopy(ISpatialReferenceSystem var1, ISpatialReferenceSystem var2);

    public boolean project(ISpatialReferenceSystem var1, ISpatialReferenceSystem var2);

    public boolean contains(IGeometry var1);

    public boolean intersects(IGeometry var1);

    public boolean crosses(IGeometry var1);

    public boolean disjoint(IGeometry var1);

    public boolean equals(IGeometry var1);

    public boolean overlaps(IGeometry var1);

    public boolean touches(IGeometry var1);

    public boolean within(IGeometry var1);
}

