/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.basic.a;

import com.geoway.adf.gis.basic.LicChecker;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.a.a;
import com.geoway.adf.gis.basic.a.c;
import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.basic.geometry.Coordinate;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.atlas.license.authorize.LicenseCheck;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.ogr;
import org.gdal.osr.CoordinateTransformation;
import org.gdal.osr.SpatialReference;

public class b
implements IGeometry,
Cloneable {
    Geometry n;
    GeometryType o = GeometryType.Unknown;
    CoordinateType p = CoordinateType.XY;
    private static Map<String, CoordinateTransformation> q;

    b(Geometry geometry) {
        this.n = geometry;
    }

    protected Geometry a() {
        return this.n;
    }

    public static IGeometry createGeometry(byte[] byArray) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        Geometry geometry = Geometry.CreateFromWkb((byte[])byArray);
        IGeometry iGeometry = b.a(geometry);
        return iGeometry;
    }

    public static IGeometry createGeometry(String string) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        Geometry geometry = Geometry.CreateFromWkt((String)string);
        IGeometry iGeometry = b.a(geometry);
        return iGeometry;
    }

    public static IGeometry createGeometryFromJson(String string) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        Geometry geometry = Geometry.CreateFromJson((String)string);
        IGeometry iGeometry = b.a(geometry);
        return iGeometry;
    }

    public static IGeometry a(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        RefObject<GeometryType> refObject = new RefObject<GeometryType>();
        RefObject<CoordinateType> refObject2 = new RefObject<CoordinateType>();
        b.convertWkbType(geometry.GetGeometryType(), refObject, refObject2);
        b b2 = new b(geometry);
        b2.o = refObject.get();
        b2.p = refObject2.get();
        return b2;
    }

    public static void convertWkbType(int n, RefObject<GeometryType> refObject, RefObject<CoordinateType> refObject2) {
        GeometryType geometryType;
        CoordinateType coordinateType = CoordinateType.XY;
        switch (n) {
            case 1: {
                geometryType = GeometryType.Point;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483647: {
                geometryType = GeometryType.Point;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2001: {
                geometryType = GeometryType.Point;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3001: {
                geometryType = GeometryType.Point;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 4: {
                geometryType = GeometryType.MultiPoint;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483644: {
                geometryType = GeometryType.MultiPoint;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2004: {
                geometryType = GeometryType.MultiPoint;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3004: {
                geometryType = GeometryType.MultiPoint;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 2: {
                geometryType = GeometryType.LineString;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483646: {
                geometryType = GeometryType.LineString;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2002: {
                geometryType = GeometryType.LineString;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3002: {
                geometryType = GeometryType.LineString;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 5: {
                geometryType = GeometryType.Polyline;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483643: {
                geometryType = GeometryType.Polyline;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2005: {
                geometryType = GeometryType.Polyline;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3005: {
                geometryType = GeometryType.Polyline;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 3: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483645: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2003: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3003: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 6: {
                geometryType = GeometryType.MultiPolygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483642: {
                geometryType = GeometryType.MultiPolygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2006: {
                geometryType = GeometryType.MultiPolygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3006: {
                geometryType = GeometryType.MultiPolygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 101: {
                geometryType = GeometryType.LinearRing;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 8: {
                geometryType = GeometryType.CircularString;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1008: {
                geometryType = GeometryType.CircularString;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2008: {
                geometryType = GeometryType.CircularString;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3008: {
                geometryType = GeometryType.CircularString;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 13: {
                geometryType = GeometryType.Curve;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1013: {
                geometryType = GeometryType.Curve;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2013: {
                geometryType = GeometryType.Curve;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3013: {
                geometryType = GeometryType.Curve;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 9: {
                geometryType = GeometryType.CompoundCurve;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1009: {
                geometryType = GeometryType.CompoundCurve;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2009: {
                geometryType = GeometryType.CompoundCurve;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3009: {
                geometryType = GeometryType.CompoundCurve;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 11: {
                geometryType = GeometryType.MultiCurve;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1011: {
                geometryType = GeometryType.MultiCurve;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2011: {
                geometryType = GeometryType.MultiCurve;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3011: {
                geometryType = GeometryType.MultiCurve;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 17: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1017: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2017: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3017: {
                geometryType = GeometryType.Polygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 14: 
            case 15: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1014: 
            case 1015: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2014: 
            case 2015: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3014: 
            case 3015: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 12: {
                geometryType = GeometryType.MultiCurvePolygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1012: {
                geometryType = GeometryType.MultiCurvePolygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2012: {
                geometryType = GeometryType.MultiCurvePolygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3012: {
                geometryType = GeometryType.MultiCurvePolygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 10: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.XY;
                break;
            }
            case 1010: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2010: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3010: {
                geometryType = GeometryType.CurvePolygon;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 7: {
                geometryType = GeometryType.GeometryCollection;
                coordinateType = CoordinateType.XY;
                break;
            }
            case -2147483641: {
                geometryType = GeometryType.GeometryCollection;
                coordinateType = CoordinateType.Z;
                break;
            }
            case 2007: {
                geometryType = GeometryType.GeometryCollection;
                coordinateType = CoordinateType.M;
                break;
            }
            case 3007: {
                geometryType = GeometryType.GeometryCollection;
                coordinateType = CoordinateType.ZM;
                break;
            }
            case 0: 
            case 16: 
            case 1016: 
            case 2016: 
            case 3016: {
                geometryType = GeometryType.Unknown;
                break;
            }
            default: {
                System.out.println("\u672a\u5904\u7406\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + n);
                geometryType = GeometryType.Unknown;
            }
        }
        refObject.set(geometryType);
        refObject2.set(coordinateType);
    }

    public static IGeometry mergeGeometrys(List<IGeometry> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Geometry geometry = null;
        IGeometry iGeometry = list.get(0);
        switch (iGeometry.getType()) {
            case Point: 
            case MultiPoint: {
                switch (iGeometry.getCoordinateType()) {
                    case XY: {
                        geometry = new Geometry(4);
                        break;
                    }
                    case Z: {
                        geometry = new Geometry(-2147483644);
                        break;
                    }
                    case M: {
                        geometry = new Geometry(2004);
                        break;
                    }
                    case ZM: {
                        geometry = new Geometry(3004);
                    }
                }
                for (IGeometry iGeometry2 : list) {
                    Geometry geometry2 = (Geometry)iGeometry2.getObject();
                    if (geometry2.GetGeometryCount() == 0) {
                        geometry.AddGeometryDirectly(geometry2);
                        continue;
                    }
                    for (int i = 0; i < geometry2.GetGeometryCount(); ++i) {
                        geometry.AddGeometry(geometry2.GetGeometryRef(i));
                    }
                }
                break;
            }
            case LineString: 
            case Polyline: 
            case LinearRing: 
            case CircularString: 
            case Curve: 
            case CompoundCurve: 
            case MultiCurve: {
                switch (iGeometry.getCoordinateType()) {
                    case XY: {
                        geometry = new Geometry(5);
                        break;
                    }
                    case Z: {
                        geometry = new Geometry(-2147483643);
                        break;
                    }
                    case M: {
                        geometry = new Geometry(2005);
                        break;
                    }
                    case ZM: {
                        geometry = new Geometry(3005);
                    }
                }
                for (IGeometry iGeometry3 : list) {
                    Geometry geometry3 = (Geometry)iGeometry3.getObject();
                    if (geometry3.GetGeometryCount() == 0) {
                        geometry.AddGeometryDirectly(ogr.ForceToLineString((Geometry)geometry3));
                        continue;
                    }
                    for (int i = 0; i < geometry3.GetGeometryCount(); ++i) {
                        geometry.AddGeometryDirectly(ogr.ForceToLineString((Geometry)geometry3.GetGeometryRef(i)));
                    }
                }
                break;
            }
            case Polygon: 
            case MultiPolygon: 
            case Envelope: 
            case CurvePolygon: 
            case MultiCurvePolygon: {
                switch (iGeometry.getCoordinateType()) {
                    case XY: {
                        geometry = new Geometry(6);
                        break;
                    }
                    case Z: {
                        geometry = new Geometry(-2147483642);
                        break;
                    }
                    case M: {
                        geometry = new Geometry(2006);
                        break;
                    }
                    case ZM: {
                        geometry = new Geometry(3006);
                    }
                }
                for (IGeometry iGeometry4 : list) {
                    Geometry geometry4 = (Geometry)iGeometry4.getObject();
                    for (int i = 0; i < geometry4.GetGeometryCount(); ++i) {
                        geometry.AddGeometryDirectly(ogr.ForceToPolygon((Geometry)geometry4.GetGeometryRef(i)));
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + iGeometry.getType());
            }
        }
        if (geometry != null) {
            return b.a(geometry);
        }
        return null;
    }

    public static IGeometry forceToPolygon(IGeometry iGeometry) {
        Geometry geometry = (Geometry)iGeometry.getObject();
        return b.a(ogr.ForceToPolygon((Geometry)geometry));
    }

    public static IGeometry forceToMultiPolygon(IGeometry iGeometry) {
        Geometry geometry = (Geometry)iGeometry.getObject();
        return b.a(ogr.ForceToMultiPolygon((Geometry)geometry));
    }

    public static IGeometry forceToLineString(IGeometry iGeometry) {
        Geometry geometry = (Geometry)iGeometry.getObject();
        return b.a(ogr.ForceToLineString((Geometry)geometry));
    }

    public static IGeometry forceToMultiLineString(IGeometry iGeometry) {
        Geometry geometry = (Geometry)iGeometry.getObject();
        return b.a(ogr.ForceToMultiLineString((Geometry)geometry));
    }

    @Override
    public Object getObject() {
        return this.a();
    }

    @Override
    public GeometryType getType() {
        return this.o;
    }

    @Override
    public CoordinateType getCoordinateType() {
        return this.p;
    }

    @Override
    public void changeDimension(CoordinateType coordinateType) {
        if (this.a() != null) {
            this.p = coordinateType;
            switch (coordinateType) {
                case XY: {
                    this.n.SetCoordinateDimension(2);
                    break;
                }
                case Z: {
                    this.n.SetCoordinateDimension(3);
                    break;
                }
                case M: {
                    this.n.SetCoordinateDimension(3);
                    break;
                }
                case ZM: {
                    this.n.SetCoordinateDimension(4);
                    break;
                }
            }
        }
    }

    @Override
    public IEnvelope getEnvelope() {
        if (this.a() == null) {
            return null;
        }
        double[] dArray = new double[6];
        this.n.GetEnvelope3D(dArray);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        IEnvelope iEnvelope = a.createEnvelope(d, d3, d2, d4);
        return iEnvelope;
    }

    @Override
    public String toWkt() {
        if (this.a() == null) {
            return null;
        }
        return this.n.ExportToWkt();
    }

    @Override
    public String toEWkt(int n) {
        if (this.a() == null) {
            return null;
        }
        return "SRID=" + n + ";" + this.n.ExportToWkt();
    }

    @Override
    public byte[] toWkb() {
        if (this.a() == null) {
            return null;
        }
        return this.n.ExportToIsoWkb(GeometryFunc.m);
    }

    @Override
    public byte[] toEWkb(int n) {
        byte[] byArray = this.toWkb();
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        return GeometryFunc.toEWkb(byArray, n);
    }

    @Override
    public String toJson() {
        if (this.a() == null) {
            return null;
        }
        return this.n.ExportToJson();
    }

    @Override
    public boolean isEmpty() {
        if (this.a() == null) {
            return true;
        }
        return this.n.IsEmpty();
    }

    @Override
    public IGeometry clone() {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Clone();
        return b.a(geometry);
    }

    @Override
    public boolean isValid() {
        if (this.a() == null) {
            return false;
        }
        return this.n.IsValid();
    }

    @Override
    public IGeometry makeValid() {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.MakeValid();
        return b.a(geometry);
    }

    @Override
    public IGeometry simplify(double d) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Simplify(d);
        return b.a(geometry);
    }

    @Override
    public double getArea() {
        if (this.a() == null) {
            return 0.0;
        }
        return this.n.Area();
    }

    @Override
    public double getLenth() {
        if (this.a() == null) {
            return 0.0;
        }
        return this.n.Length();
    }

    @Override
    public Coordinate getCentroid() {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Centroid();
        if (geometry != null) {
            return new Coordinate(geometry.GetX(), geometry.GetY(), geometry.GetZ());
        }
        return null;
    }

    @Override
    public Coordinate getPointOnSurface() {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.PointOnSurface();
        if (geometry != null) {
            return new Coordinate(geometry.GetX(), geometry.GetY(), geometry.GetZ());
        }
        return null;
    }

    @Override
    public IGeometry buffer(double d) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Buffer(d, 30);
        return b.a(geometry);
    }

    @Override
    public IGeometry difference(IGeometry iGeometry) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Difference(((b)iGeometry).a());
        if (geometry == null || geometry.IsEmpty()) {
            return null;
        }
        return b.a(geometry);
    }

    @Override
    public IGeometry intersection(IGeometry iGeometry) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Intersection(((b)iGeometry).a());
        if (geometry == null || geometry.IsEmpty()) {
            return null;
        }
        return b.a(geometry);
    }

    @Override
    public IGeometry union(IGeometry iGeometry) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Union(((b)iGeometry).a());
        if (geometry == null || geometry.IsEmpty()) {
            return null;
        }
        return b.a(geometry);
    }

    private synchronized void a(String string, CoordinateTransformation coordinateTransformation) {
        q.putIfAbsent(string, coordinateTransformation);
    }

    @Override
    public IGeometry projectToCopy(ISpatialReferenceSystem iSpatialReferenceSystem, ISpatialReferenceSystem iSpatialReferenceSystem2) {
        if (this.a() == null) {
            return null;
        }
        Geometry geometry = this.n.Clone();
        if (this.a(iSpatialReferenceSystem, iSpatialReferenceSystem2, geometry)) {
            return b.a(geometry);
        }
        return null;
    }

    @Override
    public boolean project(ISpatialReferenceSystem iSpatialReferenceSystem, ISpatialReferenceSystem iSpatialReferenceSystem2) {
        if (this.a() == null) {
            return false;
        }
        return this.a(iSpatialReferenceSystem, iSpatialReferenceSystem2, this.n);
    }

    private boolean a(ISpatialReferenceSystem iSpatialReferenceSystem, ISpatialReferenceSystem iSpatialReferenceSystem2, Geometry geometry) {
        SpatialReference spatialReference;
        SpatialReference spatialReference2 = iSpatialReferenceSystem == null ? null : ((c)iSpatialReferenceSystem).b();
        SpatialReference spatialReference3 = spatialReference = iSpatialReferenceSystem2 == null ? null : ((c)iSpatialReferenceSystem2).b();
        if (spatialReference2 == null || spatialReference == null) {
            return true;
        }
        String string = iSpatialReferenceSystem.hashCode() + "_" + iSpatialReferenceSystem2.hashCode();
        CoordinateTransformation coordinateTransformation = q.getOrDefault(string, null);
        if (coordinateTransformation == null) {
            coordinateTransformation = CoordinateTransformation.CreateCoordinateTransformation((SpatialReference)spatialReference2, (SpatialReference)spatialReference);
            this.a(string, coordinateTransformation);
        }
        return geometry.Transform(coordinateTransformation) == 0;
    }

    @Override
    public boolean contains(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Contains(((b)iGeometry).a());
    }

    @Override
    public boolean intersects(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Intersects(((b)iGeometry).a());
    }

    @Override
    public boolean crosses(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Crosses(((b)iGeometry).a());
    }

    @Override
    public boolean disjoint(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Disjoint(((b)iGeometry).a());
    }

    @Override
    public boolean equals(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.equals((Object)((b)iGeometry).a());
    }

    @Override
    public boolean overlaps(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Overlaps(((b)iGeometry).a());
    }

    @Override
    public boolean touches(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Touches(((b)iGeometry).a());
    }

    @Override
    public boolean within(IGeometry iGeometry) {
        if (this.a() == null) {
            throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e3a\u7a7a");
        }
        return this.n.Within(((b)iGeometry).a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<LicenseCheck> clazz = LicenseCheck.class;
        synchronized (LicenseCheck.class) {
            LicenseCheck.isValid((int)LicChecker.EnumModule.modGIS.value);
            // ** MonitorExit[var0] (shouldn't be in output)
            q = new HashMap<String, CoordinateTransformation>();
            return;
        }
    }
}

