/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.basic.geometry;

import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.a.a;
import com.geoway.adf.gis.basic.a.b;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.util.HexStrUtil;
import java.nio.ByteOrder;
import java.util.List;
import org.gdal.ogr.Geometry;

public class GeometryFunc {
    public static int m = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? 1 : 0;

    public static IEnvelope createEnvelope(double d, double d2, double d3, double d4) {
        IEnvelope iEnvelope = a.createEnvelope(d, d2, d3, d4);
        return iEnvelope;
    }

    public static IGeometry createGeometry(byte[] byArray) {
        byte by = byArray[0];
        int n = GeometryFunc.a(by, byArray, 1);
        if ((n & 0x20000000) == 0x20000000) {
            int n2 = n & 0xFF;
            int n3 = 0;
            if ((n & Integer.MIN_VALUE) == Integer.MIN_VALUE && (n & 0x40000000) == 0x40000000) {
                n3 = 3000;
            } else if ((n & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                n3 = 1000;
            } else if ((n & 0x40000000) == 0x40000000) {
                n3 = 2000;
            }
            byte[] byArray2 = new byte[byArray.length - 4];
            byArray2[0] = by;
            GeometryFunc.a(by, byArray2, 1, n3 + n2);
            System.arraycopy(byArray, 9, byArray2, 5, byArray.length - 9);
            IGeometry iGeometry = b.createGeometry(byArray2);
            return iGeometry;
        }
        IGeometry iGeometry = b.createGeometry(byArray);
        return iGeometry;
    }

    public static IGeometry createGeometry(String string) {
        if (string.startsWith("SRID=")) {
            string = string.substring(string.indexOf(";") + 1);
        }
        IGeometry iGeometry = b.createGeometry(string);
        return iGeometry;
    }

    public static IGeometry createGeometryFromHex(String string) {
        byte[] byArray = HexStrUtil.hexStrToBytes(string);
        IGeometry iGeometry = GeometryFunc.createGeometry(byArray);
        return iGeometry;
    }

    public static IGeometry createGeometryFromJson(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        IGeometry iGeometry = b.createGeometryFromJson(string);
        return iGeometry;
    }

    public static IGeometry createGeometryByObject(Object object) {
        IGeometry iGeometry = b.a((Geometry)object);
        return iGeometry;
    }

    public static void convertWkbType(int n, RefObject<GeometryType> refObject, RefObject<CoordinateType> refObject2) {
        b.convertWkbType(n, refObject, refObject2);
    }

    public static IGeometry mergeGeometrys(List<IGeometry> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return b.mergeGeometrys(list);
    }

    public static IGeometry forceToPolygon(IGeometry iGeometry) {
        return b.forceToPolygon(iGeometry);
    }

    public static IGeometry forceToLineString(IGeometry iGeometry) {
        return b.forceToLineString(iGeometry);
    }

    public static IGeometry forceToMultiPolygon(IGeometry iGeometry) {
        return b.forceToMultiPolygon(iGeometry);
    }

    public static IGeometry forceToMultiLineString(IGeometry iGeometry) {
        return b.forceToMultiLineString(iGeometry);
    }

    public static byte[] toEWkb(byte[] byArray, int n) {
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        byte by = byArray[0];
        int n2 = GeometryFunc.a(by, byArray, 1);
        int n3 = 0;
        int n4 = 0;
        if (n2 >= 1000 && n2 < 2000) {
            n4 = Integer.MIN_VALUE;
            n3 += n2 - 1000;
        } else if (n2 >= 2000 && n2 < 3000) {
            n4 = 0x40000000;
            n3 = n2 - 2000;
        } else if (n2 >= 3000 && n2 < 4000) {
            n4 = -1073741824;
            n3 = n2 - 3000;
        } else {
            n3 = n2;
        }
        n2 = (n4 += 0x20000000) + n3;
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray2, 0, 5);
        GeometryFunc.a(by, byArray2, 1, n2);
        GeometryFunc.a(by, byArray2, 5, n);
        System.arraycopy(byArray, 5, byArray2, 9, byArray.length - 5);
        return byArray2;
    }

    private static int a(int n, byte[] byArray, int n2) {
        if (n == 1) {
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    private static void a(int n, byte[] byArray, int n2, int n3) {
        if (n == 1) {
            byArray[n2] = (byte)n3;
            byArray[n2 + 1] = (byte)(n3 >> 8);
            byArray[n2 + 2] = (byte)(n3 >> 16);
            byArray[n2 + 3] = (byte)(n3 >> 24);
        } else {
            byArray[n2] = (byte)(n3 >> 24);
            byArray[n2 + 1] = (byte)(n3 >> 16);
            byArray[n2 + 2] = (byte)(n3 >> 8);
            byArray[n2 + 3] = (byte)n3;
        }
    }
}

