/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.obstorage;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.i;
import com.geoway.adf.gis.fs.obstorage.BucketInfo;
import com.geoway.adf.gis.fs.obstorage.BucketPolicyEnum;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileStorage
implements IFileStorage,
IObjectStorage {
    private static final Logger a = LoggerFactory.getLogger(OSSFileStorage.class);
    protected final String endPoint;
    private final String z;
    private final String A;
    protected String bucketName;
    public String pathPrefix;
    private OSS S;
    private static Map<String, OSS> D = new ConcurrentHashMap<String, OSS>();

    public OSSFileStorage(String string, String string2, String string3, String string4) {
        this.z = string3;
        this.A = string4;
        String string5 = string;
        while (string5.endsWith("/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        this.endPoint = string5;
        if (string2 != null && !string2.trim().isEmpty()) {
            this.bucketName = string2.trim();
            this.pathPrefix = this.endPoint + "/" + this.bucketName;
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            return this.endPoint;
        }
        return this.endPoint + "/" + this.bucketName;
    }

    @Override
    public String getUserName() {
        return this.z;
    }

    @Override
    public String getPassword() {
        return this.A;
    }

    @Override
    public String getType() {
        return "object storage";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.S != null) {
            return true;
        }
        String string = String.format("%s:%s@%s", this.z, this.A, this.endPoint);
        if (D.containsKey(string)) {
            this.S = D.get(string);
        } else {
            boolean bl;
            OSS oSS = new OSSClientBuilder().build(this.endPoint, this.z, this.A);
            if (this.bucketName != null && !this.bucketName.isEmpty() && !(bl = oSS.doesBucketExist(this.bucketName))) {
                throw new RuntimeException("\u8fde\u63a5\u5931\u8d25\uff0c\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
            }
            D.put(string, oSS);
            this.S = oSS;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.S != null) {
                this.S = null;
            }
        }
        catch (Exception exception) {
            a.error(this.endPoint + "\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public List<String> listBucketNames() {
        BucketList bucketList = this.S.listBuckets(new ListBucketsRequest());
        return bucketList.getBucketList().stream().map(Bucket::getName).collect(Collectors.toList());
    }

    @Override
    public BucketInfo getBucketInfo() {
        com.aliyun.oss.model.BucketInfo bucketInfo = this.S.getBucketInfo(this.bucketName);
        Date date = bucketInfo.getBucket().getCreationDate();
        BucketPolicyEnum bucketPolicyEnum = BucketPolicyEnum.Private;
        AccessControlList accessControlList = this.S.getBucketAcl(this.bucketName);
        switch (accessControlList.getCannedACL()) {
            case PublicRead: {
                bucketPolicyEnum = BucketPolicyEnum.PublicRead;
                break;
            }
            case PublicReadWrite: {
                bucketPolicyEnum = BucketPolicyEnum.PublicReadWrite;
                break;
            }
            default: {
                bucketPolicyEnum = BucketPolicyEnum.Private;
            }
        }
        BucketStat bucketStat = this.S.getBucketStat(this.bucketName);
        BucketInfo bucketInfo2 = new BucketInfo();
        bucketInfo2.setBucketName(this.bucketName);
        bucketInfo2.setBucketPolicy(bucketPolicyEnum);
        bucketInfo2.setStorageSize(bucketStat.getStorageSize());
        bucketInfo2.setCreationDate(date);
        return bucketInfo2;
    }

    @Override
    public String generatePresignedGetUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(this.bucketName, string2, HttpMethod.GET);
        generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + (long)n * 1000L));
        if (map != null) {
            generatePresignedUrlRequest.setHeaders(map);
        }
        if (map2 != null) {
            for (Map.Entry entry : map2.entrySet()) {
                if ("response-content-type".equalsIgnoreCase((String)entry.getKey()) || "response-content-disposition".equalsIgnoreCase((String)entry.getKey())) continue;
                generatePresignedUrlRequest.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        URL uRL = this.S.generatePresignedUrl(generatePresignedUrlRequest);
        return uRL.toString();
    }

    @Override
    public String generatePresignedPutUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(this.bucketName, string2, HttpMethod.PUT);
        generatePresignedUrlRequest.setExpiration(new Date(System.currentTimeMillis() + (long)n * 1000L));
        if (map != null) {
            generatePresignedUrlRequest.setHeaders(map);
        }
        if (map2 != null) {
            generatePresignedUrlRequest.setQueryParameter(map2);
        }
        URL uRL = this.S.generatePresignedUrl(generatePresignedUrlRequest);
        return uRL.toString();
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        i i2;
        String string2 = this.g(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setPrefix(string2);
        listObjectsRequest.setDelimiter("/");
        ObjectListing objectListing = this.S.listObjects(listObjectsRequest);
        for (String string3 : objectListing.getCommonPrefixes()) {
            i2 = new i(this, string3, true);
            arrayList.add(i2);
        }
        for (String string3 : objectListing.getObjectSummaries()) {
            if (string3.getKey().equals(string2)) continue;
            i2 = new i(this, string3.getKey(), this.h(string3.getKey()));
            if (!i2.getIsDirectory()) {
                i2.a(Date.from(string3.getLastModified().toInstant()));
                i2.a(string3.getSize());
            }
            arrayList.add(i2);
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        String string2 = this.g(string);
        return this.f(string2);
    }

    @Override
    public IFileset getFile(String string) {
        String string2 = this.g(string);
        if (this.h(string2)) {
            if (this.f(string2)) {
                i i2 = new i(this, string2, true);
                return i2;
            }
            a.error(string + " does not exist.");
            return null;
        }
        if (!this.S.doesObjectExist(this.bucketName, string2)) {
            a.error(string + " does not exist.");
            return null;
        }
        OSSObject oSSObject = this.S.getObject(this.bucketName, string2);
        i i3 = new i(this, string2, this.h(string2));
        if (!i3.getIsDirectory()) {
            i3.a(Date.from(oSSObject.getObjectMetadata().getLastModified().toInstant()));
            i3.a(oSSObject.getObjectMetadata().getContentLength());
        }
        return i3;
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = null;
        if (string.endsWith("/")) {
            int n = string.substring(0, string.length() - 1).lastIndexOf("/");
            if (n >= 0) {
                string2 = string.substring(0, n + 1);
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n >= 0 && !this.fileExist(string2 = string.substring(0, n + 1))) {
                string2 = string.substring(0, n);
            }
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        String string2 = this.g(string);
        this.S.deleteObject(this.bucketName, string2);
        return true;
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        String string3 = this.g(string);
        String string4 = string3 + string2 + "/";
        this.e(string4);
        return this.getFile(string4);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (int j = 0; j < stringArray.length - 1; ++j) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)stringArray[j], (String)"/"));
        }
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.stripStart((String)stringArray[stringArray.length - 1], (String)"/"));
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        String string3 = this.g(string2);
        File file = new File(string);
        if (file.isDirectory() && !string3.isEmpty() && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        this.b(file, string3, bl);
        return this.getFile(string3);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        String string2 = this.g(string);
        this.S.putObject(this.bucketName, string2, inputStream);
        return this.getFile(string2);
    }

    @Override
    public InputStream openFileStream(String string) {
        String string2 = this.g(string);
        OSSObject oSSObject = this.S.getObject(this.bucketName, string2);
        return oSSObject.getObjectContent();
    }

    private void b(File file, String string, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !this.f(string)) {
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, string, file);
                PutObjectResult putObjectResult = this.S.putObject(putObjectRequest);
            }
            return;
        }
        this.e(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName();
            if (file2.isDirectory()) {
                string2 = string2 + "/";
            }
            this.b(file2, string2, bl);
        }
    }

    private void e(String string) {
        if (!this.f(string)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, string, (InputStream)byteArrayInputStream);
            this.S.putObject(putObjectRequest);
        }
    }

    private boolean f(String string) {
        if (string.isEmpty() || string.equals("/")) {
            return true;
        }
        if (this.h(string)) {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
            listObjectsRequest.setPrefix(string);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setMaxKeys(Integer.valueOf(1));
            ObjectListing objectListing = this.S.listObjects(listObjectsRequest);
            return !objectListing.getObjectSummaries().isEmpty() || !objectListing.getCommonPrefixes().isEmpty();
        }
        return this.S.doesObjectExist(this.bucketName, string);
    }

    private String g(String string) {
        if (this.bucketName == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6876\u540d\u79f0");
        }
        if (string == null || string.length() == 0 || string.equals("/")) {
            string = "";
        }
        String string2 = string;
        if (string.startsWith(this.pathPrefix)) {
            string2 = string.substring(this.pathPrefix.length());
        }
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private boolean h(String string) {
        return string.isEmpty() || string.endsWith("/");
    }
}

