/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.obstorage;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.g;
import com.geoway.adf.gis.fs.obstorage.BucketInfo;
import com.geoway.adf.gis.fs.obstorage.BucketPolicyEnum;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.admin.MinioAdminClient;
import io.minio.errors.ErrorResponseException;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinIOFileStorage
implements IFileStorage,
IObjectStorage {
    private static final Logger a = LoggerFactory.getLogger(MinIOFileStorage.class);
    protected final String endPoint;
    private final String z;
    private final String A;
    protected String bucketName;
    public String pathPrefix;
    private MinioClient N;
    private static Map<String, MinioClient> D = new ConcurrentHashMap<String, MinioClient>();
    private static Map<String, MinioAdminClient> O = new ConcurrentHashMap<String, MinioAdminClient>();

    public MinIOFileStorage(String string, String string2, String string3, String string4) {
        this.z = string3;
        this.A = string4;
        String string5 = string;
        while (string5.endsWith("/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        this.endPoint = string5;
        if (string2 != null && !string2.trim().isEmpty()) {
            this.bucketName = string2.trim();
            this.pathPrefix = this.endPoint + "/" + this.bucketName;
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            return this.endPoint;
        }
        return this.endPoint + "/" + this.bucketName;
    }

    @Override
    public String getUserName() {
        return this.z;
    }

    @Override
    public String getPassword() {
        return this.A;
    }

    @Override
    public String getType() {
        return "object storage";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.N != null) {
            return true;
        }
        String string = String.format("%s:%s@%s", this.z, this.A, this.endPoint);
        if (D.containsKey(string)) {
            this.N = D.get(string);
        } else {
            MinioClient minioClient = MinioClient.builder().endpoint(this.endPoint).credentials(this.z, this.A).build();
            if (this.bucketName != null && !this.bucketName.isEmpty()) {
                boolean bl = false;
                List list = minioClient.listBuckets();
                for (Bucket bucket : list) {
                    if (!bucket.name().equals(this.bucketName)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new RuntimeException("\u8fde\u63a5\u5931\u8d25\uff0c\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
                }
            }
            D.put(string, minioClient);
            this.N = minioClient;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.N != null) {
                this.N = null;
            }
        }
        catch (Exception exception) {
            a.error(this.endPoint + "\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public List<String> listBucketNames() {
        List list = this.N.listBuckets();
        return list.stream().map(Bucket::name).collect(Collectors.toList());
    }

    @Override
    public BucketInfo getBucketInfo() {
        Object object;
        Object object22;
        Date date = null;
        boolean bl = false;
        List list = this.N.listBuckets();
        for (Object object22 : list) {
            if (!object22.name().equals(this.bucketName)) continue;
            date = Date.from(object22.creationDate().toInstant());
            bl = true;
            break;
        }
        if (!bl) {
            throw new RuntimeException("\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
        }
        Object object3 = BucketPolicyEnum.Private;
        try {
            object22 = this.N.getBucketPolicy((GetBucketPolicyArgs)((GetBucketPolicyArgs.Builder)GetBucketPolicyArgs.builder().bucket(this.bucketName)).build());
            object3 = object22 != null && ((String)object22).contains("s3:GetObject") ? (((String)object22).contains("s3:PutObject") ? BucketPolicyEnum.PublicReadWrite : BucketPolicyEnum.PublicRead) : BucketPolicyEnum.Private;
        }
        catch (ErrorResponseException errorResponseException) {
            a.error("\u83b7\u53d6[{}]\u6876[{}]\u7b56\u7565\u5931\u8d25\uff1a" + (Object)((Object)errorResponseException), (Object)this.endPoint, (Object)this.bucketName);
        }
        object22 = null;
        try {
            object = String.format("%s:%s@%s", this.z, this.A, this.endPoint);
            MinioAdminClient minioAdminClient = O.get(object);
            if (minioAdminClient == null) {
                minioAdminClient = MinioAdminClient.builder().endpoint(this.endPoint).credentials(this.z, this.A).build();
                O.put((String)object, minioAdminClient);
            }
            object22 = minioAdminClient.getDataUsageInfo();
        }
        catch (Exception exception) {
            a.error("\u83b7\u53d6[{}]\u6876[{}]\u5b58\u50a8\u4fe1\u606f\u5931\u8d25\uff1a" + exception, (Object)this.endPoint, (Object)this.bucketName);
        }
        object = new BucketInfo();
        ((BucketInfo)object).setBucketName(this.bucketName);
        ((BucketInfo)object).setBucketPolicy((BucketPolicyEnum)((Object)object3));
        ((BucketInfo)object).setStorageSize(object22 == null ? null : Long.valueOf(object22.objectsTotalSize()));
        ((BucketInfo)object).setCreationDate(date);
        return object;
    }

    @Override
    public String generatePresignedGetUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(this.bucketName)).object(string2)).expiry(n).extraHeaders(map)).extraQueryParams(map2)).build();
        String string3 = this.N.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        return string3;
    }

    @Override
    public String generatePresignedPutUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        GetPresignedObjectUrlArgs getPresignedObjectUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(this.bucketName)).object(string2)).expiry(n).extraHeaders(map)).extraQueryParams(map2)).build();
        String string3 = this.N.getPresignedObjectUrl(getPresignedObjectUrlArgs);
        return string3;
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        String string2 = this.g(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix(string2).delimiter("/").fetchOwner(true).recursive(bl).build();
        Iterable iterable = this.N.listObjects(listObjectsArgs);
        for (Result result : iterable) {
            g g2;
            block6: {
                Item item = (Item)result.get();
                if (item.objectName().equals(string2)) continue;
                g2 = new g(this, item.objectName(), item.isDir());
                if (!g2.getIsDirectory()) {
                    g2.a(Date.from(item.lastModified().toInstant()));
                    g2.a(item.size());
                }
                try {
                    if (!string2.equals("")) break block6;
                    StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(item.objectName())).build();
                    StatObjectResponse statObjectResponse = this.N.statObject(statObjectArgs);
                }
                catch (ErrorResponseException errorResponseException) {
                    if (!"AccessDenied".equalsIgnoreCase(errorResponseException.errorResponse().code())) break block6;
                    a.warn(item.objectName() + ":" + errorResponseException.getMessage());
                    continue;
                }
            }
            arrayList.add(g2);
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        String string2 = this.g(string);
        return this.f(string2);
    }

    @Override
    public IFileset getFile(String string) {
        String string2 = this.g(string);
        if (this.h(string2)) {
            boolean bl = this.f(string2);
            if (bl) {
                g g2 = new g(this, string2, true);
                return g2;
            }
            a.error(string + " does not exist.");
            return null;
        }
        try {
            StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(string2)).build();
            StatObjectResponse statObjectResponse = this.N.statObject(statObjectArgs);
            if (statObjectResponse == null) {
                a.error(string + " does not exist.");
                return null;
            }
            g g3 = new g(this, string2, this.h(string2));
            if (!g3.getIsDirectory()) {
                g3.a(Date.from(statObjectResponse.lastModified().toInstant()));
                g3.a(statObjectResponse.size());
            }
            return g3;
        }
        catch (ErrorResponseException | IOException | InvalidKeyException throwable) {
            a.warn(string2 + ":" + throwable.getMessage());
            return null;
        }
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = null;
        if (string.endsWith("/")) {
            int n = string.substring(0, string.length() - 1).lastIndexOf("/");
            if (n >= 0) {
                string2 = string.substring(0, n + 1);
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n >= 0 && !this.fileExist(string2 = string.substring(0, n + 1))) {
                string2 = string.substring(0, n);
            }
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        String string2 = this.g(string);
        this.N.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(string2)).build());
        return true;
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        String string3 = this.g(string);
        String string4 = string3 + string2 + "/";
        this.e(string4);
        return this.getFile(string4);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (int j = 0; j < stringArray.length - 1; ++j) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)stringArray[j], (String)"/"));
        }
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.stripStart((String)stringArray[stringArray.length - 1], (String)"/"));
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        String string3 = this.g(string2);
        File file = new File(string);
        if (file.isDirectory() && !string3.isEmpty() && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        this.b(file, string3, bl);
        return this.getFile(string3);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        String string2 = this.g(string);
        PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(string2)).stream(inputStream, (long)inputStream.available(), -1L).build();
        ObjectWriteResponse objectWriteResponse = this.N.putObject(putObjectArgs);
        return this.getFile(string2);
    }

    @Override
    public InputStream openFileStream(String string) {
        String string2 = this.g(string);
        GetObjectArgs getObjectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(string2)).build();
        return this.N.getObject(getObjectArgs);
    }

    private void b(File file, String string, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !this.f(string)) {
                UploadObjectArgs uploadObjectArgs = (UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.bucketName)).filename(file.getAbsolutePath()).object(string)).build();
                ObjectWriteResponse objectWriteResponse = this.N.uploadObject(uploadObjectArgs);
            }
            return;
        }
        this.e(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName();
            if (file2.isDirectory()) {
                string2 = string2 + "/";
            }
            this.b(file2, string2, bl);
        }
    }

    private void e(String string) {
        if (!this.f(string)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            PutObjectArgs putObjectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(string)).stream((InputStream)byteArrayInputStream, 0L, -1L).contentType("application/octet-stream").build();
            this.N.putObject(putObjectArgs);
        }
    }

    private boolean f(String string) {
        try {
            if (string.isEmpty() || string.equals("/")) {
                return true;
            }
            if (this.h(string)) {
                ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix(string).recursive(false).maxKeys(1).build();
                Iterable iterable = this.N.listObjects(listObjectsArgs);
                boolean bl = false;
                for (Result result : iterable) {
                    Item item = (Item)result.get();
                    if (!item.objectName().startsWith(string)) continue;
                    bl = true;
                    break;
                }
                return bl;
            }
            StatObjectArgs statObjectArgs = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(string)).build();
            StatObjectResponse statObjectResponse = this.N.statObject(statObjectArgs);
            return Objects.nonNull(statObjectResponse);
        }
        catch (ErrorResponseException errorResponseException) {
            if ("NoSuchKey".equalsIgnoreCase(errorResponseException.errorResponse().code())) {
                return false;
            }
            if ("AccessDenied".equalsIgnoreCase(errorResponseException.errorResponse().code())) {
                return true;
            }
            throw errorResponseException;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    private String g(String string) {
        if (this.bucketName == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6876\u540d\u79f0");
        }
        if (string == null || string.length() == 0 || string.equals("/")) {
            string = "";
        }
        String string2 = string;
        if (string.startsWith(this.pathPrefix)) {
            string2 = string.substring(this.pathPrefix.length());
        }
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private boolean h(String string) {
        return string.isEmpty() || string.endsWith("/");
    }
}

