/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.hdfs;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.d;
import com.geoway.adf.gis.fs.a.e;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFileStorage
implements IFileStorage {
    private final Logger a = LoggerFactory.getLogger(HDFSFileStorage.class);
    private static final int v = 0xA00000;
    private GenericObjectPool<FileSystem> r;
    public final String url;
    private final String c;
    private final String d;
    public String dataFolder;
    private Map w;
    protected FileSystem fileSystem;

    public HDFSFileStorage(String string, String string2, String string3, Map map) {
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        this.c = string2;
        this.d = string3;
        this.w = map;
        int n = string.indexOf("/");
        if (n < 0) {
            this.url = string;
            this.dataFolder = "/";
        } else {
            this.url = string.substring(0, n);
            this.dataFolder = string.substring(n);
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.dataFolder == null || this.dataFolder.isEmpty() || this.dataFolder.equals("/")) {
            return this.url;
        }
        return this.url + this.dataFolder;
    }

    @Override
    public String getUserName() {
        return this.c;
    }

    @Override
    public String getPassword() {
        return this.d;
    }

    @Override
    public String getType() {
        return "hdfs";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.fileSystem == null) {
            this.r = e.a(this.url, this.c, this.d, this.w);
            this.fileSystem = (FileSystem)this.r.borrowObject();
        }
        try {
            Path path = new Path(this.dataFolder);
            if (!this.fileSystem.exists(path)) {
                throw new RuntimeException("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + path);
            }
        }
        catch (Exception exception) {
            this.close();
            throw exception;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.r != null) {
                this.r.returnObject((Object)this.fileSystem);
            }
            this.fileSystem = null;
        }
        catch (Exception exception) {
            this.a.error(this.url + "\u5173\u95ed\u5f02\u5e38", (Throwable)exception);
        }
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        FileStatus[] fileStatusArray;
        Path path = this.getHdfsPath(string);
        if (!this.fileSystem.exists(path)) {
            throw new RuntimeException("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + string);
        }
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        for (FileStatus fileStatus : fileStatusArray = this.fileSystem.listStatus(path)) {
            d d2 = new d(this, fileStatus);
            arrayList.add(d2);
            if (!bl || !fileStatus.isDirectory()) continue;
            arrayList.addAll(this.listFile(fileStatus.getPath().toString(), bl));
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        Path path = this.getHdfsPath(string);
        return this.fileSystem.exists(path);
    }

    @Override
    public IFileset getFile(String string) {
        Path path = this.getHdfsPath(string);
        if (this.fileSystem.exists(path)) {
            FileStatus fileStatus = this.fileSystem.getFileStatus(path);
            d d2 = new d(this, fileStatus);
            return d2;
        }
        return null;
    }

    @Override
    public IFileset getParentFile(String string) {
        Path path = this.getHdfsPath(string);
        Path path2 = path.getParent();
        if (path2 == null) {
            return null;
        }
        return this.getFile(path2.toString());
    }

    @Override
    public boolean deleteFile(String string) {
        Path path = this.getHdfsPath(string);
        if (!this.fileSystem.exists(path)) {
            return true;
        }
        FileStatus fileStatus = this.fileSystem.getFileStatus(path);
        return this.fileSystem.delete(path, fileStatus.isDirectory());
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        Path path = this.getHdfsPath(string);
        path = new Path(path, string2);
        if (this.fileSystem.mkdirs(path)) {
            FileStatus fileStatus = this.fileSystem.getFileStatus(path);
            d d2 = new d(this, fileStatus);
            return d2;
        }
        return null;
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (String string2 : stringArray) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)string2, (String)"/"));
        }
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        Path path = this.getHdfsPath(string2);
        try {
            File file = new File(string);
            HDFSFileStorage.a(file, this.fileSystem, path, bl);
            FileStatus fileStatus = this.fileSystem.getFileStatus(path);
            d d2 = new d(this, fileStatus);
            return d2;
        }
        catch (IOException iOException) {
            this.a.error(string + " \u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + iOException.getMessage(), (Throwable)iOException);
            throw iOException;
        }
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        Path path = this.getHdfsPath(string);
        try {
            Path path2 = path.getParent();
            if (!this.fileSystem.exists(path2) && !this.fileSystem.mkdirs(path2)) {
                throw new RuntimeException(path2.toString() + " \u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
            }
            FSDataOutputStream fSDataOutputStream = null;
            try {
                fSDataOutputStream = this.fileSystem.create(path);
                IOUtils.copyBytes((InputStream)inputStream, (OutputStream)fSDataOutputStream, (int)0xA00000, (boolean)true);
            }
            catch (IOException iOException) {
                IOUtils.closeStream(fSDataOutputStream);
                throw iOException;
            }
            FileStatus fileStatus = this.fileSystem.getFileStatus(path);
            d d2 = new d(this, fileStatus);
            return d2;
        }
        catch (IOException iOException) {
            this.a.error("\u6570\u636e\u4e0a\u4f20\u5931\u8d25\uff0c" + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public InputStream openFileStream(String string) {
        Path path = this.getHdfsPath(string);
        return this.fileSystem.open(path);
    }

    private static boolean a(File file, FileSystem fileSystem, Path path, boolean bl) throws IOException {
        HDFSFileStorage.a(file.getName(), fileSystem, path, bl);
        if (file.isDirectory()) {
            if (!fileSystem.exists(path) && !fileSystem.mkdirs(path)) {
                return false;
            }
            File[] fileArray = FileUtil.listFiles((File)file);
            for (int j = 0; j < fileArray.length; ++j) {
                HDFSFileStorage.a(fileArray[j], fileSystem, new Path(path, fileArray[j].getName()), bl);
            }
        } else {
            if (!file.isFile()) {
                if (!file.canRead()) {
                    throw new IOException(file.toString() + ": Permission denied");
                }
                throw new IOException(file.toString() + ": No such file or directory");
            }
            Path path2 = path.getParent();
            if (!fileSystem.exists(path2) && !fileSystem.mkdirs(path2)) {
                return false;
            }
            Object var4_5 = null;
            FSDataOutputStream fSDataOutputStream = null;
            try {
                InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
                fSDataOutputStream = fileSystem.create(path);
                IOUtils.copyBytes((InputStream)inputStream, (OutputStream)fSDataOutputStream, (int)0xA00000, (boolean)true);
            }
            catch (IOException iOException) {
                IOUtils.closeStream(fSDataOutputStream);
                throw iOException;
            }
        }
        return true;
    }

    private static Path a(String string, FileSystem fileSystem, Path path, boolean bl) throws IOException {
        FileStatus fileStatus;
        try {
            fileStatus = fileSystem.getFileStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileStatus = null;
        }
        if (null != fileStatus) {
            if (fileStatus.isDirectory()) {
                if (null == string) {
                    if (bl) {
                        return path;
                    }
                    throw new PathIsDirectoryException(path.toString());
                }
                return HDFSFileStorage.a((String)null, fileSystem, new Path(path, string), bl);
            }
            if (!bl) {
                throw new PathExistsException(path.toString(), "Target " + path + " already exists");
            }
        }
        return path;
    }

    public Path getHdfsPath(String string) {
        if (string == null || string.length() == 0) {
            string = this.dataFolder;
        }
        String string2 = string;
        if (string.startsWith(this.url)) {
            string2 = string.substring(this.url.length());
        }
        if (!string2.startsWith(this.dataFolder)) {
            string2 = (this.dataFolder.endsWith("/") ? this.dataFolder.substring(0, this.dataFolder.length() - 1) : this.dataFolder) + "/" + (string2.startsWith("/") ? string2.substring(1) : string2);
        }
        if (string2.length() == 0) {
            string2 = "/";
        }
        Path path = new Path(string2);
        return path;
    }
}

