/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.obstorage;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.f;
import com.geoway.adf.gis.fs.obstorage.BucketInfo;
import com.geoway.adf.gis.fs.obstorage.BucketPolicyEnum;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.utils.AttributeMap;

public class AmazonS3FileStorage
implements IFileStorage,
IObjectStorage {
    private static final Logger a = LoggerFactory.getLogger(AmazonS3FileStorage.class);
    protected final String endPoint;
    private final String C;
    private final String D;
    protected String bucketName;
    public String pathPrefix;
    private Region E = Region.AWS_CN_GLOBAL;
    private S3Client F;
    private static Map<String, S3Client> G = new ConcurrentHashMap<String, S3Client>();

    public AmazonS3FileStorage(String string, String string2, String string3, String string4) {
        this.C = string3;
        this.D = string4;
        String string5 = string;
        while (string5.endsWith("/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        this.endPoint = string5;
        if (string2 != null && !string2.trim().isEmpty()) {
            this.bucketName = string2.trim();
            this.pathPrefix = this.endPoint + "/" + this.bucketName;
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            return this.endPoint;
        }
        return this.endPoint + "/" + this.bucketName;
    }

    @Override
    public String getUserName() {
        return this.C;
    }

    @Override
    public String getPassword() {
        return this.D;
    }

    @Override
    public String getType() {
        return "object storage";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.F != null) {
            return true;
        }
        String string = String.format("%s:%s@%s", this.C, this.D, this.endPoint);
        if (G.containsKey(string)) {
            this.F = G.get(string);
        } else {
            AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this.C, (String)this.D);
            AttributeMap attributeMap = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)true).build();
            SdkHttpClient sdkHttpClient = new DefaultSdkHttpClientBuilder().buildWithDefaults(attributeMap);
            S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.E)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsBasicCredentials))).endpointOverride(URI.create(this.endPoint))).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build())).httpClient(sdkHttpClient)).build();
            if (this.bucketName != null && !this.bucketName.isEmpty()) {
                HeadBucketResponse headBucketResponse = s3Client.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName).build());
            }
            G.put(string, s3Client);
            this.F = s3Client;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.F != null) {
                this.F = null;
            }
        }
        catch (Exception exception) {
            a.error(this.endPoint + "\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public List<String> listBucketNames() {
        ListBucketsResponse listBucketsResponse = this.F.listBuckets();
        return listBucketsResponse.buckets().stream().map(Bucket::name).collect(Collectors.toList());
    }

    @Override
    public BucketInfo getBucketInfo() {
        Bucket bucket2;
        Date date = null;
        boolean bl = false;
        ListBucketsResponse listBucketsResponse = this.F.listBuckets();
        for (Bucket bucket2 : listBucketsResponse.buckets()) {
            if (!bucket2.name().equals(this.bucketName)) continue;
            date = Date.from(bucket2.creationDate());
            bl = true;
            break;
        }
        if (!bl) {
            throw new RuntimeException("\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
        }
        Object object = BucketPolicyEnum.Private;
        bucket2 = this.F.getBucketAcl((GetBucketAclRequest)GetBucketAclRequest.builder().bucket(this.bucketName).build());
        for (Grant grant : bucket2.grants()) {
            if (!grant.grantee().id().equalsIgnoreCase("Everyone")) continue;
            if (grant.permission().equals((Object)Permission.READ)) {
                object = BucketPolicyEnum.PublicRead;
                continue;
            }
            if (!grant.permission().equals((Object)Permission.FULL_CONTROL)) continue;
            object = BucketPolicyEnum.PublicReadWrite;
        }
        BucketInfo bucketInfo = new BucketInfo();
        bucketInfo.setBucketName(this.bucketName);
        bucketInfo.setBucketPolicy((BucketPolicyEnum)((Object)object));
        bucketInfo.setStorageSize(null);
        bucketInfo.setCreationDate(date);
        return bucketInfo;
    }

    @Override
    public String generatePresignedGetUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this.C, (String)this.D);
        try (S3Presigner s3Presigner = S3Presigner.builder().region(this.E).endpointOverride(URI.create(this.endPoint)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsBasicCredentials)).build();){
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(string2).overrideConfiguration(builder -> {
                if (map != null) {
                    for (String string : map.keySet()) {
                        builder.putHeader(string, (String)map.get(string));
                    }
                }
                if (map2 != null) {
                    for (String string : map2.keySet()) {
                        builder.putRawQueryParameter(string, (String)map2.get(string));
                    }
                }
            }).build();
            PresignedGetObjectRequest presignedGetObjectRequest = s3Presigner.presignGetObject(builder -> builder.getObjectRequest(getObjectRequest).signatureDuration(Duration.ofSeconds(n)));
            String string3 = presignedGetObjectRequest.url().toString();
            return string3;
        }
    }

    @Override
    public String generatePresignedPutUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this.C, (String)this.D);
        try (S3Presigner s3Presigner = S3Presigner.builder().region(this.E).endpointOverride(URI.create(this.endPoint)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsBasicCredentials)).build();){
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(string2).overrideConfiguration(builder -> {
                if (map != null) {
                    for (String string : map.keySet()) {
                        builder.putHeader(string, (String)map.get(string));
                    }
                }
                if (map2 != null) {
                    for (String string : map2.keySet()) {
                        builder.putRawQueryParameter(string, (String)map2.get(string));
                    }
                }
            }).build();
            PresignedPutObjectRequest presignedPutObjectRequest = s3Presigner.presignPutObject(builder -> builder.putObjectRequest(putObjectRequest).signatureDuration(Duration.ofSeconds(n)));
            String string3 = presignedPutObjectRequest.url().toString();
            return string3;
        }
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        String string2 = this.g(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        if (bl) {
            ListObjectsRequest listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucketName).prefix(string2).build();
            ListObjectsResponse listObjectsResponse = this.F.listObjects(listObjectsRequest);
            for (S3Object s3Object : listObjectsResponse.contents()) {
                if (s3Object.key().equals(string2)) continue;
                f f2 = new f(this, s3Object.key(), this.h(s3Object.key()));
                if (!f2.getIsDirectory()) {
                    f2.a(Date.from(s3Object.lastModified()));
                    f2.a(s3Object.size());
                }
                arrayList.add(f2);
            }
        } else {
            f f3;
            ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucketName).prefix(string2).delimiter("/").build();
            ListObjectsV2Response listObjectsV2Response = this.F.listObjectsV2(listObjectsV2Request);
            for (CommonPrefix commonPrefix : listObjectsV2Response.commonPrefixes()) {
                f3 = new f(this, commonPrefix.prefix(), true);
                arrayList.add(f3);
            }
            for (CommonPrefix commonPrefix : listObjectsV2Response.contents()) {
                if (commonPrefix.key().equals(string2)) continue;
                f3 = new f(this, commonPrefix.key(), this.h(commonPrefix.key()));
                if (!f3.getIsDirectory()) {
                    f3.a(Date.from(commonPrefix.lastModified()));
                    f3.a(commonPrefix.size());
                }
                arrayList.add(f3);
            }
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        String string2 = this.g(string);
        return this.f(string2);
    }

    @Override
    public IFileset getFile(String string) {
        String string2 = this.g(string);
        if (this.h(string2)) {
            boolean bl = this.f(string2);
            if (bl) {
                f f2 = new f(this, string2, true);
                return f2;
            }
            a.error(string + " does not exist.");
            return null;
        }
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(string2).build();
            HeadObjectResponse headObjectResponse = this.F.headObject(headObjectRequest);
            f f3 = new f(this, string2, this.h(string2));
            if (!f3.getIsDirectory()) {
                f3.a(Date.from(headObjectResponse.lastModified()));
                f3.a(headObjectResponse.contentLength());
            }
            return f3;
        }
        catch (S3Exception s3Exception) {
            if (s3Exception.statusCode() == 404) {
                a.error(string + " does not exist.");
                return null;
            }
            throw s3Exception;
        }
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = null;
        if (string.endsWith("/")) {
            int n = string.substring(0, string.length() - 1).lastIndexOf("/");
            if (n >= 0) {
                string2 = string.substring(0, n + 1);
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n >= 0 && !this.fileExist(string2 = string.substring(0, n + 1))) {
                string2 = string.substring(0, n);
            }
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        String string2 = this.g(string);
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(string2).build();
        this.F.deleteObject(deleteObjectRequest);
        return true;
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        String string3 = this.g(string);
        String string4 = string3 + string2 + "/";
        this.e(string4);
        return this.getFile(string4);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (int j = 0; j < stringArray.length - 1; ++j) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)stringArray[j], (String)"/"));
        }
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.stripStart((String)stringArray[stringArray.length - 1], (String)"/"));
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        String string3 = this.g(string2);
        File file = new File(string);
        if (file.isDirectory() && !string3.isEmpty() && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        this.b(file, string3, bl);
        return this.getFile(string3);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        String string2 = this.g(string);
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(string2).build();
        this.F.putObject(putObjectRequest, RequestBody.fromInputStream((InputStream)inputStream, (long)inputStream.available()));
        return this.getFile(string2);
    }

    @Override
    public InputStream openFileStream(String string) {
        String string2 = this.g(string);
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(string2).build();
        ResponseInputStream responseInputStream = this.F.getObject(getObjectRequest);
        return responseInputStream;
    }

    private void b(File file, String string, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !this.f(string)) {
                PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(string).build();
                PutObjectResponse putObjectResponse = this.F.putObject(putObjectRequest, file.toPath());
            }
            return;
        }
        this.e(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName();
            if (file2.isDirectory()) {
                string2 = string2 + "/";
            }
            this.b(file2, string2, bl);
        }
    }

    private void e(String string) {
        if (!this.f(string)) {
            ByteBuffer byteBuffer = ByteBuffer.wrap("".getBytes(StandardCharsets.UTF_8));
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(string).build();
            this.F.putObject(putObjectRequest, RequestBody.fromByteBuffer((ByteBuffer)byteBuffer));
        }
    }

    private boolean f(String string) {
        try {
            if (string.isEmpty() || string.equals("/")) {
                return true;
            }
            if (this.h(string)) {
                ListObjectsRequest listObjectsRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(this.bucketName).prefix(string).maxKeys(Integer.valueOf(1)).build();
                ListObjectsResponse listObjectsResponse = this.F.listObjects(listObjectsRequest);
                return !listObjectsResponse.commonPrefixes().isEmpty() || !listObjectsResponse.contents().isEmpty();
            }
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.bucketName).key(string).build();
            HeadObjectResponse headObjectResponse = this.F.headObject(headObjectRequest);
            return true;
        }
        catch (S3Exception s3Exception) {
            if (s3Exception.statusCode() == 404) {
                return false;
            }
            throw s3Exception;
        }
    }

    private String g(String string) {
        if (this.bucketName == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6876\u540d\u79f0");
        }
        if (string == null || string.length() == 0 || string.equals("/")) {
            string = "";
        }
        String string2 = string;
        if (string.startsWith(this.pathPrefix)) {
            string2 = string.substring(this.pathPrefix.length());
        }
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private boolean h(String string) {
        return string.isEmpty() || string.endsWith("/");
    }
}

