/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.field;

import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Fields
implements IFields {
    private List<IField> L;
    private Map<String, Integer> M;

    public Fields() {
        this.L = new ArrayList<IField>();
        this.M = new HashMap<String, Integer>();
    }

    public Fields(Collection<IField> collection) {
        this.L = new ArrayList<IField>(collection);
        this.M = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < this.L.size(); ++i2) {
            this.M.put(this.L.get(i2).getName().toLowerCase(), i2);
        }
    }

    @Override
    public int getFieldCount() {
        return this.L.size();
    }

    @Override
    public boolean contains(String string) {
        return this.M.containsKey(string.toLowerCase());
    }

    @Override
    public Iterator<IField> iterator() {
        return this.L.iterator();
    }

    @Override
    public IField[] toArray() {
        return this.L.toArray(new IField[0]);
    }

    public String toString() {
        return String.join((CharSequence)",", this.L.stream().map(IField::getName).collect(Collectors.toList()));
    }

    @Override
    public void addField(IField iField) {
        this.L.add(iField);
        this.M.put(iField.getName().toLowerCase(), this.L.size() - 1);
    }

    @Override
    public void removeField(int n2) {
        IField iField = this.getField(n2);
        if (iField != null) {
            this.L.remove(n2);
            this.M.remove(iField.getName().toLowerCase());
        }
    }

    @Override
    public void removeField(String string) {
        int n2 = this.findFieldIndex(string);
        if (n2 >= 0) {
            this.L.remove(n2);
            this.M.remove(string.toLowerCase());
        }
    }

    @Override
    public IField getField(int n2) {
        if (n2 < this.L.size() && n2 > -1) {
            return this.L.get(n2);
        }
        return null;
    }

    @Override
    public IField findField(String string) {
        int n2 = this.findFieldIndex(string);
        return this.getField(n2);
    }

    @Override
    public int findFieldIndex(String string) {
        if (!this.M.containsKey(string.toLowerCase())) {
            return -1;
        }
        return this.M.get(string.toLowerCase());
    }
}

