/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.cursor;

import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IFields;

public class Row
implements IRow {
    protected ITable table;
    protected IFields fields;
    protected Object[] values;
    protected Object objectId;
    protected int oidFieldIndex = -1;

    public Row(ITable iTable, String string, IFields iFields) {
        this.table = iTable;
        this.fields = iFields;
        this.values = new Object[iFields.getFieldCount()];
        if (string != null && string.length() > 0) {
            this.oidFieldIndex = iFields.findFieldIndex(string);
        }
    }

    @Override
    public ITable getTable() {
        return this.table;
    }

    @Override
    public IFields getFields() {
        return this.fields;
    }

    @Override
    public void setValue(int n2, Object object) {
        if (n2 > -1 && n2 < this.fields.getFieldCount()) {
            this.values[n2] = object;
            if (n2 == this.oidFieldIndex) {
                this.objectId = object;
            }
        }
    }

    @Override
    public void setValue(String string, Object object) {
        int n2 = this.fields.findFieldIndex(string);
        this.setValue(n2, object);
    }

    @Override
    public Object getValue(int n2) {
        if (n2 > -1 && n2 < this.fields.getFieldCount()) {
            return this.values[n2];
        }
        return null;
    }

    @Override
    public Object getValue(String string) {
        int n2 = this.fields.findFieldIndex(string);
        return this.getValue(n2);
    }

    @Override
    public Object getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(Object object) {
        this.objectId = object;
        this.setValue(this.oidFieldIndex, object);
    }
}

